/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.AbstractFilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColRegExpStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringGroupColConcatStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringGroupConcatColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLTrimCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLength;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLower;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringRTrimCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringScalarConcatStringGroupCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringSubstrColStart;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringSubstrColStartLen;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringTrimCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUpper;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CharScalarEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharScalarEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharScalarGreaterStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharScalarLessEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColEqualCharScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColEqualStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColEqualVarCharScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColGreaterEqualCharScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColGreaterEqualStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColGreaterEqualVarCharScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColLessCharScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColLessStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColLessStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringGroupColLessVarCharScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringScalarEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringScalarGreaterStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringScalarLessEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharScalarEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharScalarGreaterStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharScalarLessEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringGroupColEqualCharScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringGroupColEqualStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringGroupColEqualVarCharScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringGroupColLessStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringScalarEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.VarCharScalarEqualStringGroupColumn;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestVectorStringExpressions {
    private static final Logger LOG = LoggerFactory.getLogger(TestVectorStringExpressions.class);
    private static byte[] red;
    private static byte[] redred;
    private static byte[] red2;
    private static byte[] green;
    private static byte[] greenred;
    private static byte[] redgreen;
    private static byte[] greengreen;
    private static byte[] blue;
    private static byte[] emptyString;
    private static byte[] mixedUp;
    private static byte[] mixedUpLower;
    private static byte[] mixedUpUpper;
    private static byte[] multiByte;
    private static byte[] mixPercentPattern;
    private static byte[] blanksLeft;
    private static byte[] blanksRight;
    private static byte[] blanksBoth;
    private static byte[] blankString;
    private static byte[] blankRanges;
    private static byte[] ascii_sentence;
    private HiveConf hiveConf = new HiveConf();

    static void addMultiByteChars(byte[] b) {
        int i = 0;
        b[i++] = 65;
        b[i++] = -61;
        b[i++] = -128;
        b[i++] = -30;
        b[i++] = -126;
        b[i++] = -84;
        b[i++] = -16;
        b[i++] = -92;
        b[i++] = -83;
        b[i++] = -94;
    }

    static void addMultiByteCharLeftPadded1_1(byte[] b) {
        int i = 0;
        b[i++] = 32;
        b[i++] = -48;
        b[i++] = -126;
    }

    static void addMultiByteCharLeftPadded1_2(byte[] b) {
        int i = 0;
        b[i++] = 32;
        b[i++] = -16;
        b[i++] = -97;
        b[i++] = -104;
        b[i++] = -124;
        b[i++] = -16;
        b[i++] = -97;
        b[i++] = -104;
        b[i++] = -84;
    }

    static void addMultiByteCharLeftPadded3_1(byte[] b) {
        int i = 0;
        b[i++] = 32;
        b[i++] = 32;
        b[i++] = 32;
        b[i++] = -28;
        b[i++] = -96;
        b[i++] = -92;
    }

    static void addMultiByteCharRightPadded1_1(byte[] b) {
        int i = 0;
        b[i++] = -32;
        b[i++] = -81;
        b[i++] = -112;
        b[i++] = 32;
    }

    static void addMultiByteCharRightPadded1_2(byte[] b) {
        int i = 0;
        b[i++] = -22;
        b[i++] = -108;
        b[i++] = -95;
        b[i++] = 90;
        b[i++] = 32;
    }

    static void addMultiByteCharRightPadded1_3(byte[] b) {
        int i = 0;
        b[i++] = -52;
        b[i++] = -127;
        b[i++] = -32;
        b[i++] = -92;
        b[i++] = -107;
        b[i++] = -32;
        b[i++] = -91;
        b[i++] = -115;
        b[i++] = 32;
    }

    static int addMultiByteCharSentenceOne(byte[] b, int start) {
        int i = start;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -110;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -122;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -106;
        b[i++] = 32;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -127;
        b[i++] = 32;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -91;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -100;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -88;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -99;
        return i;
    }

    static int addMultiByteCharSentenceTwo(byte[] b, int start) {
        int i = start;
        b[i++] = -55;
        b[i++] = -112;
        b[i++] = -55;
        b[i++] = -93;
        b[i++] = -55;
        b[i++] = -81;
        b[i++] = -54;
        b[i++] = -126;
        b[i++] = 32;
        b[i++] = -54;
        b[i++] = -97;
        b[i++] = -53;
        b[i++] = -112;
        b[i++] = 32;
        b[i++] = -53;
        b[i++] = -102;
        b[i++] = -53;
        b[i++] = -95;
        b[i++] = -53;
        b[i++] = -93;
        b[i++] = -53;
        b[i++] = -124;
        b[i++] = 46;
        return i;
    }

    static int addMultiByteCharSentenceBlankRanges(byte[] b, int start) {
        int i = start;
        b[i++] = -16;
        b[i++] = -112;
        b[i++] = -83;
        b[i++] = -119;
        b[i++] = -31;
        b[i++] = -90;
        b[i++] = -99;
        b[i++] = 32;
        b[i++] = 32;
        b[i++] = 32;
        b[i++] = 45;
        b[i++] = 32;
        b[i++] = 96;
        b[i++] = -30;
        b[i++] = -104;
        b[i++] = -128;
        b[i++] = -30;
        b[i++] = -104;
        b[i++] = -110;
        b[i++] = 32;
        b[i++] = 32;
        b[i++] = 32;
        b[i++] = 32;
        b[i++] = 32;
        b[i++] = -30;
        b[i++] = -104;
        b[i++] = -122;
        b[i++] = -30;
        b[i++] = -101;
        b[i++] = -65;
        return i;
    }

    static int addPads(byte[] b, int start, int count) {
        int i;
        int end = start + count;
        for (i = start; i < end; ++i) {
            b[i] = 32;
        }
        return i;
    }

    private boolean vectorEqual(BytesColumnVector vector, int i, byte[] bytes, int offset, int length) {
        byte[] bytesSlice = new byte[length];
        System.arraycopy(bytes, offset, bytesSlice, 0, length);
        int vectorLength = vector.length[i];
        byte[] vectorSlice = new byte[vectorLength];
        System.arraycopy(vector.vector[i], vector.start[i], vectorSlice, 0, vectorLength);
        boolean equals = Arrays.equals(bytesSlice, vectorSlice);
        if (!equals) {
            System.out.println("vectorEqual offset " + offset + " length " + length + " vectorSlice.length " + vectorSlice.length);
            System.out.println("vectorEqual bytesSlice " + Hex.encodeHexString((byte[])bytesSlice));
            System.out.println("vectorEqual vectorSlice " + Hex.encodeHexString((byte[])vectorSlice));
        }
        return equals;
    }

    private int vectorCharacterCount(BytesColumnVector vector, int i) {
        return StringExpr.characterCount((byte[])vector.vector[i], (int)vector.start[i], (int)vector.length[i]);
    }

    @Test
    public void testAssignBytesColumnVector() {
        BytesColumnVector outV = new BytesColumnVector(1024);
        outV.initBuffer(35);
        int i = 0;
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        StringExpr.assign((BytesColumnVector)outV, (int)i, (byte[])blue, (int)0, (int)blue.length);
        int expectedResultLen = blue.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blue, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        StringExpr.assign((BytesColumnVector)outV, (int)(++i), (byte[])redgreen, (int)0, (int)redgreen.length);
        expectedResultLen = redgreen.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, redgreen, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        StringExpr.assign((BytesColumnVector)outV, (int)(++i), (byte[])ascii_sentence, (int)0, (int)ascii_sentence.length);
        expectedResultLen = ascii_sentence.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, ascii_sentence, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        StringExpr.assign((BytesColumnVector)outV, (int)(++i), (byte[])blanksLeft, (int)0, (int)blanksLeft.length);
        expectedResultLen = blanksLeft.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksLeft, 0, expectedResultLen));
        byte[] sentenceBlankRanges = new byte[100];
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        StringExpr.assign((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen);
        expectedResultLen = sentenceBlankRangesLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        StringExpr.assign((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3));
        expectedResultLen = sentenceBlankRangesLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)4, (int)(sentenceBlankRangesLen - 4)) == 16 ? 1 : 0) != 0);
        StringExpr.assign((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)4, (int)(sentenceBlankRangesLen - 4));
        expectedResultLen = sentenceBlankRangesLen - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 16 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        StringExpr.assign((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)7, (int)17);
        expectedResultLen = 17;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 13 ? 1 : 0) != 0);
        ++i;
    }

    @Test
    public void testRightTrimBytesSlice() {
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        int resultLen = StringExpr.rightTrim((byte[])blue, (int)0, (int)blue.length);
        Assert.assertTrue((resultLen == blue.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)resultLen) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])redgreen, (int)0, (int)redgreen.length);
        Assert.assertTrue((resultLen == redgreen.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length);
        Assert.assertTrue((resultLen == ascii_sentence.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blanksLeft, (int)0, (int)blanksLeft.length);
        Assert.assertTrue((resultLen == blanksLeft.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blanksRight, (int)0, (int)blanksRight.length);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blanksBoth, (int)0, (int)blanksBoth.length);
        Assert.assertTrue((resultLen == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)resultLen) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blankString, (int)0, (int)blankString.length);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blankRanges, (int)0, (int)blankRanges.length);
        Assert.assertTrue((resultLen == blankRanges.length - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)resultLen) == 26 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1));
        Assert.assertTrue((resultLen == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)resultLen) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4));
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)resultLen) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5));
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)(blankString.length - 1)) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blankString, (int)1, (int)(blankString.length - 1));
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4)) == 26 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4));
        Assert.assertTrue((resultLen == blankRanges.length - 4 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)resultLen) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6));
        Assert.assertTrue((resultLen == blankRanges.length - 6 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)resultLen) == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7));
        Assert.assertTrue((resultLen == blankRanges.length - 7 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 19 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)1) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])blankRanges, (int)7, (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 0 ? 1 : 0) != 0);
        byte[] multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])multiByte, (int)0, (int)4);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])multiByte, (int)0, (int)5);
        Assert.assertTrue((resultLen == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])multiByte, (int)0, (int)9);
        Assert.assertTrue((resultLen == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)1) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])multiByte, (int)3, (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 0 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])multiByte, (int)3, (int)2);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)resultLen) == 1 ? 1 : 0) != 0);
        byte[] sentenceOne = new byte[100];
        int sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceOne, (int)0, (int)sentenceOneLen);
        Assert.assertTrue((resultLen == sentenceOneLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3));
        Assert.assertTrue((resultLen == sentenceOneLen - 3 ? 1 : 0) != 0);
        byte[] sentenceTwo = new byte[100];
        int sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen);
        Assert.assertTrue((resultLen == sentenceTwoLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5));
        Assert.assertTrue((resultLen == sentenceTwoLen - 5 ? 1 : 0) != 0);
        byte[] sentenceOnePaddedLeft = new byte[100];
        int start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        int sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen);
        Assert.assertTrue((resultLen == sentenceOnePaddedLeftLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3));
        Assert.assertTrue((resultLen == sentenceOnePaddedLeftLen - 3 ? 1 : 0) != 0);
        byte[] sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        int sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen);
        Assert.assertTrue((resultLen == sentenceTwoPaddedLeftLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5));
        Assert.assertTrue((resultLen == sentenceTwoPaddedLeftLen - 5 ? 1 : 0) != 0);
        byte[] sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        int sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen);
        Assert.assertTrue((resultLen == sentenceOnePaddedRightLen - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4));
        Assert.assertTrue((resultLen == sentenceOnePaddedRightLen - 3 - 4 ? 1 : 0) != 0);
        byte[] sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        int sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen);
        Assert.assertTrue((resultLen == sentenceTwoPaddedRightLen - 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1));
        Assert.assertTrue((resultLen == sentenceTwoPaddedRightLen - 5 - 1 ? 1 : 0) != 0);
        byte[] sentenceBlankRanges = new byte[100];
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen);
        Assert.assertTrue((resultLen == sentenceBlankRangesLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3));
        Assert.assertTrue((resultLen == sentenceBlankRangesLen - 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrim((byte[])sentenceBlankRanges, (int)7, (int)17);
        Assert.assertTrue((resultLen == 12 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)resultLen) == 8 ? 1 : 0) != 0);
    }

    @Test
    public void testRightTrimBytesColumnVector() {
        BytesColumnVector outV = new BytesColumnVector(1024);
        outV.initBuffer(30);
        int i = 0;
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)i, (byte[])blue, (int)0, (int)blue.length);
        int expectedResultLen = blue.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blue, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])redgreen, (int)0, (int)redgreen.length);
        expectedResultLen = redgreen.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, redgreen, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])ascii_sentence, (int)0, (int)ascii_sentence.length);
        expectedResultLen = ascii_sentence.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, ascii_sentence, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blanksLeft, (int)0, (int)blanksLeft.length);
        expectedResultLen = blanksLeft.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)0, (int)blanksRight.length);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)0, (int)blanksBoth.length);
        expectedResultLen = 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)0, (int)blankString.length);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)0, (int)blankRanges.length);
        expectedResultLen = blankRanges.length - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 26 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)1, (int)(blanksRight.length - 1));
        expectedResultLen = 2;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4));
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5));
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 5, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)(blankString.length - 1)) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)1, (int)(blankString.length - 1));
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4)) == 26 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)4, (int)(blankRanges.length - 4));
        expectedResultLen = blankRanges.length - 4 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)6, (int)(blankRanges.length - 6));
        expectedResultLen = blankRanges.length - 6 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 6, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)(blankRanges.length - 7));
        expectedResultLen = blankRanges.length - 7 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 19 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)1) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        byte[] multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)4);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)5);
        expectedResultLen = 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)9);
        expectedResultLen = 8;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)1) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)2);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        byte[] sentenceOne = new byte[100];
        int sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)sentenceOneLen);
        expectedResultLen = sentenceOneLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3));
        expectedResultLen = sentenceOneLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        byte[] sentenceTwo = new byte[100];
        int sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)sentenceTwoLen);
        expectedResultLen = sentenceTwoLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5));
        expectedResultLen = sentenceTwoLen - 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        byte[] sentenceOnePaddedLeft = new byte[100];
        int start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        int sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen);
        expectedResultLen = sentenceOnePaddedLeftLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3));
        expectedResultLen = sentenceOnePaddedLeftLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        byte[] sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        int sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen);
        expectedResultLen = sentenceTwoPaddedLeftLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5));
        expectedResultLen = sentenceTwoPaddedLeftLen - 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        byte[] sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        int sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen);
        expectedResultLen = sentenceOnePaddedRightLen - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4));
        expectedResultLen = sentenceOnePaddedRightLen - 3 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        byte[] sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        int sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen);
        expectedResultLen = sentenceTwoPaddedRightLen - 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1));
        expectedResultLen = sentenceTwoPaddedRightLen - 5 - 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        byte[] sentenceBlankRanges = new byte[100];
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen);
        expectedResultLen = sentenceBlankRangesLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3));
        expectedResultLen = sentenceBlankRangesLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrim((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)7, (int)17);
        expectedResultLen = 12;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 8 ? 1 : 0) != 0);
    }

    @Test
    public void testTruncateBytesSlice() {
        int largeMaxLength = 100;
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        int resultLen = StringExpr.truncate((byte[])blue, (int)0, (int)blue.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == blue.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)resultLen) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])redgreen, (int)0, (int)redgreen.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == redgreen.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == ascii_sentence.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == blanksLeft.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blue, (int)0, (int)blue.length, (int)4);
        Assert.assertTrue((resultLen == blue.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)resultLen) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])redgreen, (int)0, (int)redgreen.length, (int)8);
        Assert.assertTrue((resultLen == redgreen.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)31);
        Assert.assertTrue((resultLen == ascii_sentence.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)5);
        Assert.assertTrue((resultLen == blanksLeft.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blue, (int)0, (int)blue.length, (int)3);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])redgreen, (int)0, (int)redgreen.length, (int)6);
        Assert.assertTrue((resultLen == 6 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)14);
        Assert.assertTrue((resultLen == 14 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)2);
        Assert.assertTrue((resultLen == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blanksRight, (int)0, (int)blanksRight.length, (int)4);
        Assert.assertTrue((resultLen == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)resultLen) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blanksBoth, (int)0, (int)blanksBoth.length, (int)2);
        Assert.assertTrue((resultLen == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)resultLen) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blankString, (int)0, (int)blankString.length, (int)1);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)resultLen) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blankRanges, (int)0, (int)blankRanges.length, (int)29);
        Assert.assertTrue((resultLen == 29 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)resultLen) == 29 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1), (int)3);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)resultLen) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4), (int)2);
        Assert.assertTrue((resultLen == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)resultLen) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5), (int)1);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)resultLen) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4)) == 26 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4), (int)22);
        Assert.assertTrue((resultLen == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)resultLen) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6), (int)7);
        Assert.assertTrue((resultLen == 7 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)resultLen) == 7 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7), (int)20);
        Assert.assertTrue((resultLen == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 20 ? 1 : 0) != 0);
        byte[] multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])multiByte, (int)0, (int)4, (int)1);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])multiByte, (int)0, (int)5, (int)2);
        Assert.assertTrue((resultLen == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])multiByte, (int)0, (int)9, (int)2);
        Assert.assertTrue((resultLen == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])multiByte, (int)3, (int)2, (int)1);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)resultLen) == 1 ? 1 : 0) != 0);
        byte[] sentenceOne = new byte[100];
        int sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceOne, (int)0, (int)sentenceOneLen, (int)8);
        Assert.assertTrue((resultLen == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3), (int)3);
        Assert.assertTrue((resultLen == 9 ? 1 : 0) != 0);
        byte[] sentenceTwo = new byte[100];
        int sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen, (int)9);
        Assert.assertTrue((resultLen == 16 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5), (int)6);
        Assert.assertTrue((resultLen == 11 ? 1 : 0) != 0);
        byte[] sentenceOnePaddedLeft = new byte[100];
        int start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        int sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen, (int)4);
        Assert.assertTrue((resultLen == 6 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3), (int)7);
        Assert.assertTrue((resultLen == 13 ? 1 : 0) != 0);
        byte[] sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        int sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen, (int)14);
        Assert.assertTrue((resultLen == 24 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5), (int)9);
        Assert.assertTrue((resultLen == 15 ? 1 : 0) != 0);
        byte[] sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        int sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen, (int)1);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4), (int)5);
        Assert.assertTrue((resultLen == 13 ? 1 : 0) != 0);
        byte[] sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        int sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen, (int)6);
        Assert.assertTrue((resultLen == 11 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1), (int)8);
        Assert.assertTrue((resultLen == 14 ? 1 : 0) != 0);
        byte[] sentenceBlankRanges = new byte[100];
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen, (int)4);
        Assert.assertTrue((resultLen == 9 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3), (int)14);
        Assert.assertTrue((resultLen == 23 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.truncate((byte[])sentenceBlankRanges, (int)7, (int)17, (int)11);
        Assert.assertTrue((resultLen == 15 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)resultLen) == 11 ? 1 : 0) != 0);
    }

    @Test
    public void testTruncateBytesColumnVector() {
        BytesColumnVector outV = new BytesColumnVector(1024);
        outV.initBuffer(35);
        int i = 0;
        int largeMaxLength = 100;
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)i, (byte[])blue, (int)0, (int)blue.length, (int)largeMaxLength);
        int expectedResultLen = blue.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blue, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])redgreen, (int)0, (int)redgreen.length, (int)largeMaxLength);
        expectedResultLen = redgreen.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, redgreen, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)largeMaxLength);
        expectedResultLen = ascii_sentence.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, ascii_sentence, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)largeMaxLength);
        expectedResultLen = blanksLeft.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blue, (int)0, (int)blue.length, (int)4);
        expectedResultLen = blue.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blue, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])redgreen, (int)0, (int)redgreen.length, (int)8);
        expectedResultLen = redgreen.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, redgreen, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)31);
        expectedResultLen = ascii_sentence.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, ascii_sentence, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)5);
        expectedResultLen = blanksLeft.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blue, (int)0, (int)blue.length, (int)3);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blue, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])redgreen, (int)0, (int)redgreen.length, (int)6);
        expectedResultLen = 6;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, redgreen, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)14);
        expectedResultLen = 14;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, ascii_sentence, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)2);
        expectedResultLen = 2;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)0, (int)blanksRight.length, (int)4);
        expectedResultLen = 4;
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)0, (int)blanksBoth.length, (int)2);
        expectedResultLen = 2;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)0, (int)blankString.length, (int)1);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)0, (int)blankRanges.length, (int)29);
        expectedResultLen = 29;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 29 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)1, (int)(blanksRight.length - 1), (int)3);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4), (int)2);
        expectedResultLen = 2;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5), (int)1);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 5, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4)) == 26 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)4, (int)(blankRanges.length - 4), (int)22);
        expectedResultLen = 22;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)6, (int)(blankRanges.length - 6), (int)7);
        expectedResultLen = 7;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 6, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 7 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)(blankRanges.length - 7), (int)20);
        expectedResultLen = 20;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 20 ? 1 : 0) != 0);
        byte[] multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)4, (int)1);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)5, (int)2);
        expectedResultLen = 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)9, (int)2);
        expectedResultLen = 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)2, (int)1);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        byte[] sentenceOne = new byte[100];
        int sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)sentenceOneLen, (int)8);
        expectedResultLen = 20;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3), (int)3);
        expectedResultLen = 9;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        byte[] sentenceTwo = new byte[100];
        int sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)sentenceTwoLen, (int)9);
        expectedResultLen = 16;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5), (int)6);
        expectedResultLen = 11;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        byte[] sentenceOnePaddedLeft = new byte[100];
        int start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        int sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen, (int)4);
        expectedResultLen = 6;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3), (int)7);
        expectedResultLen = 13;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        byte[] sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        int sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen, (int)14);
        expectedResultLen = 24;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5), (int)9);
        expectedResultLen = 15;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        byte[] sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        int sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen, (int)1);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4), (int)5);
        expectedResultLen = 13;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        byte[] sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        int sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen, (int)6);
        expectedResultLen = 11;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1), (int)8);
        expectedResultLen = 14;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        byte[] sentenceBlankRanges = new byte[100];
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen, (int)4);
        expectedResultLen = 9;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3), (int)14);
        expectedResultLen = 23;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        StringExpr.truncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)7, (int)17, (int)11);
        expectedResultLen = 15;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 11 ? 1 : 0) != 0);
        ++i;
    }

    @Test
    public void testTruncateScalar() {
        int largeMaxLength = 100;
        Assert.assertTrue((StringExpr.characterCount((byte[])blue) == 4 ? 1 : 0) != 0);
        byte[] result = StringExpr.truncateScalar((byte[])blue, (int)largeMaxLength);
        Assert.assertTrue((boolean)Arrays.equals(blue, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen) == 8 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])redgreen, (int)largeMaxLength);
        Assert.assertTrue((boolean)Arrays.equals(redgreen, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence) == 31 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])ascii_sentence, (int)largeMaxLength);
        Assert.assertTrue((boolean)Arrays.equals(ascii_sentence, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft) == 5 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])blanksLeft, (int)largeMaxLength);
        Assert.assertTrue((boolean)Arrays.equals(blanksLeft, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])blue) == 4 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])blue, (int)blue.length);
        Assert.assertTrue((boolean)Arrays.equals(blue, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen) == 8 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])redgreen, (int)redgreen.length);
        Assert.assertTrue((boolean)Arrays.equals(redgreen, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence) == 31 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])ascii_sentence, (int)ascii_sentence.length);
        Assert.assertTrue((boolean)Arrays.equals(ascii_sentence, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft) == 5 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])blanksLeft, (int)blanksLeft.length);
        Assert.assertTrue((boolean)Arrays.equals(blanksLeft, result));
        result = StringExpr.truncateScalar((byte[])blue, (int)3);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blue, 3), result));
        result = StringExpr.truncateScalar((byte[])redgreen, (int)6);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(redgreen, 6), result));
        result = StringExpr.truncateScalar((byte[])ascii_sentence, (int)14);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(ascii_sentence, 14), result));
        result = StringExpr.truncateScalar((byte[])blanksLeft, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blanksLeft, 2), result));
        result = StringExpr.truncateScalar((byte[])blanksRight, (int)4);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blanksRight, 4), result));
        result = StringExpr.truncateScalar((byte[])blanksBoth, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blanksBoth, 2), result));
        result = StringExpr.truncateScalar((byte[])blankString, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blankString, 1), result));
        result = StringExpr.truncateScalar((byte[])blankRanges, (int)29);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blankRanges, 29), result));
        byte[] scratch = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(scratch);
        byte[] multiByte = Arrays.copyOf(scratch, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])multiByte, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(multiByte, 3), result));
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(scratch);
        multiByte = Arrays.copyOf(scratch, 5);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])multiByte, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(multiByte, 4), result));
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(scratch);
        multiByte = Arrays.copyOf(scratch, 9);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])multiByte, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(multiByte, 5), result));
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(scratch);
        multiByte = Arrays.copyOfRange(scratch, 3, 5);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte) == 2 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])multiByte, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(multiByte, 1), result));
        int sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(scratch, 0);
        byte[] sentenceOne = Arrays.copyOf(scratch, sentenceOneLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne) == 10 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceOne, (int)8);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOne, 20), result));
        byte[] sentenceOnePortion = Arrays.copyOf(sentenceOne, sentenceOneLen - 3);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePortion) == 9 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceOnePortion, (int)3);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePortion, 9), result));
        int sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(scratch, 0);
        byte[] sentenceTwo = Arrays.copyOf(scratch, sentenceTwoLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo) == 13 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceTwo, (int)9);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwo, 16), result));
        byte[] sentenceTwoPortion = Arrays.copyOf(sentenceTwo, sentenceTwoLen - 5);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPortion) == 10 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceTwoPortion, (int)6);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPortion, 11), result));
        int start = TestVectorStringExpressions.addPads(scratch, 0, 3);
        int sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(scratch, start);
        byte[] sentenceOnePaddedLeft = Arrays.copyOf(scratch, sentenceOnePaddedLeftLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft) == 13 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceOnePaddedLeft, (int)4);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePaddedLeft, 6), result));
        byte[] sentenceOnePaddedLeftPortion = Arrays.copyOf(sentenceOnePaddedLeft, sentenceOnePaddedLeftLen - 3);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeftPortion) == 12 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceOnePaddedLeftPortion, (int)7);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePaddedLeftPortion, 13), result));
        start = TestVectorStringExpressions.addPads(scratch, 0, 2);
        int sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(scratch, start);
        byte[] sentenceTwoPaddedLeft = Arrays.copyOf(scratch, sentenceTwoPaddedLeftLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft) == 15 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceTwoPaddedLeft, (int)14);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPaddedLeft, 24), result));
        byte[] sentenceTwoPaddedLeftPortion = Arrays.copyOf(sentenceTwoPaddedLeft, sentenceTwoPaddedLeftLen - 5);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeftPortion) == 12 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceTwoPaddedLeftPortion, (int)9);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPaddedLeftPortion, 15), result));
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(scratch, 0);
        int sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(scratch, start, 4);
        byte[] sentenceOnePaddedRight = Arrays.copyOf(scratch, sentenceOnePaddedRightLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight) == 14 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceOnePaddedRight, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePaddedRight, 3), result));
        byte[] sentenceOnePaddedRightPortion = Arrays.copyOf(sentenceOnePaddedRight, sentenceOnePaddedRightLen - 3 - 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRightPortion) == 9 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceOnePaddedRightPortion, (int)5);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePaddedRightPortion, 13), result));
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(scratch, 0);
        int sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(scratch, start, 1);
        byte[] sentenceTwoPaddedRight = Arrays.copyOf(scratch, sentenceTwoPaddedRightLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight) == 14 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceTwoPaddedRight, (int)6);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPaddedRight, 11), result));
        byte[] sentenceTwoPaddedRightPortion = Arrays.copyOf(sentenceTwoPaddedRight, sentenceTwoPaddedRightLen - 5 - 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRightPortion) == 10 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceTwoPaddedRightPortion, (int)8);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPaddedRightPortion, 14), result));
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(scratch, 0);
        byte[] sentenceBlankRanges = Arrays.copyOf(scratch, sentenceBlankRangesLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges) == 17 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceBlankRanges, (int)4);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceBlankRanges, 9), result));
        byte[] sentenceBlankRangesPortion = Arrays.copyOf(sentenceBlankRanges, sentenceBlankRangesLen - 3);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRangesPortion) == 16 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceBlankRangesPortion, (int)14);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceBlankRangesPortion, 23), result));
        sentenceBlankRangesPortion = Arrays.copyOfRange(sentenceBlankRanges, 7, 24);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRangesPortion) == 13 ? 1 : 0) != 0);
        result = StringExpr.truncateScalar((byte[])sentenceBlankRangesPortion, (int)11);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceBlankRangesPortion, 15), result));
        Assert.assertTrue((StringExpr.characterCount((byte[])result) == 11 ? 1 : 0) != 0);
    }

    @Test
    public void testRightTrimAndTruncateBytesSlice() {
        int largeMaxLength = 100;
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        int resultLen = StringExpr.rightTrimAndTruncate((byte[])blue, (int)0, (int)blue.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == blue.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)resultLen) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])redgreen, (int)0, (int)redgreen.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == redgreen.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == ascii_sentence.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == blanksLeft.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksRight, (int)0, (int)blanksRight.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)0, (int)blanksBoth.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)resultLen) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankString, (int)0, (int)blankString.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)0, (int)blankRanges.length, (int)largeMaxLength);
        Assert.assertTrue((resultLen == blankRanges.length - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)resultLen) == 26 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1), (int)largeMaxLength);
        Assert.assertTrue((resultLen == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)resultLen) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4), (int)largeMaxLength);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)resultLen) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5), (int)largeMaxLength);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)(blankString.length - 1)) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankString, (int)1, (int)(blankString.length - 1), (int)largeMaxLength);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4)) == 26 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4), (int)largeMaxLength);
        Assert.assertTrue((resultLen == blankRanges.length - 4 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)resultLen) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6), (int)largeMaxLength);
        Assert.assertTrue((resultLen == blankRanges.length - 6 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)resultLen) == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7), (int)largeMaxLength);
        Assert.assertTrue((resultLen == blankRanges.length - 7 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 19 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)1) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)7, (int)1, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 0 ? 1 : 0) != 0);
        byte[] multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)4, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)5, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)9, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)1) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)3, (int)1, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 0 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)3, (int)2, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)resultLen) == 1 ? 1 : 0) != 0);
        byte[] sentenceOne = new byte[100];
        int sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOne, (int)0, (int)sentenceOneLen, (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceOneLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3), (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceOneLen - 3 ? 1 : 0) != 0);
        byte[] sentenceTwo = new byte[100];
        int sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen, (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceTwoLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5), (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceTwoLen - 5 ? 1 : 0) != 0);
        byte[] sentenceOnePaddedLeft = new byte[100];
        int start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        int sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen, (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceOnePaddedLeftLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3), (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceOnePaddedLeftLen - 3 ? 1 : 0) != 0);
        byte[] sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        int sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen, (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceTwoPaddedLeftLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5), (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceTwoPaddedLeftLen - 5 ? 1 : 0) != 0);
        byte[] sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        int sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen, (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceOnePaddedRightLen - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4), (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceOnePaddedRightLen - 3 - 4 ? 1 : 0) != 0);
        byte[] sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        int sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen, (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceTwoPaddedRightLen - 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1), (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceTwoPaddedRightLen - 5 - 1 ? 1 : 0) != 0);
        byte[] sentenceBlankRanges = new byte[100];
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen, (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceBlankRangesLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3), (int)largeMaxLength);
        Assert.assertTrue((resultLen == sentenceBlankRangesLen - 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)7, (int)17, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 12 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)resultLen) == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blue, (int)0, (int)blue.length, (int)4);
        Assert.assertTrue((resultLen == blue.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)resultLen) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])redgreen, (int)0, (int)redgreen.length, (int)8);
        Assert.assertTrue((resultLen == redgreen.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)31);
        Assert.assertTrue((resultLen == ascii_sentence.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)5);
        Assert.assertTrue((resultLen == blanksLeft.length ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)0);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksRight, (int)0, (int)blanksRight.length, (int)5);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)0, (int)blanksBoth.length, (int)7);
        Assert.assertTrue((resultLen == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)resultLen) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankString, (int)0, (int)blankString.length, (int)2);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)0, (int)blankRanges.length, (int)30);
        Assert.assertTrue((resultLen == blankRanges.length - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)resultLen) == 26 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1), (int)4);
        Assert.assertTrue((resultLen == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)resultLen) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4), (int)3);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)resultLen) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5), (int)2);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)(blankString.length - 1)) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankString, (int)1, (int)(blankString.length - 1), (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4)) == 26 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4), (int)26);
        Assert.assertTrue((resultLen == blankRanges.length - 4 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)resultLen) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6), (int)24);
        Assert.assertTrue((resultLen == blankRanges.length - 6 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)resultLen) == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7), (int)23);
        Assert.assertTrue((resultLen == blankRanges.length - 7 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 19 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)1) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)7, (int)1, (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 0 ? 1 : 0) != 0);
        multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)4, (int)2);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)5, (int)3);
        Assert.assertTrue((resultLen == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)9, (int)4);
        Assert.assertTrue((resultLen == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)1) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)3, (int)1, (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 0 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)3, (int)2, (int)2);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)resultLen) == 1 ? 1 : 0) != 0);
        sentenceOne = new byte[100];
        sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOne, (int)0, (int)sentenceOneLen, (int)10);
        Assert.assertTrue((resultLen == sentenceOneLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3), (int)9);
        Assert.assertTrue((resultLen == sentenceOneLen - 3 ? 1 : 0) != 0);
        sentenceTwo = new byte[100];
        sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen, (int)13);
        Assert.assertTrue((resultLen == sentenceTwoLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5), (int)10);
        Assert.assertTrue((resultLen == sentenceTwoLen - 5 ? 1 : 0) != 0);
        sentenceOnePaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen, (int)13);
        Assert.assertTrue((resultLen == sentenceOnePaddedLeftLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3), (int)12);
        Assert.assertTrue((resultLen == sentenceOnePaddedLeftLen - 3 ? 1 : 0) != 0);
        sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen, (int)15);
        Assert.assertTrue((resultLen == sentenceTwoPaddedLeftLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5), (int)12);
        Assert.assertTrue((resultLen == sentenceTwoPaddedLeftLen - 5 ? 1 : 0) != 0);
        sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen, (int)14);
        Assert.assertTrue((resultLen == sentenceOnePaddedRightLen - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4), (int)9);
        Assert.assertTrue((resultLen == sentenceOnePaddedRightLen - 3 - 4 ? 1 : 0) != 0);
        sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen, (int)14);
        Assert.assertTrue((resultLen == sentenceTwoPaddedRightLen - 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1), (int)10);
        Assert.assertTrue((resultLen == sentenceTwoPaddedRightLen - 5 - 1 ? 1 : 0) != 0);
        sentenceBlankRanges = new byte[100];
        sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen, (int)17);
        Assert.assertTrue((resultLen == sentenceBlankRangesLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3), (int)16);
        Assert.assertTrue((resultLen == sentenceBlankRangesLen - 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)7, (int)17, (int)largeMaxLength);
        Assert.assertTrue((resultLen == 12 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)resultLen) == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blue, (int)0, (int)blue.length, (int)3);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])redgreen, (int)0, (int)redgreen.length, (int)6);
        Assert.assertTrue((resultLen == 6 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)30);
        Assert.assertTrue((resultLen == 30 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksRight, (int)0, (int)blanksRight.length, (int)4);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)0, (int)blanksBoth.length, (int)6);
        Assert.assertTrue((resultLen == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)resultLen) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankString, (int)0, (int)blankString.length, (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)0, (int)blankRanges.length, (int)19);
        Assert.assertTrue((resultLen == 15 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)resultLen) == 15 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1), (int)3);
        Assert.assertTrue((resultLen == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)resultLen) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4), (int)2);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)resultLen) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5), (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)(blankString.length - 1)) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankString, (int)1, (int)(blankString.length - 1), (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)resultLen) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)3, (int)6) == 6 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)3, (int)6, (int)5);
        Assert.assertTrue((resultLen == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)3, (int)resultLen) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6), (int)22);
        Assert.assertTrue((resultLen == blankRanges.length - 6 - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)resultLen) == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7), (int)10);
        Assert.assertTrue((resultLen == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)1) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])blankRanges, (int)7, (int)1, (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)resultLen) == 0 ? 1 : 0) != 0);
        multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)4, (int)1);
        Assert.assertTrue((resultLen == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)5, (int)2);
        Assert.assertTrue((resultLen == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)0, (int)9, (int)3);
        Assert.assertTrue((resultLen == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 3 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)1) == 1 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)3, (int)1, (int)1);
        Assert.assertTrue((resultLen == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)resultLen) == 0 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])multiByte, (int)3, (int)2, (int)1);
        Assert.assertTrue((resultLen == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)resultLen) == 1 ? 1 : 0) != 0);
        sentenceOne = new byte[100];
        sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOne, (int)0, (int)sentenceOneLen, (int)7);
        Assert.assertTrue((resultLen == sentenceOneLen - 9 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3), (int)6);
        Assert.assertTrue((resultLen == 13 ? 1 : 0) != 0);
        sentenceTwo = new byte[100];
        sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen, (int)13);
        Assert.assertTrue((resultLen == sentenceTwoLen ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5), (int)10);
        Assert.assertTrue((resultLen == sentenceTwoLen - 5 ? 1 : 0) != 0);
        sentenceOnePaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen, (int)11);
        Assert.assertTrue((resultLen == sentenceOnePaddedLeftLen - 6 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3), (int)9);
        Assert.assertTrue((resultLen == 16 ? 1 : 0) != 0);
        sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen, (int)7);
        Assert.assertTrue((resultLen == 10 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5), (int)6);
        Assert.assertTrue((resultLen == 10 ? 1 : 0) != 0);
        sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen, (int)10);
        Assert.assertTrue((resultLen == sentenceOnePaddedRightLen - 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4), (int)7);
        Assert.assertTrue((resultLen == 17 ? 1 : 0) != 0);
        sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen, (int)13);
        Assert.assertTrue((resultLen == sentenceTwoPaddedRightLen - 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1), (int)4);
        Assert.assertTrue((resultLen == 8 ? 1 : 0) != 0);
        sentenceBlankRanges = new byte[100];
        sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen, (int)4);
        Assert.assertTrue((resultLen == 7 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3), (int)6);
        Assert.assertTrue((resultLen == 11 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)4, (int)12) == 8 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)4, (int)12, (int)6);
        Assert.assertTrue((resultLen == 7 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)4, (int)resultLen) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        resultLen = StringExpr.rightTrimAndTruncate((byte[])sentenceBlankRanges, (int)7, (int)17, (int)11);
        Assert.assertTrue((resultLen == 12 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)resultLen) == 8 ? 1 : 0) != 0);
    }

    @Test
    public void testRightTrimAndTruncateBytesColumnVector() {
        BytesColumnVector outV = new BytesColumnVector(1024);
        outV.initBuffer(35);
        int i = 0;
        int largeMaxLength = 100;
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)i, (byte[])blue, (int)0, (int)blue.length, (int)largeMaxLength);
        int expectedResultLen = blue.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blue, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])redgreen, (int)0, (int)redgreen.length, (int)largeMaxLength);
        expectedResultLen = redgreen.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, redgreen, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)largeMaxLength);
        expectedResultLen = ascii_sentence.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, ascii_sentence, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)largeMaxLength);
        expectedResultLen = blanksLeft.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)0, (int)blanksRight.length, (int)largeMaxLength);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)0, (int)blanksBoth.length, (int)largeMaxLength);
        expectedResultLen = 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)0, (int)blankString.length, (int)largeMaxLength);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)0, (int)blankRanges.length, (int)largeMaxLength);
        expectedResultLen = blankRanges.length - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 26 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)1, (int)(blanksRight.length - 1), (int)largeMaxLength);
        expectedResultLen = 2;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4), (int)largeMaxLength);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5), (int)largeMaxLength);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 5, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)(blankString.length - 1)) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)1, (int)(blankString.length - 1), (int)largeMaxLength);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4)) == 26 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)4, (int)(blankRanges.length - 4), (int)largeMaxLength);
        expectedResultLen = blankRanges.length - 4 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)6, (int)(blankRanges.length - 6), (int)largeMaxLength);
        expectedResultLen = blankRanges.length - 6 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 6, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)(blankRanges.length - 7), (int)largeMaxLength);
        expectedResultLen = blankRanges.length - 7 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 19 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)1) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)1, (int)largeMaxLength);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        byte[] multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)4, (int)largeMaxLength);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)5, (int)largeMaxLength);
        expectedResultLen = 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)9, (int)largeMaxLength);
        expectedResultLen = 8;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)1) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)1, (int)largeMaxLength);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)2, (int)largeMaxLength);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        byte[] sentenceOne = new byte[100];
        int sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)sentenceOneLen, (int)largeMaxLength);
        expectedResultLen = sentenceOneLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3), (int)largeMaxLength);
        expectedResultLen = sentenceOneLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        byte[] sentenceTwo = new byte[100];
        int sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)sentenceTwoLen, (int)largeMaxLength);
        expectedResultLen = sentenceTwoLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5), (int)largeMaxLength);
        expectedResultLen = sentenceTwoLen - 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        byte[] sentenceOnePaddedLeft = new byte[100];
        int start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        int sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen, (int)largeMaxLength);
        expectedResultLen = sentenceOnePaddedLeftLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3), (int)largeMaxLength);
        expectedResultLen = sentenceOnePaddedLeftLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        ++i;
        byte[] sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        int sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen, (int)largeMaxLength);
        expectedResultLen = sentenceTwoPaddedLeftLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5), (int)largeMaxLength);
        expectedResultLen = sentenceTwoPaddedLeftLen - 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        byte[] sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        int sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen, (int)largeMaxLength);
        expectedResultLen = sentenceOnePaddedRightLen - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4), (int)largeMaxLength);
        expectedResultLen = sentenceOnePaddedRightLen - 3 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        byte[] sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        int sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen, (int)largeMaxLength);
        expectedResultLen = sentenceTwoPaddedRightLen - 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1), (int)largeMaxLength);
        expectedResultLen = sentenceTwoPaddedRightLen - 5 - 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        byte[] sentenceBlankRanges = new byte[100];
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen, (int)largeMaxLength);
        expectedResultLen = sentenceBlankRangesLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3), (int)largeMaxLength);
        expectedResultLen = sentenceBlankRangesLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)7, (int)17, (int)largeMaxLength);
        expectedResultLen = 12;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blue, (int)0, (int)blue.length, (int)4);
        expectedResultLen = blue.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blue, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])redgreen, (int)0, (int)redgreen.length, (int)8);
        expectedResultLen = redgreen.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, redgreen, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)31);
        expectedResultLen = ascii_sentence.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, ascii_sentence, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)5);
        expectedResultLen = blanksLeft.length;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)0, (int)blanksRight.length, (int)5);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)0, (int)blanksBoth.length, (int)7);
        expectedResultLen = 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)0, (int)blankString.length, (int)2);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)0, (int)blankRanges.length, (int)30);
        expectedResultLen = blankRanges.length - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 26 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)1, (int)(blanksRight.length - 1), (int)4);
        expectedResultLen = 2;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4), (int)3);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5), (int)2);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 5, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)(blankString.length - 1)) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)1, (int)(blankString.length - 1), (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)4, (int)(blankRanges.length - 4)) == 26 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)4, (int)(blankRanges.length - 4), (int)26);
        expectedResultLen = blankRanges.length - 4 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)6, (int)(blankRanges.length - 6), (int)24);
        expectedResultLen = blankRanges.length - 6 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 6, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)(blankRanges.length - 7), (int)23);
        expectedResultLen = blankRanges.length - 7 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 19 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)1) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)1, (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)4, (int)2);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)5, (int)3);
        expectedResultLen = 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)9, (int)4);
        expectedResultLen = 8;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)1) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)1, (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)2, (int)2);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        sentenceOne = new byte[100];
        sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)sentenceOneLen, (int)10);
        expectedResultLen = sentenceOneLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3), (int)9);
        expectedResultLen = sentenceOneLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        sentenceTwo = new byte[100];
        sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)sentenceTwoLen, (int)13);
        expectedResultLen = sentenceTwoLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5), (int)10);
        expectedResultLen = sentenceTwoLen - 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        sentenceOnePaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen, (int)13);
        expectedResultLen = sentenceOnePaddedLeftLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3), (int)12);
        expectedResultLen = sentenceOnePaddedLeftLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        ++i;
        sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen, (int)15);
        expectedResultLen = sentenceTwoPaddedLeftLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5), (int)12);
        expectedResultLen = sentenceTwoPaddedLeftLen - 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen, (int)14);
        expectedResultLen = sentenceOnePaddedRightLen - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4), (int)9);
        expectedResultLen = sentenceOnePaddedRightLen - 3 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen, (int)14);
        expectedResultLen = sentenceTwoPaddedRightLen - 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1), (int)10);
        expectedResultLen = sentenceTwoPaddedRightLen - 5 - 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        sentenceBlankRanges = new byte[100];
        sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen, (int)17);
        expectedResultLen = sentenceBlankRangesLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3), (int)16);
        expectedResultLen = sentenceBlankRangesLen - 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)7, (int)17, (int)largeMaxLength);
        expectedResultLen = 12;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blue, (int)0, (int)blue.length) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blue, (int)0, (int)blue.length, (int)3);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blue, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen, (int)0, (int)redgreen.length) == 8 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])redgreen, (int)0, (int)redgreen.length, (int)6);
        expectedResultLen = 6;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, redgreen, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence, (int)0, (int)ascii_sentence.length) == 31 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])ascii_sentence, (int)0, (int)ascii_sentence.length, (int)30);
        expectedResultLen = 30;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, ascii_sentence, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft, (int)0, (int)blanksLeft.length) == 5 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksLeft, (int)0, (int)blanksLeft.length, (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)0, (int)blanksRight.length) == 5 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)0, (int)blanksRight.length, (int)4);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)0, (int)blanksBoth.length) == 7 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)0, (int)blanksBoth.length, (int)6);
        expectedResultLen = 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)0, (int)blankString.length) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)0, (int)blankString.length, (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)0, (int)blankRanges.length) == 30 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)0, (int)blankRanges.length, (int)19);
        expectedResultLen = 15;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 15 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksRight, (int)1, (int)(blanksRight.length - 1)) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksRight, (int)1, (int)(blanksRight.length - 1), (int)3);
        expectedResultLen = 2;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksRight, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4)) == 3 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)4, (int)(blanksBoth.length - 4), (int)2);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5)) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blanksBoth, (int)5, (int)(blanksBoth.length - 5), (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blanksBoth, 5, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankString, (int)1, (int)(blankString.length - 1)) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankString, (int)1, (int)(blankString.length - 1), (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankString, 1, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)3, (int)6) == 6 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)3, (int)6, (int)5);
        expectedResultLen = 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 4 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)6, (int)(blankRanges.length - 6)) == 24 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)6, (int)(blankRanges.length - 6), (int)22);
        expectedResultLen = blankRanges.length - 6 - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 6, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 20 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)(blankRanges.length - 7)) == 23 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)(blankRanges.length - 7), (int)10);
        expectedResultLen = 8;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 8 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])blankRanges, (int)7, (int)1) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])blankRanges, (int)7, (int)1, (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, blankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        multiByte = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)4, (int)1);
        expectedResultLen = 3;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)5, (int)2);
        expectedResultLen = 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 2 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)0, (int)9, (int)3);
        expectedResultLen = 8;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 0, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 3 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)1) == 1 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)1, (int)1);
        expectedResultLen = 0;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 0 ? 1 : 0) != 0);
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(multiByte);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)3, (int)2) == 2 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])multiByte, (int)3, (int)2, (int)1);
        expectedResultLen = 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, multiByte, 3, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 1 ? 1 : 0) != 0);
        sentenceOne = new byte[100];
        sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOne, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)sentenceOneLen) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)sentenceOneLen, (int)7);
        expectedResultLen = sentenceOneLen - 9;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3)) == 9 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOne, (int)0, (int)(sentenceOneLen - 3), (int)6);
        expectedResultLen = 13;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOne, 0, expectedResultLen));
        sentenceTwo = new byte[100];
        sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwo, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)sentenceTwoLen) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)sentenceTwoLen, (int)13);
        expectedResultLen = sentenceTwoLen;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5)) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwo, (int)0, (int)(sentenceTwoLen - 5), (int)10);
        expectedResultLen = sentenceTwoLen - 5;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwo, 0, expectedResultLen));
        sentenceOnePaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceOnePaddedLeft, 0, 3);
        sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)sentenceOnePaddedLeftLen, (int)11);
        expectedResultLen = sentenceOnePaddedLeftLen - 6;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3)) == 12 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedLeft, (int)0, (int)(sentenceOnePaddedLeftLen - 3), (int)9);
        expectedResultLen = 16;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedLeft, 0, expectedResultLen));
        sentenceTwoPaddedLeft = new byte[100];
        start = TestVectorStringExpressions.addPads(sentenceTwoPaddedLeft, 0, 2);
        sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedLeft, start);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen) == 15 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)sentenceTwoPaddedLeftLen, (int)7);
        expectedResultLen = 10;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5)) == 12 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedLeft, (int)0, (int)(sentenceTwoPaddedLeftLen - 5), (int)6);
        expectedResultLen = 10;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedLeft, 0, expectedResultLen));
        sentenceOnePaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(sentenceOnePaddedRight, 0);
        sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(sentenceOnePaddedRight, start, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)sentenceOnePaddedRightLen, (int)10);
        expectedResultLen = sentenceOnePaddedRightLen - 4;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4)) == 9 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceOnePaddedRight, (int)0, (int)(sentenceOnePaddedRightLen - 3 - 4), (int)7);
        expectedResultLen = 17;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceOnePaddedRight, 0, expectedResultLen));
        sentenceTwoPaddedRight = new byte[100];
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(sentenceTwoPaddedRight, 0);
        sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(sentenceTwoPaddedRight, start, 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen) == 14 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)sentenceTwoPaddedRightLen, (int)13);
        expectedResultLen = sentenceTwoPaddedRightLen - 1;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1)) == 10 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceTwoPaddedRight, (int)0, (int)(sentenceTwoPaddedRightLen - 5 - 1), (int)4);
        expectedResultLen = 8;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceTwoPaddedRight, 0, expectedResultLen));
        sentenceBlankRanges = new byte[100];
        sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(sentenceBlankRanges, 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen) == 17 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)sentenceBlankRangesLen, (int)4);
        expectedResultLen = 7;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3)) == 16 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)0, (int)(sentenceBlankRangesLen - 3), (int)6);
        expectedResultLen = 11;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 0, expectedResultLen));
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)4, (int)12) == 8 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)4, (int)12, (int)6);
        expectedResultLen = 7;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 4, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 5 ? 1 : 0) != 0);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges, (int)7, (int)17) == 13 ? 1 : 0) != 0);
        StringExpr.rightTrimAndTruncate((BytesColumnVector)outV, (int)(++i), (byte[])sentenceBlankRanges, (int)7, (int)17, (int)11);
        expectedResultLen = 12;
        Assert.assertTrue((boolean)this.vectorEqual(outV, i, sentenceBlankRanges, 7, expectedResultLen));
        Assert.assertTrue((this.vectorCharacterCount(outV, i) == 8 ? 1 : 0) != 0);
        ++i;
    }

    @Test
    public void testRightTrimAndTruncateScalar() {
        int largeMaxLength = 100;
        Assert.assertTrue((StringExpr.characterCount((byte[])blue) == 4 ? 1 : 0) != 0);
        byte[] result = StringExpr.rightTrimAndTruncateScalar((byte[])blue, (int)largeMaxLength);
        Assert.assertTrue((boolean)Arrays.equals(blue, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen) == 8 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])redgreen, (int)largeMaxLength);
        Assert.assertTrue((boolean)Arrays.equals(redgreen, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence) == 31 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])ascii_sentence, (int)largeMaxLength);
        Assert.assertTrue((boolean)Arrays.equals(ascii_sentence, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft) == 5 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blanksLeft, (int)largeMaxLength);
        Assert.assertTrue((boolean)Arrays.equals(blanksLeft, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])blue) == 4 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blue, (int)blue.length);
        Assert.assertTrue((boolean)Arrays.equals(blue, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])redgreen) == 8 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])redgreen, (int)redgreen.length);
        Assert.assertTrue((boolean)Arrays.equals(redgreen, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])ascii_sentence) == 31 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])ascii_sentence, (int)ascii_sentence.length);
        Assert.assertTrue((boolean)Arrays.equals(ascii_sentence, result));
        Assert.assertTrue((StringExpr.characterCount((byte[])blanksLeft) == 5 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blanksLeft, (int)blanksLeft.length);
        Assert.assertTrue((boolean)Arrays.equals(blanksLeft, result));
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blue, (int)3);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blue, 3), result));
        result = StringExpr.rightTrimAndTruncateScalar((byte[])redgreen, (int)6);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(redgreen, 6), result));
        result = StringExpr.rightTrimAndTruncateScalar((byte[])ascii_sentence, (int)14);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(ascii_sentence, 14), result));
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blanksLeft, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blanksLeft, 0), result));
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blanksRight, (int)4);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blanksRight, 3), result));
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blanksBoth, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blanksBoth, 0), result));
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blankString, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blankString, 0), result));
        result = StringExpr.rightTrimAndTruncateScalar((byte[])blankRanges, (int)29);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(blankRanges, 26), result));
        byte[] scratch = new byte[100];
        TestVectorStringExpressions.addMultiByteCharRightPadded1_1(scratch);
        byte[] multiByte = Arrays.copyOf(scratch, 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)4) == 2 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])multiByte, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(multiByte, 3), result));
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(scratch);
        multiByte = Arrays.copyOf(scratch, 5);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)5) == 3 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])multiByte, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(multiByte, 4), result));
        TestVectorStringExpressions.addMultiByteCharRightPadded1_3(scratch);
        multiByte = Arrays.copyOf(scratch, 9);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte, (int)0, (int)9) == 4 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])multiByte, (int)2);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(multiByte, 5), result));
        TestVectorStringExpressions.addMultiByteCharRightPadded1_2(scratch);
        multiByte = Arrays.copyOfRange(scratch, 3, 5);
        Assert.assertTrue((StringExpr.characterCount((byte[])multiByte) == 2 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])multiByte, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(multiByte, 1), result));
        int sentenceOneLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(scratch, 0);
        byte[] sentenceOne = Arrays.copyOf(scratch, sentenceOneLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOne) == 10 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceOne, (int)8);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOne, 20), result));
        byte[] sentenceOnePortion = Arrays.copyOf(sentenceOne, sentenceOneLen - 3);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePortion) == 9 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceOnePortion, (int)3);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePortion, 9), result));
        int sentenceTwoLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(scratch, 0);
        byte[] sentenceTwo = Arrays.copyOf(scratch, sentenceTwoLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwo) == 13 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceTwo, (int)9);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwo, 16), result));
        byte[] sentenceTwoPortion = Arrays.copyOf(sentenceTwo, sentenceTwoLen - 5);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPortion) == 10 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceTwoPortion, (int)6);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPortion, 11), result));
        int start = TestVectorStringExpressions.addPads(scratch, 0, 3);
        int sentenceOnePaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceOne(scratch, start);
        byte[] sentenceOnePaddedLeft = Arrays.copyOf(scratch, sentenceOnePaddedLeftLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeft) == 13 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceOnePaddedLeft, (int)4);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePaddedLeft, 6), result));
        byte[] sentenceOnePaddedLeftPortion = Arrays.copyOf(sentenceOnePaddedLeft, sentenceOnePaddedLeftLen - 3);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedLeftPortion) == 12 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceOnePaddedLeftPortion, (int)7);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePaddedLeftPortion, 12), result));
        start = TestVectorStringExpressions.addPads(scratch, 0, 2);
        int sentenceTwoPaddedLeftLen = TestVectorStringExpressions.addMultiByteCharSentenceTwo(scratch, start);
        byte[] sentenceTwoPaddedLeft = Arrays.copyOf(scratch, sentenceTwoPaddedLeftLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeft) == 15 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceTwoPaddedLeft, (int)14);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPaddedLeft, 24), result));
        byte[] sentenceTwoPaddedLeftPortion = Arrays.copyOf(sentenceTwoPaddedLeft, sentenceTwoPaddedLeftLen - 5);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedLeftPortion) == 12 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceTwoPaddedLeftPortion, (int)9);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPaddedLeftPortion, 15), result));
        start = TestVectorStringExpressions.addMultiByteCharSentenceOne(scratch, 0);
        int sentenceOnePaddedRightLen = TestVectorStringExpressions.addPads(scratch, start, 4);
        byte[] sentenceOnePaddedRight = Arrays.copyOf(scratch, sentenceOnePaddedRightLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRight) == 14 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceOnePaddedRight, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePaddedRight, 3), result));
        byte[] sentenceOnePaddedRightPortion = Arrays.copyOf(sentenceOnePaddedRight, sentenceOnePaddedRightLen - 3 - 4);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceOnePaddedRightPortion) == 9 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceOnePaddedRightPortion, (int)5);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceOnePaddedRightPortion, 13), result));
        start = TestVectorStringExpressions.addMultiByteCharSentenceTwo(scratch, 0);
        int sentenceTwoPaddedRightLen = TestVectorStringExpressions.addPads(scratch, start, 1);
        byte[] sentenceTwoPaddedRight = Arrays.copyOf(scratch, sentenceTwoPaddedRightLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRight) == 14 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceTwoPaddedRight, (int)6);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPaddedRight, 11), result));
        byte[] sentenceTwoPaddedRightPortion = Arrays.copyOf(sentenceTwoPaddedRight, sentenceTwoPaddedRightLen - 5 - 1);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceTwoPaddedRightPortion) == 10 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceTwoPaddedRightPortion, (int)8);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceTwoPaddedRightPortion, 13), result));
        int sentenceBlankRangesLen = TestVectorStringExpressions.addMultiByteCharSentenceBlankRanges(scratch, 0);
        byte[] sentenceBlankRanges = Arrays.copyOf(scratch, sentenceBlankRangesLen);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRanges) == 17 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceBlankRanges, (int)4);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceBlankRanges, 7), result));
        byte[] sentenceBlankRangesPortion = Arrays.copyOf(sentenceBlankRanges, sentenceBlankRangesLen - 3);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRangesPortion) == 16 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceBlankRangesPortion, (int)14);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceBlankRangesPortion, 19), result));
        sentenceBlankRangesPortion = Arrays.copyOfRange(sentenceBlankRanges, 7, 24);
        Assert.assertTrue((StringExpr.characterCount((byte[])sentenceBlankRangesPortion) == 13 ? 1 : 0) != 0);
        result = StringExpr.rightTrimAndTruncateScalar((byte[])sentenceBlankRangesPortion, (int)11);
        Assert.assertTrue((boolean)Arrays.equals(Arrays.copyOf(sentenceBlankRangesPortion, 12), result));
        Assert.assertTrue((StringExpr.characterCount((byte[])result) == 8 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBytesColumnVectorByValueLargeData() {
        BytesColumnVector bcv = new BytesColumnVector(1024);
        bcv.initBuffer(10);
        int initialBufferSize = bcv.bufferSize();
        String s = "0123456789";
        while (s.length() < 500) {
            s = s + s;
        }
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i != 1024; ++i) {
            bcv.setVal(i, b, 0, b.length);
        }
        Assert.assertTrue((bcv.bufferSize() > initialBufferSize ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBytesColumnVectorByRef() {
        BytesColumnVector bcv = new BytesColumnVector(1024);
        String s = "red";
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i != 1024; ++i) {
            bcv.setRef(i, b, 0, b.length);
        }
        byte[] v = new byte[b.length];
        for (int i = 0; i != 1024; ++i) {
            Assert.assertTrue((bcv.length[i] == b.length ? 1 : 0) != 0);
            System.arraycopy(bcv.vector[i], bcv.start[i], v, 0, b.length);
            Assert.assertTrue((boolean)Arrays.equals(b, v));
        }
    }

    @Test
    public void testStringColCompareStringScalarFilter() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        FilterStringGroupColEqualStringScalar expr = new FilterStringGroupColEqualStringScalar(0, red2);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringGroupColLessStringScalar(0, red2);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 1 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringGroupColGreaterEqualStringScalar(0, green);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 2 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[1] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStringColCompareCharScalarFilter() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        FilterStringGroupColEqualCharScalar expr = new FilterStringGroupColEqualCharScalar(0, new HiveChar(new String(red2), 10).getStrippedValue().getBytes());
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringGroupColLessCharScalar(0, new HiveChar(new String(red2), 8).getStrippedValue().getBytes());
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 1 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringGroupColGreaterEqualCharScalar(0, new HiveChar(new String(green), 12).getStrippedValue().getBytes());
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 2 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[1] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStringColCompareVarCharScalarFilter() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        FilterStringGroupColEqualVarCharScalar expr = new FilterStringGroupColEqualVarCharScalar(0, new HiveVarchar(new String(red2), 10).getValue().getBytes());
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringGroupColLessVarCharScalar(0, new HiveVarchar(new String(red2), 8).getValue().getBytes());
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 1 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringGroupColGreaterEqualVarCharScalar(0, new HiveVarchar(new String(green), 12).getValue().getBytes());
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 2 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[1] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStringColCompareStringScalarProjection() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringGroupColEqualStringScalar expr = new StringGroupColEqualStringScalar(0, red2, 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        LongColumnVector outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)1L, (long)outVector.vector[0]);
        Assert.assertEquals((long)0L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
        batch = this.makeStringBatch();
        expr = new StringGroupColEqualStringScalar(0, green, 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)0L, (long)outVector.vector[0]);
        Assert.assertEquals((long)1L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
    }

    @Test
    public void testStringColCompareCharScalarProjection() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringGroupColEqualCharScalar expr = new StringGroupColEqualCharScalar(0, new HiveChar(new String(red2), 8).getStrippedValue().getBytes(), 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        LongColumnVector outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)1L, (long)outVector.vector[0]);
        Assert.assertEquals((long)0L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
        batch = this.makeStringBatch();
        expr = new StringGroupColEqualCharScalar(0, new HiveChar(new String(green), 10).getStrippedValue().getBytes(), 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)0L, (long)outVector.vector[0]);
        Assert.assertEquals((long)1L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
    }

    @Test
    public void testStringColCompareVarCharScalarProjection() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringGroupColEqualVarCharScalar expr = new StringGroupColEqualVarCharScalar(0, new HiveVarchar(new String(red2), 8).getValue().getBytes(), 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        LongColumnVector outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)1L, (long)outVector.vector[0]);
        Assert.assertEquals((long)0L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
        batch = this.makeStringBatch();
        expr = new StringGroupColEqualVarCharScalar(0, new HiveVarchar(new String(green), 10).getValue().getBytes(), 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)0L, (long)outVector.vector[0]);
        Assert.assertEquals((long)1L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
    }

    @Test
    public void testStringScalarCompareStringCol() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        FilterStringScalarEqualStringGroupColumn expr = new FilterStringScalarEqualStringGroupColumn(red2, 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringScalarGreaterStringGroupColumn(red2, 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 1 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringScalarLessEqualStringGroupColumn(green, 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 2 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[1] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCharScalarCompareStringCol() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        FilterCharScalarEqualStringGroupColumn expr = new FilterCharScalarEqualStringGroupColumn(new HiveChar(new String(red2), 8).getStrippedValue().getBytes(), 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterCharScalarGreaterStringGroupColumn(new HiveChar(new String(red2), 8).getStrippedValue().getBytes(), 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 1 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterCharScalarLessEqualStringGroupColumn(new HiveChar(new String(green), 10).getStrippedValue().getBytes(), 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 2 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[1] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testVarCharScalarCompareStringCol() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        FilterVarCharScalarEqualStringGroupColumn expr = new FilterVarCharScalarEqualStringGroupColumn(new HiveVarchar(new String(red2), 8).getValue().getBytes(), 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterVarCharScalarGreaterStringGroupColumn(new HiveVarchar(new String(red2), 8).getValue().getBytes(), 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 1 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterVarCharScalarLessEqualStringGroupColumn(new HiveVarchar(new String(green), 10).getValue().getBytes(), 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 2 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[1] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStringScalarCompareStringColProjection() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringScalarEqualStringGroupColumn expr = new StringScalarEqualStringGroupColumn(red2, 0, 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        LongColumnVector outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)1L, (long)outVector.vector[0]);
        Assert.assertEquals((long)0L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
        batch = this.makeStringBatch();
        expr = new StringScalarEqualStringGroupColumn(green, 0, 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)0L, (long)outVector.vector[0]);
        Assert.assertEquals((long)1L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
    }

    @Test
    public void testCharScalarCompareStringColProjection() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        CharScalarEqualStringGroupColumn expr = new CharScalarEqualStringGroupColumn(new HiveChar(new String(red2), 8).getStrippedValue().getBytes(), 0, 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        LongColumnVector outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)1L, (long)outVector.vector[0]);
        Assert.assertEquals((long)0L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
        batch = this.makeStringBatch();
        expr = new CharScalarEqualStringGroupColumn(new HiveChar(new String(green), 10).getStrippedValue().getBytes(), 0, 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)0L, (long)outVector.vector[0]);
        Assert.assertEquals((long)1L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
    }

    @Test
    public void testVarCharScalarCompareStringColProjection() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        VarCharScalarEqualStringGroupColumn expr = new VarCharScalarEqualStringGroupColumn(new HiveVarchar(new String(red2), 8).getValue().getBytes(), 0, 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        LongColumnVector outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)1L, (long)outVector.vector[0]);
        Assert.assertEquals((long)0L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
        batch = this.makeStringBatch();
        expr = new VarCharScalarEqualStringGroupColumn(new HiveVarchar(new String(green), 10).getValue().getBytes(), 0, 2);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)0L, (long)outVector.vector[0]);
        Assert.assertEquals((long)1L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
    }

    @Test
    public void testStringColCompareStringColFilter() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchForColColCompare();
        FilterStringGroupColLessStringGroupColumn expr = new FilterStringGroupColLessStringGroupColumn(0, 1);
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)2L, (long)batch.size);
        Assert.assertEquals((long)3L, (long)batch.selected[1]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[3] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)3L, (long)batch.selected[2]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)2L, (long)batch.size);
        Assert.assertEquals((long)1L, (long)batch.selected[1]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)3L, (long)batch.selected[2]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)2L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        Assert.assertEquals((long)1L, (long)batch.selected[1]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)2L, (long)batch.size);
        Assert.assertEquals((long)3L, (long)batch.selected[1]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)3L, (long)batch.selected[2]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
    }

    @Test
    public void testStringColCompareStringColProjection() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchForColColCompare();
        StringGroupColLessStringGroupColumn expr = new StringGroupColLessStringGroupColumn(0, 1, 3);
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        long[] outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)0L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertTrue((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)0L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)0L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[3] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)0L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertEquals((long)4L, (long)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertTrue((boolean)batch.cols[3].isNull[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertEquals((long)4L, (long)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertEquals((long)4L, (long)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertTrue((boolean)batch.cols[3].isNull[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertEquals((long)4L, (long)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertTrue((boolean)batch.cols[3].isNull[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)4L, (long)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertTrue((boolean)batch.cols[3].isNull[0]);
    }

    VectorizedRowBatch makeStringBatch() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        batch.cols[1] = new BytesColumnVector();
        batch.cols[2] = new LongColumnVector(batch.size);
        v.setRef(0, red, 0, red.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, emptyString, 0, emptyString.length);
        v.isNull[2] = true;
        v.noNulls = false;
        batch.size = 3;
        return batch;
    }

    VectorizedRowBatch makeStringBatchMixedCase() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1024);
        BytesColumnVector v = new BytesColumnVector(1024);
        batch.cols[0] = v;
        BytesColumnVector outV = new BytesColumnVector(1024);
        outV.initBuffer();
        batch.cols[1] = outV;
        v.setRef(0, mixedUp, 0, mixedUp.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, emptyString, 0, emptyString.length);
        v.isNull[2] = true;
        v.noNulls = false;
        batch.size = 3;
        return batch;
    }

    VectorizedRowBatch makeStringBatchMixedCharSize() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1024);
        BytesColumnVector v = new BytesColumnVector(1024);
        batch.cols[0] = v;
        LongColumnVector outV = new LongColumnVector(1024);
        batch.cols[1] = outV;
        v.setRef(0, mixedUp, 0, mixedUp.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, emptyString, 0, emptyString.length);
        v.isNull[2] = true;
        v.noNulls = false;
        v.setRef(3, multiByte, 0, 10);
        v.isNull[3] = false;
        batch.size = 4;
        return batch;
    }

    @Test
    public void testColLower() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchMixedCase();
        StringLower expr = new StringLower(0, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])mixedUpLower, (int)0, (int)mixedUpLower.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])green, (int)0, (int)green.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        batch = this.makeStringBatchMixedCase();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])mixedUpLower, (int)0, (int)mixedUpLower.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.noNulls);
        batch = this.makeStringBatchMixedCase();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])mixedUpLower, (int)0, (int)mixedUpLower.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        batch = this.makeStringBatchMixedCase();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])mixedUpLower, (int)0, (int)mixedUpLower.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testColUpper() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchMixedCase();
        StringUpper expr = new StringUpper(0, 1);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])mixedUpUpper, (int)0, (int)mixedUpUpper.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testStringLength() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchMixedCharSize();
        StringLength expr = new StringLength(0, 1);
        expr.evaluate(batch);
        LongColumnVector outCol = (LongColumnVector)batch.cols[1];
        Assert.assertEquals((long)5L, (long)outCol.vector[1]);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        Assert.assertEquals((long)4L, (long)outCol.vector[3]);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (LongColumnVector)batch.cols[1];
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)4L, (long)outCol.vector[3]);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (LongColumnVector)batch.cols[1];
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertEquals((long)7L, (long)outCol.vector[0]);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (LongColumnVector)batch.cols[1];
        Assert.assertEquals((long)7L, (long)outCol.vector[0]);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    private VectorizedRowBatch makeStringBatch2In1Out() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        BytesColumnVector v2 = new BytesColumnVector();
        batch.cols[1] = v2;
        batch.cols[2] = new BytesColumnVector();
        v.setRef(0, red, 0, red.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, emptyString, 0, emptyString.length);
        v.isNull[2] = true;
        v.noNulls = false;
        v2.setRef(0, red, 0, red.length);
        v2.isNull[0] = false;
        v2.setRef(1, green, 0, green.length);
        v2.isNull[1] = false;
        v2.setRef(2, emptyString, 0, emptyString.length);
        v2.isNull[2] = true;
        v2.noNulls = false;
        batch.size = 3;
        return batch;
    }

    private VectorizedRowBatch makeStringBatchForColColCompare() {
        VectorizedRowBatch batch = new VectorizedRowBatch(4);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        BytesColumnVector v2 = new BytesColumnVector();
        batch.cols[1] = v2;
        batch.cols[2] = new BytesColumnVector();
        batch.cols[3] = new LongColumnVector();
        v.setRef(0, blue, 0, blue.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, red, 0, red.length);
        v.isNull[2] = false;
        v.setRef(3, emptyString, 0, emptyString.length);
        v.isNull[3] = true;
        v.noNulls = false;
        v2.setRef(0, red, 0, red.length);
        v2.isNull[0] = false;
        v2.setRef(1, green, 0, green.length);
        v2.isNull[1] = false;
        v2.setRef(2, blue, 0, blue.length);
        v2.isNull[2] = false;
        v2.setRef(3, red, 0, red.length);
        v2.isNull[3] = false;
        v2.noNulls = false;
        batch.size = 4;
        return batch;
    }

    @Test
    public void testStringLike() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchMixedCharSize();
        Text pattern = new Text(mixPercentPattern);
        FilterStringColLikeStringScalar expr = new FilterStringColLikeStringScalar(0, mixPercentPattern);
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        batch = this.makeStringBatchMixedCharSize();
        int initialBatchSize = batch.size;
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)initialBatchSize, (long)batch.size);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
        batch = this.makeStringBatchMixedCharSize();
        initialBatchSize = batch.size;
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)initialBatchSize, (long)batch.size);
    }

    @Test
    public void testStringLikePatternType() throws HiveException {
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1, 1, 1);
        vrb.cols[0] = new BytesColumnVector(1);
        BytesColumnVector bcv = (BytesColumnVector)vrb.cols[0];
        vrb.size = 0;
        FilterStringColLikeStringScalar expr = new FilterStringColLikeStringScalar(0, "abc%".getBytes());
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(vrb);
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.BeginChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "%abc".getBytes(StandardCharsets.UTF_8));
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(vrb);
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.EndChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "%abc%".getBytes());
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(vrb);
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.MiddleChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "%abc%de".getBytes());
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(vrb);
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.ChainedChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "%abc_%de".getBytes());
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(vrb);
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.ComplexChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "abc".getBytes());
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(vrb);
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.NoneChecker.class, expr.checker.getClass());
    }

    @Test
    public void testStringLikeMultiByte() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchMixedCharSize();
        FilterStringColLikeStringScalar expr = new FilterStringColLikeStringScalar(0, ('%' + new String(multiByte) + '%').getBytes(StandardCharsets.UTF_8));
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)batch.size);
        batch = this.makeStringBatchMixedCharSize();
        expr = new FilterStringColLikeStringScalar(0, ('%' + new String(multiByte) + 'x').getBytes(StandardCharsets.UTF_8));
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
    }

    private String randomizePattern(Random control, String value) {
        switch (control.nextInt(10)) {
            default: {
                return value;
            }
            case 1: {
                return control.nextInt(1000) + value;
            }
            case 2: {
                return value + control.nextInt(1000);
            }
            case 3: {
                return control.nextInt(1000) + value.substring(1);
            }
            case 4: {
                return value.substring(1) + control.nextInt(1000);
            }
            case 5: {
                return control.nextInt(1000) + value.substring(0, value.length() - 1);
            }
            case 6: {
                return "";
            }
            case 7: {
                return value.toLowerCase();
            }
            case 8: {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < control.nextInt(12); ++i) {
                    sb.append((char)(97 + control.nextInt(26)));
                }
                return sb.toString();
            }
            case 9: 
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < control.nextInt(12); ++i) {
            sb.append((char)(65 + control.nextInt(26)));
        }
        return sb.toString();
    }

    private String generateCandidate(Random control, String pattern) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(pattern, "%");
        boolean leftAnchor = pattern.startsWith("%");
        boolean rightAnchor = pattern.endsWith("%");
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String chunk = tokens.nextToken();
            if (leftAnchor && i == 0) {
                sb.append(this.randomizePattern(control, chunk));
            } else if (rightAnchor && !tokens.hasMoreTokens()) {
                sb.append(this.randomizePattern(control, chunk));
            } else {
                sb.append(this.randomizePattern(control, chunk));
            }
            ++i;
        }
        return sb.toString();
    }

    @Test
    public void testStringLikeRandomized() throws HiveException {
        String[] patterns = new String[]{"ABC%", "%ABC", "%ABC%", "ABC%DEF", "ABC%DEF%", "%ABC%DEF", "%ABC%DEF%", "ABC%DEF%EFG", "%ABC%DEF%EFG", "%ABC%DEF%EFG%H"};
        long positive = 0L;
        long negative = 0L;
        Random control = new Random(1234L);
        UDFLike udf = new UDFLike();
        for (String pattern : patterns) {
            FilterStringColLikeStringScalar expr = new FilterStringColLikeStringScalar(0, pattern.getBytes(StandardCharsets.UTF_8));
            expr.transientInit((Configuration)this.hiveConf);
            VectorizedRowBatch batch = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1, 1, 1);
            batch.cols[0] = new BytesColumnVector(1);
            BytesColumnVector bcv = (BytesColumnVector)batch.cols[0];
            Text pText = new Text(pattern);
            for (int i = 0; i < 1024; ++i) {
                String input = this.generateCandidate(control, pattern);
                BooleanWritable like = udf.evaluate(new Text(input), pText);
                batch.reset();
                bcv.initBuffer();
                byte[] utf8 = input.getBytes(StandardCharsets.UTF_8);
                bcv.setVal(0, utf8, 0, utf8.length);
                bcv.noNulls = true;
                batch.size = 1;
                expr.evaluate(batch);
                if (like.get()) {
                    ++positive;
                } else {
                    ++negative;
                }
                Assert.assertEquals((String)String.format("Checking '%s' against '%s'", input, pattern), (Object)like.get(), (Object)(batch.size != 0 ? 1 : 0));
            }
        }
        LOG.info(String.format("Randomized testing: ran %d positive tests and %d negative tests", positive, negative));
    }

    @Test
    public void testColConcatStringScalar() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringGroupColConcatStringScalar expr = new StringGroupColConcatStringScalar(0, red, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        cmp2 = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        int cmp3 = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((long)0L, (long)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testColConcatCharScalar() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringGroupColConcatStringScalar expr = new StringGroupColConcatStringScalar(0, new HiveChar(new String(red), 6).getStrippedValue().getBytes(), 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        cmp2 = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        int cmp3 = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((long)0L, (long)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testColConcatVarCharScalar() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringGroupColConcatStringScalar expr = new StringGroupColConcatStringScalar(0, new HiveVarchar(new String(red), 14).getValue().getBytes(), 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        cmp2 = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        int cmp3 = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((long)0L, (long)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testStringScalarConcatCol() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringScalarConcatStringGroupCol expr = new StringScalarConcatStringGroupCol(red, 0, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        cmp2 = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        int cmp3 = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((long)0L, (long)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testCharScalarConcatCol() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringScalarConcatStringGroupCol expr = new StringScalarConcatStringGroupCol(new HiveChar(new String(red), 6).getStrippedValue().getBytes(), 0, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        cmp2 = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        int cmp3 = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((long)0L, (long)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testVarCharScalarConcatCol() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringScalarConcatStringGroupCol expr = new StringScalarConcatStringGroupCol(new HiveVarchar(new String(red), 14).getValue().getBytes(), 0, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        cmp2 = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        int cmp3 = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((long)0L, (long)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testColConcatCol() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatch2In1Out();
        StringGroupConcatColCol expr = new StringGroupConcatColCol(0, 1, 2);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[2];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])greengreen, (int)0, (int)greengreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        cmp2 = StringExpr.compare((byte[])greengreen, (int)0, (int)greengreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp2);
        int cmp3 = StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((long)0L, (long)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((Object)true, (Object)outCol.isRepeating);
        Assert.assertEquals((Object)true, (Object)outCol.isNull[0]);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((Object)false, (Object)outCol.isRepeating);
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertEquals((Object)true, (Object)outCol.isNull[2]);
        batch = this.makeStringBatch2In1Out();
        batch.cols[1].isRepeating = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((Object)true, (Object)outCol.isRepeating);
        Assert.assertEquals((Object)true, (Object)outCol.isNull[0]);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        batch.cols[1].isRepeating = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((Object)true, (Object)outCol.isRepeating);
        Assert.assertEquals((Object)true, (Object)outCol.isNull[0]);
        batch = this.makeStringBatch2In1Out();
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((Object)false, (Object)outCol.isRepeating);
        Assert.assertEquals((Object)false, (Object)outCol.isNull[0]);
        Assert.assertEquals((Object)false, (Object)outCol.noNulls);
        Assert.assertEquals((Object)true, (Object)outCol.isNull[2]);
        cmp = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((Object)false, (Object)outCol.isRepeating);
        cmp = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((long)0L, (long)cmp);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((Object)false, (Object)outCol.isRepeating);
        Assert.assertEquals((Object)false, (Object)outCol.isNull[0]);
        Assert.assertEquals((Object)false, (Object)outCol.noNulls);
        Assert.assertEquals((Object)true, (Object)outCol.isNull[2]);
        cmp = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((long)0L, (long)cmp);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((Object)true, (Object)outCol.isRepeating);
        Assert.assertEquals((Object)false, (Object)outCol.isNull[0]);
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
    }

    @Test
    public void testSubstrStart() throws HiveException {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        BytesColumnVector outV = new BytesColumnVector();
        batch.cols[1] = outV;
        byte[] data1 = "abcd string".getBytes(StandardCharsets.UTF_8);
        byte[] data2 = "efgh string".getBytes(StandardCharsets.UTF_8);
        byte[] data3 = "efgh".getBytes(StandardCharsets.UTF_8);
        batch.size = 3;
        v.noNulls = true;
        v.setRef(0, data1, 0, data1.length);
        v.isNull[0] = false;
        v.setRef(1, data2, 0, data2.length);
        v.isNull[1] = false;
        v.setRef(2, data3, 0, data3.length);
        v.isNull[2] = false;
        StringSubstrColStart expr = new StringSubstrColStart(0, 6, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        byte[] expected = "string".getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outCol.noNulls = false;
        outCol.isRepeating = true;
        expr = new StringSubstrColStart(0, -6, 1);
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outCol.noNulls = false;
        outCol.isRepeating = true;
        expr = new StringSubstrColStart(0, 1, 1);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data1, (int)0, (int)data1.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data2, (int)0, (int)data2.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data3, (int)0, (int)data3.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.noNulls = false;
        outV.isRepeating = true;
        expr = new StringSubstrColStart(0, 6, 1);
        v.noNulls = false;
        v.isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertFalse((boolean)outV.noNulls);
        Assert.assertTrue((boolean)outV.isNull[0]);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outCol.noNulls = false;
        outCol.isRepeating = false;
        outV = new BytesColumnVector();
        v = new BytesColumnVector();
        v.isRepeating = true;
        v.noNulls = true;
        v.setRef(0, data1, 0, data1.length);
        batch = new VectorizedRowBatch(2);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        expected = "string".getBytes(StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)outV.isRepeating);
        Assert.assertTrue((boolean)outV.noNulls);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        v = new BytesColumnVector();
        v.isRepeating = false;
        v.noNulls = true;
        v.setRef(0, multiByte, 0, 10);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStart(0, 3, 1);
        batch.size = 1;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertFalse((boolean)outV.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])multiByte, (int)3, (int)7, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        v = new BytesColumnVector();
        v.isRepeating = false;
        v.noNulls = true;
        v.setRef(0, multiByte, 3, 7);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        outV.isRepeating = true;
        outV.noNulls = false;
        outCol = (BytesColumnVector)batch.cols[1];
        expr = new StringSubstrColStart(0, 2, 1);
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outV.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])multiByte, (int)6, (int)4, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
    }

    @Test
    public void testSubstrStartLen() throws HiveException {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        BytesColumnVector outV = new BytesColumnVector();
        batch.cols[1] = outV;
        byte[] data1 = "abcd string".getBytes(StandardCharsets.UTF_8);
        byte[] data2 = "efgh string".getBytes(StandardCharsets.UTF_8);
        byte[] data3 = "efgh".getBytes(StandardCharsets.UTF_8);
        batch.size = 3;
        v.noNulls = true;
        v.setRef(0, data1, 0, data1.length);
        v.isNull[0] = false;
        v.setRef(1, data2, 0, data2.length);
        v.isNull[1] = false;
        v.setRef(2, data3, 0, data3.length);
        v.isNull[2] = false;
        outV.isRepeating = true;
        outV.noNulls = false;
        StringSubstrColStartLen expr = new StringSubstrColStartLen(0, 6, 6, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertFalse((boolean)outCol.isRepeating);
        byte[] expected = "string".getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, -6, 6, 1);
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 1, 0, 1);
        outCol = (BytesColumnVector)batch.cols[1];
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data1, (int)1, (int)0, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data2, (int)1, (int)0, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data3, (int)1, (int)0, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 0, 11, 1);
        outCol = (BytesColumnVector)batch.cols[1];
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data1, (int)0, (int)data1.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data2, (int)0, (int)data2.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])data3, (int)0, (int)data3.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 6, 10, 1);
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = true;
        v.noNulls = false;
        v.isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertFalse((boolean)outV.noNulls);
        Assert.assertTrue((boolean)outV.isNull[0]);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV = new BytesColumnVector();
        v = new BytesColumnVector();
        outV.isRepeating = false;
        outV.noNulls = true;
        v.isRepeating = true;
        v.noNulls = false;
        v.setRef(0, data1, 0, data1.length);
        batch = new VectorizedRowBatch(2);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        v = new BytesColumnVector();
        v.isRepeating = false;
        v.noNulls = true;
        batch.size = 1;
        v.setRef(0, multiByte, 0, 10);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 3, 2, 1);
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)batch.size);
        Assert.assertFalse((boolean)outV.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])multiByte, (int)3, (int)7, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        v = new BytesColumnVector();
        v.isRepeating = false;
        v.noNulls = true;
        outV = new BytesColumnVector();
        batch.size = 1;
        v.setRef(0, multiByte, 3, 7);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 2, 2, 1);
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((long)1L, (long)batch.size);
        Assert.assertFalse((boolean)outV.isRepeating);
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])multiByte, (int)6, (int)4, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
    }

    @Test
    public void testVectorLTrim() throws HiveException {
        VectorizedRowBatch b = this.makeTrimBatch();
        StringLTrimCol expr = new StringLTrimCol(0, 1);
        expr.evaluate(b);
        BytesColumnVector outV = (BytesColumnVector)b.cols[1];
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)0, (byte[])outV.vector[0], (int)0, (int)0));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksLeft, (int)2, (int)3, (byte[])outV.vector[1], (int)outV.start[1], (int)outV.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksRight, (int)0, (int)5, (byte[])outV.vector[2], (int)outV.start[2], (int)outV.length[2]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksBoth, (int)2, (int)5, (byte[])outV.vector[3], (int)outV.start[3], (int)outV.length[3]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])red, (int)0, (int)3, (byte[])outV.vector[4], (int)outV.start[4], (int)outV.length[4]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blankString, (int)0, (int)0, (byte[])outV.vector[5], (int)outV.start[5], (int)outV.length[5]));
    }

    @Test
    public void testVectorRTrim() throws HiveException {
        VectorizedRowBatch b = this.makeTrimBatch();
        StringRTrimCol expr = new StringRTrimCol(0, 1);
        expr.evaluate(b);
        BytesColumnVector outV = (BytesColumnVector)b.cols[1];
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)0, (byte[])outV.vector[0], (int)0, (int)0));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksLeft, (int)0, (int)5, (byte[])outV.vector[1], (int)outV.start[1], (int)outV.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksRight, (int)0, (int)3, (byte[])outV.vector[2], (int)outV.start[2], (int)outV.length[2]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksBoth, (int)0, (int)5, (byte[])outV.vector[3], (int)outV.start[3], (int)outV.length[3]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])red, (int)0, (int)3, (byte[])outV.vector[4], (int)outV.start[4], (int)outV.length[4]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blankString, (int)0, (int)0, (byte[])outV.vector[5], (int)outV.start[5], (int)outV.length[5]));
    }

    @Test
    public void testVectorTrim() throws HiveException {
        VectorizedRowBatch b = this.makeTrimBatch();
        StringTrimCol expr = new StringTrimCol(0, 1);
        expr.evaluate(b);
        BytesColumnVector outV = (BytesColumnVector)b.cols[1];
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])emptyString, (int)0, (int)0, (byte[])outV.vector[0], (int)0, (int)0));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksLeft, (int)2, (int)3, (byte[])outV.vector[1], (int)outV.start[1], (int)outV.length[1]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksRight, (int)0, (int)3, (byte[])outV.vector[2], (int)outV.start[2], (int)outV.length[2]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blanksBoth, (int)2, (int)3, (byte[])outV.vector[3], (int)outV.start[3], (int)outV.length[3]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])red, (int)0, (int)3, (byte[])outV.vector[4], (int)outV.start[4], (int)outV.length[4]));
        Assert.assertEquals((long)0L, (long)StringExpr.compare((byte[])blankString, (int)0, (int)0, (byte[])outV.vector[5], (int)outV.start[5], (int)outV.length[5]));
    }

    private VectorizedRowBatch makeTrimBatch() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        BytesColumnVector inV = new BytesColumnVector();
        BytesColumnVector outV = new BytesColumnVector();
        b.cols[0] = inV;
        b.cols[1] = outV;
        inV.setRef(0, emptyString, 0, 0);
        inV.setRef(1, blanksLeft, 0, blanksLeft.length);
        inV.setRef(2, blanksRight, 0, blanksRight.length);
        inV.setRef(3, blanksBoth, 0, blanksBoth.length);
        inV.setRef(4, red, 0, red.length);
        inV.setRef(5, blankString, 0, blankString.length);
        b.size = 5;
        return b;
    }

    @Test
    public void testStringInExpr() throws HiveException {
        VectorizedRowBatch b = this.makeStringBatch();
        b.size = 2;
        b.cols[0].noNulls = true;
        byte[][] inVals = new byte[][]{red, blue};
        StringColumnInList expr = new StringColumnInList(0, 2);
        expr.setInListValues((byte[][])inVals);
        expr.evaluate(b);
        LongColumnVector outV = (LongColumnVector)b.cols[2];
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b = this.makeStringBatch();
        b.size = 2;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        outV = (LongColumnVector)b.cols[2];
        Assert.assertEquals((Object)true, (Object)(!outV.noNulls && outV.isNull[0] && !outV.isNull[1] ? 1 : 0));
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b = this.makeStringBatch();
        b.size = 2;
        b.cols[0].noNulls = true;
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        outV = (LongColumnVector)b.cols[2];
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
        Assert.assertEquals((Object)true, (Object)outV.isRepeating);
    }

    @Test
    public void testRegex() throws HiveException {
        VectorizedRowBatch b = this.makeStringBatch();
        FilterStringColRegExpStringScalar expr = new FilterStringColRegExpStringScalar(0, "a.*".getBytes());
        expr.transientInit((Configuration)this.hiveConf);
        b.size = 5;
        b.selectedInUse = false;
        BytesColumnVector v = (BytesColumnVector)b.cols[0];
        v.isRepeating = false;
        v.noNulls = false;
        String s1 = "4kMasVoB7lX1wc5i64bNk";
        String s2 = "a27V63IL7jK3o";
        String s3 = "27V63IL7jK3oa";
        String s4 = "27V63IL7jK3o";
        v.isNull[0] = false;
        v.setRef(0, s1.getBytes(), 0, s1.getBytes().length);
        v.isNull[1] = true;
        v.vector[1] = null;
        v.isNull[2] = false;
        v.setRef(2, s2.getBytes(), 0, s2.getBytes().length);
        v.isNull[3] = false;
        v.setRef(3, s3.getBytes(), 0, s3.getBytes().length);
        v.isNull[4] = false;
        v.setRef(4, s4.getBytes(), 0, s4.getBytes().length);
        expr.evaluate(b);
        Assert.assertTrue((boolean)b.selectedInUse);
        Assert.assertEquals((long)3L, (long)b.size);
        Assert.assertEquals((long)0L, (long)b.selected[0]);
        Assert.assertEquals((long)2L, (long)b.selected[1]);
        Assert.assertEquals((long)3L, (long)b.selected[2]);
    }

    static {
        blue = "blue".getBytes(StandardCharsets.UTF_8);
        red = "red".getBytes(StandardCharsets.UTF_8);
        redred = "redred".getBytes(StandardCharsets.UTF_8);
        green = "green".getBytes(StandardCharsets.UTF_8);
        greenred = "greenred".getBytes(StandardCharsets.UTF_8);
        redgreen = "redgreen".getBytes(StandardCharsets.UTF_8);
        greengreen = "greengreen".getBytes(StandardCharsets.UTF_8);
        emptyString = "".getBytes(StandardCharsets.UTF_8);
        mixedUp = "mixedUp".getBytes(StandardCharsets.UTF_8);
        mixedUpLower = "mixedup".getBytes(StandardCharsets.UTF_8);
        mixedUpUpper = "MIXEDUP".getBytes(StandardCharsets.UTF_8);
        mixPercentPattern = "mix%".getBytes(StandardCharsets.UTF_8);
        multiByte = new byte[10];
        TestVectorStringExpressions.addMultiByteChars(multiByte);
        blanksLeft = "  foo".getBytes(StandardCharsets.UTF_8);
        blanksRight = "foo  ".getBytes(StandardCharsets.UTF_8);
        blanksBoth = "  foo  ".getBytes(StandardCharsets.UTF_8);
        blankString = "  ".getBytes(StandardCharsets.UTF_8);
        blankRanges = "   more  than a    bargain    ".getBytes(StandardCharsets.UTF_8);
        ascii_sentence = "The fox trotted over the fence.".getBytes(StandardCharsets.UTF_8);
        red2 = new byte[red.length];
        System.arraycopy(red, 0, red2, 0, red.length);
    }
}

