/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorStringConcat {
    @Test
    public void testString() throws Exception {
        Random random = new Random(12882L);
        this.doStringConcatTests(random, "string", "string");
    }

    @Test
    public void testChar() throws Exception {
        Random random = new Random(12882L);
        this.doStringConcatTests(random, "char(20)", "char(10)");
        this.doStringConcatTests(random, "char(20)", "string");
        this.doStringConcatTests(random, "char(20)", "varchar(10)");
        this.doStringConcatTests(random, "string", "char(10)");
    }

    @Test
    public void testVarchar() throws Exception {
        Random random = new Random(12882L);
        this.doStringConcatTests(random, "varchar(20)", "varchar(10)");
        this.doStringConcatTests(random, "varchar(20)", "string");
        this.doStringConcatTests(random, "varchar(20)", "char(10)");
        this.doStringConcatTests(random, "string", "varchar(10)");
    }

    private void doStringConcatTests(Random random, String stringTypeName1, String stringTypeName2) throws Exception {
        for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
            this.doStringConcatTestsWithDiffColumnScalar(random, stringTypeName1, stringTypeName2, columnScalarMode);
        }
    }

    private void doStringConcatTestsWithDiffColumnScalar(Random random, String stringTypeName1, String stringTypeName2, ColumnScalarMode columnScalarMode) throws Exception {
        int i;
        ExprNodeConstantDesc col2Expr;
        ExprNodeConstantDesc col1Expr;
        TypeInfo stringTypeInfo1 = TypeInfoUtils.getTypeInfoFromTypeString((String)stringTypeName1);
        PrimitiveObjectInspector.PrimitiveCategory stringPrimitiveCategory1 = ((PrimitiveTypeInfo)stringTypeInfo1).getPrimitiveCategory();
        TypeInfo stringTypeInfo2 = TypeInfoUtils.getTypeInfoFromTypeString((String)stringTypeName2);
        PrimitiveObjectInspector.PrimitiveCategory stringPrimitiveCategory2 = ((PrimitiveTypeInfo)stringTypeInfo2).getPrimitiveCategory();
        String functionName = "concat";
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 1;
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.COLUMN_SCALAR) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(stringTypeInfo1));
            explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col1Expr = new ExprNodeColumnDesc(stringTypeInfo1, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar1Object = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)stringTypeInfo1);
            col1Expr = new ExprNodeConstantDesc(stringTypeInfo1, scalar1Object);
        }
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.SCALAR_COLUMN) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(stringTypeInfo2));
            explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col2Expr = new ExprNodeColumnDesc(stringTypeInfo2, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar2Object = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)stringTypeInfo2);
            col2Expr = new ExprNodeConstantDesc(stringTypeInfo2, scalar2Object);
        }
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        children.add((ExprNodeDesc)col2Expr);
        String[] columnNames = columns.toArray(new String[0]);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        String[] outputScratchTypeNames = new String[]{"string"};
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, outputScratchTypeNames, null);
        FunctionInfo funcInfo = null;
        try {
            funcInfo = FunctionRegistry.getFunctionInfo((String)functionName);
        }
        catch (SemanticException e) {
            Assert.fail((String)("Failed to load " + functionName + " " + (Object)((Object)e)));
        }
        GenericUDF genericUdf = funcInfo.getGenericUDF();
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[StringConcatTestMode.count][];
        block6: for (i = 0; i < StringConcatTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            StringConcatTestMode stringConcatTestMode = StringConcatTestMode.values()[i];
            switch (stringConcatTestMode) {
                case ROW_MODE: {
                    this.doRowStringConcatTest(stringTypeInfo1, stringTypeInfo2, columns, children, randomRows, columnScalarMode, (ObjectInspector)rowSource.rowStructObjectInspector(), genericUdf, resultObjects);
                    continue block6;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    this.doVectorStringConcatTest(stringTypeInfo1, stringTypeInfo2, columns, rowSource.typeInfos(), children, stringConcatTestMode, columnScalarMode, batchSource, batchContext, (ObjectInspector)rowSource.rowStructObjectInspector(), genericUdf, resultObjects);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + (Object)((Object)stringConcatTestMode));
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < StringConcatTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " " + (Object)((Object)StringConcatTestMode.values()[v]) + " " + (Object)((Object)columnScalarMode) + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null) + " row values " + Arrays.toString(randomRows[i])));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " " + (Object)((Object)StringConcatTestMode.values()[v]) + " " + (Object)((Object)columnScalarMode) + " result \"" + vectorResult.toString() + "\" (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result \"" + expectedResult.toString() + "\" (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i])));
            }
        }
    }

    private void doRowStringConcatTest(TypeInfo stringTypeInfo, TypeInfo integerTypeInfo, List<String> columns, List<ExprNodeDesc> children, Object[][] randomRows, ColumnScalarMode columnScalarMode, ObjectInspector rowInspector, GenericUDF genericUdf, Object[] resultObjects) throws Exception {
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, genericUdf, children);
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = evaluator.getOutputOI();
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorStringConcatTest(TypeInfo stringTypeInfo1, TypeInfo stringTypeInfo2, List<String> columns, TypeInfo[] typeInfos, List<ExprNodeDesc> children, StringConcatTestMode stringConcatTestMode, ColumnScalarMode columnScalarMode, VectorRandomBatchSource batchSource, VectorizedRowBatchCtx batchContext, ObjectInspector rowInspector, GenericUDF genericUdf, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (stringConcatTestMode == StringConcatTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        Object[] dataTypePhysicalVariations = new DataTypePhysicalVariation[2];
        Arrays.fill(dataTypePhysicalVariations, DataTypePhysicalVariation.NONE);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, genericUdf, children);
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = evaluator.getOutputOI();
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)objectInspector);
        exprDesc = new ExprNodeGenericFuncDesc(outputTypeInfo, genericUdf, children);
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (stringConcatTestMode == StringConcatTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* stringTypeInfo1 " + stringTypeInfo1.toString() + " stringTypeInfo2 " + stringTypeInfo2.toString() + " stringConcatTestMode " + (Object)((Object)stringConcatTestMode) + " columnScalarMode " + (Object)((Object)columnScalarMode) + " vectorExpression " + vectorExpression.toString());
        }
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{columns.size()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            rowIndex += batch.size;
        }
    }

    public static enum ColumnScalarMode {
        COLUMN_COLUMN,
        COLUMN_SCALAR,
        SCALAR_COLUMN;

        static final int count;

        static {
            count = ColumnScalarMode.values().length;
        }
    }

    public static enum StringConcatTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = StringConcatTestMode.values().length;
        }
    }
}

