/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorIfStatement {
    @Test
    public void testBoolean() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "boolean");
    }

    @Test
    public void testInt() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "int");
    }

    @Test
    public void testBigInt() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "bigint");
    }

    @Test
    public void testString() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "string");
    }

    @Test
    public void testTimestamp() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "timestamp");
    }

    @Test
    public void testDate() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "date");
    }

    @Test
    public void testIntervalDayTime() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "interval_day_time");
    }

    @Test
    public void testIntervalYearMonth() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "interval_year_month");
    }

    @Test
    public void testDouble() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "double");
    }

    @Test
    public void testChar() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "char(10)");
    }

    @Test
    public void testVarchar() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "varchar(15)");
    }

    @Test
    public void testBinary() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "binary");
    }

    @Test
    public void testDecimalLarge() throws Exception {
        Random random = new Random(9300L);
        this.doIfTests(random, "decimal(20,8)");
    }

    @Test
    public void testDecimalSmall() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "decimal(10,4)");
    }

    @Test
    public void testDecimal64() throws Exception {
        Random random = new Random(238L);
        this.doIfTestsWithDiffColumnScalar(random, "decimal(10,4)", ColumnScalarMode.COLUMN_COLUMN, IfVariation.PROJECTION_IF, DataTypePhysicalVariation.DECIMAL_64, false, false);
        this.doIfTestsWithDiffColumnScalar(random, "decimal(10,4)", ColumnScalarMode.COLUMN_SCALAR, IfVariation.PROJECTION_IF, DataTypePhysicalVariation.DECIMAL_64, false, false);
        this.doIfTestsWithDiffColumnScalar(random, "decimal(10,4)", ColumnScalarMode.SCALAR_COLUMN, IfVariation.PROJECTION_IF, DataTypePhysicalVariation.DECIMAL_64, false, false);
        this.doIfTestsWithDiffColumnScalar(random, "decimal(10,4)", ColumnScalarMode.SCALAR_SCALAR, IfVariation.PROJECTION_IF, DataTypePhysicalVariation.DECIMAL_64, false, false);
    }

    private void doIfTests(Random random, String typeName) throws Exception {
        if (typeName.equals("boolean")) {
            this.doIfTests(random, typeName, IfVariation.FILTER_IF, DataTypePhysicalVariation.NONE);
        }
        this.doIfTests(random, typeName, IfVariation.PROJECTION_IF, DataTypePhysicalVariation.NONE);
    }

    private void doIfTests(Random random, String typeName, IfVariation ifVariation, DataTypePhysicalVariation dataTypePhysicalVariation) throws Exception {
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.COLUMN_COLUMN, ifVariation, dataTypePhysicalVariation, false, false);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.COLUMN_SCALAR, ifVariation, dataTypePhysicalVariation, false, false);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.COLUMN_SCALAR, ifVariation, dataTypePhysicalVariation, false, true);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.SCALAR_COLUMN, ifVariation, dataTypePhysicalVariation, false, false);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.SCALAR_COLUMN, ifVariation, dataTypePhysicalVariation, true, false);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.SCALAR_SCALAR, ifVariation, dataTypePhysicalVariation, false, false);
    }

    private void doIfTestsWithDiffColumnScalar(Random random, String typeName, ColumnScalarMode columnScalarMode, IfVariation ifVariation, DataTypePhysicalVariation dataTypePhysicalVariation, boolean isNullScalar1, boolean isNullScalar2) throws Exception {
        int i;
        ExprNodeConstantDesc col3Expr;
        ExprNodeConstantDesc col2Expr;
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        boolean isDecimal64 = dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64;
        int decimal64Scale = isDecimal64 ? ((DecimalTypeInfo)typeInfo).getScale() : 0;
        ArrayList<String> explicitTypeNameList = new ArrayList<String>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        explicitTypeNameList.add("boolean");
        explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        if (columnScalarMode != ColumnScalarMode.SCALAR_SCALAR) {
            explicitTypeNameList.add(typeName);
            explicitDataTypePhysicalVariationList.add(dataTypePhysicalVariation);
            if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN) {
                explicitTypeNameList.add(typeName);
                explicitDataTypePhysicalVariationList.add(dataTypePhysicalVariation);
            }
        }
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initExplicitSchema(random, explicitTypeNameList, 0, true, true, explicitDataTypePhysicalVariationList);
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("col1");
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Boolean.class, "col1", "table", false);
        int columnNum = 2;
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.COLUMN_SCALAR) {
            String columnName = "col" + columnNum++;
            col2Expr = new ExprNodeColumnDesc(typeInfo, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar1Object = isNullScalar1 ? null : VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo);
            col2Expr = new ExprNodeConstantDesc(typeInfo, scalar1Object);
        }
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.SCALAR_COLUMN) {
            String columnName = "col" + columnNum++;
            col3Expr = new ExprNodeColumnDesc(typeInfo, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar2Object = isNullScalar2 ? null : VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo);
            col3Expr = new ExprNodeConstantDesc(typeInfo, scalar2Object);
        }
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        children.add((ExprNodeDesc)col2Expr);
        children.add((ExprNodeDesc)col3Expr);
        String[] columnNames = columns.toArray(new String[0]);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[IfStmtTestMode.count][];
        block4: for (i = 0; i < IfStmtTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            IfStmtTestMode ifStmtTestMode = IfStmtTestMode.values()[i];
            switch (ifStmtTestMode) {
                case ROW_MODE: {
                    this.doRowIfTest(typeInfo, columns, children, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), resultObjects);
                    continue block4;
                }
                case ADAPTOR_WHEN: 
                case VECTOR_EXPRESSION: {
                    this.doVectorIfTest(typeInfo, ifVariation, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, ifStmtTestMode, columnScalarMode, batchSource, resultObjects);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + (Object)((Object)ifStmtTestMode));
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < IfStmtTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (ifVariation.isFilter && expectedResult == null && vectorResult != null) {
                    boolean vectorBoolean = ((BooleanWritable)vectorResult).get();
                    if (!vectorBoolean) continue;
                    Assert.fail((String)("Row " + i + " typeName " + typeInfo.getTypeName() + " " + (Object)((Object)ifVariation) + " result is NOT NULL and true does not match row-mode expected result is NULL which means false here row values " + Arrays.toString(randomRows[i])));
                    continue;
                }
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " " + (Object)((Object)IfStmtTestMode.values()[v]) + " " + (Object)((Object)columnScalarMode) + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null)));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " " + (Object)((Object)IfStmtTestMode.values()[v]) + " " + (Object)((Object)columnScalarMode) + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ")"));
            }
        }
    }

    private void doRowIfTest(TypeInfo typeInfo, List<String> columns, List<ExprNodeDesc> children, Object[][] randomRows, ObjectInspector rowInspector, Object[] resultObjects) throws Exception {
        GenericUDFIf udf = new GenericUDFIf();
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(typeInfo, (GenericUDF)udf, children);
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        for (Object[] row : randomRows) {
            Object result;
            resultObjects[i] = result = evaluator.evaluate((Object)row);
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorIfTest(TypeInfo typeInfo, IfVariation ifVariation, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, IfStmtTestMode ifStmtTestMode, ColumnScalarMode columnScalarMode, VectorRandomBatchSource batchSource, Object[] resultObjects) throws Exception {
        ObjectInspector objectInspector;
        TypeInfo outputTypeInfo;
        GenericUDFIf udf;
        boolean isFilter = ifVariation.isFilter;
        switch (ifStmtTestMode) {
            case VECTOR_EXPRESSION: {
                udf = new GenericUDFIf();
                break;
            }
            case ADAPTOR_WHEN: {
                udf = new GenericUDFWhen();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected IF statement test mode " + (Object)((Object)ifStmtTestMode));
            }
        }
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(typeInfo, (GenericUDF)udf, children);
        String ifExprMode = ifStmtTestMode != IfStmtTestMode.VECTOR_EXPRESSION ? "adaptor" : "good";
        HiveConf hiveConf = new HiveConf();
        hiveConf.setVar(HiveConf.ConfVars.HIVE_VECTORIZED_IF_EXPR_MODE, ifExprMode);
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc, isFilter ? VectorExpressionDescriptor.Mode.FILTER : VectorExpressionDescriptor.Mode.PROJECTION);
        if (!isFilter) {
            outputTypeInfo = vectorExpression.getOutputTypeInfo();
            objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)outputTypeInfo);
        } else {
            outputTypeInfo = null;
            objectInspector = null;
        }
        if (ifStmtTestMode == IfStmtTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " ifStmtTestMode " + (Object)((Object)ifStmtTestMode) + " ifVariation " + (Object)((Object)ifVariation) + " columnScalarMode " + (Object)((Object)columnScalarMode) + " vectorExpression " + vectorExpression.toString());
        }
        String[] outputScratchTypeNames = vectorizationContext.getScratchColumnTypeNames();
        DataTypePhysicalVariation[] outputDataTypePhysicalVariations = vectorizationContext.getScratchDataTypePhysicalVariations();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, typeInfos, dataTypePhysicalVariations, null, 0, 0, null, outputScratchTypeNames, outputDataTypePhysicalVariations);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = null;
        Object[] scrqtchRow = null;
        if (!isFilter) {
            resultVectorExtractRow = new VectorExtractRow();
            int outputColumnNum = vectorExpression.getOutputColumnNum();
            resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{outputColumnNum});
            scrqtchRow = new Object[1];
        }
        boolean copySelectedInUse = false;
        int[] copySelected = new int[1024];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            int originalBatchSize = batch.size;
            if (isFilter) {
                copySelectedInUse = batch.selectedInUse;
                if (batch.selectedInUse) {
                    System.arraycopy(batch.selected, 0, copySelected, 0, originalBatchSize);
                }
            }
            vectorExpression.evaluate(batch);
            if (!isFilter) {
                this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            } else {
                int i;
                int i2;
                int selectIndex;
                int currentBatchSize = batch.size;
                if (copySelectedInUse && batch.selectedInUse) {
                    selectIndex = 0;
                    for (i2 = 0; i2 < originalBatchSize; ++i2) {
                        boolean booleanResult;
                        int originalBatchIndex = copySelected[i2];
                        if (selectIndex < currentBatchSize && batch.selected[selectIndex] == originalBatchIndex) {
                            booleanResult = true;
                            ++selectIndex;
                        } else {
                            booleanResult = false;
                        }
                        resultObjects[rowIndex + i2] = new BooleanWritable(booleanResult);
                    }
                } else if (batch.selectedInUse) {
                    selectIndex = 0;
                    for (i2 = 0; i2 < originalBatchSize; ++i2) {
                        boolean booleanResult;
                        if (selectIndex < currentBatchSize && batch.selected[selectIndex] == i2) {
                            booleanResult = true;
                            ++selectIndex;
                        } else {
                            booleanResult = false;
                        }
                        resultObjects[rowIndex + i2] = new BooleanWritable(booleanResult);
                    }
                } else if (currentBatchSize == 0) {
                    for (i = 0; i < originalBatchSize; ++i) {
                        resultObjects[rowIndex + i] = new BooleanWritable(false);
                    }
                } else {
                    for (i = 0; i < originalBatchSize; ++i) {
                        resultObjects[rowIndex + i] = new BooleanWritable(true);
                    }
                }
            }
            rowIndex += originalBatchSize;
        }
    }

    public static enum IfVariation {
        FILTER_IF,
        PROJECTION_IF;

        static final int count;
        final boolean isFilter = this.name().startsWith("FILTER");

        static {
            count = IfVariation.values().length;
        }
    }

    public static enum ColumnScalarMode {
        COLUMN_COLUMN,
        COLUMN_SCALAR,
        SCALAR_COLUMN,
        SCALAR_SCALAR;

        static final int count;

        static {
            count = ColumnScalarMode.values().length;
        }
    }

    public static enum IfStmtTestMode {
        ROW_MODE,
        ADAPTOR_WHEN,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = IfStmtTestMode.values().length;
        }
    }
}

