/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorFilterCompare {
    private static TypeInfo[] integerTypeInfos = new TypeInfo[]{TypeInfoFactory.byteTypeInfo, TypeInfoFactory.shortTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.longTypeInfo};
    private static TypeInfo[] floatingTypeInfos = new TypeInfo[]{TypeInfoFactory.doubleTypeInfo};
    private static TypeInfo[] decimalTypeInfos = new TypeInfo[]{new DecimalTypeInfo(38, 18), new DecimalTypeInfo(25, 2), new DecimalTypeInfo(19, 4), new DecimalTypeInfo(18, 10), new DecimalTypeInfo(17, 3), new DecimalTypeInfo(12, 2), new DecimalTypeInfo(7, 1)};

    public TestVectorFilterCompare() {
        SessionState ss = new SessionState(new HiveConf());
        ss.getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
        SessionState.setCurrentSessionState((SessionState)ss);
    }

    @Test
    public void testIntegers() throws Exception {
        Random random = new Random(7743L);
        this.doIntegerTests(random);
    }

    @Test
    public void testIntegerFloating() throws Exception {
        Random random = new Random(7743L);
        this.doIntegerFloatingTests(random);
    }

    @Test
    public void testFloating() throws Exception {
        Random random = new Random(7743L);
        this.doFloatingTests(random);
    }

    @Test
    public void testDecimal() throws Exception {
        Random random = new Random(7743L);
        this.doDecimalTests(random, false);
    }

    @Test
    public void testDecimal64() throws Exception {
        Random random = new Random(7743L);
        this.doDecimalTests(random, true);
    }

    @Test
    public void testTimestamp() throws Exception {
        Random random = new Random(7743L);
        this.doTests(random, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.doTests(random, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.longTypeInfo);
        this.doTests(random, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.doTests(random, (TypeInfo)TypeInfoFactory.longTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.doTests(random, (TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
    }

    @Test
    public void testDate() throws Exception {
        Random random = new Random(7743L);
        this.doTests(random, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
    }

    @Test
    public void testInterval() throws Exception {
        Random random = new Random(7743L);
        this.doTests(random, (TypeInfo)TypeInfoFactory.intervalYearMonthTypeInfo, (TypeInfo)TypeInfoFactory.intervalYearMonthTypeInfo);
        this.doTests(random, (TypeInfo)TypeInfoFactory.intervalDayTimeTypeInfo, (TypeInfo)TypeInfoFactory.intervalDayTimeTypeInfo);
    }

    @Test
    public void testStringFamily() throws Exception {
        Random random = new Random(7743L);
        this.doTests(random, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.doTests(random, (TypeInfo)new CharTypeInfo(10), (TypeInfo)new CharTypeInfo(10));
        this.doTests(random, (TypeInfo)new VarcharTypeInfo(10), (TypeInfo)new VarcharTypeInfo(10));
    }

    private void doIntegerTests(Random random) throws Exception {
        for (TypeInfo typeInfo : integerTypeInfos) {
            this.doTests(random, typeInfo, typeInfo);
        }
    }

    private void doIntegerFloatingTests(Random random) throws Exception {
        for (TypeInfo typeInfo1 : integerTypeInfos) {
            for (TypeInfo typeInfo2 : floatingTypeInfos) {
                this.doTests(random, typeInfo1, typeInfo2);
            }
        }
        for (TypeInfo typeInfo1 : floatingTypeInfos) {
            for (TypeInfo typeInfo2 : integerTypeInfos) {
                this.doTests(random, typeInfo1, typeInfo2);
            }
        }
    }

    private void doFloatingTests(Random random) throws Exception {
        for (TypeInfo typeInfo1 : floatingTypeInfos) {
            for (TypeInfo typeInfo2 : floatingTypeInfos) {
                this.doTests(random, typeInfo1, typeInfo2);
            }
        }
    }

    private void doDecimalTests(Random random, boolean tryDecimal64) throws Exception {
        for (TypeInfo typeInfo : decimalTypeInfos) {
            this.doTests(random, typeInfo, typeInfo, tryDecimal64);
        }
    }

    private TypeInfo getOutputTypeInfo(GenericUDF genericUdfClone, List<ObjectInspector> objectInspectorList) throws HiveException {
        ObjectInspector[] array = objectInspectorList.toArray(new ObjectInspector[objectInspectorList.size()]);
        ObjectInspector outputObjectInspector = genericUdfClone.initialize(array);
        return TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
    }

    private TypeInfo getDecimalScalarTypeInfo(Object scalarObject) {
        HiveDecimal dec = (HiveDecimal)scalarObject;
        int precision = dec.precision();
        int scale = dec.scale();
        return new DecimalTypeInfo(precision, scale);
    }

    private boolean checkDecimal64(boolean tryDecimal64, TypeInfo typeInfo) {
        if (!tryDecimal64 || !(typeInfo instanceof DecimalTypeInfo)) {
            return false;
        }
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
        boolean result = HiveDecimalWritable.isPrecisionDecimal64((int)decimalTypeInfo.getPrecision());
        return result;
    }

    private void doTests(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2, boolean tryDecimal64) throws Exception {
        for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
            this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode, tryDecimal64);
        }
    }

    private void doTests(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2) throws Exception {
        for (ColumnScalarMode columnScalarMode : ColumnScalarMode.values()) {
            this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode);
        }
    }

    private void doTestsWithDiffColumnScalar(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2, ColumnScalarMode columnScalarMode) throws Exception {
        this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode, false);
    }

    private void doTestsWithDiffColumnScalar(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2, ColumnScalarMode columnScalarMode, boolean tryDecimal64) throws Exception {
        for (Comparison comparison : Comparison.values()) {
            this.doTestsWithDiffColumnScalar(random, typeInfo1, typeInfo2, columnScalarMode, comparison, tryDecimal64);
        }
    }

    private void doTestsWithDiffColumnScalar(Random random, TypeInfo typeInfo1, TypeInfo typeInfo2, ColumnScalarMode columnScalarMode, Comparison comparison, boolean tryDecimal64) throws Exception {
        int i;
        GenericUDFOPEqual genericUdf;
        ExprNodeConstantDesc col2Expr;
        ExprNodeConstantDesc col1Expr;
        String typeName1 = typeInfo1.getTypeName();
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory1 = ((PrimitiveTypeInfo)typeInfo1).getPrimitiveCategory();
        String typeName2 = typeInfo2.getTypeName();
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory2 = ((PrimitiveTypeInfo)typeInfo2).getPrimitiveCategory();
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 1;
        Object scalar1Object = null;
        boolean decimal64Enable1 = this.checkDecimal64(tryDecimal64, typeInfo1);
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.COLUMN_SCALAR) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(typeInfo1));
            explicitDataTypePhysicalVariationList.add(decimal64Enable1 ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col1Expr = new ExprNodeColumnDesc(typeInfo1, columnName, "table", false);
            columns.add(columnName);
        } else {
            scalar1Object = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo1);
            if (typeInfo1 instanceof DecimalTypeInfo) {
                typeInfo1 = this.getDecimalScalarTypeInfo(scalar1Object);
            }
            col1Expr = new ExprNodeConstantDesc(typeInfo1, scalar1Object);
        }
        Object scalar2Object = null;
        boolean decimal64Enable2 = this.checkDecimal64(tryDecimal64, typeInfo2);
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.SCALAR_COLUMN) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(typeInfo2));
            explicitDataTypePhysicalVariationList.add(decimal64Enable2 ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE);
            String columnName = "col" + columnNum++;
            col2Expr = new ExprNodeColumnDesc(typeInfo2, columnName, "table", false);
            columns.add(columnName);
        } else {
            scalar2Object = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo2);
            if (typeInfo2 instanceof DecimalTypeInfo) {
                typeInfo2 = this.getDecimalScalarTypeInfo(scalar2Object);
            }
            col2Expr = new ExprNodeConstantDesc(typeInfo2, scalar2Object);
        }
        ArrayList<ObjectInspector> objectInspectorList = new ArrayList<ObjectInspector>();
        objectInspectorList.add(VectorRandomRowSource.getObjectInspector(typeInfo1));
        objectInspectorList.add(VectorRandomRowSource.getObjectInspector(typeInfo2));
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        children.add((ExprNodeDesc)col2Expr);
        String[] columnNames = columns.toArray(new String[0]);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        switch (comparison) {
            case EQUALS: {
                genericUdf = new GenericUDFOPEqual();
                break;
            }
            case LESS_THAN: {
                genericUdf = new GenericUDFOPLessThan();
                break;
            }
            case LESS_THAN_EQUAL: {
                genericUdf = new GenericUDFOPEqualOrLessThan();
                break;
            }
            case GREATER_THAN: {
                genericUdf = new GenericUDFOPGreaterThan();
                break;
            }
            case GREATER_THAN_EQUAL: {
                genericUdf = new GenericUDFOPEqualOrGreaterThan();
                break;
            }
            case NOT_EQUALS: {
                genericUdf = new GenericUDFOPNotEqual();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected arithmetic " + (Object)((Object)comparison));
            }
        }
        ObjectInspector[] objectInspectors = objectInspectorList.toArray(new ObjectInspector[objectInspectorList.size()]);
        ObjectInspector outputObjectInspector = null;
        try {
            outputObjectInspector = genericUdf.initialize(objectInspectors);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(outputTypeInfo, (GenericUDF)genericUdf, children);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[FilterCompareTestMode.count][];
        block14: for (i = 0; i < FilterCompareTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            FilterCompareTestMode filterCompareTestMode = FilterCompareTestMode.values()[i];
            switch (filterCompareTestMode) {
                case ROW_MODE: {
                    this.doRowFilterCompareTest(typeInfo1, typeInfo2, columns, children, exprDesc, comparison, randomRows, columnScalarMode, (ObjectInspector)rowSource.rowStructObjectInspector(), outputTypeInfo, resultObjects);
                    continue block14;
                }
                case ADAPTOR: 
                case FILTER_VECTOR_EXPRESSION: 
                case COMPARE_VECTOR_EXPRESSION: {
                    this.doVectorFilterCompareTest(typeInfo1, typeInfo2, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, exprDesc, comparison, filterCompareTestMode, columnScalarMode, batchSource, exprDesc.getWritableObjectInspector(), outputTypeInfo, resultObjects);
                    continue block14;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + (Object)((Object)filterCompareTestMode));
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < FilterCompareTestMode.count; ++v) {
                FilterCompareTestMode filterCompareTestMode = FilterCompareTestMode.values()[v];
                Object vectorResult = resultObjectsArray[v][i];
                if (filterCompareTestMode == FilterCompareTestMode.FILTER_VECTOR_EXPRESSION && expectedResult == null && vectorResult != null) {
                    boolean vectorBoolean = ((BooleanWritable)vectorResult).get();
                    if (!vectorBoolean) continue;
                    Assert.fail((String)("Row " + i + " typeName1 " + typeName1 + " typeName2 " + typeName2 + " outputTypeName " + outputTypeInfo.getTypeName() + " " + (Object)((Object)comparison) + " " + (Object)((Object)filterCompareTestMode) + " " + (Object)((Object)columnScalarMode) + " result is NOT NULL and true does not match row-mode expected result is NULL which means false here" + (columnScalarMode == ColumnScalarMode.SCALAR_COLUMN ? " scalar1 " + scalar1Object.toString() : "") + " row values " + Arrays.toString(randomRows[i]) + (columnScalarMode == ColumnScalarMode.COLUMN_SCALAR ? " scalar2 " + scalar2Object.toString() : "")));
                    continue;
                }
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " typeName1 " + typeName1 + " typeName2 " + typeName2 + " outputTypeName " + outputTypeInfo.getTypeName() + " " + (Object)((Object)comparison) + " " + (Object)((Object)filterCompareTestMode) + " " + (Object)((Object)columnScalarMode) + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null) + (columnScalarMode == ColumnScalarMode.SCALAR_COLUMN ? " scalar1 " + scalar1Object.toString() : "") + " row values " + Arrays.toString(randomRows[i]) + (columnScalarMode == ColumnScalarMode.COLUMN_SCALAR ? " scalar2 " + scalar2Object.toString() : "")));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " typeName1 " + typeName1 + " typeName2 " + typeName2 + " outputTypeName " + outputTypeInfo.getTypeName() + " " + (Object)((Object)comparison) + " " + (Object)((Object)filterCompareTestMode) + " " + (Object)((Object)columnScalarMode) + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ")" + (columnScalarMode == ColumnScalarMode.SCALAR_COLUMN ? " scalar1 " + scalar1Object.toString() : "") + " row values " + Arrays.toString(randomRows[i]) + (columnScalarMode == ColumnScalarMode.COLUMN_SCALAR ? " scalar2 " + scalar2Object.toString() : "")));
            }
        }
    }

    private void doRowFilterCompareTest(TypeInfo typeInfo1, TypeInfo typeInfo2, List<String> columns, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, Comparison comparison, Object[][] randomRows, ColumnScalarMode columnScalarMode, ObjectInspector rowInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)outputTypeInfo);
        for (Object[] row : randomRows) {
            Object result = evaluator.evaluate((Object)row);
            Object copyResult = null;
            try {
                copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            }
            catch (Exception e) {
                Assert.fail((String)e.toString());
            }
            resultObjects[i] = copyResult;
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorFilterCompareTest(TypeInfo typeInfo1, TypeInfo typeInfo2, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, Comparison comparison, FilterCompareTestMode filterCompareTestMode, ColumnScalarMode columnScalarMode, VectorRandomBatchSource batchSource, ObjectInspector objectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        VectorExpressionDescriptor.Mode mode;
        HiveConf hiveConf = new HiveConf();
        if (filterCompareTestMode == FilterCompareTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
            dataTypePhysicalVariations = null;
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), dataTypePhysicalVariations == null ? null : Arrays.asList(dataTypePhysicalVariations), hiveConf);
        switch (filterCompareTestMode) {
            case ADAPTOR: 
            case COMPARE_VECTOR_EXPRESSION: {
                mode = VectorExpressionDescriptor.Mode.PROJECTION;
                break;
            }
            case FILTER_VECTOR_EXPRESSION: {
                mode = VectorExpressionDescriptor.Mode.FILTER;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected filter compare mode " + (Object)((Object)filterCompareTestMode));
            }
        }
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc, mode);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (filterCompareTestMode == FilterCompareTestMode.COMPARE_VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo1 " + typeInfo1.toString() + " typeInfo2 " + typeInfo2.toString() + " " + (Object)((Object)comparison) + "  filterCompareTestMode " + (Object)((Object)filterCompareTestMode) + " columnScalarMode " + (Object)((Object)columnScalarMode) + " vectorExpression " + vectorExpression.toString());
        }
        String[] outputScratchTypeNames = vectorizationContext.getScratchColumnTypeNames();
        DataTypePhysicalVariation[] outputDataTypePhysicalVariations = vectorizationContext.getScratchDataTypePhysicalVariations();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, typeInfos, dataTypePhysicalVariations, null, 0, 0, null, outputScratchTypeNames, outputDataTypePhysicalVariations);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        int outputColumnNum = vectorExpression.getOutputColumnNum();
        resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{outputColumnNum});
        Object[] scrqtchRow = new Object[1];
        boolean isFilter = mode == VectorExpressionDescriptor.Mode.FILTER;
        boolean copySelectedInUse = false;
        int[] copySelected = new int[1024];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            int originalBatchSize = batch.size;
            if (isFilter) {
                copySelectedInUse = batch.selectedInUse;
                if (batch.selectedInUse) {
                    System.arraycopy(batch.selected, 0, copySelected, 0, originalBatchSize);
                }
            }
            vectorExpression.evaluate(batch);
            if (!isFilter) {
                this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            } else {
                int i;
                int i2;
                int selectIndex;
                int currentBatchSize = batch.size;
                if (copySelectedInUse && batch.selectedInUse) {
                    selectIndex = 0;
                    for (i2 = 0; i2 < originalBatchSize; ++i2) {
                        boolean booleanResult;
                        int originalBatchIndex = copySelected[i2];
                        if (selectIndex < currentBatchSize && batch.selected[selectIndex] == originalBatchIndex) {
                            booleanResult = true;
                            ++selectIndex;
                        } else {
                            booleanResult = false;
                        }
                        resultObjects[rowIndex + i2] = new BooleanWritable(booleanResult);
                    }
                } else if (batch.selectedInUse) {
                    selectIndex = 0;
                    for (i2 = 0; i2 < originalBatchSize; ++i2) {
                        boolean booleanResult;
                        if (selectIndex < currentBatchSize && batch.selected[selectIndex] == i2) {
                            booleanResult = true;
                            ++selectIndex;
                        } else {
                            booleanResult = false;
                        }
                        resultObjects[rowIndex + i2] = new BooleanWritable(booleanResult);
                    }
                } else if (currentBatchSize == 0) {
                    for (i = 0; i < originalBatchSize; ++i) {
                        resultObjects[rowIndex + i] = new BooleanWritable(false);
                    }
                } else {
                    for (i = 0; i < originalBatchSize; ++i) {
                        resultObjects[rowIndex + i] = new BooleanWritable(true);
                    }
                }
            }
            rowIndex += originalBatchSize;
        }
    }

    public static enum Comparison {
        EQUALS,
        LESS_THAN,
        LESS_THAN_EQUAL,
        GREATER_THAN,
        GREATER_THAN_EQUAL,
        NOT_EQUALS;

    }

    public static enum ColumnScalarMode {
        COLUMN_COLUMN,
        COLUMN_SCALAR,
        SCALAR_COLUMN;

        static final int count;

        static {
            count = ColumnScalarMode.values().length;
        }
    }

    public static enum FilterCompareTestMode {
        ROW_MODE,
        ADAPTOR,
        FILTER_VECTOR_EXPRESSION,
        COMPARE_VECTOR_EXPRESSION;

        static final int count;

        static {
            count = FilterCompareTestMode.values().length;
        }
    }
}

