/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMonthDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearDate;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorDateExpressions {
    private ExecutorService runner;

    private TimestampWritableV2 toTimestampWritable(long daysSinceEpoch) {
        return new TimestampWritableV2(Timestamp.ofEpochMilli((long)DateWritableV2.daysToMillis((int)((int)daysSinceEpoch))));
    }

    private TimestampLocalTZWritable toTimestampLocalTZWritable(long daysSinceEpoch) {
        return new TimestampLocalTZWritable(TimestampTZUtil.convert((Timestamp)Timestamp.ofEpochMilli((long)DateWritableV2.daysToMillis((int)((int)daysSinceEpoch))), (ZoneId)ZoneId.systemDefault()));
    }

    private int[] getAllBoundaries() {
        ArrayList<Integer> boundaries = new ArrayList<Integer>(1);
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.setTimeInMillis(0L);
        for (int year = 1902; year <= 2038; ++year) {
            c.set(year, 0, 1, 0, 0, 0);
            int exactly = (int)(c.getTimeInMillis() / 86400000L);
            int before = exactly - 1;
            int after = exactly + 1;
            boundaries.add(before);
            boundaries.add(exactly);
            boundaries.add(after);
        }
        Integer[] indices = boundaries.toArray(new Integer[1]);
        return ArrayUtils.toPrimitive((Integer[])indices);
    }

    private VectorizedRowBatch getVectorizedRandomRowBatch(int seed, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        LongColumnVector lcv = new LongColumnVector(size);
        Random rand = new Random(seed);
        for (int i = 0; i < size; ++i) {
            lcv.vector[i] = rand.nextInt();
        }
        batch.cols[0] = lcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRowBatch(int[] inputs, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        LongColumnVector lcv = new LongColumnVector(size);
        for (int i = 0; i < size; ++i) {
            lcv.vector[i] = inputs[i % inputs.length];
        }
        batch.cols[0] = lcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private void compareToUDFYearDate(long t, int y) throws HiveException {
        UDFYear udf = new UDFYear();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = this.toTimestampWritable(t);
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((long)res.get(), (long)y);
    }

    private void verifyUDFYear(VectorizedRowBatch batch) throws HiveException {
        VectorUDFYearDate udf = null;
        udf = new VectorUDFYearDate(0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.dateTypeInfo});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
                }
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFYearDate(t, (int)y);
                continue;
            }
            Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFYear() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFYear(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFYear(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFYear(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFYear(batch);
    }

    private void compareToUDFDayOfMonthDate(long t, int y) throws HiveException {
        UDFDayOfMonth udf = new UDFDayOfMonth();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = this.toTimestampWritable(t);
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((long)res.get(), (long)y);
    }

    private void verifyUDFDayOfMonth(VectorizedRowBatch batch) throws HiveException {
        VectorUDFDayOfMonthDate udf = null;
        udf = new VectorUDFDayOfMonthDate(0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.dateTypeInfo});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
                }
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFDayOfMonthDate(t, (int)y);
                continue;
            }
            Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFDayOfMonth() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFDayOfMonth(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFDayOfMonth(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFDayOfMonth(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFDayOfMonth(batch);
    }

    private void compareToUDFMonthDate(long t, int y) throws HiveException {
        UDFMonth udf = new UDFMonth();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = this.toTimestampWritable(t);
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((long)res.get(), (long)y);
    }

    private void verifyUDFMonth(VectorizedRowBatch batch) throws HiveException {
        VectorUDFMonthDate udf = new VectorUDFMonthDate(0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.dateTypeInfo});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
                }
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFMonthDate(t, (int)y);
                continue;
            }
            Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFMonth() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMonth(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFMonth(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMonth(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMonth(batch);
    }

    private LongWritable getLongWritable(TimestampLocalTZWritable i) {
        LongWritable result = new LongWritable();
        if (i == null) {
            return null;
        }
        result.set(i.getSeconds());
        return result;
    }

    private void compareToUDFUnixTimeStampDate(long t, long y) {
        TimestampLocalTZWritable tsw = this.toTimestampLocalTZWritable(t);
        LongWritable res = this.getLongWritable(tsw);
        Assert.assertEquals((long)res.get(), (long)y);
    }

    private void verifyUDFUnixTimeStamp(VectorizedRowBatch batch) throws HiveException {
        VectorUDFUnixTimeStampDate udf = new VectorUDFUnixTimeStampDate(0, 1);
        udf.transientInit((Configuration)new HiveConf());
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.dateTypeInfo});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[1].noNulls) {
                    Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
                }
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFUnixTimeStampDate(t, y);
                continue;
            }
            Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFUnixTimeStamp() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFUnixTimeStamp(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFUnixTimeStamp(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFUnixTimeStamp(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFUnixTimeStamp(batch);
    }

    private void compareToUDFWeekOfYearDate(long t, int y) {
        UDFWeekOfYear udf = new UDFWeekOfYear();
        TimestampWritableV2 tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((long)res.get(), (long)y);
    }

    private void verifyUDFWeekOfYear(VectorizedRowBatch batch) throws HiveException {
        VectorUDFWeekOfYearDate udf = new VectorUDFWeekOfYearDate(0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.dateTypeInfo});
        udf.transientInit((Configuration)new HiveConf());
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFWeekOfYearDate(t, (int)y);
                continue;
            }
            Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFWeekOfYear() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFWeekOfYear(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFWeekOfYear(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFWeekOfYear(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFWeekOfYear(batch);
    }

    @Before
    public void setUp() throws Exception {
        this.runner = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setNameFormat("date-tester-thread-%d").build());
    }

    @Test(timeout=5000L)
    public void testMultiThreadedVectorUDFDate() throws HiveException {
        ArrayList<MultiThreadedDateFormatTest> tasks = new ArrayList<MultiThreadedDateFormatTest>();
        for (int i = 0; i < 200; ++i) {
            tasks.add(new MultiThreadedDateFormatTest());
        }
        try {
            List results = this.runner.invokeAll(tasks);
            for (Future f : results) {
                Assert.assertNull(f.get());
            }
        }
        catch (InterruptedException ioe) {
            Assert.fail((String)"Interrupted while running tests");
        }
        catch (Exception e) {
            Assert.fail((String)("Multi threaded operations threw unexpected Exception: " + e.getMessage()));
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.runner != null) {
            this.runner.shutdownNow();
        }
    }

    public static void main(String[] args) throws HiveException {
        TestVectorDateExpressions self = new TestVectorDateExpressions();
        self.testVectorUDFYear();
        self.testVectorUDFMonth();
        self.testVectorUDFDayOfMonth();
        self.testVectorUDFWeekOfYear();
        self.testVectorUDFUnixTimeStamp();
        self.testMultiThreadedVectorUDFDate();
    }

    private static final class MultiThreadedDateFormatTest
    implements Callable<Void> {
        private MultiThreadedDateFormatTest() {
        }

        @Override
        public Void call() throws Exception {
            int batchSize = 1024;
            VectorUDFDateString udf = new VectorUDFDateString(0, 1);
            VectorizedRowBatch batch = new VectorizedRowBatch(2, batchSize);
            BytesColumnVector in = new BytesColumnVector(batchSize);
            LongColumnVector out = new LongColumnVector(batchSize);
            batch.cols[0] = in;
            batch.cols[1] = out;
            for (int i = 0; i < batchSize; ++i) {
                byte[] data = String.format("1999-%02d-%02d", 1 + i % 12, 1 + i % 15).getBytes("UTF-8");
                in.setRef(i, data, 0, data.length);
                in.isNull[i] = false;
            }
            udf.evaluate(batch);
            return null;
        }
    }
}

