/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorCoalesceElt {
    @Test
    public void testCoalesce() throws Exception {
        Random random = new Random(5371L);
        int iteration = 0;
        for (int i = 0; i < 10; ++i) {
            iteration = this.doCoalesceElt(random, iteration, true, false);
        }
    }

    @Test
    public void testElt() throws Exception {
        Random random = new Random(5371L);
        int iteration = 0;
        for (int i = 0; i < 10; ++i) {
            iteration = this.doCoalesceElt(random, iteration, false, false);
            iteration = this.doCoalesceElt(random, iteration, false, true);
        }
    }

    private int doCoalesceElt(Random random, int iteration, boolean isCoalesce, boolean isEltIndexConst) throws Exception {
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 2, null, null, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 2, null, null, false);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 3, null, null, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 3, new int[]{0}, null, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 3, new int[]{0}, new int[]{0}, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 3, new int[]{1}, null, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 3, new int[]{1}, new int[]{1}, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 3, new int[]{0, 2}, null, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 3, new int[]{0, 2}, new int[]{0}, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 3, new int[]{0, 2}, new int[]{0, 2}, false);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 4, null, null, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 4, null, null, false);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 4, new int[]{0, 1, 2}, new int[]{0, 1, 2}, true);
        this.doCoalesceOnRandomDataType(random, iteration++, isCoalesce, isEltIndexConst, 4, new int[]{0, 1, 2}, new int[]{0, 1, 2}, false);
        return iteration;
    }

    private boolean contains(int[] columns, int column) {
        if (columns == null) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != column) continue;
            return true;
        }
        return false;
    }

    private boolean doCoalesceOnRandomDataType(Random random, int iteration, boolean isCoalesce, boolean isEltIndexConst, int columnCount, int[] constantColumns, int[] nullConstantColumns, boolean allowNulls) throws Exception {
        int i;
        ObjectInspector intObjectInspector;
        PrimitiveTypeInfo intTypeInfo;
        String typeName;
        if (isCoalesce) {
            typeName = VectorRandomRowSource.getRandomTypeName(random, VectorRandomRowSource.SupportedTypes.PRIMITIVES, null);
            typeName = VectorRandomRowSource.getDecoratedTypeName(random, typeName, VectorRandomRowSource.SupportedTypes.PRIMITIVES, null, 0, 2);
        } else {
            typeName = "string";
        }
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        if (isCoalesce) {
            intTypeInfo = null;
            intObjectInspector = null;
        } else {
            intTypeInfo = TypeInfoFactory.intTypeInfo;
            intObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)intTypeInfo);
        }
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        int columnNum = 1;
        if (!isCoalesce) {
            ExprNodeConstantDesc intColExpr;
            ArrayList<Object> intValueList = new ArrayList<Object>();
            for (int i2 = -1; i2 < columnCount + 2; ++i2) {
                intValueList.add(new IntWritable(i2));
            }
            int intValueListCount = intValueList.size();
            if (!isEltIndexConst) {
                generationSpecList.add(VectorRandomRowSource.GenerationSpec.createValueList((TypeInfo)intTypeInfo, intValueList));
                explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
                String columnName = "col" + columnNum++;
                columns.add(columnName);
                intColExpr = new ExprNodeColumnDesc((TypeInfo)intTypeInfo, columnName, "table", false);
            } else {
                Object scalarObject = random.nextInt(10) != 0 ? intValueList.get(random.nextInt(intValueListCount)) : null;
                intColExpr = new ExprNodeConstantDesc(typeInfo, scalarObject);
            }
            children.add((ExprNodeDesc)intColExpr);
        }
        for (int c = 0; c < columnCount; ++c) {
            ExprNodeConstantDesc colExpr;
            if (!this.contains(constantColumns, c)) {
                generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(typeInfo));
                explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
                String columnName = "col" + columnNum++;
                columns.add(columnName);
                colExpr = new ExprNodeColumnDesc(typeInfo, columnName, "table", false);
            } else {
                Object scalarObject = !this.contains(nullConstantColumns, c) ? VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo) : null;
                colExpr = new ExprNodeConstantDesc(typeInfo, scalarObject);
            }
            children.add((ExprNodeDesc)colExpr);
        }
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, allowNulls, true, explicitDataTypePhysicalVariationList);
        String[] columnNames = columns.toArray(new String[0]);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        GenericUDFCoalesce udf = isCoalesce ? new GenericUDFCoalesce() : new GenericUDFElt();
        int start = isCoalesce ? 0 : 1;
        int end = start + columnCount;
        ObjectInspector[] argumentOIs = new ObjectInspector[end];
        if (!isCoalesce) {
            argumentOIs[0] = intObjectInspector;
        }
        for (int i3 = start; i3 < end; ++i3) {
            argumentOIs[i3] = objectInspector;
        }
        ObjectInspector outputObjectInspector = udf.initialize(argumentOIs);
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(typeInfo, (GenericUDF)udf, children);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[CoalesceEltTestMode.count][];
        block7: for (i = 0; i < CoalesceEltTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            CoalesceEltTestMode coalesceEltTestMode = CoalesceEltTestMode.values()[i];
            switch (coalesceEltTestMode) {
                case ROW_MODE: {
                    if (this.doRowCastTest(typeInfo, columns, children, (GenericUDF)udf, exprDesc, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), exprDesc.getWritableObjectInspector(), resultObjects)) continue block7;
                    return false;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    if (this.doVectorCastTest(typeInfo, iteration, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, (GenericUDF)udf, exprDesc, coalesceEltTestMode, batchSource, exprDesc.getWritableObjectInspector(), outputTypeInfo, resultObjects)) continue block7;
                    return false;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + (Object)((Object)coalesceEltTestMode));
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < CoalesceEltTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                CoalesceEltTestMode coalesceEltTestMode = CoalesceEltTestMode.values()[v];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " sourceTypeName " + typeName + " " + (Object)((Object)coalesceEltTestMode) + " iteration " + iteration + " result is NULL " + (vectorResult == null ? "YES" : "NO result " + vectorResult.toString()) + " does not match row-mode expected result is NULL " + (expectedResult == null ? "YES" : "NO result '" + expectedResult.toString()) + "' row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " sourceTypeName " + typeName + " " + (Object)((Object)coalesceEltTestMode) + " iteration " + iteration + " result '" + vectorResult.toString() + "' (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result '" + expectedResult.toString() + "' (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
            }
        }
        return true;
    }

    private boolean doRowCastTest(TypeInfo typeInfo, List<String> columns, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, ObjectInspector rowInspector, ObjectInspector objectInspector, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        try {
            evaluator.initialize(rowInspector);
        }
        catch (HiveException e) {
            return false;
        }
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        return true;
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private boolean doVectorCastTest(TypeInfo typeInfo, int iteration, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, CoalesceEltTestMode coalesceEltTestMode, VectorRandomBatchSource batchSource, ObjectInspector objectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (coalesceEltTestMode == CoalesceEltTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (coalesceEltTestMode == CoalesceEltTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " coalesceEltTestMode " + (Object)((Object)coalesceEltTestMode) + " vectorExpression " + vectorExpression.toString());
        }
        VectorRandomRowSource rowSource = batchSource.getRowSource();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, vectorizationContext.getScratchColumnTypeNames(), vectorizationContext.getScratchDataTypePhysicalVariations());
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{vectorExpression.getOutputColumnNum()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            rowIndex += batch.size;
        }
        return true;
    }

    public static enum CoalesceEltTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = CoalesceEltTestMode.values().length;
        }
    }
}

