/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestDecimalUtil {
    @Test
    public void testFloor() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 13);
        HiveDecimal d1 = HiveDecimal.create((String)"19.56778");
        HiveDecimal expected1 = HiveDecimal.create((String)"19");
        DecimalUtil.floor((int)0, (HiveDecimal)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected1.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d2 = HiveDecimal.create((String)"23.00000");
        Assert.assertEquals((long)0L, (long)d2.scale());
        HiveDecimal expected2 = HiveDecimal.create((String)"23");
        DecimalUtil.floor((int)0, (HiveDecimal)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected2.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d3 = HiveDecimal.create((String)"-25.34567");
        HiveDecimal expected3 = HiveDecimal.create((String)"-26");
        DecimalUtil.floor((int)0, (HiveDecimal)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected3.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d4 = HiveDecimal.create((String)"-17.00000");
        Assert.assertEquals((long)0L, (long)d4.scale());
        HiveDecimal expected4 = HiveDecimal.create((String)"-17");
        DecimalUtil.floor((int)0, (HiveDecimal)d4, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected4.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d5 = HiveDecimal.create((String)"-0.30000");
        Assert.assertEquals((long)1L, (long)d5.scale());
        HiveDecimal expected5 = HiveDecimal.create((String)"-1");
        DecimalUtil.floor((int)0, (HiveDecimal)d5, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected5.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d6 = HiveDecimal.create((String)"0.30000");
        Assert.assertEquals((long)1L, (long)d6.scale());
        HiveDecimal expected6 = HiveDecimal.create((String)"0");
        DecimalUtil.floor((int)0, (HiveDecimal)d6, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected6.compareTo(dcv.vector[0].getHiveDecimal()));
    }

    @Test
    public void testCeiling() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 13);
        HiveDecimal d1 = HiveDecimal.create((String)"19.56778");
        HiveDecimal expected1 = HiveDecimal.create((String)"20");
        DecimalUtil.ceiling((int)0, (HiveDecimal)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected1.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d2 = HiveDecimal.create((String)"23.00000");
        Assert.assertEquals((long)0L, (long)d2.scale());
        HiveDecimal expected2 = HiveDecimal.create((String)"23");
        DecimalUtil.ceiling((int)0, (HiveDecimal)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected2.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d3 = HiveDecimal.create((String)"-25.34567");
        HiveDecimal expected3 = HiveDecimal.create((String)"-25");
        DecimalUtil.ceiling((int)0, (HiveDecimal)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected3.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d4 = HiveDecimal.create((String)"-17.00000");
        Assert.assertEquals((long)0L, (long)d4.scale());
        HiveDecimal expected4 = HiveDecimal.create((String)"-17");
        DecimalUtil.ceiling((int)0, (HiveDecimal)d4, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected4.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d5 = HiveDecimal.create((String)"-0.30000");
        Assert.assertEquals((long)1L, (long)d5.scale());
        HiveDecimal expected5 = HiveDecimal.create((String)"0");
        DecimalUtil.ceiling((int)0, (HiveDecimal)d5, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected5.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d6 = HiveDecimal.create((String)"0.30000");
        Assert.assertEquals((long)1L, (long)d6.scale());
        HiveDecimal expected6 = HiveDecimal.create((String)"1");
        DecimalUtil.ceiling((int)0, (HiveDecimal)d6, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected6.compareTo(dcv.vector[0].getHiveDecimal()));
    }

    @Test
    public void testAbs() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 13);
        HiveDecimal d1 = HiveDecimal.create((String)"19.56778");
        DecimalUtil.abs((int)0, (HiveDecimal)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)d1.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d2 = HiveDecimal.create((String)"-25.34567");
        HiveDecimal expected2 = HiveDecimal.create((String)"25.34567");
        DecimalUtil.abs((int)0, (HiveDecimal)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected2.compareTo(dcv.vector[0].getHiveDecimal()));
    }

    @Test
    public void testRound() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 0);
        HiveDecimal d1 = HiveDecimal.create((String)"19.56778");
        HiveDecimal expected1 = HiveDecimal.create((String)"20");
        DecimalUtil.round((int)0, (HiveDecimal)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected1.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d2 = HiveDecimal.create((String)"23.00000");
        Assert.assertEquals((long)0L, (long)d2.scale());
        HiveDecimal expected2 = HiveDecimal.create((String)"23");
        DecimalUtil.round((int)0, (HiveDecimal)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected2.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d3 = HiveDecimal.create((String)"-25.34567");
        HiveDecimal expected3 = HiveDecimal.create((String)"-25");
        DecimalUtil.round((int)0, (HiveDecimal)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected3.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d4 = HiveDecimal.create((String)"-17.00000");
        Assert.assertEquals((long)0L, (long)d4.scale());
        HiveDecimal expected4 = HiveDecimal.create((String)"-17");
        DecimalUtil.round((int)0, (HiveDecimal)d4, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected4.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d5 = HiveDecimal.create((String)"19.36778");
        HiveDecimal expected5 = HiveDecimal.create((String)"19");
        DecimalUtil.round((int)0, (HiveDecimal)d5, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected5.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d6 = HiveDecimal.create((String)"-25.54567");
        HiveDecimal expected6 = HiveDecimal.create((String)"-26");
        DecimalUtil.round((int)0, (HiveDecimal)d6, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected6.compareTo(dcv.vector[0].getHiveDecimal()));
    }

    @Test
    public void testRoundWithDigits() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 3);
        HiveDecimal d1 = HiveDecimal.create((String)"19.56778");
        HiveDecimal expected1 = HiveDecimal.create((String)"19.568");
        DecimalUtil.round((int)0, (HiveDecimal)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected1.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d2 = HiveDecimal.create((String)"23.56700");
        Assert.assertEquals((long)3L, (long)d2.scale());
        HiveDecimal expected2 = HiveDecimal.create((String)"23.567");
        DecimalUtil.round((int)0, (HiveDecimal)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected2.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d3 = HiveDecimal.create((String)"-25.34567");
        HiveDecimal expected3 = HiveDecimal.create((String)"-25.346");
        DecimalUtil.round((int)0, (HiveDecimal)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected3.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d4 = HiveDecimal.create((String)"-17.23400");
        Assert.assertEquals((long)3L, (long)d4.scale());
        HiveDecimal expected4 = HiveDecimal.create((String)"-17.234");
        DecimalUtil.round((int)0, (HiveDecimal)d4, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected4.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d5 = HiveDecimal.create((String)"19.36748");
        HiveDecimal expected5 = HiveDecimal.create((String)"19.367");
        DecimalUtil.round((int)0, (HiveDecimal)d5, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected5.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d6 = HiveDecimal.create((String)"-25.54537");
        HiveDecimal expected6 = HiveDecimal.create((String)"-25.545");
        DecimalUtil.round((int)0, (HiveDecimal)d6, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected6.compareTo(dcv.vector[0].getHiveDecimal()));
    }

    @Test
    public void testNegate() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 13);
        HiveDecimal d1 = HiveDecimal.create((String)"19.56778");
        HiveDecimal expected1 = HiveDecimal.create((String)"-19.56778");
        DecimalUtil.negate((int)0, (HiveDecimal)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected1.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d2 = HiveDecimal.create((String)"-25.34567");
        HiveDecimal expected2 = HiveDecimal.create((String)"25.34567");
        DecimalUtil.negate((int)0, (HiveDecimal)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected2.compareTo(dcv.vector[0].getHiveDecimal()));
        HiveDecimal d3 = HiveDecimal.create((String)"0.00000");
        Assert.assertEquals((long)0L, (long)d3.scale());
        HiveDecimal expected3 = HiveDecimal.create((String)"0");
        DecimalUtil.negate((int)0, (HiveDecimal)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((long)0L, (long)expected3.compareTo(dcv.vector[0].getHiveDecimal()));
    }

    @Test
    public void testSign() {
        LongColumnVector lcv = new LongColumnVector(4);
        HiveDecimal d1 = HiveDecimal.create((String)"19.56778");
        DecimalUtil.sign((int)0, (HiveDecimal)d1, (LongColumnVector)lcv);
        Assert.assertEquals((long)1L, (long)lcv.vector[0]);
        HiveDecimal d2 = HiveDecimal.create((String)"-25.34567");
        DecimalUtil.sign((int)0, (HiveDecimal)d2, (LongColumnVector)lcv);
        Assert.assertEquals((long)-1L, (long)lcv.vector[0]);
        HiveDecimal d3 = HiveDecimal.create((String)"0.00000");
        Assert.assertEquals((long)0L, (long)d3.scale());
        DecimalUtil.sign((int)0, (HiveDecimal)d3, (LongColumnVector)lcv);
        Assert.assertEquals((long)0L, (long)lcv.vector[0]);
    }
}

