/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.aggregation;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;

public class AggregationBase {
    public static GenericUDAFEvaluator getEvaluator(String aggregationFunctionName, TypeInfo typeInfo) throws SemanticException {
        GenericUDAFResolver resolver = FunctionRegistry.getGenericUDAFResolver((String)aggregationFunctionName);
        TypeInfo[] parameters = new TypeInfo[]{typeInfo};
        GenericUDAFEvaluator evaluator = resolver.getEvaluator(parameters);
        return evaluator;
    }

    protected static boolean doRowTest(TypeInfo typeInfo, GenericUDAFEvaluator evaluator, TypeInfo outputTypeInfo, GenericUDAFEvaluator.Mode udafEvaluatorMode, int maxKeyCount, List<String> columns, List<ExprNodeDesc> children, Object[][] randomRows, ObjectInspector rowInspector, Object[] results) throws Exception {
        boolean isCountStar;
        GenericUDAFEvaluator.AggregationBuffer[] aggregationBuffers = new GenericUDAFEvaluator.AggregationBuffer[maxKeyCount + 1];
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)outputTypeInfo);
        if (evaluator instanceof GenericUDAFCount.GenericUDAFCountEvaluator) {
            GenericUDAFCount.GenericUDAFCountEvaluator countEvaluator = (GenericUDAFCount.GenericUDAFCountEvaluator)evaluator;
            isCountStar = countEvaluator.getCountAllColumns();
        } else {
            isCountStar = false;
        }
        Object[] parameterArray = isCountStar ? new Object[]{} : new Object[1];
        for (Object[] row : randomRows) {
            ShortWritable shortWritable = (ShortWritable)row[0];
            int key = shortWritable == null ? maxKeyCount : (int)shortWritable.get();
            GenericUDAFEvaluator.AggregationBuffer aggregationBuffer = aggregationBuffers[key];
            if (aggregationBuffer == null) {
                aggregationBuffers[key] = aggregationBuffer = evaluator.getNewAggregationBuffer();
            }
            if (!isCountStar) {
                parameterArray[0] = row[1];
            }
            evaluator.aggregate(aggregationBuffer, parameterArray);
        }
        boolean isPrimitive = outputTypeInfo instanceof PrimitiveTypeInfo;
        boolean isPartial = udafEvaluatorMode == GenericUDAFEvaluator.Mode.PARTIAL1 || udafEvaluatorMode == GenericUDAFEvaluator.Mode.PARTIAL2;
        for (int key = 0; key < maxKeyCount + 1; key = (int)((short)(key + 1))) {
            GenericUDAFEvaluator.AggregationBuffer aggregationBuffer = aggregationBuffers[key];
            if (aggregationBuffer == null) continue;
            Object result = isPartial ? evaluator.terminatePartial(aggregationBuffer) : evaluator.terminate(aggregationBuffer);
            Object copyResult = result == null ? null : (isPrimitive ? VectorRandomRowSource.getWritablePrimitiveObject((PrimitiveTypeInfo)outputTypeInfo, objectInspector, result) : ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            results[key] = copyResult;
        }
        return true;
    }

    private static void extractResultObjects(VectorizedRowBatch outputBatch, short[] keys, VectorExtractRow resultVectorExtractRow, TypeInfo outputTypeInfo, Object[] scrqtchRow, Object[] results) {
        boolean isPrimitive = outputTypeInfo instanceof PrimitiveTypeInfo;
        ObjectInspector objectInspector = isPrimitive ? TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)outputTypeInfo) : null;
        for (int batchIndex = 0; batchIndex < outputBatch.size; ++batchIndex) {
            Object copyResult;
            resultVectorExtractRow.extractRow(outputBatch, batchIndex, scrqtchRow);
            results[keys[batchIndex]] = isPrimitive ? (copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE)) : scrqtchRow[0];
        }
    }

    protected static boolean doVectorTest(String aggregationName, TypeInfo typeInfo, GenericUDAFEvaluator evaluator, TypeInfo outputTypeInfo, GenericUDAFEvaluator.Mode udafEvaluatorMode, int maxKeyCount, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> parameterList, VectorRandomBatchSource batchSource, Object[] results) throws Exception {
        VectorAggregateExpression.AggregationBuffer aggregationBuffer;
        short key;
        HiveConf hiveConf = new HiveConf();
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        ImmutablePair pair = Vectorizer.getVectorAggregationDesc((String)aggregationName, parameterList, (GenericUDAFEvaluator)evaluator, (TypeInfo)outputTypeInfo, (GenericUDAFEvaluator.Mode)udafEvaluatorMode, (VectorizationContext)vectorizationContext);
        VectorAggregationDesc vecAggrDesc = (VectorAggregationDesc)pair.left;
        if (vecAggrDesc == null) {
            Assert.fail((String)("No vector aggregation expression found for aggregationName " + aggregationName + " udafEvaluatorMode " + udafEvaluatorMode + " parameterList " + parameterList + " outputTypeInfo " + outputTypeInfo));
        }
        Class vecAggrClass = vecAggrDesc.getVecAggrClass();
        Constructor ctor = null;
        try {
            ctor = vecAggrClass.getConstructor(VectorAggregationDesc.class);
        }
        catch (Exception e) {
            throw new HiveException("Constructor " + vecAggrClass.getSimpleName() + "(VectorAggregationDesc) not available");
        }
        VectorAggregateExpression vecAggrExpr = null;
        try {
            vecAggrExpr = (VectorAggregateExpression)ctor.newInstance(vecAggrDesc);
        }
        catch (Exception e) {
            throw new HiveException("Failed to create " + vecAggrClass.getSimpleName() + "(VectorAggregationDesc) object ", (Throwable)e);
        }
        VectorExpression.doTransientInit((VectorExpression)vecAggrExpr.getInputExpression(), (Configuration)hiveConf);
        VectorRandomRowSource rowSource = batchSource.getRowSource();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, vectorizationContext.getScratchColumnTypeNames(), vectorizationContext.getScratchDataTypePhysicalVariations());
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorAggregationBufferRow[] vectorAggregationBufferRows = new VectorAggregationBufferRow[maxKeyCount + 1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            LongColumnVector keyLongColVector = (LongColumnVector)batch.cols[0];
            VectorAggregationBufferRow[] batchBufferRows = new VectorAggregationBufferRow[1024];
            int size = batch.size;
            boolean selectedInUse = batch.selectedInUse;
            int[] selected = batch.selected;
            for (int logical = 0; logical < size; ++logical) {
                int batchIndex = selectedInUse ? selected[logical] : logical;
                int keyAdjustedBatchIndex = keyLongColVector.isRepeating ? 0 : batchIndex;
                key = keyLongColVector.noNulls || !keyLongColVector.isNull[keyAdjustedBatchIndex] ? (short)keyLongColVector.vector[keyAdjustedBatchIndex] : (short)maxKeyCount;
                VectorAggregationBufferRow bufferRow = vectorAggregationBufferRows[key];
                if (bufferRow == null) {
                    aggregationBuffer = vecAggrExpr.getNewAggregationBuffer();
                    aggregationBuffer.reset();
                    VectorAggregateExpression.AggregationBuffer[] aggregationBuffers = new VectorAggregateExpression.AggregationBuffer[]{aggregationBuffer};
                    vectorAggregationBufferRows[key] = bufferRow = new VectorAggregationBufferRow(aggregationBuffers);
                }
                batchBufferRows[logical] = bufferRow;
            }
            vecAggrExpr.aggregateInputSelection(batchBufferRows, 0, batch);
            rowIndex += batch.size;
        }
        String[] outputColumnNames = new String[]{"output"};
        TypeInfo[] outputTypeInfos = new TypeInfo[]{outputTypeInfo};
        VectorizedRowBatchCtx outputBatchContext = new VectorizedRowBatchCtx(outputColumnNames, outputTypeInfos, new DataTypePhysicalVariation[]{vecAggrExpr.getOutputDataTypePhysicalVariation()}, null, 0, 0, null, new String[0], new DataTypePhysicalVariation[0]);
        VectorizedRowBatch outputBatch = outputBatchContext.createVectorizedRowBatch();
        short[] keys = new short[1024];
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{0});
        Object[] scrqtchRow = new Object[1];
        for (key = 0; key < maxKeyCount + 1; key = (short)(key + 1)) {
            VectorAggregationBufferRow vectorAggregationBufferRow = vectorAggregationBufferRows[key];
            if (vectorAggregationBufferRow == null) continue;
            if (outputBatch.size == 1024) {
                AggregationBase.extractResultObjects(outputBatch, keys, resultVectorExtractRow, outputTypeInfo, scrqtchRow, results);
                outputBatch.reset();
            }
            keys[outputBatch.size] = key;
            aggregationBuffer = vectorAggregationBufferRow.getAggregationBuffer(0);
            vecAggrExpr.assignRowColumn(outputBatch, outputBatch.size++, 0, aggregationBuffer);
        }
        if (outputBatch.size > 0) {
            AggregationBase.extractResultObjects(outputBatch, keys, resultVectorExtractRow, outputTypeInfo, scrqtchRow, results);
        }
        return true;
    }

    private boolean compareObjects(Object object1, Object object2, TypeInfo typeInfo, ObjectInspector objectInspector) {
        if (typeInfo instanceof PrimitiveTypeInfo) {
            return VectorRandomRowSource.getWritablePrimitiveObject((PrimitiveTypeInfo)typeInfo, objectInspector, object1).equals(VectorRandomRowSource.getWritablePrimitiveObject((PrimitiveTypeInfo)typeInfo, objectInspector, object2));
        }
        return object1.equals(object2);
    }

    protected void executeAggregationTests(String aggregationName, TypeInfo typeInfo, GenericUDAFEvaluator evaluator, TypeInfo outputTypeInfo, GenericUDAFEvaluator.Mode udafEvaluatorMode, int maxKeyCount, List<String> columns, String[] columnNames, List<ExprNodeDesc> parameters, Object[][] randomRows, VectorRandomRowSource rowSource, VectorRandomBatchSource batchSource, boolean tryDecimal64, Object[] resultsArray) throws Exception {
        block4: for (int i = 0; i < AggregationTestMode.count; ++i) {
            Object[] results;
            resultsArray[i] = results = new Object[maxKeyCount + 1];
            AggregationTestMode aggregationTestMode = AggregationTestMode.values()[i];
            switch (aggregationTestMode) {
                case ROW_MODE: {
                    if (AggregationBase.doRowTest(typeInfo, evaluator, outputTypeInfo, udafEvaluatorMode, maxKeyCount, columns, parameters, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), results)) continue block4;
                    return;
                }
                case VECTOR_EXPRESSION: {
                    if (AggregationBase.doVectorTest(aggregationName, typeInfo, evaluator, outputTypeInfo, udafEvaluatorMode, maxKeyCount, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), parameters, batchSource, results)) continue block4;
                    return;
                }
                default: {
                    throw new RuntimeException("Unexpected Hash Aggregation test mode " + (Object)((Object)aggregationTestMode));
                }
            }
        }
    }

    protected void verifyAggregationResults(TypeInfo typeInfo, TypeInfo outputTypeInfo, int maxKeyCount, GenericUDAFEvaluator.Mode udafEvaluatorMode, Object[] resultsArray) {
        Object[] expectedResults = (Object[])resultsArray[0];
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)outputTypeInfo);
        for (int v = 1; v < AggregationTestMode.count; ++v) {
            Object[] vectorResults = (Object[])resultsArray[v];
            for (int key = 0; key < maxKeyCount + 1; key = (int)((short)(key + 1))) {
                Object expectedResult = expectedResults[key];
                Object vectorResult = vectorResults[key];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Key " + key + " typeName " + typeInfo.getTypeName() + " outputTypeName " + outputTypeInfo.getTypeName() + " " + (Object)((Object)AggregationTestMode.values()[v]) + " result is NULL " + (vectorResult == null ? "YES" : "NO result " + vectorResult.toString()) + " does not match row-mode expected result is NULL " + (expectedResult == null ? "YES" : "NO result " + expectedResult.toString()) + " udafEvaluatorMode " + udafEvaluatorMode));
                    continue;
                }
                if (this.compareObjects(expectedResult, vectorResult, outputTypeInfo, objectInspector)) continue;
                Assert.fail((String)("Key " + key + " typeName " + typeInfo.getTypeName() + " outputTypeName " + outputTypeInfo.getTypeName() + " " + (Object)((Object)AggregationTestMode.values()[v]) + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") udafEvaluatorMode " + udafEvaluatorMode));
            }
        }
    }

    public static enum AggregationTestMode {
        ROW_MODE,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = AggregationTestMode.values().length;
        }
    }
}

