/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorRowObject {
    void examineBatch(VectorizedRowBatch batch, VectorExtractRow vectorExtractRow, Object[][] randomRows, int firstRandomRowIndex) {
        int rowSize = vectorExtractRow.getCount();
        Object[] row = new Object[rowSize];
        for (int i = 0; i < batch.size; ++i) {
            vectorExtractRow.extractRow(batch, i, row);
            Object[] expectedRow = randomRows[firstRandomRowIndex + i];
            for (int c = 0; c < rowSize; ++c) {
                Object actualValue = row[c];
                Object expectedValue = expectedRow[c];
                if (actualValue == null || expectedValue == null) {
                    if (actualValue == expectedValue) continue;
                    Assert.fail((String)("Row " + (firstRandomRowIndex + i) + " and column " + c + " mismatch"));
                    continue;
                }
                if (actualValue.equals(expectedValue)) continue;
                Assert.fail((String)("Row " + (firstRandomRowIndex + i) + " and column " + c + " mismatch"));
            }
        }
    }

    void testVectorRowObject(int caseNum, boolean sort, Random r) throws HiveException {
        String[] emptyScratchTypeNames = new String[]{};
        VectorRandomRowSource source = new VectorRandomRowSource();
        source.init(r, VectorRandomRowSource.SupportedTypes.ALL, 4, true, true);
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx();
        batchContext.init(source.rowStructObjectInspector(), emptyScratchTypeNames);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        for (ColumnVector cv : batch.cols) {
            Arrays.fill(cv.isNull, true);
            cv.noNulls = false;
        }
        VectorAssignRow vectorAssignRow = new VectorAssignRow();
        vectorAssignRow.init(source.typeNames());
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(source.typeNames());
        Object[][] randomRows = source.randomRows(1000);
        if (sort) {
            source.sort(randomRows);
        }
        int firstRandomRowIndex = 0;
        for (int i = 0; i < randomRows.length; ++i) {
            Object[] row = randomRows[i];
            vectorAssignRow.assignRow(batch, batch.size, row);
            ++batch.size;
            if (batch.size != 1024) continue;
            this.examineBatch(batch, vectorExtractRow, randomRows, firstRandomRowIndex);
            firstRandomRowIndex = i + 1;
            batch.reset();
        }
        if (batch.size > 0) {
            this.examineBatch(batch, vectorExtractRow, randomRows, firstRandomRowIndex);
        }
    }

    @Test
    public void testVectorRowObject() throws Throwable {
        try {
            Random r = new Random(5678L);
            int caseNum = 0;
            for (int i = 0; i < 10; ++i) {
                this.testVectorRowObject(caseNum, false, r);
                ++caseNum;
            }
            this.testVectorRowObject(caseNum, true, r);
            ++caseNum;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }
}

