/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorGroupByOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFBloomFilterMerge;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFCount;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFCountStar;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeCaptureOutputOperator;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeCaptureVectorToRowOutputOperator;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchFromConcat;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchFromLongIterables;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchFromObjectIterables;
import org.apache.hadoop.hive.ql.exec.vector.util.FakeVectorRowBatchFromRepeats;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStdSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVarianceSample;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestVectorGroupByOperator {
    HiveConf hconf = new HiveConf();
    long outputRowCount = 0L;
    private static Object[][] validators = new Object[][]{{"count", ValueValidator.class}, {"min", ValueValidator.class}, {"max", ValueValidator.class}, {"sum", ValueValidator.class}, {"avg", AvgValidator.class}, {"variance", VarianceValidator.class}, {"var_pop", VarianceValidator.class}, {"var_samp", VarianceSampValidator.class}, {"std", StdValidator.class}, {"stddev", StdValidator.class}, {"stddev_pop", StdValidator.class}, {"stddev_samp", StdSampValidator.class}};

    private static ExprNodeDesc buildColumnDesc(VectorizationContext ctx, String column, TypeInfo typeInfo) {
        return new ExprNodeColumnDesc(typeInfo, column, "table", false);
    }

    private static AggregationDesc buildAggregationDesc(VectorizationContext ctx, String aggregate, GenericUDAFEvaluator.Mode mode, String column, TypeInfo typeInfo) {
        GenericUDAFCount.GenericUDAFCountEvaluator evaluator;
        TypeInfo[] typeInfos = new TypeInfo[]{typeInfo};
        ArrayList<ExprNodeDesc> params = new ArrayList<ExprNodeDesc>(1);
        ExprNodeDesc inputColumn = TestVectorGroupByOperator.buildColumnDesc(ctx, column, typeInfo);
        params.add(inputColumn);
        AggregationDesc agg = new AggregationDesc();
        agg.setGenericUDAFName(aggregate);
        agg.setMode(mode);
        agg.setParameters(params);
        try {
            switch (aggregate) {
                case "count": {
                    evaluator = new GenericUDAFCount.GenericUDAFCountEvaluator();
                    break;
                }
                case "min": {
                    evaluator = new GenericUDAFMin.GenericUDAFMinEvaluator();
                    break;
                }
                case "max": {
                    evaluator = new GenericUDAFMax.GenericUDAFMaxEvaluator();
                    break;
                }
                case "sum": {
                    evaluator = new GenericUDAFSum().getEvaluator(typeInfos);
                    break;
                }
                case "avg": {
                    evaluator = new GenericUDAFAverage().getEvaluator(typeInfos);
                    break;
                }
                case "variance": 
                case "var": 
                case "var_pop": {
                    evaluator = new GenericUDAFVariance.GenericUDAFVarianceEvaluator();
                    break;
                }
                case "var_samp": {
                    evaluator = new GenericUDAFVarianceSample.GenericUDAFVarianceSampleEvaluator();
                    break;
                }
                case "std": 
                case "stddev": 
                case "stddev_pop": {
                    evaluator = new GenericUDAFStd.GenericUDAFStdEvaluator();
                    break;
                }
                case "stddev_samp": {
                    evaluator = new GenericUDAFStdSample.GenericUDAFStdSampleEvaluator();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected aggregate " + aggregate);
                }
            }
        }
        catch (SemanticException e) {
            throw new RuntimeException(e);
        }
        agg.setGenericUDAFEvaluator((GenericUDAFEvaluator)evaluator);
        return agg;
    }

    private static AggregationDesc buildAggregationDescCountStar(VectorizationContext ctx) {
        AggregationDesc agg = new AggregationDesc();
        agg.setGenericUDAFName("count");
        agg.setMode(GenericUDAFEvaluator.Mode.PARTIAL1);
        agg.setParameters(new ArrayList());
        agg.setGenericUDAFEvaluator((GenericUDAFEvaluator)new GenericUDAFCount.GenericUDAFCountEvaluator());
        return agg;
    }

    private static Pair<GroupByDesc, VectorGroupByDesc> buildGroupByDescType(VectorizationContext ctx, String aggregate, GenericUDAFEvaluator.Mode mode, String column, TypeInfo dataType) {
        AggregationDesc agg = TestVectorGroupByOperator.buildAggregationDesc(ctx, aggregate, mode, column, dataType);
        ArrayList<AggregationDesc> aggs = new ArrayList<AggregationDesc>();
        aggs.add(agg);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        outputColumnNames.add("_col0");
        GroupByDesc desc = new GroupByDesc();
        VectorGroupByDesc vectorDesc = new VectorGroupByDesc();
        desc.setOutputColumnNames(outputColumnNames);
        desc.setAggregators(aggs);
        vectorDesc.setProcessingMode(VectorGroupByDesc.ProcessingMode.GLOBAL);
        return new Pair((Object)desc, (Object)vectorDesc);
    }

    private static Pair<GroupByDesc, VectorGroupByDesc> buildGroupByDescCountStar(VectorizationContext ctx) {
        AggregationDesc agg = TestVectorGroupByOperator.buildAggregationDescCountStar(ctx);
        ArrayList<AggregationDesc> aggs = new ArrayList<AggregationDesc>();
        aggs.add(agg);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        outputColumnNames.add("_col0");
        GroupByDesc desc = new GroupByDesc();
        VectorGroupByDesc vectorDesc = new VectorGroupByDesc();
        vectorDesc.setVecAggrDescs(new VectorAggregationDesc[]{new VectorAggregationDesc(agg.getGenericUDAFName(), (GenericUDAFEvaluator)new GenericUDAFCount.GenericUDAFCountEvaluator(), agg.getMode(), null, ColumnVector.Type.NONE, null, (TypeInfo)TypeInfoFactory.longTypeInfo, ColumnVector.Type.LONG, VectorUDAFCountStar.class)});
        vectorDesc.setProcessingMode(VectorGroupByDesc.ProcessingMode.HASH);
        desc.setOutputColumnNames(outputColumnNames);
        desc.setAggregators(aggs);
        return new Pair((Object)desc, (Object)vectorDesc);
    }

    private static Pair<GroupByDesc, VectorGroupByDesc> buildKeyGroupByDesc(VectorizationContext ctx, String aggregate, String column, TypeInfo dataTypeInfo, String[] keys, TypeInfo[] keyTypeInfos) {
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildGroupByDescType(ctx, aggregate, GenericUDAFEvaluator.Mode.PARTIAL1, column, dataTypeInfo);
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        vectorDesc.setProcessingMode(VectorGroupByDesc.ProcessingMode.HASH);
        ArrayList<ExprNodeDesc> keyExprs = new ArrayList<ExprNodeDesc>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            TypeInfo keyTypeInfo = keyTypeInfos[i];
            ExprNodeDesc keyExp = TestVectorGroupByOperator.buildColumnDesc(ctx, key, keyTypeInfo);
            keyExprs.add(keyExp);
        }
        desc.setKeys(keyExprs);
        desc.getOutputColumnNames().add("_col1");
        return pair;
    }

    @Test
    public void testMemoryPressureFlush() throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("Key");
        mapColumnNames.add("Value");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildKeyGroupByDesc(ctx, "max", "Value", (TypeInfo)TypeInfoFactory.longTypeInfo, new String[]{"Key"}, new TypeInfo[]{TypeInfoFactory.longTypeInfo});
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        long maxMemory = memoryMXBean.getHeapMemoryUsage().getMax();
        float treshold = 102400.0f / (float)maxMemory;
        desc.setMemoryThreshold(treshold);
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        long expected = vgo.getMaxMemory();
        Assert.assertEquals((long)expected, (long)maxMemory);
        this.outputRowCount = 0L;
        out.setOutputInspector(new FakeCaptureOutputOperator.OutputInspector(){

            @Override
            public void inspectRow(Object row, int tag) throws HiveException {
                ++TestVectorGroupByOperator.this.outputRowCount;
            }
        });
        Iterable<Object> it = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    long value = 0L;

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public Object next() {
                        return ++this.value;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        FakeVectorRowBatchFromObjectIterables data = new FakeVectorRowBatchFromObjectIterables(100, new String[]{"long", "long"}, it, it);
        long countRowsProduced = 0L;
        for (VectorizedRowBatch unit : data) {
            countRowsProduced += 100L;
            vgo.process((Object)unit, 0);
            if (0L < this.outputRowCount) break;
            Assert.assertTrue((countRowsProduced < 6400L ? 1 : 0) != 0);
        }
        Assert.assertTrue((0L < this.outputRowCount ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryPressureFlushLlap() throws HiveException {
        try {
            ArrayList<String> mapColumnNames = new ArrayList<String>();
            mapColumnNames.add("Key");
            mapColumnNames.add("Value");
            VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
            Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildKeyGroupByDesc(ctx, "max", "Value", (TypeInfo)TypeInfoFactory.longTypeInfo, new String[]{"Key"}, new TypeInfo[]{TypeInfoFactory.longTypeInfo});
            GroupByDesc desc = (GroupByDesc)pair.left;
            VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
            LlapProxy.setDaemon((boolean)true);
            CompilationOpContext cCtx = new CompilationOpContext();
            Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
            VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
            FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
            long maxMemory = 0x20000000L;
            ((GroupByDesc)vgo.getConf()).setMaxMemoryAvailable(maxMemory);
            float threshold = 102400.0f / (float)maxMemory;
            desc.setMemoryThreshold(threshold);
            vgo.initialize((Configuration)this.hconf, null);
            long got = vgo.getMaxMemory();
            Assert.assertEquals((long)maxMemory, (long)got);
            this.outputRowCount = 0L;
            out.setOutputInspector(new FakeCaptureOutputOperator.OutputInspector(){

                @Override
                public void inspectRow(Object row, int tag) throws HiveException {
                    ++TestVectorGroupByOperator.this.outputRowCount;
                }
            });
            Iterable<Object> it = new Iterable<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    return new Iterator<Object>(){
                        long value = 0L;

                        @Override
                        public boolean hasNext() {
                            return true;
                        }

                        @Override
                        public Object next() {
                            return ++this.value;
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
            };
            FakeVectorRowBatchFromObjectIterables data = new FakeVectorRowBatchFromObjectIterables(100, new String[]{"long", "long"}, it, it);
            long countRowsProduced = 0L;
            for (VectorizedRowBatch unit : data) {
                countRowsProduced += 100L;
                vgo.process((Object)unit, 0);
                if (0L < this.outputRowCount) break;
                Assert.assertTrue((countRowsProduced < 6400L ? 1 : 0) != 0);
            }
            Assert.assertTrue((0L < this.outputRowCount ? 1 : 0) != 0);
        }
        finally {
            LlapProxy.setDaemon((boolean)false);
        }
    }

    @Test
    public void testRollupAggregation() throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("k1");
        mapColumnNames.add("k2");
        mapColumnNames.add("v");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildKeyGroupByDesc(ctx, "count", "v", (TypeInfo)TypeInfoFactory.longTypeInfo, new String[]{"k1", "k2"}, new TypeInfo[]{TypeInfoFactory.longTypeInfo, TypeInfoFactory.longTypeInfo});
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        desc.setGroupingSetsPresent(true);
        ArrayList<Long> groupingSets = new ArrayList<Long>();
        groupingSets.add(0L);
        groupingSets.add(1L);
        groupingSets.add(2L);
        desc.setListGroupingSets(groupingSets);
        ExprNodeConstantDesc groupingSetDummyKey = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (Object)0L);
        desc.getKeys().add(groupingSetDummyKey);
        desc.setGroupingSetPosition(2);
        CompilationOpContext cCtx = new CompilationOpContext();
        desc.setMinReductionHashAggr(0.5f);
        this.hconf.set("hive.groupby.mapaggr.checkinterval", "10");
        this.hconf.set("hive.vectorized.groupby.checkinterval", "10");
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        this.outputRowCount = 0L;
        out.setOutputInspector(new FakeCaptureOutputOperator.OutputInspector(){

            @Override
            public void inspectRow(Object row, int tag) throws HiveException {
                ++TestVectorGroupByOperator.this.outputRowCount;
            }
        });
        FakeVectorRowBatchFromObjectIterables data = this.getDataForRollup();
        long countRowsProduced = 0L;
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
            if ((countRowsProduced += (long)unit.size) < 100L) continue;
            break;
        }
        vgo.close(false);
        Assert.assertEquals((long)14L, (long)this.outputRowCount);
    }

    FakeVectorRowBatchFromObjectIterables getDataForRollup() throws HiveException {
        Iterable<Object> k1 = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    int value = 0;
                    int ndv = 2;

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public Object next() {
                        this.value = (this.value + 1) % this.ndv;
                        return this.value;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        Iterable<Object> k2 = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    int value = 0;
                    int ndv = 6;

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public Object next() {
                        this.value = (this.value + 1) % this.ndv;
                        return this.value;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        Iterable<Object> v = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    int value = 0;
                    int ndv = 1;

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public Object next() {
                        this.value = (this.value + 1) % this.ndv;
                        return this.value;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        return new FakeVectorRowBatchFromObjectIterables(2, new String[]{"long", "long", "long", "long"}, k1, k2, v, v);
    }

    @Test
    public void testRollupAggregationWithBufferReuse() throws HiveException {
        VectorAggregateExpression spyAggregator;
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("k1");
        mapColumnNames.add("k2");
        mapColumnNames.add("v");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildKeyGroupByDesc(ctx, "count", "v", (TypeInfo)TypeInfoFactory.longTypeInfo, new String[]{"k1", "k2"}, new TypeInfo[]{TypeInfoFactory.longTypeInfo, TypeInfoFactory.longTypeInfo});
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        desc.setGroupingSetsPresent(true);
        ArrayList<Long> groupingSets = new ArrayList<Long>();
        groupingSets.add(0L);
        groupingSets.add(1L);
        groupingSets.add(2L);
        desc.setListGroupingSets(groupingSets);
        ExprNodeConstantDesc groupingSetDummyKey = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (Object)0L);
        desc.getKeys().add(groupingSetDummyKey);
        desc.setGroupingSetPosition(2);
        CompilationOpContext cCtx = new CompilationOpContext();
        desc.setMinReductionHashAggr(0.5f);
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        VectorGroupByOperator.ProcessingModeHashAggregate processingMode = (VectorGroupByOperator.ProcessingModeHashAggregate)vgo.processingMode;
        vgo.aggregators[0] = spyAggregator = (VectorAggregateExpression)Mockito.spy((Object)vgo.aggregators[0]);
        FakeVectorRowBatchFromObjectIterables data = this.getDataForRollup();
        long countRowsProduced = 0L;
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
            processingMode.gcCanary.clear();
            if ((countRowsProduced += (long)unit.size) < 1000L) continue;
            break;
        }
        vgo.close(false);
        ((VectorAggregateExpression)Mockito.verify((Object)spyAggregator, (VerificationMode)Mockito.times((int)13))).getNewAggregationBuffer();
    }

    @Test
    public void testRollupAggregationWithFlush() throws HiveException {
        VectorizedRowBatch unit;
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("k1");
        mapColumnNames.add("k2");
        mapColumnNames.add("v");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildKeyGroupByDesc(ctx, "count", "v", (TypeInfo)TypeInfoFactory.longTypeInfo, new String[]{"k1", "k2"}, new TypeInfo[]{TypeInfoFactory.longTypeInfo, TypeInfoFactory.longTypeInfo});
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        desc.setGroupingSetsPresent(true);
        ArrayList<Long> groupingSets = new ArrayList<Long>();
        groupingSets.add(0L);
        groupingSets.add(1L);
        groupingSets.add(2L);
        desc.setListGroupingSets(groupingSets);
        ExprNodeConstantDesc groupingSetDummyKey = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (Object)0L);
        desc.getKeys().add(groupingSetDummyKey);
        desc.setGroupingSetPosition(2);
        CompilationOpContext cCtx = new CompilationOpContext();
        desc.setMinReductionHashAggr(0.5f);
        this.hconf.set("hive.groupby.mapaggr.checkinterval", "10");
        this.hconf.set("hive.vectorized.groupby.checkinterval", "10");
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        VectorGroupByOperator.ProcessingModeHashAggregate processingMode = (VectorGroupByOperator.ProcessingModeHashAggregate)vgo.processingMode;
        Assert.assertEquals((long)1000000L, (long)((VectorGroupByOperator.ProcessingModeHashAggregate)vgo.processingMode).getMaxHtEntries());
        this.outputRowCount = 0L;
        out.setOutputInspector(new FakeCaptureOutputOperator.OutputInspector(){

            @Override
            public void inspectRow(Object row, int tag) throws HiveException {
                ++TestVectorGroupByOperator.this.outputRowCount;
            }
        });
        FakeVectorRowBatchFromObjectIterables data = this.getDataForRollup();
        long countRowsProduced = 0L;
        long numElementsToBeRetained = 0L;
        int avgAccess = 0;
        Iterator<VectorizedRowBatch> iterator = data.iterator();
        while (iterator.hasNext()) {
            unit = iterator.next();
            vgo.process((Object)unit, 0);
            if ((countRowsProduced += (long)unit.size) < 100L) continue;
            avgAccess = processingMode.computeAvgAccess();
            numElementsToBeRetained = this.getElementsHigherThan(processingMode.mapKeysAggregationBuffers, avgAccess);
            processingMode.gcCanary.clear();
            break;
        }
        if ((iterator = data.iterator()).hasNext()) {
            unit = iterator.next();
            long zeroAccessBeforeFlush = this.getElementsWithZeroAccess(processingMode.mapKeysAggregationBuffers);
            vgo.process((Object)unit, 0);
            long freqElementsAfterFlush = this.getElementsHigherThan(processingMode.mapKeysAggregationBuffers, avgAccess);
            Assert.assertTrue((String)("After flush: " + freqElementsAfterFlush + ", before flush: " + numElementsToBeRetained), (freqElementsAfterFlush >= numElementsToBeRetained ? 1 : 0) != 0);
            long zeroAccessAfterFlush = this.getElementsWithZeroAccess(processingMode.mapKeysAggregationBuffers);
            Assert.assertTrue((String)("After flush: " + zeroAccessAfterFlush + ", before flush: " + zeroAccessBeforeFlush), (zeroAccessAfterFlush > zeroAccessBeforeFlush ? 1 : 0) != 0);
        }
        vgo.close(false);
    }

    long getElementsHigherThan(Map<KeyWrapper, VectorAggregationBufferRow> aggMap, int avgAccess) {
        return aggMap.values().stream().filter(v -> v.getAccessCount() > avgAccess).count();
    }

    long getElementsWithZeroAccess(Map<KeyWrapper, VectorAggregationBufferRow> aggMap) {
        return aggMap.values().stream().filter(v -> v.getAccessCount() == 0).count();
    }

    @Test
    public void testMaxHTEntriesFlush() throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("Key");
        mapColumnNames.add("Value");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildKeyGroupByDesc(ctx, "max", "Value", (TypeInfo)TypeInfoFactory.longTypeInfo, new String[]{"Key"}, new TypeInfo[]{TypeInfoFactory.longTypeInfo});
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        long maxMemory = memoryMXBean.getHeapMemoryUsage().getMax();
        float treshold = 1024000.0f / (float)maxMemory;
        desc.setMemoryThreshold(treshold);
        this.hconf.set("hive.vectorized.groupby.maxentries", "100");
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        long expected = vgo.getMaxMemory();
        Assert.assertEquals((long)expected, (long)maxMemory);
        this.outputRowCount = 0L;
        out.setOutputInspector(new FakeCaptureOutputOperator.OutputInspector(){

            @Override
            public void inspectRow(Object row, int tag) throws HiveException {
                ++TestVectorGroupByOperator.this.outputRowCount;
            }
        });
        Iterable<Object> it = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    long value = 0L;

                    @Override
                    public boolean hasNext() {
                        return true;
                    }

                    @Override
                    public Object next() {
                        return ++this.value;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        FakeVectorRowBatchFromObjectIterables data = new FakeVectorRowBatchFromObjectIterables(100, new String[]{"long", "long"}, it, it);
        long countRowsProduced = 0L;
        for (VectorizedRowBatch unit : data) {
            countRowsProduced += 100L;
            vgo.process((Object)unit, 0);
            if (0L >= this.outputRowCount) continue;
            break;
        }
        Assert.assertTrue((countRowsProduced > 100L ? 1 : 0) != 0);
        Assert.assertTrue(((double)countRowsProduced < 19200.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiKeyIntStringInt() throws HiveException {
        this.testMultiKey("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"int", "string", "int", "double"}, Arrays.asList(null, 1, 1, null, 2, 2, null), Arrays.asList("A", "A", "A", "C", null, null, "A"), Arrays.asList(null, 2, 2, null, 2, 2, null), Arrays.asList(1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0)), this.buildHashMap(Arrays.asList(1, "A", 2), 6.0, Arrays.asList(null, "C", null), 8.0, Arrays.asList(2, null, 2), 48.0, Arrays.asList(null, "A", null), 65.0));
    }

    @Test
    public void testMultiKeyStringByteString() throws HiveException {
        this.testMultiKey("sum", new FakeVectorRowBatchFromObjectIterables(1, new String[]{"string", "tinyint", "string", "double"}, Arrays.asList("A", "A", null), Arrays.asList(1, 1, 1), Arrays.asList("A", "A", "A"), Arrays.asList(1.0, 1.0, 1.0)), this.buildHashMap(Arrays.asList("A", (byte)1, "A"), 2.0, Arrays.asList(null, (byte)1, "A"), 1.0));
    }

    @Test
    public void testMultiKeyStringIntString() throws HiveException {
        this.testMultiKey("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"string", "int", "string", "double"}, Arrays.asList("A", "A", "A", "C", null, null, "A"), Arrays.asList(null, 1, 1, null, 2, 2, null), Arrays.asList("A", "A", "A", "C", null, null, "A"), Arrays.asList(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0)), this.buildHashMap(Arrays.asList(null, 2, null), 2.0, Arrays.asList("C", null, "C"), 1.0, Arrays.asList("A", 1, "A"), 2.0, Arrays.asList("A", null, "A"), 2.0));
    }

    @Test
    public void testMultiKeyIntStringString() throws HiveException {
        this.testMultiKey("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"int", "string", "string", "double"}, Arrays.asList(null, 1, 1, null, 2, 2, null), Arrays.asList("A", "A", "A", "C", null, null, "A"), Arrays.asList("A", "A", "A", "C", null, null, "A"), Arrays.asList(1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0)), this.buildHashMap(Arrays.asList(2, null, null), 2.0, Arrays.asList(null, "C", "C"), 1.0, Arrays.asList(1, "A", "A"), 2.0, Arrays.asList(null, "A", "A"), 2.0));
    }

    @Test
    public void testMultiKeyDoubleStringInt() throws HiveException {
        this.testMultiKey("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"double", "string", "int", "double"}, Arrays.asList(null, 1.0, 1.0, null, 2.0, 2.0, null), Arrays.asList("A", "A", "A", "C", null, null, "A"), Arrays.asList(null, 2, 2, null, 2, 2, null), Arrays.asList(1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0)), this.buildHashMap(Arrays.asList(1.0, "A", 2), 6.0, Arrays.asList(null, "C", null), 8.0, Arrays.asList(2.0, null, 2), 48.0, Arrays.asList(null, "A", null), 65.0));
    }

    @Test
    public void testMultiKeyDoubleShortString() throws HiveException {
        short s = 2;
        this.testMultiKey("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"double", "smallint", "string", "double"}, Arrays.asList(null, 1.0, 1.0, null, 2.0, 2.0, null), Arrays.asList(null, s, s, null, s, s, null), Arrays.asList("A", "A", "A", "C", null, null, "A"), Arrays.asList(1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0)), this.buildHashMap(Arrays.asList(1.0, s, "A"), 6.0, Arrays.asList(null, null, "C"), 8.0, Arrays.asList(2.0, s, null), 48.0, Arrays.asList(null, null, "A"), 65.0));
    }

    @Test
    public void testDoubleValueTypeSum() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, null, 1, null), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 20.0, null, 19.0));
    }

    @Test
    public void testDoubleValueTypeSumOneKey() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, 1, 1, 1), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 39.0));
    }

    @Test
    public void testDoubleValueTypeCount() throws HiveException {
        this.testKeyTypeAggregate("count", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, null, 1, null), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 2L, null, 1L));
    }

    @Test
    public void testDoubleValueTypeCountOneKey() throws HiveException {
        this.testKeyTypeAggregate("count", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, 1, 1, 1), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 3L));
    }

    @Test
    public void testDoubleValueTypeAvg() throws HiveException {
        this.testKeyTypeAggregate("avg", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, null, 1, null), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 10.0, null, 19.0));
    }

    @Test
    public void testDoubleValueTypeAvgOneKey() throws HiveException {
        this.testKeyTypeAggregate("avg", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, 1, 1, 1), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 13.0));
    }

    @Test
    public void testDoubleValueTypeMin() throws HiveException {
        this.testKeyTypeAggregate("min", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, null, 1, null), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 7.0, null, 19.0));
    }

    @Test
    public void testDoubleValueTypeMinOneKey() throws HiveException {
        this.testKeyTypeAggregate("min", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, 1, 1, 1), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 7.0));
    }

    @Test
    public void testDoubleValueTypeMax() throws HiveException {
        this.testKeyTypeAggregate("max", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, null, 1, null), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 13.0, null, 19.0));
    }

    @Test
    public void testDoubleValueTypeMaxOneKey() throws HiveException {
        this.testKeyTypeAggregate("max", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, 1, 1, 1), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 19.0));
    }

    @Test
    public void testDoubleValueTypeVariance() throws HiveException {
        this.testKeyTypeAggregate("variance", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, null, 1, null), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 9.0, null, 0.0));
    }

    @Test
    public void testDoubleValueTypeVarianceOneKey() throws HiveException {
        this.testKeyTypeAggregate("variance", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "double"}, Arrays.asList(1, 1, 1, 1), Arrays.asList(13.0, null, 7.0, 19.0)), this.buildHashMap((byte)1, 24.0));
    }

    @Test
    public void testTinyintKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"tinyint", "bigint"}, Arrays.asList(1, null, 1, null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap((byte)1, 20L, null, 19L));
    }

    @Test
    public void testSmallintKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"smallint", "bigint"}, Arrays.asList(1, null, 1, null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap((short)1, 20L, null, 19L));
    }

    @Test
    public void testIntKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"int", "bigint"}, Arrays.asList(1, null, 1, null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap(1, 20L, null, 19L));
    }

    @Test
    public void testBigintKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"bigint", "bigint"}, Arrays.asList(1, null, 1, null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap(1L, 20L, null, 19L));
    }

    @Test
    public void testBooleanKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"boolean", "bigint"}, Arrays.asList(true, null, true, null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap(true, 20L, null, 19L));
    }

    @Test
    public void testTimestampKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"timestamp", "bigint"}, Arrays.asList(new Timestamp(1L), null, new Timestamp(1L), null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap(new Timestamp(1L), 20L, null, 19L));
    }

    @Test
    public void testFloatKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"float", "bigint"}, Arrays.asList(1, null, 1, null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap(Float.valueOf(1.0f), 20L, null, 19L));
    }

    @Test
    public void testDoubleKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"double", "bigint"}, Arrays.asList(1, null, 1, null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap(1.0, 20L, null, 19L));
    }

    @Test
    public void testCountStar() throws HiveException {
        this.testAggregateCountStar(2, Arrays.asList(13L, null, 7L, 19L), 4L);
    }

    @Test
    public void testCountReduce() throws HiveException {
        this.testAggregateCountReduce(2, Arrays.asList(new Long[0]), 0L);
        this.testAggregateCountReduce(2, Arrays.asList(0L), 0L);
        this.testAggregateCountReduce(2, Arrays.asList(0L, 0L), 0L);
        this.testAggregateCountReduce(2, Arrays.asList(0L, 1L, 0L), 1L);
        this.testAggregateCountReduce(2, Arrays.asList(13L, 0L, 7L, 19L), 39L);
    }

    @Test
    public void testCountDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "count", 2, Arrays.asList(HiveDecimal.create((int)1), HiveDecimal.create((int)2), HiveDecimal.create((int)3)), 3L);
    }

    @Test
    public void testMaxDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "max", 2, Arrays.asList(HiveDecimal.create((int)1), HiveDecimal.create((int)2), HiveDecimal.create((int)3)), HiveDecimal.create((int)3));
        this.testAggregateDecimal("Decimal", "max", 2, Arrays.asList(HiveDecimal.create((int)3), HiveDecimal.create((int)2), HiveDecimal.create((int)1)), HiveDecimal.create((int)3));
        this.testAggregateDecimal("Decimal", "max", 2, Arrays.asList(HiveDecimal.create((int)2), HiveDecimal.create((int)3), HiveDecimal.create((int)1)), HiveDecimal.create((int)3));
    }

    @Test
    public void testMinDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "min", 2, Arrays.asList(HiveDecimal.create((int)1), HiveDecimal.create((int)2), HiveDecimal.create((int)3)), HiveDecimal.create((int)1));
        this.testAggregateDecimal("Decimal", "min", 2, Arrays.asList(HiveDecimal.create((int)3), HiveDecimal.create((int)2), HiveDecimal.create((int)1)), HiveDecimal.create((int)1));
        this.testAggregateDecimal("Decimal", "min", 2, Arrays.asList(HiveDecimal.create((int)2), HiveDecimal.create((int)1), HiveDecimal.create((int)3)), HiveDecimal.create((int)1));
    }

    @Test
    public void testSumDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "sum", 2, Arrays.asList(HiveDecimal.create((int)1), HiveDecimal.create((int)2), HiveDecimal.create((int)3)), HiveDecimal.create((int)6));
    }

    @Test
    public void testSumDecimalHive6508() throws HiveException {
        int scale = 4;
        this.testAggregateDecimal("Decimal(10,4)", "sum", 4, Arrays.asList(HiveDecimal.create((String)"1234.2401"), HiveDecimal.create((String)"1868.52"), HiveDecimal.ZERO, HiveDecimal.create((String)"456.84"), HiveDecimal.create((String)"121.89")), HiveDecimal.create((String)"3681.4901"));
    }

    @Test
    public void testAvgDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "avg", 2, Arrays.asList(HiveDecimal.create((int)1), HiveDecimal.create((int)2), HiveDecimal.create((int)3)), HiveDecimal.create((int)2));
    }

    @Test
    public void testAvgDecimalNegative() throws HiveException {
        this.testAggregateDecimal("Decimal", "avg", 2, Arrays.asList(HiveDecimal.create((int)-1), HiveDecimal.create((int)-2), HiveDecimal.create((int)-3)), HiveDecimal.create((int)-2));
    }

    @Test
    public void testVarianceDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "variance", 2, Arrays.asList(HiveDecimal.create((int)13), HiveDecimal.create((int)5), HiveDecimal.create((int)7), HiveDecimal.create((int)19)), 30.0);
    }

    @Test
    public void testVarSampDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "var_samp", 2, Arrays.asList(HiveDecimal.create((int)13), HiveDecimal.create((int)5), HiveDecimal.create((int)7), HiveDecimal.create((int)19)), 40.0);
    }

    @Test
    public void testStdPopDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "stddev_pop", 2, Arrays.asList(HiveDecimal.create((int)13), HiveDecimal.create((int)5), HiveDecimal.create((int)7), HiveDecimal.create((int)19)), Math.sqrt(30.0));
    }

    @Test
    public void testStdSampDecimal() throws HiveException {
        this.testAggregateDecimal("Decimal", "stddev_samp", 2, Arrays.asList(HiveDecimal.create((int)13), HiveDecimal.create((int)5), HiveDecimal.create((int)7), HiveDecimal.create((int)19)), Math.sqrt(40.0));
    }

    @Test
    public void testDecimalKeyTypeAggregate() throws HiveException {
        this.testKeyTypeAggregate("sum", new FakeVectorRowBatchFromObjectIterables(2, new String[]{"decimal(38,0)", "bigint"}, Arrays.asList(HiveDecimal.create((int)1), null, HiveDecimal.create((int)1), null), Arrays.asList(13L, null, 7L, 19L)), this.buildHashMap(HiveDecimal.create((int)1), 20L, null, 19L));
    }

    @Test
    public void testCountString() throws HiveException {
        this.testAggregateString("count", 2, Arrays.asList("A", "B", "C"), 3L);
    }

    @Test
    public void testMaxString() throws HiveException {
        this.testAggregateString("max", 2, Arrays.asList("A", "B", "C"), "C");
        this.testAggregateString("max", 2, Arrays.asList("C", "B", "A"), "C");
    }

    @Test
    public void testMinString() throws HiveException {
        this.testAggregateString("min", 2, Arrays.asList("A", "B", "C"), "A");
        this.testAggregateString("min", 2, Arrays.asList("C", "B", "A"), "A");
    }

    @Test
    public void testMaxNullString() throws HiveException {
        this.testAggregateString("max", 2, Arrays.asList("A", "B", null), "B");
        this.testAggregateString("max", 2, Arrays.asList(null, null, null), null);
    }

    @Test
    public void testCountStringWithNull() throws HiveException {
        this.testAggregateString("count", 2, Arrays.asList("A", null, "C", "D", null), 3L);
    }

    @Test
    public void testCountStringAllNull() throws HiveException {
        this.testAggregateString("count", 4, Arrays.asList(null, null, null, null, null), 0L);
    }

    @Test
    public void testMinLongNullStringKeys() throws HiveException {
        this.testAggregateStringKeyAggregate("min", 2, Arrays.asList("A", null, "A", null), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap("A", 7L, null, 5L));
    }

    @Test
    public void testMinLongStringKeys() throws HiveException {
        this.testAggregateStringKeyAggregate("min", 2, Arrays.asList("A", "B", "A", "B"), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap("A", 7L, "B", 5L));
    }

    @Test
    public void testMinLongKeyGroupByCompactBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("min", 2, Arrays.asList(1L, 1L, 2L, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(1L, 5L, 2L, 7L));
    }

    @Test
    public void testMinLongKeyGroupBySingleBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("min", 4, Arrays.asList(1L, 1L, 2L, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(1L, 5L, 2L, 7L));
    }

    @Test
    public void testMinLongKeyGroupByCrossBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("min", 2, Arrays.asList(1L, 2L, 1L, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(1L, 7L, 2L, 5L));
    }

    @Test
    public void testMinLongNullKeyGroupByCrossBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("min", 2, Arrays.asList(null, 2L, null, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(null, 7L, 2L, 5L));
    }

    @Test
    public void testMinLongNullKeyGroupBySingleBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("min", 4, Arrays.asList(null, 2L, null, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(null, 7L, 2L, 5L));
    }

    @Test
    public void testMaxLongNullKeyGroupBySingleBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("max", 4, Arrays.asList(null, 2L, null, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(null, 13L, 2L, 19L));
    }

    @Test
    public void testCountLongNullKeyGroupBySingleBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("count", 4, Arrays.asList(null, 2L, null, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(null, 2L, 2L, 2L));
    }

    @Test
    public void testSumLongNullKeyGroupBySingleBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("sum", 4, Arrays.asList(null, 2L, null, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(null, 20L, 2L, 24L));
    }

    @Test
    public void testAvgLongNullKeyGroupBySingleBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("avg", 4, Arrays.asList(null, 2L, null, 2L), Arrays.asList(13L, 5L, 7L, 19L), this.buildHashMap(null, 10.0, 2L, 12.0));
    }

    @Test
    public void testVarLongNullKeyGroupBySingleBatch() throws HiveException {
        this.testAggregateLongKeyAggregate("variance", 4, Arrays.asList(null, 2L, 1L, 2L, 1L, 1L), Arrays.asList(13L, 5L, 18L, 19L, 12L, 15L), this.buildHashMap(null, 0.0, 2L, 49.0, 1L, 6.0));
    }

    @Test
    public void testMinNullLongNullKeyGroupBy() throws HiveException {
        this.testAggregateLongKeyAggregate("min", 4, Arrays.asList(null, 2L, null, 2L), Arrays.asList(null, null, null, null), this.buildHashMap(null, null, 2L, null));
    }

    @Test
    public void testMinLongGroupBy() throws HiveException {
        this.testAggregateLongAggregate("min", 2, Arrays.asList(13L, 5L, 7L, 19L), 5L);
    }

    @Test
    public void testMinLongSimple() throws HiveException {
        this.testAggregateLongAggregate("min", 2, Arrays.asList(13L, 5L, 7L, 19L), 5L);
    }

    @Test
    public void testMinLongEmpty() throws HiveException {
        this.testAggregateLongAggregate("min", 2, Arrays.asList(new Long[0]), null);
    }

    @Test
    public void testMinLongNulls() throws HiveException {
        this.testAggregateLongAggregate("min", 2, Arrays.asList(new Long[]{null}), null);
        this.testAggregateLongAggregate("min", 2, Arrays.asList(null, null, null), null);
        this.testAggregateLongAggregate("min", 2, Arrays.asList(null, 5L, 7L, 19L), 5L);
        this.testAggregateLongAggregate("min", 2, Arrays.asList(13L, null, 7L, 19L), 7L);
    }

    @Test
    public void testMinLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("min", 42L, 4096, 1024, 42L);
    }

    @Test
    public void testMinLongRepeatNulls() throws HiveException {
        this.testAggregateLongRepeats("min", null, 4096, 1024, null);
    }

    @Test
    public void testMinLongNegative() throws HiveException {
        this.testAggregateLongAggregate("min", 2, Arrays.asList(13L, 5L, 7L, -19L), -19L);
    }

    @Test
    public void testMinLongMinInt() throws HiveException {
        this.testAggregateLongAggregate("min", 2, Arrays.asList(13L, 5L, Integer.MIN_VALUE, -19L), Integer.MIN_VALUE);
    }

    @Test
    public void testMinLongMinLong() throws HiveException {
        this.testAggregateLongAggregate("min", 2, Arrays.asList(13L, 5L, Long.MIN_VALUE, Integer.MIN_VALUE), Long.MIN_VALUE);
    }

    @Test
    public void testMaxLongSimple() throws HiveException {
        this.testAggregateLongAggregate("max", 2, Arrays.asList(13L, 5L, 7L, 19L), 19L);
    }

    @Test
    public void testMaxLongEmpty() throws HiveException {
        this.testAggregateLongAggregate("max", 2, Arrays.asList(new Long[0]), null);
    }

    @Test
    public void testMaxLongNegative() throws HiveException {
        this.testAggregateLongAggregate("max", 2, Arrays.asList(-13L, -5L, -7L, -19L), -5L);
    }

    @Test
    public void testMaxLongMaxInt() throws HiveException {
        this.testAggregateLongAggregate("max", 2, Arrays.asList(13L, 5L, 7L, Integer.MAX_VALUE), Integer.MAX_VALUE);
    }

    @Test
    public void testMaxLongMaxLong() throws HiveException {
        this.testAggregateLongAggregate("max", 2, Arrays.asList(13L, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE, Integer.MAX_VALUE), Long.MAX_VALUE);
    }

    @Test
    public void testMaxLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("max", 42L, 4096, 1024, 42L);
    }

    @Test
    public void testMaxLongNulls() throws HiveException {
        this.testAggregateLongRepeats("max", null, 4096, 1024, null);
    }

    @Test
    public void testMinLongConcatRepeat() throws HiveException {
        this.testAggregateLongIterable("min", new FakeVectorRowBatchFromConcat(new FakeVectorRowBatchFromRepeats(new Long[]{19L}, 10, 2), new FakeVectorRowBatchFromRepeats(new Long[]{7L}, 15, 2), new FakeVectorRowBatchFromRepeats(new Long[]{19L}, 10, 2)), 7L);
    }

    @Test
    public void testMinLongRepeatConcatValues() throws HiveException {
        this.testAggregateLongIterable("min", new FakeVectorRowBatchFromConcat(new FakeVectorRowBatchFromRepeats(new Long[]{19L}, 10, 2), new FakeVectorRowBatchFromLongIterables(3, Arrays.asList(13L, 7L, 23L, 29L))), 7L);
    }

    @Test
    public void testCountLongSimple() throws HiveException {
        this.testAggregateLongAggregate("count", 2, Arrays.asList(13L, 5L, 7L, 19L), 4L);
    }

    @Test
    public void testCountLongEmpty() throws HiveException {
        this.testAggregateLongAggregate("count", 2, Arrays.asList(new Long[0]), 0L);
    }

    @Test
    public void testCountLongNulls() throws HiveException {
        this.testAggregateLongAggregate("count", 2, Arrays.asList(new Long[]{null}), 0L);
        this.testAggregateLongAggregate("count", 2, Arrays.asList(null, null, null), 0L);
        this.testAggregateLongAggregate("count", 2, Arrays.asList(null, 5L, 7L, 19L), 3L);
        this.testAggregateLongAggregate("count", 2, Arrays.asList(13L, null, 7L, 19L), 3L);
    }

    @Test
    public void testCountLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("count", 42L, 4096, 1024, 4096L);
    }

    @Test
    public void testCountLongRepeatNulls() throws HiveException {
        this.testAggregateLongRepeats("count", null, 4096, 1024, 0L);
    }

    @Test
    public void testCountLongRepeatConcatValues() throws HiveException {
        this.testAggregateLongIterable("count", new FakeVectorRowBatchFromConcat(new FakeVectorRowBatchFromRepeats(new Long[]{19L}, 10, 2), new FakeVectorRowBatchFromLongIterables(3, Arrays.asList(13L, 7L, 23L, 29L))), 14L);
    }

    @Test
    public void testSumDoubleSimple() throws HiveException {
        this.testAggregateDouble("sum", 2, Arrays.asList(13.0, 5.0, 7.0, 19.0), 44.0);
    }

    @Test
    public void testSumDoubleGroupByString() throws HiveException {
        this.testAggregateDoubleStringKeyAggregate("sum", 4, Arrays.asList("A", null, "A", null), Arrays.asList(13.0, 5.0, 7.0, 19.0), this.buildHashMap("A", 20.0, null, 24.0));
    }

    @Test
    public void testSumLongSimple() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(13L, 5L, 7L, 19L), 44L);
    }

    @Test
    public void testSumLongEmpty() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(new Long[0]), null);
    }

    @Test
    public void testSumLongNulls() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(new Long[]{null}), null);
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(null, null, null), null);
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(null, 5L, 7L, 19L), 31L);
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(13L, null, 7L, 19L), 39L);
    }

    @Test
    public void testSumLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("sum", 42L, 4096, 1024, 172032L);
    }

    @Test
    public void testSumLongRepeatNulls() throws HiveException {
        this.testAggregateLongRepeats("sum", null, 4096, 1024, null);
    }

    @Test
    public void testSumLongRepeatConcatValues() throws HiveException {
        this.testAggregateLongIterable("sum", new FakeVectorRowBatchFromConcat(new FakeVectorRowBatchFromRepeats(new Long[]{19L}, 10, 2), new FakeVectorRowBatchFromLongIterables(3, Arrays.asList(13L, 7L, 23L, 29L))), 262L);
    }

    @Test
    public void testSumLongZero() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(-2147483647L, Integer.MAX_VALUE), 0L);
    }

    @Test
    public void testSumLong2MaxInt() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(Integer.MAX_VALUE, Integer.MAX_VALUE), 0xFFFFFFFEL);
    }

    @Test
    public void testSumLong2MinInt() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(Integer.MIN_VALUE, Integer.MIN_VALUE), -4294967296L);
    }

    @Test
    public void testSumLong2MaxLong() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(Long.MAX_VALUE, Long.MAX_VALUE), -2L);
    }

    @Test
    public void testSumLong2MinLong() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(Long.MIN_VALUE, Long.MIN_VALUE), 0L);
    }

    @Test
    public void testSumLongMinMaxLong() throws HiveException {
        this.testAggregateLongAggregate("sum", 2, Arrays.asList(Long.MAX_VALUE, Long.MIN_VALUE), -1L);
    }

    @Test
    public void testAvgLongSimple() throws HiveException {
        this.testAggregateLongAggregate("avg", 2, Arrays.asList(13L, 5L, 7L, 19L), 11.0);
    }

    @Test
    public void testAvgLongEmpty() throws HiveException {
        this.testAggregateLongAggregate("avg", 2, Arrays.asList(new Long[0]), 0.0);
    }

    @Test
    public void testAvgLongNulls() throws HiveException {
        this.testAggregateLongAggregate("avg", 2, Arrays.asList(new Long[]{null}), 0.0);
        this.testAggregateLongAggregate("avg", 2, Arrays.asList(null, null, null), 0.0);
        this.testAggregateLongAggregate("avg", 2, Arrays.asList(null, 5L, 7L, 19L), 10.333333333333334);
        this.testAggregateLongAggregate("avg", 2, Arrays.asList(13L, null, 7L, 19L), 13.0);
    }

    @Test
    public void testAvgLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("avg", 42L, 4096, 1024, 42.0);
    }

    @Test
    public void testAvgLongRepeatNulls() throws HiveException {
        this.testAggregateLongRepeats("avg", null, 4096, 1024, 0.0);
    }

    @Test
    public void testAvgLongRepeatConcatValues() throws HiveException {
        this.testAggregateLongIterable("avg", new FakeVectorRowBatchFromConcat(new FakeVectorRowBatchFromRepeats(new Long[]{19L}, 10, 2), new FakeVectorRowBatchFromLongIterables(3, Arrays.asList(13L, 7L, 23L, 29L))), 18.714285714285715);
    }

    @Test
    public void testVarianceLongSimple() throws HiveException {
        this.testAggregateLongAggregate("variance", 2, Arrays.asList(13L, 5L, 7L, 19L), 30.0);
    }

    @Test
    public void testVarianceLongEmpty() throws HiveException {
        this.testAggregateLongAggregate("variance", 2, Arrays.asList(new Long[0]), 0.0);
    }

    @Test
    public void testVarianceLongSingle() throws HiveException {
        this.testAggregateLongAggregate("variance", 2, Arrays.asList(97L), 0.0);
    }

    @Test
    public void testVarianceLongNulls() throws HiveException {
        this.testAggregateLongAggregate("variance", 2, Arrays.asList(new Long[]{null}), 0.0);
        this.testAggregateLongAggregate("variance", 2, Arrays.asList(null, null, null), 0.0);
        this.testAggregateLongAggregate("variance", 2, Arrays.asList(null, 13L, 5L, 7L, 19L), 30.0);
        this.testAggregateLongAggregate("variance", 2, Arrays.asList(13L, null, 5L, 7L, 19L), 30.0);
        this.testAggregateLongAggregate("variance", 2, Arrays.asList(null, null, null, 19L), 0.0);
    }

    @Test
    public void testVarPopLongRepeatNulls() throws HiveException {
        this.testAggregateLongRepeats("var_pop", null, 4096, 1024, 0.0);
    }

    @Test
    public void testVarPopLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("var_pop", 42L, 4096, 1024, 0.0);
    }

    @Test
    public void testVarSampLongSimple() throws HiveException {
        this.testAggregateLongAggregate("var_samp", 2, Arrays.asList(13L, 5L, 7L, 19L), 40.0);
    }

    @Test
    public void testVarSampLongEmpty() throws HiveException {
        this.testAggregateLongAggregate("var_samp", 2, Arrays.asList(new Long[0]), 0.0);
    }

    @Test
    public void testVarSampLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("var_samp", 42L, 4096, 1024, 0.0);
    }

    @Test
    public void testStdLongSimple() throws HiveException {
        this.testAggregateLongAggregate("std", 2, Arrays.asList(13L, 5L, 7L, 19L), Math.sqrt(30.0));
    }

    @Test
    public void testStdLongEmpty() throws HiveException {
        this.testAggregateLongAggregate("std", 2, Arrays.asList(new Long[0]), 0.0);
    }

    @Test
    public void testStdDevLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("stddev", 42L, 4096, 1024, 0.0);
    }

    @Test
    public void testStdDevLongRepeatNulls() throws HiveException {
        this.testAggregateLongRepeats("stddev", null, 4096, 1024, 0.0);
    }

    @Test
    public void testStdDevSampSimple() throws HiveException {
        this.testAggregateLongAggregate("stddev_samp", 2, Arrays.asList(13L, 5L, 7L, 19L), Math.sqrt(40.0));
    }

    @Test
    public void testStdDevSampLongRepeat() throws HiveException {
        this.testAggregateLongRepeats("stddev_samp", 42L, 3, 1024, 0.0);
    }

    @Test
    public void testInstantiateExpression() throws Exception {
        VectorGroupByOperator op = new VectorGroupByOperator();
        VectorAggregationDesc desc = (VectorAggregationDesc)Mockito.mock(VectorAggregationDesc.class);
        Mockito.when((Object)desc.getVecAggrClass()).thenReturn(VectorUDAFBloomFilterMerge.class);
        Mockito.when((Object)desc.getEvaluator()).thenReturn((Object)new GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator());
        VectorAggregateExpression expr = op.instantiateExpression(desc, new Configuration());
        Assert.assertTrue((expr.getClass() == VectorUDAFBloomFilterMerge.class ? 1 : 0) != 0);
        desc = (VectorAggregationDesc)Mockito.mock(VectorAggregationDesc.class);
        Mockito.when((Object)desc.getVecAggrClass()).thenReturn(VectorUDAFCount.class);
        expr = op.instantiateExpression(desc, new Configuration());
        Assert.assertTrue((expr.getClass() == VectorUDAFCount.class ? 1 : 0) != 0);
    }

    private void testMultiKey(String aggregateName, FakeVectorRowBatchFromObjectIterables data, HashMap<Object, Object> expected) throws HiveException {
        int i;
        HashMap<String, Integer> mapColumnNames = new HashMap<String, Integer>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> keysDesc = new ArrayList<ExprNodeDesc>();
        HashSet keys = new HashSet();
        final String[] columnTypes = data.getTypes();
        for (i = 0; i < columnTypes.length - 1; ++i) {
            String columnName = String.format("_col%d", i);
            mapColumnNames.put(columnName, i);
            outputColumnNames.add(columnName);
        }
        mapColumnNames.put("value", i);
        outputColumnNames.add("value");
        VectorizationContext ctx = new VectorizationContext("name", outputColumnNames);
        ArrayList<AggregationDesc> aggs = new ArrayList<AggregationDesc>(1);
        aggs.add(TestVectorGroupByOperator.buildAggregationDesc(ctx, aggregateName, GenericUDAFEvaluator.Mode.PARTIAL1, "value", (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)columnTypes[i])));
        for (i = 0; i < columnTypes.length - 1; ++i) {
            String columnName = String.format("_col%d", i);
            keysDesc.add(TestVectorGroupByOperator.buildColumnDesc(ctx, columnName, (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)columnTypes[i])));
        }
        GroupByDesc desc = new GroupByDesc();
        VectorGroupByDesc vectorGroupByDesc = new VectorGroupByDesc();
        desc.setOutputColumnNames(outputColumnNames);
        desc.setAggregators(aggs);
        desc.setKeys(keysDesc);
        vectorGroupByDesc.setProcessingMode(VectorGroupByDesc.ProcessingMode.HASH);
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorGroupByDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        out.setOutputInspector((new FakeCaptureOutputOperator.OutputInspector(){
            private int rowIndex;
            private String aggregateName;
            private Map<Object, Object> expected;
            private Set<Object> keys;

            @Override
            public void inspectRow(Object row, int tag) throws HiveException {
                Assert.assertTrue((boolean)(row instanceof Object[]));
                Object[] fields = (Object[])row;
                Assert.assertEquals((long)columnTypes.length, (long)fields.length);
                ArrayList<Object> keyValue = new ArrayList<Object>(columnTypes.length - 1);
                for (int i = 0; i < columnTypes.length - 1; ++i) {
                    ByteWritable bwKey;
                    Object key = fields[i];
                    if (null == key) {
                        keyValue.add(null);
                        continue;
                    }
                    if (key instanceof Text) {
                        Text txKey = (Text)key;
                        keyValue.add(txKey.toString());
                        continue;
                    }
                    if (key instanceof ByteWritable) {
                        bwKey = (ByteWritable)key;
                        keyValue.add(bwKey.get());
                        continue;
                    }
                    if (key instanceof ShortWritable) {
                        ShortWritable swKey = (ShortWritable)key;
                        keyValue.add(swKey.get());
                        continue;
                    }
                    if (key instanceof IntWritable) {
                        IntWritable iwKey = (IntWritable)key;
                        keyValue.add(iwKey.get());
                        continue;
                    }
                    if (key instanceof LongWritable) {
                        LongWritable lwKey = (LongWritable)key;
                        keyValue.add(lwKey.get());
                        continue;
                    }
                    if (key instanceof TimestampWritableV2) {
                        TimestampWritableV2 twKey = (TimestampWritableV2)key;
                        keyValue.add(twKey.getTimestamp());
                        continue;
                    }
                    if (key instanceof DoubleWritable) {
                        DoubleWritable dwKey = (DoubleWritable)key;
                        keyValue.add(dwKey.get());
                        continue;
                    }
                    if (key instanceof FloatWritable) {
                        FloatWritable fwKey = (FloatWritable)key;
                        keyValue.add(Float.valueOf(fwKey.get()));
                        continue;
                    }
                    if (key instanceof BooleanWritable) {
                        bwKey = (BooleanWritable)key;
                        keyValue.add(bwKey.get());
                        continue;
                    }
                    Assert.fail((String)String.format("Not implemented key output type %s: %s", key.getClass().getName(), key));
                }
                String keyAsString = Arrays.deepToString(keyValue.toArray());
                Assert.assertTrue((boolean)this.expected.containsKey(keyValue));
                Object expectedValue = this.expected.get(keyValue);
                Object value = fields[columnTypes.length - 1];
                Validator validator = TestVectorGroupByOperator.getValidator(this.aggregateName);
                validator.validate(keyAsString, expectedValue, new Object[]{value});
                this.keys.add(keyValue);
            }

            private FakeCaptureOutputOperator.OutputInspector init(String aggregateName, Map<Object, Object> expected, Set<Object> keys) {
                this.aggregateName = aggregateName;
                this.expected = expected;
                this.keys = keys;
                return this;
            }
        }).init(aggregateName, expected, keys));
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)expected.size(), (long)outBatchList.size());
        Assert.assertEquals((long)expected.size(), (long)keys.size());
    }

    private void testKeyTypeAggregate(String aggregateName, FakeVectorRowBatchFromObjectIterables data, Map<Object, Object> expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("Key");
        mapColumnNames.add("Value");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        HashSet keys = new HashSet();
        AggregationDesc agg = TestVectorGroupByOperator.buildAggregationDesc(ctx, aggregateName, GenericUDAFEvaluator.Mode.PARTIAL1, "Value", (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)data.getTypes()[1]));
        ArrayList<AggregationDesc> aggs = new ArrayList<AggregationDesc>();
        aggs.add(agg);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        outputColumnNames.add("_col0");
        outputColumnNames.add("_col1");
        GroupByDesc desc = new GroupByDesc();
        VectorGroupByDesc vectorGroupByDesc = new VectorGroupByDesc();
        desc.setOutputColumnNames(outputColumnNames);
        desc.setAggregators(aggs);
        vectorGroupByDesc.setProcessingMode(VectorGroupByDesc.ProcessingMode.HASH);
        ExprNodeDesc keyExp = TestVectorGroupByOperator.buildColumnDesc(ctx, "Key", (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)data.getTypes()[0]));
        ArrayList<ExprNodeDesc> keysDesc = new ArrayList<ExprNodeDesc>();
        keysDesc.add(keyExp);
        desc.setKeys(keysDesc);
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorGroupByDesc);
        if (vgo == null) {
            Assert.assertTrue((boolean)false);
        }
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        out.setOutputInspector((new FakeCaptureOutputOperator.OutputInspector(){
            private int rowIndex;
            private String aggregateName;
            private Map<Object, Object> expected;
            private Set<Object> keys;

            @Override
            public void inspectRow(Object row, int tag) throws HiveException {
                ByteWritable bwKey;
                Assert.assertTrue((boolean)(row instanceof Object[]));
                Object[] fields = (Object[])row;
                Assert.assertEquals((long)2L, (long)fields.length);
                Object key = fields[0];
                Comparable<Byte> keyValue = null;
                if (null == key) {
                    keyValue = null;
                } else if (key instanceof ByteWritable) {
                    bwKey = (ByteWritable)key;
                    keyValue = bwKey.get();
                } else if (key instanceof ShortWritable) {
                    ShortWritable swKey = (ShortWritable)key;
                    keyValue = swKey.get();
                } else if (key instanceof IntWritable) {
                    IntWritable iwKey = (IntWritable)key;
                    keyValue = iwKey.get();
                } else if (key instanceof LongWritable) {
                    LongWritable lwKey = (LongWritable)key;
                    keyValue = lwKey.get();
                } else if (key instanceof TimestampWritableV2) {
                    TimestampWritableV2 twKey = (TimestampWritableV2)key;
                    keyValue = twKey.getTimestamp().toSqlTimestamp();
                } else if (key instanceof DoubleWritable) {
                    DoubleWritable dwKey = (DoubleWritable)key;
                    keyValue = dwKey.get();
                } else if (key instanceof FloatWritable) {
                    FloatWritable fwKey = (FloatWritable)key;
                    keyValue = Float.valueOf(fwKey.get());
                } else if (key instanceof BooleanWritable) {
                    bwKey = (BooleanWritable)key;
                    keyValue = bwKey.get();
                } else if (key instanceof HiveDecimalWritable) {
                    HiveDecimalWritable hdwKey = (HiveDecimalWritable)key;
                    keyValue = hdwKey.getHiveDecimal();
                } else {
                    Assert.fail((String)String.format("Not implemented key output type %s: %s", key.getClass().getName(), key));
                }
                String keyValueAsString = String.format("%s", keyValue);
                Assert.assertTrue((boolean)this.expected.containsKey(keyValue));
                Object expectedValue = this.expected.get(keyValue);
                Object value = fields[1];
                Validator validator = TestVectorGroupByOperator.getValidator(this.aggregateName);
                validator.validate(keyValueAsString, expectedValue, new Object[]{value});
                this.keys.add(keyValue);
            }

            private FakeCaptureOutputOperator.OutputInspector init(String aggregateName, Map<Object, Object> expected, Set<Object> keys) {
                this.aggregateName = aggregateName;
                this.expected = expected;
                this.keys = keys;
                return this;
            }
        }).init(aggregateName, expected, keys));
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)expected.size(), (long)outBatchList.size());
        Assert.assertEquals((long)expected.size(), (long)keys.size());
    }

    public void testAggregateLongRepeats(String aggregateName, Long value, int repeat, int batchSize, Object expected) throws HiveException {
        FakeVectorRowBatchFromRepeats fdr = new FakeVectorRowBatchFromRepeats(new Long[]{value}, repeat, batchSize);
        this.testAggregateLongIterable(aggregateName, fdr, expected);
    }

    public HashMap<Object, Object> buildHashMap(Object ... pairs) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < pairs.length; i += 2) {
            map.put(pairs[i], pairs[i + 1]);
        }
        return map;
    }

    public void testAggregateStringKeyAggregate(String aggregateName, int batchSize, Iterable<Object> list, Iterable<Object> values, HashMap<Object, Object> expected) throws HiveException {
        FakeVectorRowBatchFromObjectIterables fdr = new FakeVectorRowBatchFromObjectIterables(batchSize, new String[]{"string", "long"}, list, values);
        this.testAggregateStringKeyIterable(aggregateName, fdr, (TypeInfo)TypeInfoFactory.longTypeInfo, expected);
    }

    public void testAggregateDoubleStringKeyAggregate(String aggregateName, int batchSize, Iterable<Object> list, Iterable<Object> values, HashMap<Object, Object> expected) throws HiveException {
        FakeVectorRowBatchFromObjectIterables fdr = new FakeVectorRowBatchFromObjectIterables(batchSize, new String[]{"string", "double"}, list, values);
        this.testAggregateStringKeyIterable(aggregateName, fdr, (TypeInfo)TypeInfoFactory.doubleTypeInfo, expected);
    }

    public void testAggregateLongKeyAggregate(String aggregateName, int batchSize, List<Long> list, Iterable<Long> values, HashMap<Object, Object> expected) throws HiveException {
        FakeVectorRowBatchFromLongIterables fdr = new FakeVectorRowBatchFromLongIterables(batchSize, list, values);
        this.testAggregateLongKeyIterable(aggregateName, fdr, expected);
    }

    public void testAggregateDecimal(String typeName, String aggregateName, int batchSize, Iterable<Object> values, Object expected) throws HiveException {
        FakeVectorRowBatchFromObjectIterables fdr = new FakeVectorRowBatchFromObjectIterables(batchSize, new String[]{typeName}, values);
        this.testAggregateDecimalIterable(aggregateName, fdr, expected);
    }

    public void testAggregateString(String aggregateName, int batchSize, Iterable<Object> values, Object expected) throws HiveException {
        FakeVectorRowBatchFromObjectIterables fdr = new FakeVectorRowBatchFromObjectIterables(batchSize, new String[]{"string"}, values);
        this.testAggregateStringIterable(aggregateName, fdr, expected);
    }

    public void testAggregateDouble(String aggregateName, int batchSize, Iterable<Object> values, Object expected) throws HiveException {
        FakeVectorRowBatchFromObjectIterables fdr = new FakeVectorRowBatchFromObjectIterables(batchSize, new String[]{"double"}, values);
        this.testAggregateDoubleIterable(aggregateName, fdr, expected);
    }

    public void testAggregateLongAggregate(String aggregateName, int batchSize, Iterable<Long> values, Object expected) throws HiveException {
        FakeVectorRowBatchFromLongIterables fdr = new FakeVectorRowBatchFromLongIterables(batchSize, values);
        this.testAggregateLongIterable(aggregateName, fdr, expected);
    }

    public void testAggregateCountStar(int batchSize, Iterable<Long> values, Object expected) throws HiveException {
        FakeVectorRowBatchFromLongIterables fdr = new FakeVectorRowBatchFromLongIterables(batchSize, values);
        this.testAggregateCountStarIterable(fdr, expected);
    }

    public void testAggregateCountReduce(int batchSize, Iterable<Long> values, Object expected) throws HiveException {
        FakeVectorRowBatchFromLongIterables fdr = new FakeVectorRowBatchFromLongIterables(batchSize, values);
        this.testAggregateCountReduceIterable(fdr, expected);
    }

    public static Validator getValidator(String aggregate) throws HiveException {
        try {
            for (Object[] v : validators) {
                if (!aggregate.equalsIgnoreCase((String)v[0])) continue;
                Class c = (Class)v[1];
                Constructor ctr = c.getConstructor(new Class[0]);
                return (Validator)ctr.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        throw new HiveException("Missing validator for aggregate: " + aggregate);
    }

    public void testAggregateCountStarIterable(Iterable<VectorizedRowBatch> data, Object expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("A");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildGroupByDescCountStar(ctx);
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        vectorDesc.setProcessingMode(VectorGroupByDesc.ProcessingMode.HASH);
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)1L, (long)outBatchList.size());
        Object result = outBatchList.get(0);
        Validator validator = TestVectorGroupByOperator.getValidator("count");
        validator.validate("_total", expected, result);
    }

    public void testAggregateCountReduceIterable(Iterable<VectorizedRowBatch> data, Object expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("A");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildGroupByDescType(ctx, "count", GenericUDAFEvaluator.Mode.FINAL, "A", (TypeInfo)TypeInfoFactory.longTypeInfo);
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        vectorDesc.setProcessingMode(VectorGroupByDesc.ProcessingMode.GLOBAL);
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)1L, (long)outBatchList.size());
        Object result = outBatchList.get(0);
        Validator validator = TestVectorGroupByOperator.getValidator("count");
        validator.validate("_total", expected, result);
    }

    public void testAggregateStringIterable(String aggregateName, Iterable<VectorizedRowBatch> data, Object expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("A");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildGroupByDescType(ctx, aggregateName, GenericUDAFEvaluator.Mode.PARTIAL1, "A", (TypeInfo)TypeInfoFactory.stringTypeInfo);
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)1L, (long)outBatchList.size());
        Object result = outBatchList.get(0);
        Validator validator = TestVectorGroupByOperator.getValidator(aggregateName);
        validator.validate("_total", expected, result);
    }

    public void testAggregateDecimalIterable(String aggregateName, Iterable<VectorizedRowBatch> data, Object expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("A");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildGroupByDescType(ctx, aggregateName, GenericUDAFEvaluator.Mode.PARTIAL1, "A", (TypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)30, (int)4));
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)1L, (long)outBatchList.size());
        Object result = outBatchList.get(0);
        Validator validator = TestVectorGroupByOperator.getValidator(aggregateName);
        validator.validate("_total", expected, result);
    }

    public void testAggregateDoubleIterable(String aggregateName, Iterable<VectorizedRowBatch> data, Object expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("A");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildGroupByDescType(ctx, aggregateName, GenericUDAFEvaluator.Mode.PARTIAL1, "A", (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)1L, (long)outBatchList.size());
        Object result = outBatchList.get(0);
        Validator validator = TestVectorGroupByOperator.getValidator(aggregateName);
        validator.validate("_total", expected, result);
    }

    public void testAggregateLongIterable(String aggregateName, Iterable<VectorizedRowBatch> data, Object expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("A");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildGroupByDescType(ctx, aggregateName, GenericUDAFEvaluator.Mode.PARTIAL1, "A", (TypeInfo)TypeInfoFactory.longTypeInfo);
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)1L, (long)outBatchList.size());
        Object result = outBatchList.get(0);
        Validator validator = TestVectorGroupByOperator.getValidator(aggregateName);
        validator.validate("_total", expected, result);
    }

    public void testAggregateLongKeyIterable(String aggregateName, Iterable<VectorizedRowBatch> data, HashMap<Object, Object> expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("Key");
        mapColumnNames.add("Value");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        HashSet keys = new HashSet();
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildKeyGroupByDesc(ctx, aggregateName, "Value", (TypeInfo)TypeInfoFactory.longTypeInfo, new String[]{"Key"}, new TypeInfo[]{TypeInfoFactory.longTypeInfo});
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        out.setOutputInspector((new FakeCaptureOutputOperator.OutputInspector(){
            private String aggregateName;
            private HashMap<Object, Object> expected;
            private Set<Object> keys;

            @Override
            public void inspectRow(Object row, int tag) throws HiveException {
                Assert.assertTrue((boolean)(row instanceof Object[]));
                Object[] fields = (Object[])row;
                Assert.assertEquals((long)2L, (long)fields.length);
                Object key = fields[0];
                Long keyValue = null;
                if (null != key) {
                    Assert.assertTrue((boolean)(key instanceof LongWritable));
                    LongWritable lwKey = (LongWritable)key;
                    keyValue = lwKey.get();
                }
                Assert.assertTrue((boolean)this.expected.containsKey(keyValue));
                String keyAsString = String.format("%s", key);
                Object expectedValue = this.expected.get(keyValue);
                Object value = fields[1];
                Validator validator = TestVectorGroupByOperator.getValidator(this.aggregateName);
                validator.validate(keyAsString, expectedValue, new Object[]{value});
                this.keys.add(keyValue);
            }

            private FakeCaptureOutputOperator.OutputInspector init(String aggregateName, HashMap<Object, Object> expected, Set<Object> keys) {
                this.aggregateName = aggregateName;
                this.expected = expected;
                this.keys = keys;
                return this;
            }
        }).init(aggregateName, expected, keys));
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)expected.size(), (long)outBatchList.size());
        Assert.assertEquals((long)expected.size(), (long)keys.size());
    }

    public void testAggregateStringKeyIterable(String aggregateName, Iterable<VectorizedRowBatch> data, TypeInfo dataTypeInfo, HashMap<Object, Object> expected) throws HiveException {
        ArrayList<String> mapColumnNames = new ArrayList<String>();
        mapColumnNames.add("Key");
        mapColumnNames.add("Value");
        VectorizationContext ctx = new VectorizationContext("name", mapColumnNames);
        HashSet keys = new HashSet();
        Pair<GroupByDesc, VectorGroupByDesc> pair = TestVectorGroupByOperator.buildKeyGroupByDesc(ctx, aggregateName, "Value", dataTypeInfo, new String[]{"Key"}, new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        GroupByDesc desc = (GroupByDesc)pair.left;
        VectorGroupByDesc vectorDesc = (VectorGroupByDesc)pair.right;
        CompilationOpContext cCtx = new CompilationOpContext();
        Operator groupByOp = OperatorFactory.get((CompilationOpContext)cCtx, (OperatorDesc)desc);
        VectorGroupByOperator vgo = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)groupByOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        FakeCaptureVectorToRowOutputOperator out = FakeCaptureVectorToRowOutputOperator.addCaptureOutputChild(cCtx, (Operator<? extends OperatorDesc>)vgo);
        vgo.initialize((Configuration)this.hconf, null);
        out.setOutputInspector((new FakeCaptureOutputOperator.OutputInspector(){
            private int rowIndex;
            private String aggregateName;
            private HashMap<Object, Object> expected;
            private Set<Object> keys;

            @Override
            public void inspectRow(Object row, int tag) throws HiveException {
                Assert.assertTrue((boolean)(row instanceof Object[]));
                Object[] fields = (Object[])row;
                Assert.assertEquals((long)2L, (long)fields.length);
                Object key = fields[0];
                String keyValue = null;
                if (null != key) {
                    Assert.assertTrue((boolean)(key instanceof Text));
                    Text bwKey = (Text)key;
                    keyValue = bwKey.toString();
                }
                Assert.assertTrue((boolean)this.expected.containsKey(keyValue));
                Object expectedValue = this.expected.get(keyValue);
                Object value = fields[1];
                Validator validator = TestVectorGroupByOperator.getValidator(this.aggregateName);
                String keyAsString = String.format("%s", key);
                validator.validate(keyAsString, expectedValue, new Object[]{value});
                this.keys.add(keyValue);
            }

            private FakeCaptureOutputOperator.OutputInspector init(String aggregateName, HashMap<Object, Object> expected, Set<Object> keys) {
                this.aggregateName = aggregateName;
                this.expected = expected;
                this.keys = keys;
                return this;
            }
        }).init(aggregateName, expected, keys));
        for (VectorizedRowBatch unit : data) {
            vgo.process((Object)unit, 0);
        }
        vgo.close(false);
        List<Object> outBatchList = out.getCapturedRows();
        Assert.assertNotNull(outBatchList);
        Assert.assertEquals((long)expected.size(), (long)outBatchList.size());
        Assert.assertEquals((long)expected.size(), (long)keys.size());
    }

    public static class StdSampValidator
    extends BaseVarianceValidator {
        @Override
        void validateVariance(String key, double expected, long cnt, double sum, double variance) {
            Assert.assertEquals((String)key, (double)expected, (double)Math.sqrt(variance / (double)(cnt - 1L)), (double)0.0);
        }
    }

    public static class StdValidator
    extends BaseVarianceValidator {
        @Override
        void validateVariance(String key, double expected, long cnt, double sum, double variance) {
            Assert.assertEquals((String)key, (double)expected, (double)Math.sqrt(variance / (double)cnt), (double)0.0);
        }
    }

    public static class VarianceSampValidator
    extends BaseVarianceValidator {
        @Override
        void validateVariance(String key, double expected, long cnt, double sum, double variance) {
            Assert.assertEquals((String)key, (double)expected, (double)(variance / (double)(cnt - 1L)), (double)0.0);
        }
    }

    public static class VarianceValidator
    extends BaseVarianceValidator {
        @Override
        void validateVariance(String key, double expected, long cnt, double sum, double variance) {
            Assert.assertEquals((String)key, (double)expected, (double)(variance / (double)cnt), (double)0.0);
        }
    }

    public static abstract class BaseVarianceValidator
    implements Validator {
        abstract void validateVariance(String var1, double var2, long var4, double var6, double var8);

        @Override
        public void validate(String key, Object expected, Object result) {
            Object[] arr = (Object[])result;
            Assert.assertEquals((long)1L, (long)arr.length);
            if (expected == null) {
                Assert.assertEquals(null, (Object)arr[0]);
            } else {
                Assert.assertEquals((Object)true, (Object)(arr[0] instanceof Object[]));
                Object[] vals = (Object[])arr[0];
                Assert.assertEquals((long)3L, (long)vals.length);
                Assert.assertEquals((Object)true, (Object)(vals[0] instanceof LongWritable));
                Assert.assertEquals((Object)true, (Object)(vals[1] instanceof DoubleWritable));
                Assert.assertEquals((Object)true, (Object)(vals[2] instanceof DoubleWritable));
                LongWritable cnt = (LongWritable)vals[0];
                if (cnt.get() == 0L) {
                    Assert.assertEquals((String)key, (Object)expected, (Object)0.0);
                } else {
                    DoubleWritable sum = (DoubleWritable)vals[1];
                    DoubleWritable var = (DoubleWritable)vals[2];
                    Assert.assertTrue((1L <= cnt.get() ? 1 : 0) != 0);
                    this.validateVariance(key, (Double)expected, cnt.get(), sum.get(), var.get());
                }
            }
        }
    }

    public static class AvgValidator
    implements Validator {
        @Override
        public void validate(String key, Object expected, Object result) {
            Object[] arr = (Object[])result;
            Assert.assertEquals((long)1L, (long)arr.length);
            if (expected == null) {
                Assert.assertEquals((String)key, null, (Object)arr[0]);
            } else {
                Assert.assertEquals((Object)true, (Object)(arr[0] instanceof Object[]));
                Object[] vals = (Object[])arr[0];
                Assert.assertEquals((long)3L, (long)vals.length);
                Assert.assertEquals((Object)true, (Object)(vals[0] instanceof LongWritable));
                LongWritable lw = (LongWritable)vals[0];
                if (vals[1] instanceof DoubleWritable) {
                    DoubleWritable dw = (DoubleWritable)vals[1];
                    if (lw.get() != 0L) {
                        Assert.assertEquals((String)key, (Object)expected, (Object)(dw.get() / (double)lw.get()));
                    } else {
                        Assert.assertEquals((String)key, (Object)expected, (Object)0.0);
                    }
                } else if (vals[1] instanceof HiveDecimalWritable) {
                    HiveDecimalWritable hdw = (HiveDecimalWritable)vals[1];
                    if (lw.get() != 0L) {
                        Assert.assertEquals((String)key, (Object)expected, (Object)hdw.getHiveDecimal().divide(HiveDecimal.create((long)lw.get())));
                    } else {
                        Assert.assertEquals((String)key, (Object)expected, (Object)HiveDecimal.ZERO);
                    }
                }
            }
        }
    }

    public static class ValueValidator
    implements Validator {
        @Override
        public void validate(String key, Object expected, Object result) {
            Assert.assertEquals((Object)true, (Object)(result instanceof Object[]));
            Object[] arr = (Object[])result;
            Assert.assertEquals((long)1L, (long)arr.length);
            if (expected == null) {
                Assert.assertEquals((String)key, null, (Object)arr[0]);
            } else if (arr[0] instanceof LongWritable) {
                LongWritable lw = (LongWritable)arr[0];
                Assert.assertEquals((String)key, (Object)expected, (Object)lw.get());
            } else if (arr[0] instanceof Text) {
                Text tx = (Text)arr[0];
                String sbw = tx.toString();
                Assert.assertEquals((String)key, (Object)expected, (Object)sbw);
            } else if (arr[0] instanceof DoubleWritable) {
                DoubleWritable dw = (DoubleWritable)arr[0];
                Assert.assertEquals((String)key, (Object)expected, (Object)dw.get());
            } else if (arr[0] instanceof Double) {
                Assert.assertEquals((String)key, (Object)expected, (Object)arr[0]);
            } else if (arr[0] instanceof Long) {
                Assert.assertEquals((String)key, (Object)expected, (Object)arr[0]);
            } else if (arr[0] instanceof HiveDecimalWritable) {
                HiveDecimalWritable hdw = (HiveDecimalWritable)arr[0];
                HiveDecimal hd = hdw.getHiveDecimal();
                HiveDecimal expectedDec = (HiveDecimal)expected;
                Assert.assertEquals((String)key, (Object)expectedDec, (Object)hd);
            } else if (arr[0] instanceof HiveDecimal) {
                HiveDecimal hd = (HiveDecimal)arr[0];
                HiveDecimal expectedDec = (HiveDecimal)expected;
                Assert.assertEquals((String)key, (Object)expectedDec, (Object)hd);
            } else {
                Assert.fail((String)("Unsupported result type: " + arr[0].getClass().getName()));
            }
        }
    }

    public static interface Validator {
        public void validate(String var1, Object var2, Object var3);
    }
}

