/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorFilterOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprAndExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterLongColumn;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorFilterDesc;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorFilterOperator {
    HiveConf hconf = new HiveConf();

    private VectorFilterOperator getAVectorFilterOperator() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Long.class, "col1", "table", false);
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("col1");
        FilterDesc fdesc = new FilterDesc();
        fdesc.setPredicate((ExprNodeDesc)col1Expr);
        VectorFilterDesc vectorDesc = new VectorFilterDesc();
        Operator filterOp = OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), (OperatorDesc)fdesc);
        VectorizationContext vc = new VectorizationContext("name", columns);
        return (VectorFilterOperator)Vectorizer.vectorizeFilterOperator((Operator)filterOp, (VectorizationContext)vc, (VectorFilterDesc)vectorDesc);
    }

    @Test
    public void testBasicFilterOperator() throws HiveException {
        VectorFilterOperator vfo = this.getAVectorFilterOperator();
        vfo.initialize((Configuration)this.hconf, null);
        FilterLongColGreaterLongColumn ve1 = new FilterLongColGreaterLongColumn(0, 1);
        FilterLongColEqualDoubleScalar ve2 = new FilterLongColEqualDoubleScalar(2, 0.0);
        FilterExprAndExpr ve3 = new FilterExprAndExpr();
        ve3.setChildExpressions(new VectorExpression[]{ve1, ve2});
        vfo.setFilterCondition((VectorExpression)ve3);
        FakeDataReader fdr = new FakeDataReader(1024, 3);
        VectorizedRowBatch vrg = fdr.getNext();
        vfo.getPredicateExpression().evaluate(vrg);
        int rows = 0;
        for (int i = 0; i < 1024; ++i) {
            LongColumnVector l1 = (LongColumnVector)vrg.cols[0];
            LongColumnVector l2 = (LongColumnVector)vrg.cols[1];
            LongColumnVector l3 = (LongColumnVector)vrg.cols[2];
            if (l1.vector[i] <= l2.vector[i] || l3.vector[i] != 0L) continue;
            ++rows;
        }
        Assert.assertEquals((long)rows, (long)vrg.size);
    }

    @Test
    public void testBasicFilterLargeData() throws HiveException {
        VectorFilterOperator vfo = this.getAVectorFilterOperator();
        vfo.initialize((Configuration)this.hconf, null);
        FilterLongColGreaterLongColumn ve1 = new FilterLongColGreaterLongColumn(0, 1);
        FilterLongColEqualDoubleScalar ve2 = new FilterLongColEqualDoubleScalar(2, 0.0);
        FilterExprAndExpr ve3 = new FilterExprAndExpr();
        ve3.setChildExpressions(new VectorExpression[]{ve1, ve2});
        vfo.setFilterCondition((VectorExpression)ve3);
        FakeDataReader fdr = new FakeDataReader(0x1000000, 3);
        long startTime = System.currentTimeMillis();
        VectorizedRowBatch vrg = fdr.getNext();
        while (vrg.size > 0) {
            vfo.process((Object)vrg, 0);
            vrg = fdr.getNext();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("testBaseFilterOperator Op Time = " + (endTime - startTime));
        fdr = new FakeDataReader(0x1000000, 3);
        long startTime1 = System.currentTimeMillis();
        vrg = fdr.getNext();
        LongColumnVector l1 = (LongColumnVector)vrg.cols[0];
        LongColumnVector l2 = (LongColumnVector)vrg.cols[1];
        LongColumnVector l3 = (LongColumnVector)vrg.cols[2];
        int rows = 0;
        for (int j = 0; j < 16384; ++j) {
            for (int i = 0; i < l1.vector.length && i < l2.vector.length && i < l3.vector.length; ++i) {
                if (l1.vector[i] <= l2.vector[i] || l3.vector[i] != 0L) continue;
                ++rows;
            }
        }
        long endTime1 = System.currentTimeMillis();
        System.out.println("testBaseFilterOperator base Op Time = " + (endTime1 - startTime1));
    }

    public static class FakeDataReader {
        private final int size;
        private final VectorizedRowBatch vrg;
        private int currentSize = 0;
        private final int numCols;
        private final int len = 1024;

        public FakeDataReader(int size, int numCols) {
            this.size = size;
            this.numCols = numCols;
            this.vrg = new VectorizedRowBatch(numCols, 1024);
            for (int i = 0; i < numCols; ++i) {
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.vrg.cols[i] = this.getLongVector(1024);
            }
        }

        public VectorizedRowBatch getNext() {
            if (this.currentSize >= this.size) {
                this.vrg.size = 0;
                return this.vrg;
            }
            this.vrg.size = 1024;
            this.currentSize += this.vrg.size;
            this.vrg.selectedInUse = false;
            return this.vrg;
        }

        private LongColumnVector getLongVector(int len) {
            LongColumnVector lcv = new LongColumnVector(len);
            TestVectorizedRowBatch.setRandomLongCol(lcv);
            return lcv;
        }
    }
}

