/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.util.rowobjects;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;

public class RowTestObjectsMultiSet {
    private SortedMap<RowTestObjects, Value> sortedMap = new TreeMap<RowTestObjects, Value>();
    private int totalKeyCount = 0;
    private int totalValueCount = 0;

    public int getTotalKeyCount() {
        return this.totalKeyCount;
    }

    public int getTotalValueCount() {
        return this.totalValueCount;
    }

    public void add(RowTestObjects testRow, RowFlag rowFlag) {
        if (this.sortedMap.containsKey(testRow)) {
            Value value = (Value)this.sortedMap.get(testRow);
            ++value.count;
            value.rowFlags |= rowFlag.value;
            ++this.totalValueCount;
        } else {
            this.sortedMap.put(testRow, new Value(1, rowFlag, ++this.totalKeyCount, ++this.totalValueCount));
        }
    }

    public void add(RowTestObjects testRow, int count) {
        if (this.sortedMap.containsKey(testRow)) {
            throw new RuntimeException();
        }
        this.sortedMap.put(testRow, new Value(count, RowFlag.NONE, ++this.totalKeyCount, ++this.totalValueCount));
    }

    public String displayRowFlags(long rowFlags) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (RowFlag rowFlag : RowFlag.values()) {
            if ((rowFlags & rowFlag.value) == 0L) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(rowFlag.name());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean verify(RowTestObjectsMultiSet other, String left, String right) {
        int otherSize;
        int thisSize = this.sortedMap.size();
        if (thisSize != (otherSize = other.sortedMap.size())) {
            System.out.println("*BENCHMARK* " + left + " count " + thisSize + " doesn't match " + right + " " + otherSize);
            return false;
        }
        Iterator<Map.Entry<RowTestObjects, Value>> thisIterator = this.sortedMap.entrySet().iterator();
        Iterator<Map.Entry<RowTestObjects, Value>> otherIterator = other.sortedMap.entrySet().iterator();
        for (int i = 0; i < thisSize; ++i) {
            Map.Entry<RowTestObjects, Value> thisEntry = thisIterator.next();
            Map.Entry<RowTestObjects, Value> otherEntry = otherIterator.next();
            if (!thisEntry.getKey().equals(otherEntry.getKey())) {
                System.out.println("*BENCHMARK* " + left + " row " + thisEntry.getKey().toString() + " (rowFlags " + this.displayRowFlags(thisEntry.getValue().rowFlags) + " count " + thisEntry.getValue().count + ") but found " + right + " row " + otherEntry.getKey().toString() + " (initialKeyCount " + otherEntry.getValue().initialKeyCount + " initialValueCount " + otherEntry.getValue().initialValueCount + ")");
                return false;
            }
            if (thisEntry.getValue().count == otherEntry.getValue().count) continue;
            System.out.println("*BENCHMARK* " + left + " row " + thisEntry.getKey().toString() + " count " + thisEntry.getValue().count + " (rowFlags " + this.displayRowFlags(thisEntry.getValue().rowFlags) + ") doesn't match " + right + " row count " + otherEntry.getValue().count + " (initialKeyCount " + otherEntry.getValue().initialKeyCount + " initialValueCount " + otherEntry.getValue().initialValueCount + ")");
            return false;
        }
        return thisSize == otherSize;
    }

    public RowTestObjectsMultiSet subtract(RowTestObjectsMultiSet other) {
        RowTestObjectsMultiSet result = new RowTestObjectsMultiSet();
        for (Map.Entry<RowTestObjects, Value> thisEntry : this.sortedMap.entrySet()) {
            if (other.sortedMap.containsKey(thisEntry.getKey())) {
                Value thisValue = thisEntry.getValue();
                Value otherValue = (Value)other.sortedMap.get(thisEntry.getKey());
                if (thisValue.count == otherValue.count) continue;
            }
            result.add(thisEntry.getKey(), thisEntry.getValue().count);
        }
        return result;
    }

    public void displayDifferences(RowTestObjectsMultiSet other, String left, String right) {
        RowTestObjectsMultiSet leftOnly = this.subtract(other);
        for (Map.Entry<RowTestObjects, Value> leftOnlyEntry : leftOnly.sortedMap.entrySet()) {
            System.out.println("*BENCHMARK* " + left + " only row " + leftOnlyEntry.getKey().toString() + " count " + leftOnlyEntry.getValue().count + " (initialRowFlag " + leftOnlyEntry.getValue().initialRowFlag.name() + ")");
        }
        RowTestObjectsMultiSet rightOnly = other.subtract(this);
        for (Map.Entry<RowTestObjects, Value> rightOnlyEntry : rightOnly.sortedMap.entrySet()) {
            System.out.println("*BENCHMARK* " + right + " only row " + rightOnlyEntry.getKey().toString() + " count " + rightOnlyEntry.getValue().count + " (initialRowFlag " + rightOnlyEntry.getValue().initialRowFlag.name() + ")");
        }
    }

    public String toString() {
        return this.sortedMap.toString();
    }

    private static class Value {
        public int count;
        public long rowFlags;
        public final int initialKeyCount;
        public final int initialValueCount;
        public final RowFlag initialRowFlag;

        public Value(int count, RowFlag rowFlag, int totalKeyCount, int totalValueCount) {
            this.count = count;
            this.rowFlags = rowFlag.value;
            this.initialKeyCount = totalKeyCount;
            this.initialValueCount = totalValueCount;
            this.initialRowFlag = rowFlag;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("count ");
            sb.append(this.count);
            return sb.toString();
        }
    }

    public static enum RowFlag {
        NONE(0L),
        REGULAR(1L),
        LEFT_OUTER(2L),
        FULL_OUTER(4L);

        public final long value;

        private RowFlag(long value) {
            this.value = value;
        }
    }
}

