/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.util.collectoroperator;

import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowCollectorTestOperatorBase;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public abstract class RowVectorCollectorTestOperator
extends RowCollectorTestOperatorBase {
    private final ObjectInspector[] outputObjectInspectors;
    private final VectorExtractRow vectorExtractRow;

    public RowVectorCollectorTestOperator(TypeInfo[] outputTypeInfos, ObjectInspector[] outputObjectInspectors) throws HiveException {
        this.outputObjectInspectors = outputObjectInspectors;
        this.vectorExtractRow = new VectorExtractRow();
        this.vectorExtractRow.init(outputTypeInfos);
    }

    public RowVectorCollectorTestOperator(int[] outputProjectionColumnNums, TypeInfo[] outputTypeInfos, ObjectInspector[] outputObjectInspectors) throws HiveException {
        this.outputObjectInspectors = outputObjectInspectors;
        this.vectorExtractRow = new VectorExtractRow();
        this.vectorExtractRow.init(outputTypeInfos, outputProjectionColumnNums);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        this.rowCount += batch.size;
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logical = 0; logical < batch.size; ++logical) {
            int batchIndex = selectedInUse ? selected[logical] : logical;
            Object[] rowObjects = new Object[this.outputObjectInspectors.length];
            this.vectorExtractRow.extractRow(batch, batchIndex, rowObjects);
            for (int c = 0; c < rowObjects.length; ++c) {
                rowObjects[c] = ((PrimitiveObjectInspector)this.outputObjectInspectors[c]).copyObject(rowObjects[c]);
            }
            this.nextTestRow(new RowTestObjects(rowObjects));
        }
    }

    @Override
    public String getName() {
        return RowVectorCollectorTestOperator.class.getSimpleName();
    }
}

