/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.util.collectoroperator;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowCollectorTestOperatorBase;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public abstract class RowCollectorTestOperator
extends RowCollectorTestOperatorBase {
    private static final long serialVersionUID = 1L;
    private final ObjectInspector[] outputObjectInspectors;
    private final int columnSize;

    public RowCollectorTestOperator(ObjectInspector[] outputObjectInspectors) {
        this.outputObjectInspectors = outputObjectInspectors;
        this.columnSize = outputObjectInspectors.length;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        ++this.rowCount;
        Object[] resultObjectArray = new Object[this.columnSize];
        if (row instanceof ArrayList) {
            ArrayList rowObjectList = (ArrayList)row;
            for (int c = 0; c < this.columnSize; ++c) {
                resultObjectArray[c] = ((PrimitiveObjectInspector)this.outputObjectInspectors[c]).copyObject(rowObjectList.get(c));
            }
        } else {
            Object[] rowObjectArray = (Object[])row;
            for (int c = 0; c < this.columnSize; ++c) {
                resultObjectArray[c] = ((PrimitiveObjectInspector)this.outputObjectInspectors[c]).copyObject(rowObjectArray[c]);
            }
        }
        this.nextTestRow(new RowTestObjects(resultObjectArray));
    }

    @Override
    public String getName() {
        return RowCollectorTestOperator.class.getSimpleName();
    }
}

