/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezProgressMonitor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.VertexStatus;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestTezProgressMonitor {
    private static final String REDUCER = "Reducer";
    private static final String MAPPER = "Mapper";
    @Mock
    private DAGClient dagClient;
    @Mock
    private SessionState.LogHelper console;
    @Mock
    private DAGStatus dagStatus;
    @Mock
    private Progress mapperProgress;
    @Mock
    private Progress reducerProgress;
    @Mock
    private VertexStatus succeeded;
    @Mock
    private VertexStatus running;

    private Map<String, Progress> progressMap() {
        return new HashMap<String, Progress>(){
            {
                this.put(TestTezProgressMonitor.MAPPER, TestTezProgressMonitor.this.setup(TestTezProgressMonitor.this.mapperProgress, 2, 1, 3, 4, 5));
                this.put(TestTezProgressMonitor.REDUCER, TestTezProgressMonitor.this.setup(TestTezProgressMonitor.this.reducerProgress, 3, 2, 1, 0, 1));
            }
        };
    }

    private Progress setup(Progress progressMock, int total, int succeeded, int failedAttempt, int killedAttempt, int running) {
        Mockito.when((Object)progressMock.getTotalTaskCount()).thenReturn((Object)total);
        Mockito.when((Object)progressMock.getSucceededTaskCount()).thenReturn((Object)succeeded);
        Mockito.when((Object)progressMock.getFailedTaskAttemptCount()).thenReturn((Object)failedAttempt);
        Mockito.when((Object)progressMock.getKilledTaskAttemptCount()).thenReturn((Object)killedAttempt);
        Mockito.when((Object)progressMock.getRunningTaskCount()).thenReturn((Object)running);
        return progressMock;
    }

    @Test
    public void setupInternalStateOnObjectCreation() throws IOException, TezException {
        Mockito.when((Object)this.dagStatus.getState()).thenReturn((Object)DAGStatus.State.RUNNING);
        Mockito.when((Object)this.dagClient.getVertexStatus((String)ArgumentMatchers.eq((Object)MAPPER), (Set)ArgumentMatchers.any())).thenReturn((Object)this.succeeded);
        Mockito.when((Object)this.dagClient.getVertexStatus((String)ArgumentMatchers.eq((Object)REDUCER), (Set)ArgumentMatchers.any())).thenReturn((Object)this.running);
        TezProgressMonitor monitor = new TezProgressMonitor(this.dagClient, this.dagStatus, new ArrayList(), this.progressMap(), this.console, Long.MAX_VALUE);
        ((DAGClient)Mockito.verify((Object)this.dagClient)).getVertexStatus((String)ArgumentMatchers.eq((Object)MAPPER), (Set)ArgumentMatchers.isNull());
        ((DAGClient)Mockito.verify((Object)this.dagClient)).getVertexStatus((String)ArgumentMatchers.eq((Object)REDUCER), (Set)ArgumentMatchers.isNull());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.dagClient});
        Assert.assertThat(monitor.vertexStatusMap.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{MAPPER, REDUCER}));
        Assert.assertThat(monitor.vertexStatusMap.get(MAPPER), (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)this.succeeded)));
        Assert.assertThat(monitor.vertexStatusMap.get(REDUCER), (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)this.running)));
        Assert.assertThat(monitor.progressCountsMap.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{MAPPER, REDUCER}));
        TezProgressMonitor.VertexProgress expectedMapperState = new TezProgressMonitor.VertexProgress(2, 1, 3, 4, 5, DAGStatus.State.RUNNING);
        Assert.assertThat(monitor.progressCountsMap.get(MAPPER), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)expectedMapperState)));
        TezProgressMonitor.VertexProgress expectedReducerState = new TezProgressMonitor.VertexProgress(3, 2, 1, 0, 1, DAGStatus.State.RUNNING);
        Assert.assertThat(monitor.progressCountsMap.get(REDUCER), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)expectedReducerState)));
    }
}

