/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastTableContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ConvertJoinMapJoin;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestVectorMapJoinFastHashTable {
    long keyCount = 15000000L;
    private static final Logger LOG = LoggerFactory.getLogger((String)TestVectorMapJoinFastHashTable.class.getName());

    @Test
    public void checkFast2estimations() throws Exception {
        this.runEstimationCheck(VectorMapJoinDesc.HashTableKeyType.LONG);
    }

    @Test
    public void checkFast3estimations() throws Exception {
        this.runEstimationCheck(VectorMapJoinDesc.HashTableKeyType.MULTI_KEY);
    }

    private void runEstimationCheck(VectorMapJoinDesc.HashTableKeyType l) throws SerDeException, IOException, HiveException {
        MapJoinDesc desc = new MapJoinDesc();
        VectorMapJoinDesc vectorDesc = new VectorMapJoinDesc();
        vectorDesc.setHashTableKeyType(l);
        vectorDesc.setIsFastHashTableEnabled(true);
        vectorDesc.setHashTableImplementationType(VectorMapJoinDesc.HashTableImplementationType.FAST);
        vectorDesc.setHashTableKind(VectorMapJoinDesc.HashTableKind.HASH_MAP);
        desc.setVectorDesc((VectorDesc)vectorDesc);
        TableDesc keyTblDesc = new TableDesc();
        keyTblDesc.setProperties(new Properties());
        desc.setKeyTblDesc(keyTblDesc);
        HiveConf hconf = new HiveConf();
        VectorMapJoinFastTableContainer container = new VectorMapJoinFastTableContainer(desc, (Configuration)hconf, this.keyCount);
        container.setSerde(null, null);
        long dataSize = 0L;
        BinarySortableSerializeWrite bsw = new BinarySortableSerializeWrite(1);
        ByteStream.Output outp = new ByteStream.Output();
        BytesWritable key = new BytesWritable();
        BytesWritable value = new BytesWritable();
        int i = 0;
        while ((long)i < this.keyCount) {
            bsw.set(outp);
            bsw.writeLong((long)i);
            key = new BytesWritable(outp.getData(), outp.getLength());
            bsw.set(outp);
            bsw.writeLong((long)(i * 2));
            value = new BytesWritable(outp.getData(), outp.getLength());
            container.putRow((Writable)key, (Writable)value);
            dataSize += 8L;
            dataSize += 8L;
            ++i;
        }
        Statistics stat = new Statistics(this.keyCount, dataSize, 0L, 0L);
        Long realObjectSize = this.getObjectSize(container);
        Long executionEstimate = container.getEstimatedMemorySize();
        Long compilerEstimate = null;
        ConvertJoinMapJoin cjm = new ConvertJoinMapJoin();
        cjm.hashTableLoadFactor = 0.75f;
        switch (l) {
            case MULTI_KEY: {
                compilerEstimate = cjm.computeOnlineDataSizeFastCompositeKeyed(stat);
                break;
            }
            case LONG: {
                compilerEstimate = cjm.computeOnlineDataSizeFastLongKeyed(stat);
            }
        }
        LOG.info("stats: {}", (Object)stat);
        LOG.info("realObjectSize: {}", (Object)realObjectSize);
        LOG.info("executionEstimate : {}", (Object)executionEstimate);
        LOG.info("compilerEstimate: {}", (Object)compilerEstimate);
        this.checkRelativeError(realObjectSize, executionEstimate, 0.05);
        this.checkRelativeError(realObjectSize, compilerEstimate, 0.05);
        this.checkRelativeError(compilerEstimate, executionEstimate, 0.05);
    }

    private void checkRelativeError(Long v1, Long v2, double err) {
        if (v1 == null || v2 == null) {
            return;
        }
        double d = (double)v1.longValue() / (double)v2.longValue();
        Assert.assertEquals((String)"error is outside of tolerance margin", (double)1.0, (double)d, (double)err);
    }

    private Long getObjectSize(Object o) {
        try {
            Class<?> clazz = Class.forName("jdk.nashorn.internal.ir.debug.ObjectSizeCalculator");
            Method method = clazz.getMethod("getObjectSize", Object.class);
            long l = (Long)method.invoke(null, o);
            return l;
        }
        catch (Exception e) {
            LOG.warn("Nashorn estimator not found", (Throwable)e);
            return null;
        }
    }
}

