/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.impl.InactiveServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapFixedRegistryImpl;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.registry.impl.LlapZookeeperRegistryImpl;
import org.apache.hadoop.hive.ql.exec.tez.HostAffinitySplitLocationProvider;
import org.apache.hadoop.hive.ql.exec.tez.TestHostAffinitySplitLocationProvider;
import org.apache.hadoop.hive.ql.exec.tez.Utils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);
    private static final String INACTIVE = "inactive";
    private static final String ACTIVE = "dynamic";
    private static final String DISABLED = "disabled";
    private static final String FIXED = "fix";
    @Mock
    private LlapRegistryService mockRegistry;
    @Mock
    private LlapServiceInstanceSet mockInstanceSet;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testGetSplitLocationProvider() throws IOException, URISyntaxException {
        LlapFixedRegistryImpl fixRegistry;
        ArrayList<Object> instances = new ArrayList<Object>(3);
        InactiveServiceInstance inactive = new InactiveServiceInstance(INACTIVE);
        instances.add(inactive);
        HiveConf conf = new HiveConf();
        conf.set(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM.varname, "localhost");
        LlapZookeeperRegistryImpl dynRegistry = new LlapZookeeperRegistryImpl("dyn", (Configuration)conf);
        Endpoint rpcEndpoint = RegistryTypeUtils.ipcEndpoint((String)"llap", (InetSocketAddress)new InetSocketAddress(ACTIVE, 4000));
        Endpoint shuffle = RegistryTypeUtils.ipcEndpoint((String)"shuffle", (InetSocketAddress)new InetSocketAddress(ACTIVE, 4000));
        Endpoint mng = RegistryTypeUtils.ipcEndpoint((String)"llapmng", (InetSocketAddress)new InetSocketAddress(ACTIVE, 4000));
        Endpoint outputFormat = RegistryTypeUtils.ipcEndpoint((String)"llapoutputformat", (InetSocketAddress)new InetSocketAddress(ACTIVE, 4000));
        Endpoint services = RegistryTypeUtils.webEndpoint((String)"services", (URI[])new URI[]{new URI("dynamic:4000")});
        ServiceRecord enabledSrv = new ServiceRecord();
        enabledSrv.addInternalEndpoint(rpcEndpoint);
        enabledSrv.addInternalEndpoint(shuffle);
        enabledSrv.addInternalEndpoint(mng);
        enabledSrv.addInternalEndpoint(outputFormat);
        enabledSrv.addExternalEndpoint(services);
        enabledSrv.set("hive.llap.daemon.num.enabled.executors", (Object)10);
        enabledSrv.set(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, (Object)100);
        LlapZookeeperRegistryImpl llapZookeeperRegistryImpl = dynRegistry;
        llapZookeeperRegistryImpl.getClass();
        LlapZookeeperRegistryImpl.DynamicServiceInstance dynamic = new LlapZookeeperRegistryImpl.DynamicServiceInstance(llapZookeeperRegistryImpl, enabledSrv);
        instances.add(dynamic);
        ServiceRecord disabledSrv = new ServiceRecord(enabledSrv);
        disabledSrv.set("hive.llap.daemon.num.enabled.executors", (Object)0);
        LlapZookeeperRegistryImpl llapZookeeperRegistryImpl2 = dynRegistry;
        llapZookeeperRegistryImpl2.getClass();
        LlapZookeeperRegistryImpl.DynamicServiceInstance disabled = new LlapZookeeperRegistryImpl.DynamicServiceInstance(llapZookeeperRegistryImpl2, disabledSrv);
        disabled.setHost(DISABLED);
        instances.add(disabled);
        Mockito.when((Object)this.mockRegistry.getInstances()).thenReturn((Object)this.mockInstanceSet);
        Mockito.when((Object)this.mockInstanceSet.getAllInstancesOrdered(ArgumentMatchers.anyBoolean())).thenReturn(instances);
        SplitLocationProvider provider = Utils.getCustomSplitLocationProvider((LlapRegistryService)this.mockRegistry, (Logger)LOG);
        this.assertLocations((HostAffinitySplitLocationProvider)provider, new String[]{ACTIVE});
        LlapFixedRegistryImpl llapFixedRegistryImpl = fixRegistry = new LlapFixedRegistryImpl("llap", (Configuration)new HiveConf());
        llapFixedRegistryImpl.getClass();
        LlapFixedRegistryImpl.FixedServiceInstance fixed = new LlapFixedRegistryImpl.FixedServiceInstance(llapFixedRegistryImpl, FIXED);
        instances.remove(dynamic);
        instances.add(fixed);
        provider = Utils.getCustomSplitLocationProvider((LlapRegistryService)this.mockRegistry, (Logger)LOG);
        this.assertLocations((HostAffinitySplitLocationProvider)provider, new String[]{FIXED});
    }

    private void assertLocations(HostAffinitySplitLocationProvider provider, String[] expectedLocations) throws IOException {
        FileSplit inputSplit1 = TestHostAffinitySplitLocationProvider.createMockFileSplit(true, "path2", 0L, 1000L, new String[]{"HOST-1", "HOST-2"});
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(provider.getLocations((InputSplit)inputSplit1)));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertFalse((boolean)result.contains(INACTIVE));
        Assert.assertFalse((boolean)result.contains(DISABLED));
        HashSet knownLocations = new HashSet();
        knownLocations.addAll(provider.locations);
        knownLocations.remove(null);
        Assert.assertArrayEquals((Object[])expectedLocations, (Object[])knownLocations.toArray(new String[0]));
    }

    @Test
    public void testCustomSplitLocationProvider() throws IOException {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_MODE, "llap");
        conf.setVar(HiveConf.ConfVars.LLAP_SPLIT_LOCATION_PROVIDER_CLASS, NoConstructorSplitLocationProvider.class.getName());
        SplitLocationProvider splitLocationProvider = Utils.getSplitLocationProvider((Configuration)conf, (Logger)LOG);
        Assert.assertTrue((boolean)(splitLocationProvider instanceof NoConstructorSplitLocationProvider));
        conf.setVar(HiveConf.ConfVars.LLAP_SPLIT_LOCATION_PROVIDER_CLASS, DefaultConstructorSplitLocationProvider.class.getName());
        splitLocationProvider = Utils.getSplitLocationProvider((Configuration)conf, (Logger)LOG);
        Assert.assertTrue((boolean)(splitLocationProvider instanceof DefaultConstructorSplitLocationProvider));
        conf.setVar(HiveConf.ConfVars.LLAP_SPLIT_LOCATION_PROVIDER_CLASS, ConfConstructorSplitLocationProvider.class.getName());
        splitLocationProvider = Utils.getSplitLocationProvider((Configuration)conf, (Logger)LOG);
        Assert.assertTrue((boolean)(splitLocationProvider instanceof ConfConstructorSplitLocationProvider));
    }

    public static class ConfConstructorSplitLocationProvider
    implements SplitLocationProvider {
        private Configuration configuration;

        public ConfConstructorSplitLocationProvider(Configuration conf) {
            this.configuration = conf;
        }

        public String[] getLocations(InputSplit inputSplit) throws IOException {
            return new String[0];
        }
    }

    public static class DefaultConstructorSplitLocationProvider
    implements SplitLocationProvider {
        public String[] getLocations(InputSplit inputSplit) throws IOException {
            return new String[0];
        }
    }

    public static class NoConstructorSplitLocationProvider
    implements SplitLocationProvider {
        public String[] getLocations(InputSplit inputSplit) throws IOException {
            return new String[0];
        }
    }
}

