/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.SampleTezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hive.common.util.Ref;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTezTask {
    DagUtils utils;
    MapWork[] mws;
    ReduceWork[] rws;
    TezWork work;
    TezTask task;
    TezClient session;
    TezSessionState sessionState;
    JobConf conf;
    LocalResource appLr;
    Operator<?> op;
    Path path;
    FileSystem fs;

    @Before
    public void setUp() throws Exception {
        this.utils = (DagUtils)Mockito.mock(DagUtils.class);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        this.path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.path.getFileSystem((Configuration)Mockito.any())).thenReturn((Object)this.fs);
        Mockito.when((Object)this.utils.getTezDir((Path)Mockito.any())).thenReturn((Object)this.path);
        Mockito.when((Object)this.utils.createVertex((JobConf)Mockito.any(), (BaseWork)Mockito.any(BaseWork.class), (Path)Mockito.any(Path.class), (TezWork)Mockito.any(TezWork.class), Mockito.anyMap())).thenAnswer((Answer)new Answer<Vertex>(){

            public Vertex answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return Vertex.create((String)((BaseWork)args[1]).getName(), (ProcessorDescriptor)((ProcessorDescriptor)Mockito.mock(ProcessorDescriptor.class)), (int)0, (Resource)((Resource)Mockito.mock(Resource.class)));
            }
        });
        Mockito.when((Object)this.utils.createEdge((JobConf)Mockito.any(), (Vertex)Mockito.any(Vertex.class), (Vertex)Mockito.any(Vertex.class), (TezEdgeProperty)Mockito.any(TezEdgeProperty.class), (BaseWork)Mockito.any(BaseWork.class), (TezWork)Mockito.any(TezWork.class))).thenAnswer((Answer)new Answer<Edge>(){

            public Edge answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return Edge.create((Vertex)((Vertex)args[1]), (Vertex)((Vertex)args[2]), (EdgeProperty)((EdgeProperty)Mockito.mock(EdgeProperty.class)));
            }
        });
        this.work = new TezWork("", null);
        this.mws = new MapWork[]{new MapWork(), new MapWork()};
        this.rws = new ReduceWork[]{new ReduceWork(), new ReduceWork()};
        this.work.addAll((BaseWork[])this.mws);
        this.work.addAll((BaseWork[])this.rws);
        int i = 0;
        for (BaseWork w : this.work.getAllWork()) {
            w.setName("Work " + ++i);
        }
        this.op = (Operator)Mockito.mock(Operator.class);
        LinkedHashMap map = new LinkedHashMap();
        map.put("foo", this.op);
        this.mws[0].setAliasToWork(map);
        this.mws[1].setAliasToWork(map);
        LinkedHashMap pathMap = new LinkedHashMap();
        ArrayList<String> aliasList = new ArrayList<String>();
        aliasList.add("foo");
        pathMap.put(new Path("foo"), aliasList);
        this.mws[0].setPathToAliases(pathMap);
        this.mws[1].setPathToAliases(pathMap);
        this.rws[0].setReducer(this.op);
        this.rws[1].setReducer(this.op);
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
        this.work.connect((BaseWork)this.mws[0], (BaseWork)this.rws[0], edgeProp);
        this.work.connect((BaseWork)this.mws[1], (BaseWork)this.rws[0], edgeProp);
        this.work.connect((BaseWork)this.rws[0], (BaseWork)this.rws[1], edgeProp);
        this.task = new TezTask(this.utils);
        this.task.setWork((Serializable)this.work);
        this.task.setConsole((SessionState.LogHelper)Mockito.mock(SessionState.LogHelper.class));
        QueryPlan mockQueryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
        ((QueryPlan)Mockito.doReturn((Object)UUID.randomUUID().toString()).when((Object)mockQueryPlan)).getQueryId();
        this.task.setQueryPlan(mockQueryPlan);
        this.conf = new JobConf();
        this.appLr = TestTezTask.createResource("foo.jar");
        HiveConf hiveConf = new HiveConf();
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)hiveConf);
        this.session = (TezClient)Mockito.mock(TezClient.class);
        this.sessionState = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)this.sessionState.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.sessionState.reopen()).thenReturn((Object)this.sessionState);
        Mockito.when((Object)this.session.submitDAG((DAG)Mockito.any(DAG.class))).thenThrow(new Throwable[]{new SessionNotRunning("")}).thenReturn(Mockito.mock(DAGClient.class));
    }

    @After
    public void tearDown() throws Exception {
        SessionState.get().close();
        this.utils = null;
        this.work = null;
        this.task = null;
        this.path = null;
        this.fs = null;
    }

    @Test
    public void testBuildDag() throws Exception {
        DAG dag = this.task.build(this.conf, this.work, this.path, new Context((Configuration)this.conf), DagUtils.createTezLrMap((LocalResource)this.appLr, null));
        for (BaseWork w : this.work.getAllWork()) {
            Vertex v = dag.getVertex(w.getName());
            Assert.assertNotNull((Object)v);
            List outs = v.getOutputVertices();
            for (BaseWork x : this.work.getChildren(w)) {
                boolean found = false;
                for (Vertex u : outs) {
                    if (!u.getName().equals(x.getName())) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((boolean)found);
            }
        }
    }

    @Test
    public void testEmptyWork() throws Exception {
        DAG dag = this.task.build(this.conf, new TezWork("", null), this.path, new Context((Configuration)this.conf), DagUtils.createTezLrMap((LocalResource)this.appLr, null));
        Assert.assertEquals((long)dag.getVertices().size(), (long)0L);
    }

    @Test
    public void testSubmit() throws Exception {
        DAG dag = DAG.create((String)"test");
        this.task.submit(dag, Ref.from((Object)this.sessionState));
        ((TezSessionState)Mockito.verify((Object)this.sessionState, (VerificationMode)Mockito.times((int)1))).reopen();
        ((TezClient)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)2))).submitDAG((DAG)Mockito.any(DAG.class));
    }

    @Test
    public void testSubmitOnNonPoolSession() throws Exception {
        DAG dag = DAG.create((String)"test");
        TezSessionState tezSessionState = (TezSessionState)Mockito.mock(TezSessionState.class);
        TezClient tezClient = (TezClient)Mockito.mock(TezClient.class);
        Mockito.when((Object)tezSessionState.reopen()).thenThrow(new Throwable[]{new HiveException("Dag cannot be submitted")});
        Mockito.when((Object)tezSessionState.getSession()).thenReturn((Object)tezClient);
        Mockito.when((Object)tezClient.submitDAG((DAG)Mockito.any(DAG.class))).thenThrow(new Throwable[]{new SessionNotRunning("")});
        ((TezSessionState)Mockito.doNothing().when((Object)tezSessionState)).destroy();
        boolean isException = false;
        try {
            this.task.submit(dag, Ref.from((Object)tezSessionState));
        }
        catch (Exception e) {
            isException = true;
            ((TezClient)Mockito.verify((Object)tezClient, (VerificationMode)Mockito.times((int)1))).submitDAG((DAG)Mockito.any(DAG.class));
            ((TezSessionState)Mockito.verify((Object)tezSessionState, (VerificationMode)Mockito.times((int)2))).reopen();
            ((TezSessionState)Mockito.verify((Object)tezSessionState, (VerificationMode)Mockito.times((int)1))).destroy();
            ((TezSessionState)Mockito.verify((Object)tezSessionState, (VerificationMode)Mockito.times((int)0))).returnToSessionManager();
        }
        Assert.assertTrue((boolean)isException);
    }

    @Test
    public void testSubmitOnPoolSession() throws Exception {
        DAG dag = DAG.create((String)"test");
        SampleTezSessionState tezSessionPoolSession = (SampleTezSessionState)((Object)Mockito.mock(SampleTezSessionState.class));
        TezClient tezClient = (TezClient)Mockito.mock(TezClient.class);
        Mockito.when((Object)tezSessionPoolSession.reopen()).thenThrow(new Throwable[]{new HiveException("Dag cannot be submitted")});
        ((SampleTezSessionState)((Object)Mockito.doNothing().when((Object)tezSessionPoolSession))).returnToSessionManager();
        Mockito.when((Object)tezSessionPoolSession.getSession()).thenReturn((Object)tezClient);
        Mockito.when((Object)tezSessionPoolSession.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)tezClient.submitDAG((DAG)Mockito.any(DAG.class))).thenThrow(new Throwable[]{new SessionNotRunning("")});
        boolean isException = false;
        try {
            this.task.submit(dag, Ref.from((Object)((Object)tezSessionPoolSession)));
        }
        catch (Exception e) {
            isException = true;
            ((TezClient)Mockito.verify((Object)tezClient, (VerificationMode)Mockito.times((int)1))).submitDAG((DAG)Mockito.any(DAG.class));
            ((SampleTezSessionState)((Object)Mockito.verify((Object)((Object)tezSessionPoolSession), (VerificationMode)Mockito.times((int)2)))).reopen();
            ((SampleTezSessionState)((Object)Mockito.verify((Object)((Object)tezSessionPoolSession), (VerificationMode)Mockito.times((int)0)))).destroy();
            ((SampleTezSessionState)((Object)Mockito.verify((Object)((Object)tezSessionPoolSession), (VerificationMode)Mockito.times((int)1)))).returnToSessionManager();
        }
        Assert.assertTrue((boolean)isException);
    }

    @Test
    public void testClose() throws HiveException {
        this.task.close(this.work, 0, null);
        ((Operator)Mockito.verify(this.op, (VerificationMode)Mockito.times((int)4))).jobClose((Configuration)Mockito.any(), Mockito.eq((boolean)true));
    }

    @Test
    public void testExistingSessionGetsStorageHandlerResources() throws Exception {
        String jarFilePath = "file:///tmp/foo.jar";
        String[] inputOutputJars = new String[]{"file:///tmp/foo.jar"};
        LocalResource res = TestTezTask.createResource(inputOutputJars[0]);
        Map<String, LocalResource> resources = Collections.singletonMap("file:///tmp/foo.jar", res);
        Mockito.when((Object)this.utils.localizeTempFiles(Mockito.anyString(), (Configuration)Mockito.any(), (String[])Mockito.eq((Object)inputOutputJars), (String[])Mockito.any(String[].class))).thenReturn(resources);
        Mockito.when((Object)this.sessionState.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.sessionState.isOpening()).thenReturn((Object)false);
        this.task.ensureSessionHasResources(this.sessionState, inputOutputJars);
        ((TezSessionState)Mockito.verify((Object)this.sessionState)).ensureLocalResources((Configuration)Mockito.any(), (String[])Mockito.eq((Object)inputOutputJars));
    }

    private static LocalResource createResource(String url) {
        LocalResource res = (LocalResource)Mockito.mock(LocalResource.class);
        Mockito.when((Object)res.getResource()).thenReturn((Object)URL.fromPath((Path)new Path(url)));
        return res;
    }

    @Test
    public void testParseRightmostXmx() throws Exception {
        String javaOpts = "";
        long heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)-1L, (long)heapSize);
        javaOpts = "-Xms1024m";
        heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)-1L, (long)heapSize);
        javaOpts = "-Xms1024m -Xmx2g";
        heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)0x80000000L, (long)heapSize);
        javaOpts = "-Xms1024m -Xmx1024m";
        heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)0x40000000L, (long)heapSize);
        javaOpts = "-Xms1024m -Xmx524288k";
        heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)0x20000000L, (long)heapSize);
        javaOpts = "-Xms1024m -Xmx1610612736";
        heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)0x60000000L, (long)heapSize);
        javaOpts = "-Xmx1024m -Xmx1536m";
        heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)0x60000000L, (long)heapSize);
        javaOpts = "pre-Xmx1024m";
        heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)-1L, (long)heapSize);
        javaOpts = "-Xmx1024m-post";
        heapSize = DagUtils.parseRightmostXmx((String)javaOpts);
        Assert.assertEquals((String)"Unexpected maximum heap size", (long)-1L, (long)heapSize);
    }

    @Test
    public void tezTask_updates_Metrics() throws IOException {
        Metrics mockMetrics = (Metrics)Mockito.mock(Metrics.class);
        TezTask tezTask = new TezTask();
        tezTask.updateTaskMetrics(mockMetrics);
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.times((int)1))).incrementCounter("hive_tez_tasks");
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.never())).incrementCounter("hive_spark_tasks");
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.never())).incrementCounter("hive_mapred_tasks");
    }
}

