/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class TestTezOutputCommitter {
    @ClassRule
    public static HiveTestEnvSetup ENVIRONMENT = new HiveTestEnvSetup();
    private static final String ABORT_JOB_ERROR_MSG = "JobAbortingOutputCommitter error!!!";
    private static final String ABORT_TASK_ERROR_MSG = "TaskAbortingOutputCommitter error!!!";
    private static final int MAX_TASK_ATTEMPTS = 2;
    private static final String TEST_TABLE = "output_committer_test_table";
    private static int commitTaskCounter;
    private static int abortTaskCounter;
    private static int commitJobCounter;
    private static int abortJobCounter;
    private IDriver driver;

    @Before
    public void setUp() {
        commitTaskCounter = 0;
        abortTaskCounter = 0;
        commitJobCounter = 0;
        abortJobCounter = 0;
    }

    @Test
    public void testSuccessfulJob() throws Exception {
        this.driver = this.getDriverWithCommitter(CountingOutputCommitter.class.getName());
        this.driver.run(String.format("CREATE TABLE %s (a int)", TEST_TABLE));
        this.driver.run(String.format("INSERT INTO %s VALUES (4), (5)", TEST_TABLE));
        Assert.assertEquals((long)1L, (long)commitTaskCounter);
        Assert.assertEquals((long)0L, (long)abortTaskCounter);
        Assert.assertEquals((long)1L, (long)commitJobCounter);
        Assert.assertEquals((long)0L, (long)abortJobCounter);
    }

    @Test
    public void testAbortTask() throws Exception {
        this.driver = this.getDriverWithCommitter(TaskAbortingOutputCommitter.class.getName());
        try {
            this.driver.run(String.format("CREATE TABLE %s (a int)", TEST_TABLE));
            this.driver.run(String.format("INSERT INTO %s VALUES (4), (5)", TEST_TABLE));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(ABORT_TASK_ERROR_MSG));
        }
        Assert.assertEquals((long)2L, (long)commitTaskCounter);
        Assert.assertEquals((long)2L, (long)abortTaskCounter);
        Assert.assertEquals((long)0L, (long)commitJobCounter);
        Assert.assertEquals((long)1L, (long)abortJobCounter);
    }

    @Test
    public void testAbortJob() throws Exception {
        this.driver = this.getDriverWithCommitter(JobAbortingOutputCommitter.class.getName());
        try {
            this.driver.run(String.format("CREATE TABLE %s (a int)", TEST_TABLE));
            this.driver.run(String.format("INSERT INTO %s VALUES (4), (5)", TEST_TABLE));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(ABORT_JOB_ERROR_MSG));
        }
        Assert.assertEquals((long)1L, (long)commitTaskCounter);
        Assert.assertEquals((long)0L, (long)abortTaskCounter);
        Assert.assertEquals((long)1L, (long)commitJobCounter);
        Assert.assertEquals((long)1L, (long)abortJobCounter);
    }

    @After
    public void tearDown() throws Exception {
        this.driver.run(String.format("DROP TABLE %s", TEST_TABLE));
        this.driver.close();
    }

    private IDriver getDriverWithCommitter(String committerClass) {
        HiveConf conf = TestTezOutputCommitter.ENVIRONMENT.getTestCtx().hiveConf;
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setInt("tez.am.task.max.failed.attempts", 2);
        conf.set("mapred.output.committer.class", committerClass);
        SessionState.start((HiveConf)conf);
        return DriverFactory.newDriver((HiveConf)conf);
    }

    public static class CountingOutputCommitter
    extends OutputCommitter {
        public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
            commitTaskCounter++;
        }

        public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
            abortTaskCounter++;
        }

        public void commitJob(JobContext jobContext) throws IOException {
            super.commitJob(jobContext);
            commitJobCounter++;
        }

        public void abortJob(JobContext jobContext, int status) throws IOException {
            super.abortJob(jobContext, status);
            abortJobCounter++;
        }

        public void setupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
            return true;
        }
    }

    public static class JobAbortingOutputCommitter
    extends CountingOutputCommitter {
        @Override
        public void commitJob(JobContext jobContext) throws IOException {
            super.commitJob(jobContext);
            throw new RuntimeException(TestTezOutputCommitter.ABORT_JOB_ERROR_MSG);
        }
    }

    public static class TaskAbortingOutputCommitter
    extends CountingOutputCommitter {
        @Override
        public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
            super.commitTask(taskAttemptContext);
            throw new RuntimeException(TestTezOutputCommitter.ABORT_TASK_ERROR_MSG);
        }
    }
}

