/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.exec.tez.CustomEdgeConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.CustomPartitionVertex;
import org.apache.hadoop.hive.ql.exec.tez.CustomVertexConfiguration;
import org.apache.hadoop.hive.ql.exec.tez.DataInputByteBuffer;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCustomPartitionVertex {
    @Test(timeout=20000L)
    public void testGetBytePayload() throws IOException {
        int numBuckets = 10;
        VertexManagerPluginContext context = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        CustomVertexConfiguration vertexConf = new CustomVertexConfiguration(numBuckets, TezWork.VertexType.INITIALIZED_EDGES);
        DataOutputBuffer dob = new DataOutputBuffer();
        vertexConf.write((DataOutput)dob);
        UserPayload payload = UserPayload.create((ByteBuffer)ByteBuffer.wrap(dob.getData()));
        Mockito.when((Object)context.getUserPayload()).thenReturn((Object)payload);
        CustomPartitionVertex vm = new CustomPartitionVertex(context);
        vm.initialize();
        HashMultimap routingTable = HashMultimap.create();
        payload = vm.getBytePayload((Multimap)routingTable);
        CustomEdgeConfiguration edgeConf = new CustomEdgeConfiguration();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        dibb.reset(new ByteBuffer[]{payload.getPayload()});
        edgeConf.readFields((DataInput)dibb);
        Assert.assertEquals((long)numBuckets, (long)edgeConf.getNumBuckets());
    }
}

