/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.status.RenderStrategy;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStage;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkJobMonitor {
    private HiveConf testConf;
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private SparkJobMonitor monitor;
    private PrintStream curOut;
    private PrintStream curErr;
    private RenderStrategy.InPlaceUpdateFunction updateFunction;

    @Before
    public void setUp() {
        this.curOut = System.out;
        this.curErr = System.err;
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
        this.testConf = new HiveConf();
        SessionState.start((HiveConf)this.testConf);
        this.monitor = new SparkJobMonitor(this.testConf){

            public int startMonitor() {
                return 0;
            }
        };
        this.updateFunction = new RenderStrategy.InPlaceUpdateFunction(this.monitor);
    }

    private Map<SparkStage, SparkStageProgress> progressMap() {
        return new HashMap<SparkStage, SparkStageProgress>(){
            {
                this.put(new SparkStage(1, 0), new SparkStageProgress(4, 3, 1, 0));
                this.put(new SparkStage(3, 1), new SparkStageProgress(6, 4, 1, 1));
                this.put(new SparkStage(9, 0), new SparkStageProgress(5, 5, 0, 0));
                this.put(new SparkStage(10, 2), new SparkStageProgress(5, 3, 2, 0));
                this.put(new SparkStage(15, 1), new SparkStageProgress(4, 3, 1, 0));
                this.put(new SparkStage(15, 2), new SparkStageProgress(4, 4, 0, 0));
                this.put(new SparkStage(20, 3), new SparkStageProgress(3, 1, 1, 1));
                this.put(new SparkStage(21, 1), new SparkStageProgress(2, 2, 0, 0));
            }
        };
    }

    @Test
    public void testProgress() {
        String[] testStrings;
        Map<SparkStage, SparkStageProgress> progressMap = this.progressMap();
        this.updateFunction.printStatus(progressMap, null);
        String testOutput = this.errContent.toString();
        Assert.assertTrue((boolean)testOutput.contains("Stage-1_0: 3(+1)/4\tStage-3_1: 4(+1,-1)/6\tStage-9_0: 5/5 Finished\tStage-10_2: 3(+2)/5\tStage-15_1: 3(+1)/4\tStage-15_2: 4/4 Finished\tStage-20_3: 1(+1,-1)/3\tStage-21_1: 2/2 Finished"));
        for (String testString : testStrings = new String[]{"STAGES   ATTEMPT        STATUS  TOTAL  COMPLETED  RUNNING  PENDING  FAILED", "Stage-1 ......           0       RUNNING      4          3        1        0       0", "Stage-3 .....            1       RUNNING      6          4        1        1       1", "Stage-9 ........         0      FINISHED      5          5        0        0       0", "Stage-10 ....            2       RUNNING      5          3        2        0       0", "Stage-15 .....           1       RUNNING      4          3        1        0       0", "Stage-15 .......         2      FINISHED      4          4        0        0       0", "Stage-20 ..              3       RUNNING      3          1        1        1       1", "Stage-21 .......         1      FINISHED      2          2        0        0       0", "STAGES: 03/08    [===================>>-------] 75%   ELAPSED TIME:"}) {
            Assert.assertTrue((boolean)testOutput.contains(testString));
        }
    }

    @After
    public void tearDown() {
        System.setOut(this.curOut);
        System.setErr(this.curErr);
    }
}

