/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManager;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkUtils;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.Ref;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestSparkUtilities {
    @Test
    public void testGetSparkSessionUsingMultipleThreadsWithTheSameSession() throws HiveException, InterruptedException {
        AtomicReference activeSparkSession = new AtomicReference();
        HiveConf mockConf = (HiveConf)Mockito.mock(HiveConf.class);
        SparkSessionManager mockSessionManager = (SparkSessionManager)Mockito.mock(SparkSessionManager.class);
        ((SparkSessionManager)Mockito.doAnswer(invocationOnMock -> {
            SparkSession sparkSession = (SparkSession)invocationOnMock.getArgument(0, SparkSession.class);
            if (sparkSession == null) {
                return Mockito.mock(SparkSession.class);
            }
            return sparkSession;
        }).when((Object)mockSessionManager)).getSession((SparkSession)ArgumentMatchers.any(SparkSession.class), (HiveConf)Mockito.eq((Object)mockConf), Mockito.eq((boolean)true));
        SessionState mockSessionState = (SessionState)Mockito.mock(SessionState.class);
        Mockito.when((Object)mockSessionState.getConf()).thenReturn((Object)mockConf);
        ((SessionState)Mockito.doAnswer(invocationOnMock -> {
            activeSparkSession.set(invocationOnMock.getArgument(0, SparkSession.class));
            return null;
        }).when((Object)mockSessionState)).setSparkSession((SparkSession)ArgumentMatchers.any(SparkSession.class));
        ((SessionState)Mockito.doAnswer(invocationOnMock -> (SparkSession)activeSparkSession.get()).when((Object)mockSessionState)).getSparkSession();
        ArrayList<GetSparkSessionTester> callables = new ArrayList<GetSparkSessionTester>();
        callables.add(new GetSparkSessionTester(mockConf, mockSessionManager, mockSessionState));
        callables.add(new GetSparkSessionTester(mockConf, mockSessionManager, mockSessionState));
        callables.add(new GetSparkSessionTester(mockConf, mockSessionManager, mockSessionState));
        ExecutorService executorService = Executors.newFixedThreadPool(callables.size());
        List results = executorService.invokeAll(callables);
        results.stream().map(f -> this.resolve((Future<SparkSession>)f)).forEach(ss -> Assert.assertEquals((Object)ss, activeSparkSession.get()));
    }

    @Test
    public void testCreateMoveTaskDoesntCreateCascadeTempDirs() throws Exception {
        FileSinkOperator fsOp = (FileSinkOperator)Mockito.mock(FileSinkOperator.class);
        ParseContext pctx = (ParseContext)Mockito.mock(ParseContext.class);
        Configuration conf = new Configuration();
        conf.set("_hive.hdfs.session.path", "hdfs:/dummypath");
        conf.set("_hive.local.session.path", "hdfs:/dummypath");
        Context ctx = new Context(conf);
        String executionId = ctx.getExecutionId();
        Context ctxSpy = (Context)Mockito.spy((Object)ctx);
        FileSinkDesc fileSinkDesc = (FileSinkDesc)Mockito.mock(FileSinkDesc.class);
        Path mrPath = new Path("hdfs:/tmp/.staging/" + executionId + "/-mr-10001");
        Path mrPath2 = new Path("hdfs:/tmp/.staging/" + executionId + "/-mr-10002");
        Path extPath = new Path("hdfs:/tmp/.staging/" + executionId + "/-ext-10001");
        Path extPath2 = new Path("hdfs:/tmp/.staging/" + executionId + "/-ext-10002");
        Ref expectedPathRef = new Ref((Object)mrPath);
        Ref testPathRef = new Ref((Object)extPath);
        ((ParseContext)Mockito.doAnswer(invocationOnMock -> ctxSpy).when((Object)pctx)).getContext();
        ((Context)Mockito.doAnswer(invocationOnMock -> mrPath2).when((Object)ctxSpy)).getMRTmpPath();
        ((Context)Mockito.doAnswer(invocationOnMock -> extPath2).when((Object)ctxSpy)).getExternalTmpPath((Path)ArgumentMatchers.any(Path.class));
        ((FileSinkDesc)Mockito.doAnswer(invocationOnMock -> testPathRef.value).when((Object)fileSinkDesc)).getFinalDirName();
        ((FileSinkDesc)Mockito.doAnswer(invocationOnMock -> null).when((Object)fileSinkDesc)).getLinkedFileSinkDesc();
        ((FileSinkOperator)Mockito.doAnswer(invocationOnMock -> fileSinkDesc).when((Object)fsOp)).getConf();
        ((FileSinkDesc)Mockito.doAnswer(invocationOnMock -> {
            Assert.assertEquals((Object)expectedPathRef.value, (Object)invocationOnMock.getArgument(0, Path.class));
            return null;
        }).when((Object)fileSinkDesc)).setDirName((Path)ArgumentMatchers.any(Path.class));
        testPathRef.value = mrPath;
        expectedPathRef.value = mrPath2;
        GenSparkUtils.createMoveTask(null, (boolean)true, (FileSinkOperator)fsOp, (ParseContext)pctx, null, null, null);
        testPathRef.value = extPath;
        expectedPathRef.value = extPath2;
        GenSparkUtils.createMoveTask(null, (boolean)true, (FileSinkOperator)fsOp, (ParseContext)pctx, null, null, null);
    }

    private SparkSession resolve(Future<SparkSession> future) {
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class GetSparkSessionTester
    implements Callable<SparkSession> {
        private HiveConf hiveConf;
        private SparkSessionManager sparkSessionManager;
        private SessionState sessionState;

        GetSparkSessionTester(HiveConf hiveConf, SparkSessionManager sparkSessionManager, SessionState sessionState) {
            this.hiveConf = hiveConf;
            this.sparkSessionManager = sparkSessionManager;
            this.sessionState = sessionState;
        }

        @Override
        public SparkSession call() throws Exception {
            SessionState.setCurrentSessionState((SessionState)this.sessionState);
            return SparkUtilities.getSparkSession((HiveConf)this.hiveConf, (SparkSessionManager)this.sparkSessionManager);
        }
    }
}

