/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistics;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticsBuilder;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.status.RemoteSparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobRef;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.RemoteSparkJobStatus;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.spark.client.JobHandle;
import org.apache.spark.SparkException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSparkTask {
    @Test
    public void sparkTask_updates_Metrics() throws IOException {
        Metrics mockMetrics = (Metrics)Mockito.mock(Metrics.class);
        SparkTask sparkTask = new SparkTask();
        sparkTask.updateTaskMetrics(mockMetrics);
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.times((int)1))).incrementCounter("hive_spark_tasks");
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.never())).incrementCounter("hive_tez_tasks");
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.never())).incrementCounter("hive_mapred_tasks");
    }

    @Test
    public void removeEmptySparkTask() {
        SparkTask grandpa = new SparkTask();
        SparkWork grandpaWork = new SparkWork("grandpa");
        grandpaWork.add((BaseWork)new MapWork());
        grandpa.setWork((Serializable)grandpaWork);
        SparkTask parent = new SparkTask();
        SparkWork parentWork = new SparkWork("parent");
        parentWork.add((BaseWork)new MapWork());
        parent.setWork((Serializable)parentWork);
        SparkTask child1 = new SparkTask();
        SparkWork childWork1 = new SparkWork("child1");
        childWork1.add((BaseWork)new MapWork());
        child1.setWork((Serializable)childWork1);
        grandpa.addDependentTask((Task)parent);
        parent.addDependentTask((Task)child1);
        Assert.assertEquals((long)grandpa.getChildTasks().size(), (long)1L);
        Assert.assertEquals((long)child1.getParentTasks().size(), (long)1L);
        if (this.isEmptySparkWork((SparkWork)parent.getWork())) {
            SparkUtilities.removeEmptySparkTask((SparkTask)parent);
        }
        Assert.assertEquals((long)grandpa.getChildTasks().size(), (long)0L);
        Assert.assertEquals((long)child1.getParentTasks().size(), (long)0L);
    }

    @Test
    public void testRemoteSparkCancel() {
        RemoteSparkJobStatus jobSts = (RemoteSparkJobStatus)Mockito.mock(RemoteSparkJobStatus.class);
        Mockito.when((Object)jobSts.getRemoteJobState()).thenReturn((Object)JobHandle.State.CANCELLED);
        Mockito.when((Object)jobSts.isRemoteActive()).thenReturn((Object)true);
        HiveConf hiveConf = new HiveConf();
        SessionState.start((HiveConf)hiveConf);
        RemoteSparkJobMonitor remoteSparkJobMonitor = new RemoteSparkJobMonitor(hiveConf, jobSts);
        Assert.assertEquals((long)remoteSparkJobMonitor.startMonitor(), (long)3L);
    }

    @Test
    public void testSparkStatisticsToString() {
        SparkStatisticsBuilder statsBuilder = new SparkStatisticsBuilder();
        statsBuilder.add("TEST", "stat1", "1");
        statsBuilder.add("TEST", "stat2", "1");
        String statsString = SparkTask.sparkStatisticsToString((SparkStatistics)statsBuilder.build(), (int)10);
        Assert.assertTrue((boolean)statsString.contains("10"));
        Assert.assertTrue((boolean)statsString.contains("TEST"));
        Assert.assertTrue((boolean)statsString.contains("stat1"));
        Assert.assertTrue((boolean)statsString.contains("stat2"));
        Assert.assertTrue((boolean)statsString.contains("1"));
    }

    @Test
    public void testSetSparkExceptionWithJobError() {
        SparkTask sparkTask = new SparkTask();
        SparkJobStatus mockSparkJobStatus = (SparkJobStatus)Mockito.mock(SparkJobStatus.class);
        ExecutionException ee = new ExecutionException("Exception thrown by job", (Throwable)new SparkException("Job aborted due to stage failure: Not a task or OOM error"));
        Mockito.when((Object)mockSparkJobStatus.getSparkJobException()).thenReturn((Object)ee);
        sparkTask.setSparkException(mockSparkJobStatus, 3);
        Assert.assertTrue((boolean)(sparkTask.getException() instanceof HiveException));
        Assert.assertEquals((Object)((HiveException)sparkTask.getException()).getCanonicalErrorMsg(), (Object)ErrorMsg.SPARK_JOB_RUNTIME_ERROR);
        Assert.assertTrue((boolean)sparkTask.getException().getMessage().contains("Not a task or OOM error"));
    }

    @Test
    public void testSetSparkExceptionWithTimeoutError() {
        SparkTask sparkTask = new SparkTask();
        SparkJobStatus mockSparkJobStatus = (SparkJobStatus)Mockito.mock(SparkJobStatus.class);
        Mockito.when((Object)mockSparkJobStatus.getMonitorError()).thenReturn((Object)new HiveException(ErrorMsg.SPARK_JOB_MONITOR_TIMEOUT, new String[]{Long.toString(60L)}));
        sparkTask.setSparkException(mockSparkJobStatus, 3);
        Assert.assertTrue((boolean)(sparkTask.getException() instanceof HiveException));
        Assert.assertEquals((Object)((HiveException)sparkTask.getException()).getCanonicalErrorMsg(), (Object)ErrorMsg.SPARK_JOB_MONITOR_TIMEOUT);
        Assert.assertTrue((boolean)sparkTask.getException().getMessage().contains("60s"));
    }

    @Test
    public void testSetSparkExceptionWithOOMError() {
        SparkTask sparkTask = new SparkTask();
        SparkJobStatus mockSparkJobStatus = (SparkJobStatus)Mockito.mock(SparkJobStatus.class);
        ExecutionException jobError = new ExecutionException((Throwable)new SparkException("Container killed by YARN for exceeding memory limits"));
        Mockito.when((Object)mockSparkJobStatus.getSparkJobException()).thenReturn((Object)jobError);
        sparkTask.setSparkException(mockSparkJobStatus, 3);
        Assert.assertTrue((boolean)(sparkTask.getException() instanceof HiveException));
        Assert.assertEquals((Object)((HiveException)sparkTask.getException()).getCanonicalErrorMsg(), (Object)ErrorMsg.SPARK_RUNTIME_OOM);
    }

    @Test
    public void testSparkExceptionAndMonitorError() {
        SparkTask sparkTask = new SparkTask();
        SparkJobStatus mockSparkJobStatus = (SparkJobStatus)Mockito.mock(SparkJobStatus.class);
        Mockito.when((Object)mockSparkJobStatus.getMonitorError()).thenReturn((Object)new RuntimeException());
        Mockito.when((Object)mockSparkJobStatus.getSparkJobException()).thenReturn((Object)new ExecutionException((Throwable)new SparkException("")));
        sparkTask.setSparkException(mockSparkJobStatus, 3);
        Assert.assertTrue((boolean)(sparkTask.getException() instanceof HiveException));
        Assert.assertEquals((Object)((HiveException)sparkTask.getException()).getCanonicalErrorMsg(), (Object)ErrorMsg.SPARK_JOB_RUNTIME_ERROR);
    }

    @Test
    public void testHandleInterruptedException() throws Exception {
        HiveConf hiveConf = new HiveConf();
        SparkTask sparkTask = new SparkTask();
        sparkTask.setWork((Serializable)Mockito.mock(SparkWork.class));
        TaskQueue mockTestQueue = (TaskQueue)Mockito.mock(TaskQueue.class);
        QueryState mockQueryState = (QueryState)Mockito.mock(QueryState.class);
        Mockito.when((Object)mockQueryState.getConf()).thenReturn((Object)hiveConf);
        sparkTask.initialize(mockQueryState, null, mockTestQueue, null);
        SparkJobStatus mockSparkJobStatus = (SparkJobStatus)Mockito.mock(SparkJobStatus.class);
        Mockito.when((Object)mockSparkJobStatus.getMonitorError()).thenReturn((Object)new InterruptedException());
        SparkSession mockSparkSession = (SparkSession)Mockito.mock(SparkSession.class);
        SparkJobRef mockSparkJobRef = (SparkJobRef)Mockito.mock(SparkJobRef.class);
        Mockito.when((Object)mockSparkJobRef.monitorJob()).thenReturn((Object)2);
        Mockito.when((Object)mockSparkJobRef.getSparkJobStatus()).thenReturn((Object)mockSparkJobStatus);
        Mockito.when((Object)mockSparkSession.submit((TaskQueue)ArgumentMatchers.any(), (Context)ArgumentMatchers.any(), (SparkWork)ArgumentMatchers.any())).thenReturn((Object)mockSparkJobRef);
        SessionState.start((HiveConf)hiveConf);
        SessionState.get().setSparkSession(mockSparkSession);
        sparkTask.execute();
        ((SparkJobRef)Mockito.verify((Object)mockSparkJobRef, (VerificationMode)Mockito.atLeastOnce())).cancelJob();
        Mockito.when((Object)mockSparkJobStatus.getMonitorError()).thenReturn((Object)new HiveException((Throwable)new InterruptedException()));
        sparkTask.execute();
        ((SparkJobRef)Mockito.verify((Object)mockSparkJobRef, (VerificationMode)Mockito.atLeastOnce())).cancelJob();
    }

    private boolean isEmptySparkWork(SparkWork sparkWork) {
        List allWorks = sparkWork.getAllWork();
        boolean allWorksIsEmtpy = true;
        for (BaseWork work : allWorks) {
            if (work.getAllOperators().size() <= 0) continue;
            allWorksIsEmtpy = false;
            break;
        }
        return allWorksIsEmtpy;
    }
}

