/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.SparkPlan;
import org.apache.hadoop.hive.ql.exec.spark.SparkPlanGenerator;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.reexec.ReExecDriver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.Dependency;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.HadoopRDD;
import org.apache.spark.rdd.MapPartitionsRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ShuffledRDD;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import scala.collection.JavaConversions;
import scala.collection.Seq;

@Ignore(value="HIVE-22944: Kryo 5 upgrade conflicts with Spark, which is not supported anymore")
public class TestSparkPlan {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetRDDCallSite() throws Exception {
        String confDir = "../data/conf/spark/local/hive-site.xml";
        HiveConf.setHiveSiteLocation((URL)new File(confDir).toURI().toURL());
        HiveConf conf = new HiveConf();
        conf.setBoolVar(HiveConf.ConfVars.SPARK_OPTIMIZE_SHUFFLE_SERDE, false);
        conf.set("spark.local.dir", Paths.get(System.getProperty("test.tmp.dir"), "TestSparkPlan-local-dir").toString());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path tmpDir = new Path("TestSparkPlan-tmp");
        SessionState.start((HiveConf)conf);
        IDriver driver = null;
        JavaSparkContext sc = null;
        try {
            driver = DriverFactory.newDriver((HiveConf)conf);
            driver.run("create table test (col int)");
            ((ReExecDriver)driver).compile("select * from test order by col", true);
            List sparkTasks = Utilities.getSparkTasks((List)driver.getPlan().getRootTasks());
            Assert.assertEquals((long)1L, (long)sparkTasks.size());
            SparkTask sparkTask = (SparkTask)sparkTasks.get(0);
            JobConf jobConf = new JobConf((Configuration)conf);
            SparkConf sparkConf = new SparkConf();
            sparkConf.setMaster("local");
            sparkConf.setAppName("TestSparkPlan-app");
            sc = new JavaSparkContext(sparkConf);
            SparkPlanGenerator sparkPlanGenerator = new SparkPlanGenerator(sc, null, jobConf, tmpDir, null);
            SparkPlan sparkPlan = sparkPlanGenerator.generate((SparkWork)sparkTask.getWork());
            RDD reducerRdd = sparkPlan.generateGraph().rdd();
            Assert.assertTrue((boolean)reducerRdd.name().contains("Reducer 2"));
            Assert.assertTrue((boolean)(reducerRdd instanceof MapPartitionsRDD));
            Assert.assertTrue((boolean)reducerRdd.creationSite().shortForm().contains("Reducer 2"));
            Assert.assertTrue((boolean)reducerRdd.creationSite().longForm().contains("Explain Plan"));
            Assert.assertTrue((boolean)reducerRdd.creationSite().longForm().contains("Reducer 2"));
            List rdds = JavaConversions.seqAsJavaList((Seq)reducerRdd.dependencies());
            Assert.assertEquals((long)1L, (long)rdds.size());
            RDD shuffledRdd = ((Dependency)rdds.get(0)).rdd();
            Assert.assertTrue((boolean)shuffledRdd.name().contains("Reducer 2"));
            Assert.assertTrue((boolean)shuffledRdd.name().contains("SORT"));
            Assert.assertTrue((boolean)(shuffledRdd instanceof ShuffledRDD));
            Assert.assertTrue((boolean)shuffledRdd.creationSite().shortForm().contains("Reducer 2"));
            Assert.assertTrue((boolean)shuffledRdd.creationSite().longForm().contains("Explain Plan"));
            Assert.assertTrue((boolean)shuffledRdd.creationSite().longForm().contains("Reducer 2"));
            rdds = JavaConversions.seqAsJavaList((Seq)shuffledRdd.dependencies());
            Assert.assertEquals((long)1L, (long)rdds.size());
            RDD mapRdd = ((Dependency)rdds.get(0)).rdd();
            Assert.assertTrue((boolean)mapRdd.name().contains("Map 1"));
            Assert.assertTrue((boolean)(mapRdd instanceof MapPartitionsRDD));
            Assert.assertTrue((boolean)mapRdd.creationSite().shortForm().contains("Map 1"));
            Assert.assertTrue((boolean)mapRdd.creationSite().longForm().contains("Explain Plan"));
            Assert.assertTrue((boolean)mapRdd.creationSite().longForm().contains("Map 1"));
            rdds = JavaConversions.seqAsJavaList((Seq)mapRdd.dependencies());
            Assert.assertEquals((long)1L, (long)rdds.size());
            RDD hadoopRdd = ((Dependency)rdds.get(0)).rdd();
            Assert.assertTrue((boolean)hadoopRdd.name().contains("Map 1"));
            Assert.assertTrue((boolean)hadoopRdd.name().contains("test"));
            Assert.assertTrue((boolean)(hadoopRdd instanceof HadoopRDD));
            Assert.assertTrue((boolean)hadoopRdd.creationSite().shortForm().contains("Map 1"));
        }
        finally {
            if (driver != null) {
                driver.run("drop table if exists test");
                driver.destroy();
            }
            if (sc != null) {
                sc.close();
            }
            if (fs.exists(tmpDir)) {
                fs.delete(tmpDir, true);
            }
        }
    }
}

