/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="HIVE-22944: Kryo 5 upgrade conflicts with Spark, which is not supported anymore")
public class TestSparkInvalidFileFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readTextFileAsParquet() throws IOException, CommandProcessorException {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, SQLStdHiveAuthorizerFactory.class.getName());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "spark");
        conf.set("spark.master", "local");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path tmpDir = new Path("TestSparkInvalidFileFormat-tmp");
        File testFile = new File(conf.get("test.data.files"), "kv1.txt");
        SessionState.start((HiveConf)conf);
        IDriver driver = null;
        try {
            driver = DriverFactory.newDriver((HiveConf)conf);
            driver.run("CREATE TABLE test_table (key STRING, value STRING)");
            driver.run("LOAD DATA LOCAL INPATH '" + testFile + "' INTO TABLE test_table");
            driver.run("ALTER TABLE test_table SET FILEFORMAT parquet");
            try {
                driver.run("SELECT * FROM test_table ORDER BY key LIMIT 10");
                assert (false);
            }
            catch (CommandProcessorException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof HiveException));
                Assert.assertTrue((boolean)e.getCause().getMessage().contains("Spark job failed due to task failures"));
                Assert.assertTrue((boolean)e.getCause().getMessage().contains("kv1.txt is not a Parquet file. expected magic number at tail [80, 65, 82, 49] but found [95, 57, 55, 10]"));
            }
        }
        finally {
            if (driver != null) {
                driver.run("DROP TABLE IF EXISTS test_table");
                driver.destroy();
            }
            if (fs.exists(tmpDir)) {
                fs.delete(tmpDir, true);
            }
        }
    }
}

