/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.base.Ticker;
import com.google.common.testing.FakeTicker;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.ql.exec.spark.SmallTableCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSmallTableCache {
    private static final String KEY = "Test";
    private static final String TEST_VALUE_1 = "TestValue1";
    private static final String TEST_VALUE_2 = "TestValue2";
    private SmallTableCache.SmallTableLocalCache<String, String> cache;
    private AtomicInteger counter;

    @Before
    public void setUp() {
        this.cache = new SmallTableCache.SmallTableLocalCache();
        this.counter = new AtomicInteger(0);
    }

    @Test
    public void testEmptyCache() throws ExecutionException {
        String res = (String)this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_1);
        });
        Assert.assertEquals((Object)TEST_VALUE_1, (Object)res);
        Assert.assertEquals((long)1L, (long)this.counter.get());
        Assert.assertEquals((long)1L, (long)this.cache.size());
    }

    @Test
    public void testL1Hit() throws ExecutionException {
        this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_1);
        });
        String res = (String)this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_2);
        });
        Assert.assertEquals((Object)TEST_VALUE_1, (Object)res);
        Assert.assertEquals((long)1L, (long)this.counter.get());
        Assert.assertEquals((long)1L, (long)this.cache.size());
    }

    @Test
    public void testL2Hit() throws ExecutionException {
        FakeTicker ticker = new FakeTicker();
        this.cache = new SmallTableCache.SmallTableLocalCache((Ticker)ticker);
        this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_1);
        });
        ticker.advance(60L, TimeUnit.SECONDS);
        String res = (String)this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_2);
        });
        Assert.assertEquals((Object)TEST_VALUE_1, (Object)res);
        Assert.assertEquals((long)1L, (long)this.counter.get());
        Assert.assertEquals((long)1L, (long)this.cache.size());
    }

    @Test
    public void testL2Miss() throws ExecutionException {
        FakeTicker ticker = new FakeTicker();
        this.cache = new SmallTableCache.SmallTableLocalCache((Ticker)ticker);
        this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_1);
        });
        ticker.advance(60L, TimeUnit.SECONDS);
        this.cache.cleanup();
        this.forceOOMToClearSoftValues();
        String res = (String)this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_2);
        });
        Assert.assertEquals((Object)TEST_VALUE_2, (Object)res);
        Assert.assertEquals((long)2L, (long)this.counter.get());
        Assert.assertEquals((long)1L, (long)this.cache.size());
    }

    @Test
    public void testL2IsNotClearedIfTheItemIsInL1() throws ExecutionException {
        FakeTicker ticker = new FakeTicker();
        this.cache = new SmallTableCache.SmallTableLocalCache((Ticker)ticker);
        this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_1);
        });
        this.forceOOMToClearSoftValues();
        ticker.advance(60L, TimeUnit.SECONDS);
        this.cache.cleanup();
        String res = (String)this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_2);
        });
        Assert.assertEquals((Object)TEST_VALUE_1, (Object)res);
        Assert.assertEquals((long)1L, (long)this.counter.get());
        Assert.assertEquals((long)1L, (long)this.cache.size());
    }

    @Test
    public void testClear() throws ExecutionException {
        this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_1);
        });
        this.cache.clear((k, v) -> {});
        Assert.assertEquals((long)1L, (long)this.counter.get());
        Assert.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test
    public void testPutL1() throws ExecutionException {
        this.cache.put((Object)KEY, (Object)new String(TEST_VALUE_1));
        String res = (String)this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_2);
        });
        Assert.assertEquals((Object)TEST_VALUE_1, (Object)res);
        Assert.assertEquals((long)0L, (long)this.counter.get());
    }

    @Test
    public void testPutL2() throws ExecutionException {
        FakeTicker ticker = new FakeTicker();
        this.cache = new SmallTableCache.SmallTableLocalCache((Ticker)ticker);
        this.cache.put((Object)KEY, (Object)new String(TEST_VALUE_1));
        String res = (String)this.cache.get((Object)KEY, () -> {
            this.counter.incrementAndGet();
            return new String(TEST_VALUE_2);
        });
        ticker.advance(60L, TimeUnit.SECONDS);
        this.cache.cleanup();
        Assert.assertEquals((Object)TEST_VALUE_1, (Object)res);
        Assert.assertEquals((long)0L, (long)this.counter.get());
    }

    private void forceOOMToClearSoftValues() {
        try {
            while (true) {
                Object[] objectArray = new Object[0x3FFFFFFF];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return;
        }
    }
}

