/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.KryoSerializer;
import org.apache.hadoop.hive.ql.exec.spark.RemoteHiveSparkClient;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.reexec.ReExecDriver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.spark.client.JobContext;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

@Ignore(value="HIVE-22944: Kryo 5 upgrade conflicts with Spark, which is not supported anymore")
public class TestHiveSparkClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetJobGroupAndDescription() throws Exception {
        String confDir = "../data/conf/spark/local/hive-site.xml";
        HiveConf.setHiveSiteLocation((URL)new File(confDir).toURI().toURL());
        HiveConf conf = new HiveConf();
        conf.setBoolVar(HiveConf.ConfVars.SPARK_OPTIMIZE_SHUFFLE_SERDE, false);
        conf.set("spark.local.dir", Paths.get(System.getProperty("test.tmp.dir"), "TestHiveSparkClient-local-dir").toString());
        SessionState.start((HiveConf)conf);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path tmpDir = new Path("TestHiveSparkClient-tmp");
        IDriver driver = null;
        JavaSparkContext sc = null;
        try {
            driver = DriverFactory.newDriver((HiveConf)conf);
            driver.run("create table test (col int)");
            String query = "select * from test order by col";
            ((ReExecDriver)driver).compile(query, true);
            List sparkTasks = Utilities.getSparkTasks((List)driver.getPlan().getRootTasks());
            Assert.assertEquals((long)1L, (long)sparkTasks.size());
            SparkTask sparkTask = (SparkTask)sparkTasks.get(0);
            conf.set("mapreduce.job.name", query);
            JobConf jobConf = new JobConf((Configuration)conf);
            SparkConf sparkConf = new SparkConf();
            sparkConf.setMaster("local");
            sparkConf.setAppName("TestHiveSparkClient-app");
            sc = new JavaSparkContext(sparkConf);
            byte[] jobConfBytes = KryoSerializer.serializeJobConf((JobConf)jobConf);
            byte[] scratchDirBytes = KryoSerializer.serialize((Object)tmpDir);
            byte[] sparkWorkBytes = KryoSerializer.serialize((Object)sparkTask.getWork());
            RemoteHiveSparkClient.JobStatusJob job = new RemoteHiveSparkClient.JobStatusJob(jobConfBytes, scratchDirBytes, sparkWorkBytes);
            JobContext mockJobContext = (JobContext)Mockito.mock(JobContext.class);
            Mockito.when((Object)mockJobContext.sc()).thenReturn((Object)sc);
            job.call(mockJobContext);
            Assert.assertTrue((boolean)sc.getLocalProperty("spark.job.description").contains(query));
            Assert.assertTrue((boolean)sc.getLocalProperty("spark.jobGroup.id").contains(((SparkWork)sparkTask.getWork()).getQueryId()));
        }
        finally {
            if (driver != null) {
                driver.run("drop table if exists test");
                driver.destroy();
            }
            if (sc != null) {
                sc.close();
            }
            if (fs.exists(tmpDir)) {
                fs.delete(tmpDir, true);
            }
        }
    }
}

