/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.ranger;

import com.sun.jersey.api.client.Client;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerExportPolicyList;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClientImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserGroupInformation.class})
public class TestRangerRestClient {
    @Mock
    private RangerRestClientImpl mockClient;
    @Mock
    private UserGroupInformation userGroupInformation;
    @Mock
    private HiveConf conf;

    @Before
    public void setup() throws Exception {
        PowerMockito.mockStatic(UserGroupInformation.class, (Class[])new Class[0]);
        Mockito.when((Object)UserGroupInformation.getLoginUser()).thenReturn((Object)this.userGroupInformation);
        Mockito.when((Object)this.userGroupInformation.doAs((PrivilegedAction)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)this.userGroupInformation.doAs((PrivilegedExceptionAction)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)this.mockClient.getRangerExportUrl(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.mockClient.getRangerImportUrl(Mockito.anyString(), Mockito.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY, TimeUnit.SECONDS)).thenReturn((Object)1L);
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_TOTAL_DURATION, TimeUnit.SECONDS)).thenReturn((Object)20L);
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_JITTER, TimeUnit.SECONDS)).thenReturn((Object)1L);
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_MAX_DELAY_BETWEEN_RETRIES, TimeUnit.SECONDS)).thenReturn((Object)10L);
        Mockito.when((Object)Float.valueOf(this.conf.getFloat(HiveConf.ConfVars.REPL_RETRY_BACKOFF_COEFFICIENT.varname, 1.0f))).thenReturn((Object)Float.valueOf(1.0f));
    }

    @Test
    public void testSuccessSimpleAuthCheckConnection() throws Exception {
        Mockito.when((Object)UserGroupInformation.isSecurityEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.mockClient.checkConnectionPlain(Mockito.anyString(), (HiveConf)Mockito.any(HiveConf.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockClient.checkConnection(Mockito.anyString(), (HiveConf)Mockito.any())).thenCallRealMethod();
        this.mockClient.checkConnection("http://localhost:6080/ranger", this.conf);
        ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(String.class);
        ((RangerRestClientImpl)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).checkConnectionPlain((String)urlCaptor.capture(), (HiveConf)Mockito.any(HiveConf.class));
        Assert.assertEquals((Object)"http://localhost:6080/ranger", (Object)urlCaptor.getValue());
        ArgumentCaptor privilegedActionArgumentCaptor = ArgumentCaptor.forClass(PrivilegedAction.class);
        ((UserGroupInformation)Mockito.verify((Object)this.userGroupInformation, (VerificationMode)Mockito.times((int)0))).doAs((PrivilegedAction)privilegedActionArgumentCaptor.capture());
    }

    @Test
    public void testSuccessSimpleAuthRangerExport() throws Exception {
        Mockito.when((Object)UserGroupInformation.isSecurityEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.mockClient.exportRangerPoliciesPlain(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (HiveConf)Mockito.any(HiveConf.class))).thenReturn((Object)new RangerExportPolicyList());
        Mockito.when((Object)this.mockClient.exportRangerPolicies(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (HiveConf)Mockito.any())).thenCallRealMethod();
        this.mockClient.exportRangerPolicies("http://localhost:6080/ranger", "db", "hive", this.conf);
        ArgumentCaptor urlCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor dbCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor serviceCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor confCaptor = ArgumentCaptor.forClass(HiveConf.class);
        ((RangerRestClientImpl)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).exportRangerPolicies((String)urlCaptor.capture(), (String)dbCaptor.capture(), (String)serviceCaptor.capture(), (HiveConf)confCaptor.capture());
        Assert.assertEquals((Object)"http://localhost:6080/ranger", (Object)urlCaptor.getValue());
        Assert.assertEquals((Object)"db", (Object)dbCaptor.getValue());
        Assert.assertEquals((Object)"hive", (Object)serviceCaptor.getValue());
        ArgumentCaptor privilegedActionArgumentCaptor = ArgumentCaptor.forClass(PrivilegedAction.class);
        ((UserGroupInformation)Mockito.verify((Object)this.userGroupInformation, (VerificationMode)Mockito.times((int)0))).doAs((PrivilegedAction)privilegedActionArgumentCaptor.capture());
    }

    @Test
    public void testRangerClientTimeouts() {
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_EXTERNAL_CLIENT_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS)).thenReturn((Object)20L);
        Mockito.when((Object)this.conf.getTimeVar(HiveConf.ConfVars.REPL_RANGER_CLIENT_READ_TIMEOUT, TimeUnit.MILLISECONDS)).thenReturn((Object)500L);
        Mockito.when((Object)this.mockClient.getRangerClient((HiveConf)Mockito.any(HiveConf.class))).thenCallRealMethod();
        Client client = this.mockClient.getRangerClient(this.conf);
        Assert.assertEquals((Object)20, client.getProperties().get("com.sun.jersey.client.property.connectTimeout"));
        Assert.assertEquals((Object)500, client.getProperties().get("com.sun.jersey.client.property.readTimeout"));
    }
}

