/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpTask;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.dump.HiveWrapper;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Utils.class, ReplDumpTask.class})
@PowerMockIgnore(value={"javax.management.*"})
public class TestReplDumpTask {
    protected static final Logger LOG = LoggerFactory.getLogger(TestReplDumpTask.class);
    @Mock
    private Hive hive;
    @Mock
    private HiveConf conf;
    @Mock
    private QueryState queryState;
    @Mock
    ReplicationMetricCollector metricCollector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TestException.class)
    public void removeDBPropertyToPreventRenameWhenBootstrapDumpOfTableFails() throws Exception {
        List<String> tableList = Arrays.asList("a1", "a2");
        String dbRandomKey = "akeytoberandom";
        ReplScope replScope = new ReplScope("default");
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Utils.matchesDb((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")))).thenReturn(Collections.singletonList("default"));
        PowerMockito.when((Object)Utils.getAllTables((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")), (ReplScope)((ReplScope)ArgumentMatchers.eq((Object)replScope)))).thenReturn(tableList);
        PowerMockito.when((Object)Utils.setDbBootstrapDumpState((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")))).thenReturn((Object)dbRandomKey);
        PowerMockito.when((Object)Utils.matchesTbl((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")), (ReplScope)((ReplScope)ArgumentMatchers.eq((Object)replScope)))).thenReturn(tableList);
        PowerMockito.when((Object)this.hive.getAllFunctions()).thenReturn(Collections.emptyList());
        PowerMockito.when((Object)this.queryState.getConf()).thenReturn((Object)this.conf);
        PowerMockito.when((Object)this.conf.getLong("hive.repl.last.repl.id", -1L)).thenReturn((Object)1L);
        PowerMockito.when((Object)this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_EXTERNAL_TABLES)).thenReturn((Object)false);
        PowerMockito.when((Object)HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.REPL_BOOTSTRAP_DUMP_OPEN_TXN_TIMEOUT)).thenReturn((Object)"1h");
        PowerMockito.when((Object)this.conf.getIntVar(HiveConf.ConfVars.REPL_FILE_LIST_CACHE_SIZE)).thenReturn((Object)10000);
        PowerMockito.whenNew(ReplExternalTables.Writer.class).withAnyArguments().thenReturn(Mockito.mock(ReplExternalTables.Writer.class));
        PowerMockito.whenNew(HiveWrapper.class).withAnyArguments().thenReturn(Mockito.mock(HiveWrapper.class));
        StubReplDumpTask task = new StubReplDumpTask(){
            private int tableDumpCount = 0;

            void dumpTable(String dbName, String tblName, String validTxnList, Path dbRootMetadata, Path dbRootData, long lastReplId, Hive hiveDb, HiveWrapper.Tuple<Table> tuple, FileList managedTableDirFileList, boolean dataCopyAtLoad) throws Exception {
                ++this.tableDumpCount;
                if (this.tableDumpCount > 1) {
                    throw new TestException();
                }
            }
        };
        task.initialize(this.queryState, null, null, null);
        ReplDumpWork replDumpWork = new ReplDumpWork(replScope, "", "");
        replDumpWork.setMetricCollector(this.metricCollector);
        task.setWork((Serializable)replDumpWork);
        try {
            task.bootStrapDump(new Path("mock"), new DumpMetaData(new Path("mock"), this.conf), (Path)Mockito.mock(Path.class), this.hive);
        }
        finally {
            Utils.resetDbBootstrapDumpState((Hive)((Hive)ArgumentMatchers.same((Object)this.hive)), (String)((String)ArgumentMatchers.eq((Object)"default")), (String)((String)ArgumentMatchers.eq((Object)dbRandomKey)));
        }
    }

    private static class TestException
    extends Exception {
        private TestException() {
        }
    }

    class StubReplDumpTask
    extends ReplDumpTask {
        StubReplDumpTask() {
        }

        protected Hive getHive() {
            return TestReplDumpTask.this.hive;
        }

        long currentNotificationId(Hive hiveDb) {
            return Long.MAX_VALUE;
        }

        String getValidTxnListForReplDump(Hive hiveDb, long waitUntilTime) {
            return "";
        }

        List<EximUtil.DataCopyPath> dumpFunctionMetadata(String dbName, Path dbMetadataRoot, Path dbDataRoot, Hive hiveDb, boolean copyAtLoad) {
            return Collections.emptyList();
        }

        Path dumpDbMetadata(String dbName, Path metadataRoot, long lastReplId, Hive hiveDb) {
            return (Path)Mockito.mock(Path.class);
        }

        void dumpConstraintMetadata(String dbName, String tblName, Path dbRoot, Hive hiveDb) {
        }
    }
}

