/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.RangerLoadTask;
import org.apache.hadoop.hive.ql.exec.repl.RangerLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerExportPolicyList;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerPolicy;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClient;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClientImpl;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class TestRangerLoadTask {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRangerLoadTask.class);
    private RangerLoadTask task;
    @Mock
    private RangerRestClientImpl mockClient;
    @Mock
    private HiveConf conf;
    @Mock
    private RangerLoadWork work;
    @Mock
    private ReplicationMetricCollector metricCollector;

    @Before
    public void setup() throws Exception {
        this.task = new RangerLoadTask((RangerRestClient)this.mockClient, this.conf, this.work);
        Mockito.when((Object)this.mockClient.changeDataSet(Mockito.anyList(), Mockito.anyString(), Mockito.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.mockClient.addDenyPolicies(Mockito.anyList(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.mockClient.checkConnection(Mockito.anyString(), (HiveConf)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.work.getMetricCollector()).thenReturn((Object)this.metricCollector);
    }

    @Test
    public void testFailureInvalidAuthProviderEndpoint() {
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)new Path("dumppath"));
        int status = this.task.execute();
        Assert.assertEquals((long)ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.getErrorCode(), (long)status);
    }

    @Test
    public void testSuccessValidAuthProviderEndpoint() throws MalformedURLException {
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn((Object)"rangerEndpoint");
        Mockito.when((Object)this.work.getSourceDbName()).thenReturn((Object)"srcdb");
        Mockito.when((Object)this.work.getTargetDbName()).thenReturn((Object)"tgtdb");
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)0L, (long)status);
    }

    @Test
    public void testSuccessNonEmptyRangerPolicies() throws Exception {
        String rangerResponse = "{\"metaDataInfo\":{\"Host name\":\"ranger.apache.org\",\"Exported by\":\"hive\",\"Export time\":\"May 5, 2020, 8:55:03 AM\",\"Ranger apache version\":\"2.0.0.7.2.0.0-61\"},\"policies\":[{\"service\":\"hive\",\"name\":\"db-level\",\"policyType\":0,\"description\":\"\",\"isAuditEnabled\":true,\"resources\":{\"database\":{\"values\":[\"aa\"],\"isExcludes\":false,\"isRecursive\":false},\"column\":{\"values\":[\"id\"],\"isExcludes\":false,\"isRecursive\":false},\"table\":{\"values\":[\"*\"],\"isExcludes\":false,\"isRecursive\":false}},\"policyItems\":[{\"accesses\":[{\"type\":\"select\",\"isAllowed\":true},{\"type\":\"update\",\"isAllowed\":true}],\"users\":[\"admin\"],\"groups\":[\"public\"],\"conditions\":[],\"delegateAdmin\":false}],\"denyPolicyItems\":[],\"allowExceptions\":[],\"denyExceptions\":[],\"dataMaskPolicyItems\":[],\"rowFilterPolicyItems\":[],\"id\":40,\"guid\":\"4e2b3406-7b9a-4004-8cdf-7a239c8e2cae\",\"isEnabled\":true,\"version\":1}]}";
        RangerExportPolicyList rangerPolicyList = (RangerExportPolicyList)new Gson().fromJson(rangerResponse, RangerExportPolicyList.class);
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn((Object)"rangerEndpoint");
        Mockito.when((Object)this.work.getSourceDbName()).thenReturn((Object)"srcdb");
        Mockito.when((Object)this.work.getTargetDbName()).thenReturn((Object)"tgtdb");
        Path rangerDumpPath = new Path("/tmp");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)rangerDumpPath);
        Mockito.when((Object)this.mockClient.readRangerPoliciesFromJsonFile((Path)Mockito.any(), (HiveConf)Mockito.any())).thenReturn((Object)rangerPolicyList);
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)0L, (long)status);
    }

    @Test
    public void testSuccessRangerDumpMetrics() throws Exception {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Whitebox.setInternalState(ReplState.class, (Object)logger, (Object[])new Object[0]);
        String rangerResponse = "{\"metaDataInfo\":{\"Host name\":\"ranger.apache.org\",\"Exported by\":\"hive\",\"Export time\":\"May 5, 2020, 8:55:03 AM\",\"Ranger apache version\":\"2.0.0.7.2.0.0-61\"},\"policies\":[{\"service\":\"cm_hive\",\"name\":\"db-level\",\"policyType\":0,\"description\":\"\",\"isAuditEnabled\":true,\"resources\":{\"database\":{\"values\":[\"aa\"],\"isExcludes\":false,\"isRecursive\":false},\"column\":{\"values\":[\"id\"],\"isExcludes\":false,\"isRecursive\":false},\"table\":{\"values\":[\"*\"],\"isExcludes\":false,\"isRecursive\":false}},\"policyItems\":[{\"accesses\":[{\"type\":\"select\",\"isAllowed\":true},{\"type\":\"update\",\"isAllowed\":true}],\"users\":[\"admin\"],\"groups\":[\"public\"],\"conditions\":[],\"delegateAdmin\":false}],\"denyPolicyItems\":[],\"allowExceptions\":[],\"denyExceptions\":[],\"dataMaskPolicyItems\":[],\"rowFilterPolicyItems\":[],\"id\":40,\"guid\":\"4e2b3406-7b9a-4004-8cdf-7a239c8e2cae\",\"isEnabled\":true,\"version\":1}]}";
        RangerExportPolicyList rangerPolicyList = (RangerExportPolicyList)new Gson().fromJson(rangerResponse, RangerExportPolicyList.class);
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn((Object)"rangerEndpoint");
        Mockito.when((Object)this.work.getSourceDbName()).thenReturn((Object)"srcdb");
        Mockito.when((Object)this.work.getTargetDbName()).thenReturn((Object)"tgtdb");
        Path rangerDumpPath = new Path("/tmp");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)rangerDumpPath);
        Mockito.when((Object)this.mockClient.readRangerPoliciesFromJsonFile((Path)Mockito.any(), (HiveConf)Mockito.any())).thenReturn((Object)rangerPolicyList);
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)0L, (long)status);
        ArgumentCaptor replStateCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Object.class);
        ArgumentCaptor eventDetailsCaptor = ArgumentCaptor.forClass(Object.class);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)2))).info((String)replStateCaptor.capture(), eventCaptor.capture(), eventDetailsCaptor.capture());
        Assert.assertEquals((Object)"REPL::{}: {}", replStateCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)"RANGER_LOAD_START", eventCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)"RANGER_LOAD_END", eventCaptor.getAllValues().get(1));
        Assert.assertTrue((boolean)eventDetailsCaptor.getAllValues().get(0).toString().contains("{\"sourceDbName\":\"srcdb\",\"targetDbName\":\"tgtdb\",\"estimatedNumPolicies\":1,\"loadStartTime\":"));
        Assert.assertTrue((boolean)eventDetailsCaptor.getAllValues().get(1).toString().contains("{\"sourceDbName\":\"srcdb\",\"targetDbName\":\"tgtdb\",\"actualNumPolicies\":1,\"loadEndTime\""));
    }

    @Test
    public void testSuccessAddDenyRangerPolicies() throws Exception {
        String rangerResponse = "{\"metaDataInfo\":{\"Host name\":\"ranger.apache.org\",\"Exported by\":\"hive\",\"Export time\":\"May 5, 2020, 8:55:03 AM\",\"Ranger apache version\":\"2.0.0.7.2.0.0-61\"},\"policies\":[{\"service\":\"hive\",\"name\":\"db-level\",\"policyType\":0,\"description\":\"\",\"isAuditEnabled\":true,\"resources\":{\"database\":{\"values\":[\"aa\"],\"isExcludes\":false,\"isRecursive\":false},\"column\":{\"values\":[\"id\"],\"isExcludes\":false,\"isRecursive\":false},\"table\":{\"values\":[\"*\"],\"isExcludes\":false,\"isRecursive\":false}},\"policyItems\":[{\"accesses\":[{\"type\":\"select\",\"isAllowed\":true},{\"type\":\"update\",\"isAllowed\":true}],\"users\":[\"admin\"],\"groups\":[\"public\"],\"conditions\":[],\"delegateAdmin\":false}],\"denyPolicyItems\":[],\"allowExceptions\":[],\"denyExceptions\":[],\"dataMaskPolicyItems\":[],\"rowFilterPolicyItems\":[],\"id\":40,\"guid\":\"4e2b3406-7b9a-4004-8cdf-7a239c8e2cae\",\"isEnabled\":true,\"version\":1}]}";
        RangerExportPolicyList rangerPolicyList = (RangerExportPolicyList)new Gson().fromJson(rangerResponse, RangerExportPolicyList.class);
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn((Object)"rangerEndpoint");
        Mockito.when((Object)this.work.getSourceDbName()).thenReturn((Object)"srcdb");
        Mockito.when((Object)this.work.getTargetDbName()).thenReturn((Object)"tgtdb");
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.service.name")).thenReturn((Object)"hive");
        Mockito.when((Object)this.conf.getBoolVar(HiveConf.ConfVars.REPL_RANGER_ADD_DENY_POLICY_TARGET)).thenReturn((Object)true);
        Path rangerDumpPath = new Path("/tmp");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)rangerDumpPath);
        Mockito.when((Object)this.mockClient.readRangerPoliciesFromJsonFile((Path)Mockito.any(), (HiveConf)Mockito.any())).thenReturn((Object)rangerPolicyList);
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)0L, (long)status);
        ArgumentCaptor rangerPolicyCapture = ArgumentCaptor.forClass(RangerExportPolicyList.class);
        ArgumentCaptor rangerEndpoint = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor serviceName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor targetDb = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor confCaptor = ArgumentCaptor.forClass(HiveConf.class);
        ((RangerRestClientImpl)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).importRangerPolicies((RangerExportPolicyList)rangerPolicyCapture.capture(), (String)targetDb.capture(), (String)rangerEndpoint.capture(), (String)serviceName.capture(), (HiveConf)confCaptor.capture());
        Assert.assertEquals((Object)"tgtdb", targetDb.getAllValues().get(0));
        Assert.assertEquals((Object)"rangerEndpoint", rangerEndpoint.getAllValues().get(0));
        Assert.assertEquals((Object)"hive", serviceName.getAllValues().get(0));
        RangerExportPolicyList actualPolicyList = (RangerExportPolicyList)rangerPolicyCapture.getAllValues().get(0);
        Assert.assertEquals((Object)rangerPolicyList.getMetaDataInfo(), (Object)actualPolicyList.getMetaDataInfo());
        Assert.assertEquals((long)2L, (long)actualPolicyList.getListSize());
        RangerPolicy denyPolicy = (RangerPolicy)actualPolicyList.getPolicies().get(1);
        Assert.assertEquals((Object)"hive", (Object)denyPolicy.getService());
        Assert.assertEquals((Object)"srcdb_replication deny policy for tgtdb", (Object)denyPolicy.getName());
        Assert.assertEquals((long)1L, (long)denyPolicy.getDenyExceptions().size());
        Assert.assertEquals((Object)"public", ((RangerPolicy.RangerPolicyItem)denyPolicy.getDenyPolicyItems().get(0)).getGroups().get(0));
        Assert.assertEquals((long)8L, (long)((RangerPolicy.RangerPolicyItem)denyPolicy.getDenyPolicyItems().get(0)).getAccesses().size());
        boolean isReplAdminDenied = false;
        for (RangerPolicy.RangerPolicyItemAccess access : ((RangerPolicy.RangerPolicyItem)denyPolicy.getDenyPolicyItems().get(0)).getAccesses()) {
            if (!access.getType().equalsIgnoreCase("ReplAdmin")) continue;
            isReplAdminDenied = true;
        }
        Assert.assertTrue((boolean)isReplAdminDenied);
        Assert.assertEquals((Object)"hive", ((RangerPolicy.RangerPolicyItem)denyPolicy.getDenyExceptions().get(0)).getUsers().get(0));
        Assert.assertEquals((long)10L, (long)((RangerPolicy.RangerPolicyItem)denyPolicy.getDenyExceptions().get(0)).getAccesses().size());
        isReplAdminDenied = false;
        for (RangerPolicy.RangerPolicyItemAccess access : ((RangerPolicy.RangerPolicyItem)denyPolicy.getDenyExceptions().get(0)).getAccesses()) {
            if (!access.getType().equalsIgnoreCase("ReplAdmin")) continue;
            isReplAdminDenied = true;
        }
        Assert.assertTrue((boolean)isReplAdminDenied);
    }

    @Test
    public void testSuccessDisableDenyRangerPolicies() throws Exception {
        String rangerResponse = "{\"metaDataInfo\":{\"Host name\":\"ranger.apache.org\",\"Exported by\":\"hive\",\"Export time\":\"May 5, 2020, 8:55:03 AM\",\"Ranger apache version\":\"2.0.0.7.2.0.0-61\"},\"policies\":[{\"service\":\"hive\",\"name\":\"db-level\",\"policyType\":0,\"description\":\"\",\"isAuditEnabled\":true,\"resources\":{\"database\":{\"values\":[\"aa\"],\"isExcludes\":false,\"isRecursive\":false},\"column\":{\"values\":[\"id\"],\"isExcludes\":false,\"isRecursive\":false},\"table\":{\"values\":[\"*\"],\"isExcludes\":false,\"isRecursive\":false}},\"policyItems\":[{\"accesses\":[{\"type\":\"select\",\"isAllowed\":true},{\"type\":\"update\",\"isAllowed\":true}],\"users\":[\"admin\"],\"groups\":[\"public\"],\"conditions\":[],\"delegateAdmin\":false}],\"denyPolicyItems\":[],\"allowExceptions\":[],\"denyExceptions\":[],\"dataMaskPolicyItems\":[],\"rowFilterPolicyItems\":[],\"id\":40,\"guid\":\"4e2b3406-7b9a-4004-8cdf-7a239c8e2cae\",\"isEnabled\":true,\"version\":1}]}";
        RangerExportPolicyList rangerPolicyList = (RangerExportPolicyList)new Gson().fromJson(rangerResponse, RangerExportPolicyList.class);
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn((Object)"rangerEndpoint");
        Mockito.when((Object)this.work.getSourceDbName()).thenReturn((Object)"srcdb");
        Mockito.when((Object)this.work.getTargetDbName()).thenReturn((Object)"tgtdb");
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.service.name")).thenReturn((Object)"hive");
        Mockito.when((Object)this.conf.getBoolVar(HiveConf.ConfVars.REPL_RANGER_ADD_DENY_POLICY_TARGET)).thenReturn((Object)false);
        Path rangerDumpPath = new Path("/tmp");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)rangerDumpPath);
        Mockito.when((Object)this.mockClient.readRangerPoliciesFromJsonFile((Path)Mockito.any(), (HiveConf)Mockito.any())).thenReturn((Object)rangerPolicyList);
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)0L, (long)status);
        ArgumentCaptor rangerPolicyCapture = ArgumentCaptor.forClass(RangerExportPolicyList.class);
        ArgumentCaptor rangerEndpoint = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor serviceName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor targetDb = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor confCaptor = ArgumentCaptor.forClass(HiveConf.class);
        ((RangerRestClientImpl)Mockito.verify((Object)this.mockClient, (VerificationMode)Mockito.times((int)1))).importRangerPolicies((RangerExportPolicyList)rangerPolicyCapture.capture(), (String)targetDb.capture(), (String)rangerEndpoint.capture(), (String)serviceName.capture(), (HiveConf)confCaptor.capture());
        Assert.assertEquals((Object)"tgtdb", targetDb.getAllValues().get(0));
        Assert.assertEquals((Object)"rangerEndpoint", rangerEndpoint.getAllValues().get(0));
        Assert.assertEquals((Object)"hive", serviceName.getAllValues().get(0));
        RangerExportPolicyList actualPolicyList = (RangerExportPolicyList)rangerPolicyCapture.getAllValues().get(0);
        Assert.assertEquals((Object)rangerPolicyList.getMetaDataInfo(), (Object)actualPolicyList.getMetaDataInfo());
        Assert.assertEquals((long)1L, (long)actualPolicyList.getListSize());
    }

    @Test
    public void testRangerEndpointCreation() throws Exception {
        RangerRestClientImpl rangerRestClient = new RangerRestClientImpl();
        Assert.assertTrue((boolean)rangerRestClient.getRangerExportUrl("http://ranger.apache.org:6080", "hive", "dbname").equals("http://ranger.apache.org:6080/service/plugins/policies/exportJson?serviceName=hive&polResource=dbname&resource%3Adatabase=dbname&serviceType=hive&resourceMatchScope=self_or_ancestor&resourceMatch=full"));
        Assert.assertTrue((boolean)rangerRestClient.getRangerExportUrl("http://ranger.apache.org:6080/", "hive", "dbname").equals("http://ranger.apache.org:6080/service/plugins/policies/exportJson?serviceName=hive&polResource=dbname&resource%3Adatabase=dbname&serviceType=hive&resourceMatchScope=self_or_ancestor&resourceMatch=full"));
        Assert.assertTrue((boolean)rangerRestClient.getRangerImportUrl("http://ranger.apache.org:6080/", "dbname").equals("http://ranger.apache.org:6080/service/plugins/policies/importPoliciesFromFile?updateIfExists=true&polResource=dbname&policyMatchingAlgorithm=matchByName"));
        Assert.assertTrue((boolean)rangerRestClient.getRangerImportUrl("http://ranger.apache.org:6080", "dbname").equals("http://ranger.apache.org:6080/service/plugins/policies/importPoliciesFromFile?updateIfExists=true&polResource=dbname&policyMatchingAlgorithm=matchByName"));
    }

    @Test
    public void testChangeDataSet() throws Exception {
        RangerRestClientImpl rangerRestClient = new RangerRestClientImpl();
        String rangerResponse = "{\"metaDataInfo\":{\"Host name\":\"ranger.apache.org\",\"Exported by\":\"hive\",\"Export time\":\"May 5, 2020, 8:55:03 AM\",\"Ranger apache version\":\"2.0.0.7.2.0.0-61\"},\"policies\":[{\"service\":\"cm_hive\",\"name\":\"db-level\",\"policyType\":0,\"description\":\"\",\"isAuditEnabled\":true,\"resources\":{\"database\":{\"values\":[\"aa\"],\"isExcludes\":false,\"isRecursive\":false},\"column\":{\"values\":[\"id\"],\"isExcludes\":false,\"isRecursive\":false},\"table\":{\"values\":[\"*\"],\"isExcludes\":false,\"isRecursive\":false}},\"policyItems\":[{\"accesses\":[{\"type\":\"select\",\"isAllowed\":true},{\"type\":\"update\",\"isAllowed\":true}],\"users\":[\"admin\"],\"groups\":[\"public\"],\"conditions\":[],\"delegateAdmin\":false}],\"denyPolicyItems\":[],\"allowExceptions\":[],\"denyExceptions\":[],\"dataMaskPolicyItems\":[],\"rowFilterPolicyItems\":[],\"id\":40,\"guid\":\"4e2b3406-7b9a-4004-8cdf-7a239c8e2cae\",\"isEnabled\":true,\"version\":1}]}";
        RangerExportPolicyList rangerPolicyList = (RangerExportPolicyList)new Gson().fromJson(rangerResponse, RangerExportPolicyList.class);
        List rangerPolicies = rangerPolicyList.getPolicies();
        rangerRestClient.changeDataSet(rangerPolicies, null, null);
        this.assertEqualsRangerPolicies(rangerPolicies, rangerRestClient.changeDataSet(rangerPolicies, null, null), "aa");
        this.assertEqualsRangerPolicies(rangerPolicies, rangerRestClient.changeDataSet(rangerPolicies, "aa", null), "aa");
        this.assertEqualsRangerPolicies(rangerPolicies, rangerRestClient.changeDataSet(rangerPolicies, null, "aa"), "aa");
        this.assertEqualsRangerPolicies(rangerPolicies, rangerRestClient.changeDataSet(rangerPolicies, "aa", "aa"), "aa");
        this.assertNotEqualsRangerPolicies(rangerPolicies, rangerRestClient.changeDataSet(rangerPolicies, "aa", "tgt_aa"), "tgt_aa");
    }

    private void assertNotEqualsRangerPolicies(List<RangerPolicy> expectedRangerPolicies, List<RangerPolicy> actualRangerPolicies, String targetName) {
        Assert.assertEquals((long)expectedRangerPolicies.size(), (long)actualRangerPolicies.size());
        for (int index = 0; index < expectedRangerPolicies.size(); ++index) {
            Assert.assertEquals((Object)expectedRangerPolicies.get(index).getName(), (Object)actualRangerPolicies.get(index).getName());
            Assert.assertEquals((Object)expectedRangerPolicies.get(index).getService(), (Object)actualRangerPolicies.get(index).getService());
            Assert.assertEquals((Object)expectedRangerPolicies.get(index).getDescription(), (Object)actualRangerPolicies.get(index).getDescription());
            Assert.assertEquals((Object)expectedRangerPolicies.get(index).getPolicyType(), (Object)actualRangerPolicies.get(index).getPolicyType());
            Assert.assertEquals((long)expectedRangerPolicies.get(index).getResources().size(), (long)actualRangerPolicies.get(index).getResources().size());
            Assert.assertEquals((long)expectedRangerPolicies.get(index).getResources().size(), (long)actualRangerPolicies.get(index).getResources().size());
            RangerPolicy.RangerPolicyResource expectedRangerPolicyResource = (RangerPolicy.RangerPolicyResource)expectedRangerPolicies.get(index).getResources().get("database");
            RangerPolicy.RangerPolicyResource actualRangerPolicyResource = (RangerPolicy.RangerPolicyResource)actualRangerPolicies.get(index).getResources().get("database");
            Assert.assertEquals((long)expectedRangerPolicyResource.getValues().size(), (long)actualRangerPolicyResource.getValues().size());
            for (int resourceIndex = 0; resourceIndex < expectedRangerPolicyResource.getValues().size(); ++resourceIndex) {
                Assert.assertEquals(actualRangerPolicyResource.getValues().get(index), (Object)targetName);
            }
        }
    }

    private void assertEqualsRangerPolicies(List<RangerPolicy> expectedRangerPolicies, List<RangerPolicy> actualRangerPolicies, String sourceName) {
        Assert.assertEquals((long)expectedRangerPolicies.size(), (long)actualRangerPolicies.size());
        for (int index = 0; index < expectedRangerPolicies.size(); ++index) {
            Assert.assertEquals((Object)expectedRangerPolicies.get(index).getName(), (Object)actualRangerPolicies.get(index).getName());
            Assert.assertEquals((Object)expectedRangerPolicies.get(index).getService(), (Object)actualRangerPolicies.get(index).getService());
            Assert.assertEquals((Object)expectedRangerPolicies.get(index).getDescription(), (Object)actualRangerPolicies.get(index).getDescription());
            Assert.assertEquals((Object)expectedRangerPolicies.get(index).getPolicyType(), (Object)actualRangerPolicies.get(index).getPolicyType());
            Assert.assertEquals((long)expectedRangerPolicies.get(index).getResources().size(), (long)actualRangerPolicies.get(index).getResources().size());
            Assert.assertEquals((long)expectedRangerPolicies.get(index).getResources().size(), (long)actualRangerPolicies.get(index).getResources().size());
            RangerPolicy.RangerPolicyResource expectedRangerPolicyResource = (RangerPolicy.RangerPolicyResource)expectedRangerPolicies.get(index).getResources().get("database");
            RangerPolicy.RangerPolicyResource actualRangerPolicyResource = (RangerPolicy.RangerPolicyResource)actualRangerPolicies.get(index).getResources().get("database");
            Assert.assertEquals((long)expectedRangerPolicyResource.getValues().size(), (long)actualRangerPolicyResource.getValues().size());
            for (int resourceIndex = 0; resourceIndex < expectedRangerPolicyResource.getValues().size(); ++resourceIndex) {
                Assert.assertEquals(expectedRangerPolicyResource.getValues().get(index), actualRangerPolicyResource.getValues().get(index));
                Assert.assertEquals(actualRangerPolicyResource.getValues().get(index), (Object)sourceName);
            }
        }
    }
}

