/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.RangerDumpTask;
import org.apache.hadoop.hive.ql.exec.repl.RangerDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerExportPolicyList;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClient;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClientImpl;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LoggerFactory.class})
public class TestRangerDumpTask {
    private RangerDumpTask task;
    @Mock
    private RangerRestClientImpl mockClient;
    @Mock
    private HiveConf conf;
    @Mock
    private RangerDumpWork work;
    @Mock
    private ReplicationMetricCollector metricCollector;

    @Before
    public void setup() throws Exception {
        this.task = new RangerDumpTask((RangerRestClient)this.mockClient, this.conf, this.work);
        Mockito.when((Object)this.mockClient.removeMultiResourcePolicies(Mockito.anyList())).thenCallRealMethod();
        Mockito.when((Object)this.mockClient.checkConnection(Mockito.anyString(), (HiveConf)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.work.getMetricCollector()).thenReturn((Object)this.metricCollector);
    }

    @Test
    public void testFailureInvalidAuthProviderEndpoint() throws Exception {
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn(null);
        Mockito.when((Object)this.work.getDbName()).thenReturn((Object)"testdb");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)new Path("/tmp"));
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.getErrorCode(), (long)status);
    }

    @Test
    public void testFailureInvalidRangerConfig() throws Exception {
        Mockito.when((Object)this.work.getDbName()).thenReturn((Object)"testdb");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)new Path("/tmp"));
        int status = this.task.execute();
        Assert.assertEquals((long)ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.getErrorCode(), (long)status);
    }

    @Test
    public void testSuccessValidAuthProviderEndpoint() throws Exception {
        RangerExportPolicyList rangerPolicyList = new RangerExportPolicyList();
        rangerPolicyList.setPolicies(new ArrayList());
        Mockito.when((Object)this.mockClient.exportRangerPolicies(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (HiveConf)Mockito.any())).thenReturn((Object)rangerPolicyList);
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn((Object)"rangerEndpoint");
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.service.name")).thenReturn((Object)"hive");
        Mockito.when((Object)this.work.getDbName()).thenReturn((Object)"testdb");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)new Path("/tmp"));
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)0L, (long)status);
    }

    @Test
    public void testSuccessNonEmptyRangerPolicies() throws Exception {
        String rangerResponse = "{\"metaDataInfo\":{\"Host name\":\"ranger.apache.org\",\"Exported by\":\"hive\",\"Export time\":\"May 5, 2020, 8:55:03 AM\",\"Ranger apache version\":\"2.0.0.7.2.0.0-61\"},\"policies\":[{\"service\":\"cm_hive\",\"name\":\"db-level\",\"policyType\":0,\"description\":\"\",\"isAuditEnabled\":true,\"resources\":{\"database\":{\"values\":[\"aa\"],\"isExcludes\":false,\"isRecursive\":false},\"column\":{\"values\":[\"id\"],\"isExcludes\":false,\"isRecursive\":false},\"table\":{\"values\":[\"*\"],\"isExcludes\":false,\"isRecursive\":false}},\"policyItems\":[{\"accesses\":[{\"type\":\"select\",\"isAllowed\":true},{\"type\":\"update\",\"isAllowed\":true}],\"users\":[\"admin\"],\"groups\":[\"public\"],\"conditions\":[],\"delegateAdmin\":false}],\"denyPolicyItems\":[],\"allowExceptions\":[],\"denyExceptions\":[],\"dataMaskPolicyItems\":[],\"rowFilterPolicyItems\":[],\"id\":40,\"guid\":\"4e2b3406-7b9a-4004-8cdf-7a239c8e2cae\",\"isEnabled\":true,\"version\":1}]}";
        RangerExportPolicyList rangerPolicyList = (RangerExportPolicyList)new Gson().fromJson(rangerResponse, RangerExportPolicyList.class);
        Mockito.when((Object)this.mockClient.exportRangerPolicies(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (HiveConf)Mockito.any())).thenReturn((Object)rangerPolicyList);
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn((Object)"rangerEndpoint");
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.service.name")).thenReturn((Object)"hive");
        Mockito.when((Object)this.work.getDbName()).thenReturn((Object)"testdb");
        Path rangerDumpPath = new Path("/tmp");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)rangerDumpPath);
        Path policyFile = new Path(rangerDumpPath, "ranger_policies.json");
        Mockito.when((Object)this.mockClient.saveRangerPoliciesToFile(rangerPolicyList, rangerDumpPath, "ranger_policies.json", this.conf)).thenReturn((Object)policyFile);
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)0L, (long)status);
    }

    @Test
    public void testSuccessRangerDumpMetrics() throws Exception {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Whitebox.setInternalState(ReplState.class, (Object)logger, (Object[])new Object[0]);
        RangerExportPolicyList rangerPolicyList = new RangerExportPolicyList();
        rangerPolicyList.setPolicies(new ArrayList());
        Mockito.when((Object)this.mockClient.exportRangerPolicies(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (HiveConf)Mockito.any())).thenReturn((Object)rangerPolicyList);
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.policy.rest.url")).thenReturn((Object)"rangerEndpoint");
        Mockito.when((Object)this.conf.get("ranger.plugin.hive.service.name")).thenReturn((Object)"hive");
        Mockito.when((Object)this.work.getDbName()).thenReturn((Object)"testdb");
        Mockito.when((Object)this.work.getCurrentDumpPath()).thenReturn((Object)new Path("/tmp"));
        Mockito.when((Object)this.work.getRangerConfigResource()).thenReturn((Object)new URL("file://ranger.xml"));
        int status = this.task.execute();
        Assert.assertEquals((long)0L, (long)status);
        ArgumentCaptor replStateCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Object.class);
        ArgumentCaptor eventDetailsCaptor = ArgumentCaptor.forClass(Object.class);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)2))).info((String)replStateCaptor.capture(), eventCaptor.capture(), eventDetailsCaptor.capture());
        Assert.assertEquals((Object)"REPL::{}: {}", replStateCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)"RANGER_DUMP_START", eventCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)"RANGER_DUMP_END", eventCaptor.getAllValues().get(1));
        Assert.assertTrue((boolean)eventDetailsCaptor.getAllValues().get(0).toString().contains("{\"dbName\":\"testdb\",\"dumpStartTime"));
        Assert.assertTrue((boolean)eventDetailsCaptor.getAllValues().get(1).toString().contains("{\"dbName\":\"testdb\",\"actualNumPolicies\":0,\"dumpEndTime\""));
    }
}

