/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.AtlasLoadTask;
import org.apache.hadoop.hive.ql.exec.repl.AtlasLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasReplInfo;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;

@RunWith(value=MockitoJUnitRunner.class)
public class TestAtlasLoadTask {
    private AtlasLoadTask atlasLoadTask;
    @Mock
    private HiveConf conf;
    @Mock
    private AtlasLoadWork work;
    @Mock
    private ReplicationMetricCollector metricCollector;

    @Test
    public void testAtlasLoadMetrics() throws Exception {
        Mockito.when((Object)this.work.getMetricCollector()).thenReturn((Object)this.metricCollector);
        this.atlasLoadTask = new AtlasLoadTask(this.conf, this.work);
        AtlasLoadTask atlasLoadTaskSpy = (AtlasLoadTask)Mockito.spy((Object)this.atlasLoadTask);
        Mockito.when((Object)this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL)).thenReturn((Object)true);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Whitebox.setInternalState(ReplState.class, (Object)logger, (Object[])new Object[0]);
        AtlasReplInfo atlasReplInfo = new AtlasReplInfo("http://localhost:21000/atlas", "srcDB", "tgtDB", "srcCluster", "tgtCluster", new Path("hdfs://tmp"), null, this.conf);
        atlasReplInfo.setSrcFsUri("hdfs://srcFsUri:8020");
        atlasReplInfo.setTgtFsUri("hdfs:tgtFsUri:8020");
        ((AtlasLoadTask)Mockito.doReturn((Object)atlasReplInfo).when((Object)atlasLoadTaskSpy)).createAtlasReplInfo();
        int status = atlasLoadTaskSpy.execute();
        Assert.assertEquals((long)0L, (long)status);
        ArgumentCaptor replStateCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Object.class);
        ArgumentCaptor eventDetailsCaptor = ArgumentCaptor.forClass(Object.class);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)2))).info((String)replStateCaptor.capture(), eventCaptor.capture(), eventDetailsCaptor.capture());
        Assert.assertEquals((Object)"REPL::{}: {}", replStateCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)"ATLAS_LOAD_START", eventCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)"ATLAS_LOAD_END", eventCaptor.getAllValues().get(1));
        Assert.assertTrue((boolean)eventDetailsCaptor.getAllValues().get(0).toString().contains("{\"sourceDbName\":\"srcDB\",\"targetDbName\":\"tgtDB\",\"loadStartTime\":"));
        Assert.assertTrue((boolean)eventDetailsCaptor.getAllValues().get(1).toString().contains("{\"sourceDbName\":\"srcDB\",\"targetDbName\":\"tgtDB\",\"numOfEntities\":0,\"loadEndTime\""));
    }
}

