/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinEagerRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;

class Utilities {
    Utilities() {
    }

    static void testEquality(MapJoinKeyObject key1, MapJoinKeyObject key2) {
        Assert.assertEquals((long)key1.hashCode(), (long)key2.hashCode());
        Assert.assertEquals((Object)key1, (Object)key2);
        Assert.assertEquals((long)key1.getKeyLength(), (long)key2.getKeyLength());
        Assert.assertTrue((boolean)key1.equals((Object)key2));
    }

    static MapJoinKeyObject serde(MapJoinKeyObject key, String columns, String types) throws Exception {
        MapJoinKeyObject result = new MapJoinKeyObject();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        LazyBinarySerDe serde = new LazyBinarySerDe();
        Properties props = new Properties();
        props.put("columns", columns);
        props.put("columns.types", types);
        serde.initialize(null, props, null);
        MapJoinObjectSerDeContext context = new MapJoinObjectSerDeContext((AbstractSerDe)serde, false);
        key.write(context, out);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        result.read(context, in, (Writable)new BytesWritable());
        return result;
    }

    static void testEquality(MapJoinRowContainer container1, MapJoinRowContainer container2) throws HiveException {
        Assert.assertEquals((long)container1.rowCount(), (long)container2.rowCount());
        AbstractRowContainer.RowIterator iter1 = container1.rowIter();
        AbstractRowContainer.RowIterator iter2 = container2.rowIter();
        List row1 = (List)iter1.first();
        List row2 = (List)iter2.first();
        while (row1 != null && row2 != null) {
            Assert.assertEquals((Object)row1, (Object)row2);
            row1 = (List)iter1.next();
            row2 = (List)iter2.next();
        }
    }

    static MapJoinEagerRowContainer serde(MapJoinRowContainer container, String columns, String types) throws Exception {
        MapJoinEagerRowContainer result = new MapJoinEagerRowContainer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        LazyBinarySerDe serde = new LazyBinarySerDe();
        Properties props = new Properties();
        props.put("columns", columns);
        props.put("columns.types", types);
        serde.initialize(null, props, null);
        MapJoinObjectSerDeContext context = new MapJoinObjectSerDeContext((AbstractSerDe)serde, true);
        container.write(context, out);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        result.read(context, in, (Writable)new BytesWritable());
        return result;
    }
}

