/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.persistence.PTFRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestRowContainer {
    @Test
    public void testSpillTimestamp() throws HiveException, SerDeException, IOException {
        int i;
        int blockSize = 10;
        Configuration cfg = new Configuration();
        RowContainer result = new RowContainer(blockSize, cfg, null);
        LazyBinarySerDe serde = new LazyBinarySerDe();
        Properties props = new Properties();
        props.put("columns", "x");
        props.put("columns.types", "array<string>");
        serde.initialize(null, props, null);
        result.setSerDe((AbstractSerDe)serde, ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)serde.getObjectInspector()));
        result.setTableDesc(PTFRowContainer.createTableDesc((StructObjectInspector)((StructObjectInspector)serde.getObjectInspector())));
        TimestampWritableV2 key = new TimestampWritableV2(Timestamp.ofEpochMilli((long)10L));
        result.setKeyObject((List)Lists.newArrayList((Object[])new TimestampWritableV2[]{key}));
        for (i = 0; i <= blockSize * 2; ++i) {
            ArrayList<Text> row = new ArrayList<Text>();
            row.add(new Text("" + i));
            result.addRow(row);
        }
        Assert.assertEquals((long)2L, (long)result.getNumFlushedBlocks());
        result.setKeyObject(null);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{0}).toString(), (Object)result.first().get(0).toString());
        for (i = 1; i < result.rowCount() - 1; ++i) {
            Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{i}).toString(), (Object)result.next().get(0).toString());
        }
        result.close();
    }
}

