/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMapRedTask {
    @Test
    public void mrTask_updates_Metrics() throws IOException {
        Metrics mockMetrics = (Metrics)Mockito.mock(Metrics.class);
        MapRedTask mapRedTask = new MapRedTask();
        mapRedTask.updateTaskMetrics(mockMetrics);
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.times((int)1))).incrementCounter("hive_mapred_tasks");
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.never())).incrementCounter("hive_tez_tasks");
        ((Metrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.never())).incrementCounter("hive_spark_tasks");
    }

    @Test
    public void mrTaskSumbitViaChildWithImpersonation() throws IOException, LoginException {
        Utils.getUGI().setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
        Context ctx = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)ctx.getLocalTmpPath()).thenReturn((Object)new Path(System.getProperty("java.io.tmpdir")));
        TaskQueue taskQueue = new TaskQueue(ctx);
        QueryState queryState = new QueryState.Builder().build();
        HiveConf conf = queryState.getConf();
        conf.setBoolVar(HiveConf.ConfVars.SUBMITVIACHILD, true);
        MapredWork mrWork = new MapredWork();
        mrWork.setMapWork((MapWork)Mockito.mock(MapWork.class));
        MapRedTask mrTask = (MapRedTask)Mockito.spy((Object)new MapRedTask());
        mrTask.setWork((Serializable)mrWork);
        mrTask.initialize(queryState, null, taskQueue, ctx);
        mrTask.jobExecHelper = (HadoopJobExecHelper)Mockito.mock(HadoopJobExecHelper.class);
        Mockito.when((Object)mrTask.jobExecHelper.progressLocal((Process)Mockito.any(Process.class), Mockito.anyString())).thenReturn((Object)0);
        mrTask.execute();
        ArgumentCaptor captor = ArgumentCaptor.forClass(String[].class);
        ((MapRedTask)Mockito.verify((Object)mrTask)).spawn(Mockito.anyString(), Mockito.anyString(), (String[])captor.capture());
        String expected = "HADOOP_PROXY_USER=" + Utils.getUGI().getUserName();
        Assert.assertTrue((boolean)Arrays.asList((Object[])captor.getValue()).contains(expected));
    }
}

