/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.TopNKeyFilter;
import org.apache.hadoop.hive.ql.exec.vector.VectorTopNKeyOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTopNKeyFilter {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestTopNKeyFilter.class.getName());
    public static final Comparator<TestKeyWrapper> TEST_KEY_WRAPPER_COMPARATOR = Comparator.comparingInt(o -> TestKeyWrapper.access$000(o));

    @Test
    public void testNothingCanBeForwardedIfTopNIs0() {
        TopNKeyFilter topNKeyFilter = new TopNKeyFilter(0, TEST_KEY_WRAPPER_COMPARATOR);
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(1)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(-1)), (Matcher)Matchers.is((Object)false));
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getEffectiveBoundaryChecks());
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getRepeated());
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getKeySetSize());
    }

    @Test
    public void testFirstTopNKeysCanBeForwarded() {
        TopNKeyFilter topNKeyFilter = new TopNKeyFilter(3, TEST_KEY_WRAPPER_COMPARATOR);
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(1)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(5)), (Matcher)Matchers.is((Object)true));
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getEffectiveBoundaryChecks());
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getRepeated());
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(10)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(11)), (Matcher)Matchers.is((Object)false));
        Assert.assertEquals((long)1L, (long)topNKeyFilter.getEffectiveBoundaryChecks());
        Assert.assertEquals((long)3L, (long)topNKeyFilter.getKeySetSize());
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(10)), (Matcher)Matchers.is((Object)true));
        Assert.assertEquals((long)2L, (long)topNKeyFilter.getEffectiveBoundaryChecks());
    }

    @Test
    public void testFirstTopNKeysCanBeForwardedDesc() {
        TopNKeyFilter topNKeyFilter = new TopNKeyFilter(3, TEST_KEY_WRAPPER_COMPARATOR.reversed());
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(10)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(5)), (Matcher)Matchers.is((Object)true));
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getEffectiveBoundaryChecks());
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getRepeated());
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(1)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(11)), (Matcher)Matchers.is((Object)true));
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getEffectiveBoundaryChecks());
        Assert.assertEquals((long)0L, (long)topNKeyFilter.getRepeated());
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(0)), (Matcher)Matchers.is((Object)false));
        Assert.assertEquals((long)1L, (long)topNKeyFilter.getEffectiveBoundaryChecks());
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(11)), (Matcher)Matchers.is((Object)true));
        Assert.assertEquals((long)1L, (long)topNKeyFilter.getRepeated());
        Assert.assertEquals((long)3L, (long)topNKeyFilter.getKeySetSize());
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(5)), (Matcher)Matchers.is((Object)true));
        Assert.assertEquals((long)2L, (long)topNKeyFilter.getEffectiveBoundaryChecks());
    }

    @Test
    public void testKeyCanNotBeForwardedIfItIsDroppedOutFromTopNKeys() {
        TopNKeyFilter topNKeyFilter = new TopNKeyFilter(2, TEST_KEY_WRAPPER_COMPARATOR);
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(1)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(3)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(2)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(3)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testMembersOfTopNKeysStillCanBeForwardedAfterNonTopNKeysTried() {
        TopNKeyFilter topNKeyFilter = new TopNKeyFilter(2, TEST_KEY_WRAPPER_COMPARATOR);
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(1)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(3)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(5)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(3)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(1)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testEfficiencyWhenEverythingIsForwarded() {
        TopNKeyFilter topNKeyFilter = new TopNKeyFilter(2, TEST_KEY_WRAPPER_COMPARATOR);
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(5)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(4)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(3)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(2)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(1)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Float.valueOf(topNKeyFilter.forwardingRatio()), (Matcher)Matchers.is((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void testEfficiencyWhenOnlyOneIsForwarded() {
        TopNKeyFilter topNKeyFilter = new TopNKeyFilter(1, TEST_KEY_WRAPPER_COMPARATOR);
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(1)), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(2)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(3)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(4)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)topNKeyFilter.canForward((KeyWrapper)new TestKeyWrapper(5)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Float.valueOf(topNKeyFilter.forwardingRatio()), (Matcher)Matchers.is((Object)Float.valueOf(0.2f)));
    }

    @Test
    public void testDisabling() {
        final TopNKeyFilter efficientFilter = new TopNKeyFilter(1, TEST_KEY_WRAPPER_COMPARATOR);
        efficientFilter.canForward((KeyWrapper)new TestKeyWrapper(1));
        efficientFilter.canForward((KeyWrapper)new TestKeyWrapper(2));
        efficientFilter.canForward((KeyWrapper)new TestKeyWrapper(3));
        final TopNKeyFilter inefficientFilter = new TopNKeyFilter(1, TEST_KEY_WRAPPER_COMPARATOR);
        inefficientFilter.canForward((KeyWrapper)new TestKeyWrapper(3));
        inefficientFilter.canForward((KeyWrapper)new TestKeyWrapper(2));
        inefficientFilter.canForward((KeyWrapper)new TestKeyWrapper(1));
        HashMap<KeyWrapper, TopNKeyFilter> filters = new HashMap<KeyWrapper, TopNKeyFilter>(){
            {
                this.put(new TestKeyWrapper(100), efficientFilter);
                this.put(new TestKeyWrapper(200), inefficientFilter);
            }
        };
        HashSet disabled = new HashSet();
        VectorTopNKeyOperator.checkTopNFilterEfficiency((Map)filters, disabled, (float)0.6f, (Logger)LOG, (long)1L);
        Assert.assertThat(disabled, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(disabled, (Matcher)Matchers.hasItem((Object)((Object)new TestKeyWrapper(200))));
    }

    private static class TestKeyWrapper
    extends KeyWrapper {
        private final int keyValue;

        TestKeyWrapper(int keyValue) {
            this.keyValue = keyValue;
        }

        public void getNewKey(Object row, ObjectInspector rowInspector) throws HiveException {
        }

        public void setHashKey() {
        }

        public KeyWrapper copyKey() {
            return new TestKeyWrapper(this.keyValue);
        }

        public void copyKey(KeyWrapper oldWrapper) {
        }

        public Object[] getKeyArray() {
            return new Object[0];
        }

        public boolean isCopy() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TestKeyWrapper that = (TestKeyWrapper)((Object)o);
            return this.keyValue == that.keyValue;
        }

        public int hashCode() {
            return Objects.hash(this.keyValue);
        }
    }
}

