/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.CheckResult;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Msck;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.RetryUtilities;
import org.apache.hadoop.hive.ql.exec.TestMsckCreatePartitionsInBatches;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMsckDropPartitionsInBatches {
    private static HiveConf hiveConf;
    private static Msck msck;
    private final String catName = "hive";
    private final String dbName = "default";
    private final String tableName = "test_msck_batch";
    private static IMetaStoreClient db;
    private List<String> repairOutput;
    private Table table;
    private final int noException = 1;
    private final int oneException = 2;
    private final int allException = 3;

    @BeforeClass
    public static void setupClass() throws Exception {
        hiveConf = new HiveConf(TestMsckCreatePartitionsInBatches.class);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_MSCK_REPAIR_BATCH_SIZE, 5);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)hiveConf);
        db = new HiveMetaStoreClient((Configuration)hiveConf);
        msck = new Msck(false, false);
        msck.init(Msck.getMsckConf((Configuration)hiveConf));
    }

    @Before
    public void before() throws Exception {
        this.createPartitionedTable("hive", "default", "test_msck_batch");
        this.table = db.getTable("hive", "default", "test_msck_batch");
        this.repairOutput = new ArrayList<String>();
    }

    @After
    public void after() throws Exception {
        this.cleanUpTableQuietly("hive", "default", "test_msck_batch");
    }

    private Table createPartitionedTable(String catName, String dbName, String tableName) throws Exception {
        try {
            db.dropTable(catName, dbName, tableName);
            Table table = new Table();
            table.setCatName(catName);
            table.setDbName(dbName);
            table.setTableName(tableName);
            FieldSchema col1 = new FieldSchema("key", "string", "");
            FieldSchema col2 = new FieldSchema("value", "int", "");
            FieldSchema col3 = new FieldSchema("city", "string", "");
            StorageDescriptor sd = new StorageDescriptor();
            sd.setSerdeInfo(new SerDeInfo());
            sd.setInputFormat(TextInputFormat.class.getCanonicalName());
            sd.setOutputFormat(HiveIgnoreKeyTextOutputFormat.class.getCanonicalName());
            sd.setCols(Arrays.asList(col1, col2));
            table.setPartitionKeys(Arrays.asList(col3));
            table.setSd(sd);
            db.createTable(table);
            return db.getTable(catName, dbName, tableName);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unable to drop and create table " + StatsUtils.getFullyQualifiedTableName((String)dbName, (String)tableName) + " because " + StringUtils.stringifyException((Throwable)exception)));
            throw exception;
        }
    }

    private void cleanUpTableQuietly(String catName, String dbName, String tableName) {
        try {
            db.dropTable(catName, dbName, tableName, true, true, true);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)exception)));
        }
    }

    private Set<CheckResult.PartitionResult> dropPartsNotInFs(int numOfParts) {
        HashSet<CheckResult.PartitionResult> partsNotInFs = new HashSet<CheckResult.PartitionResult>();
        for (int i = 0; i < numOfParts; ++i) {
            CheckResult.PartitionResult result = new CheckResult.PartitionResult();
            result.setTableName("test_msck_batch");
            result.setPartitionName("city=dummyCity_" + String.valueOf(i));
            partsNotInFs.add(result);
        }
        return partsNotInFs;
    }

    private int findMSB(int n) {
        int msbIndex = 0;
        Assert.assertTrue((String)"Only positive values expected", (n > 0 ? 1 : 0) != 0);
        while (n > 1) {
            n >>= 1;
            ++msbIndex;
        }
        return msbIndex;
    }

    private void runDropPartitions(int partCount, int batchSize, int maxRetries, int exceptionStatus) throws Exception {
        int[] expectedBatchSizes;
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        Set<CheckResult.PartitionResult> partsNotInFs = this.dropPartsNotInFs(partCount);
        int expectedCallCount = maxRetries;
        int lastBatchSize = batchSize;
        int actualBatchSize = batchSize;
        if (exceptionStatus == 2) {
            actualBatchSize = batchSize / 2;
        }
        if (exceptionStatus != 3) {
            expectedCallCount = partCount / actualBatchSize;
            if (expectedCallCount * actualBatchSize < partCount) {
                lastBatchSize = partCount - expectedCallCount * actualBatchSize;
                ++expectedCallCount;
            }
            if (exceptionStatus == 2) {
                ++expectedCallCount;
                ((IMetaStoreClient)Mockito.doThrow(MetaException.class).doCallRealMethod().doCallRealMethod().when((Object)spyDb)).dropPartitions((String)ArgumentMatchers.eq((Object)this.table.getCatName()), (String)ArgumentMatchers.eq((Object)this.table.getDbName()), (String)ArgumentMatchers.eq((Object)this.table.getTableName()), ArgumentMatchers.anyList(), (PartitionDropOptions)ArgumentMatchers.any(PartitionDropOptions.class));
            }
            expectedBatchSizes = new int[expectedCallCount];
            expectedBatchSizes[0] = Integer.min(partCount, batchSize);
            for (int i = 1; i < expectedCallCount - 1; ++i) {
                expectedBatchSizes[i] = Integer.min(partCount, actualBatchSize);
            }
            expectedBatchSizes[expectedCallCount - 1] = lastBatchSize;
            msck.dropPartitionsInBatches(spyDb, this.repairOutput, partsNotInFs, null, this.table, batchSize, 2, maxRetries);
        } else {
            if (maxRetries == 0) {
                expectedCallCount = this.findMSB(batchSize) + 1;
            }
            expectedBatchSizes = new int[expectedCallCount];
            for (int i = 0; i < expectedCallCount; ++i) {
                actualBatchSize = batchSize / (int)Math.pow(2.0, i);
                expectedBatchSizes[i] = Integer.min(partCount, actualBatchSize);
            }
            ((IMetaStoreClient)Mockito.doThrow(MetaException.class).when((Object)spyDb)).dropPartitions((String)ArgumentMatchers.eq((Object)this.table.getCatName()), (String)ArgumentMatchers.eq((Object)this.table.getDbName()), (String)ArgumentMatchers.eq((Object)this.table.getTableName()), ArgumentMatchers.anyList(), (PartitionDropOptions)ArgumentMatchers.any(PartitionDropOptions.class));
            Exception ex = null;
            try {
                msck.dropPartitionsInBatches(spyDb, this.repairOutput, partsNotInFs, null, this.table, batchSize, 2, maxRetries);
            }
            catch (Exception retryEx) {
                ex = retryEx;
            }
            Assert.assertFalse((String)"Exception was expected but was not thrown", (ex == null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Unexpected class of exception thrown", (boolean)(ex instanceof RetryUtilities.RetryException));
        }
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)expectedCallCount))).dropPartitions((String)ArgumentMatchers.eq((Object)this.table.getCatName()), (String)ArgumentMatchers.eq((Object)this.table.getDbName()), (String)ArgumentMatchers.eq((Object)this.table.getTableName()), (List)argument.capture(), (PartitionDropOptions)ArgumentMatchers.any(PartitionDropOptions.class));
        List droppedParts = argument.getAllValues();
        Assert.assertEquals((long)expectedCallCount, (long)droppedParts.size());
        for (int i = 0; i < expectedCallCount; ++i) {
            Assert.assertEquals((String)String.format("Unexpected batch size in attempt %d.  Expected: %d.  Found: %d", i + 1, expectedBatchSizes[i], ((List)droppedParts.get(i)).size()), (long)expectedBatchSizes[i], (long)((List)droppedParts.get(i)).size());
        }
    }

    private void runDropPartitions(int partCount, int batchSize) throws Exception {
        this.runDropPartitions(partCount, batchSize, 0, 1);
    }

    @Test
    public void testNumberOfDropPartitionsCalls() throws Exception {
        this.runDropPartitions(10, 5);
    }

    @Test
    public void testUnevenNumberOfCreatePartitionCalls() throws Exception {
        this.runDropPartitions(14, 5);
    }

    @Test
    public void testEqualNumberOfPartitions() throws Exception {
        this.runDropPartitions(13, 13);
    }

    @Test
    public void testSmallNumberOfPartitions() throws Exception {
        this.runDropPartitions(10, 20);
    }

    @Test
    public void testBatchingWhenException() throws Exception {
        this.runDropPartitions(23, 30, 0, 2);
    }

    @Test
    public void testRetriesExhaustedBatchSize() throws Exception {
        this.runDropPartitions(17, 30, 0, 3);
    }

    @Test
    public void testMaxRetriesReached() throws Exception {
        this.runDropPartitions(17, 30, 2, 3);
    }

    @Test
    public void testOneMaxRetries() throws Exception {
        this.runDropPartitions(17, 30, 1, 3);
    }
}

