/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.CheckResult;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Msck;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.RetryUtilities;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMsckCreatePartitionsInBatches {
    private static HiveConf hiveConf;
    private static Msck msck;
    private final String catName = "hive";
    private final String dbName = "default";
    private final String tableName = "test_msck_batch";
    private static IMetaStoreClient db;
    private List<String> repairOutput;
    private Table table;

    @BeforeClass
    public static void setupClass() throws HiveException, MetaException {
        hiveConf = new HiveConf(TestMsckCreatePartitionsInBatches.class);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_MSCK_REPAIR_BATCH_SIZE, 5);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)hiveConf);
        try {
            db = new HiveMetaStoreClient((Configuration)hiveConf);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
        msck = new Msck(false, false);
        msck.init(Msck.getMsckConf((Configuration)hiveConf));
    }

    @Before
    public void before() throws Exception {
        this.createPartitionedTable("hive", "default", "test_msck_batch");
        this.table = db.getTable("hive", "default", "test_msck_batch");
        this.repairOutput = new ArrayList<String>();
    }

    @After
    public void after() throws Exception {
        this.cleanUpTableQuietly("hive", "default", "test_msck_batch");
    }

    private Table createPartitionedTable(String catName, String dbName, String tableName) throws Exception {
        try {
            db.dropTable(catName, dbName, tableName);
            Table table = new Table();
            table.setCatName(catName);
            table.setDbName(dbName);
            table.setTableName(tableName);
            FieldSchema col1 = new FieldSchema("key", "string", "");
            FieldSchema col2 = new FieldSchema("value", "int", "");
            FieldSchema col3 = new FieldSchema("city", "string", "");
            StorageDescriptor sd = new StorageDescriptor();
            sd.setSerdeInfo(new SerDeInfo());
            sd.setInputFormat(TextInputFormat.class.getCanonicalName());
            sd.setOutputFormat(HiveIgnoreKeyTextOutputFormat.class.getCanonicalName());
            sd.setCols(Arrays.asList(col1, col2));
            table.setPartitionKeys(Arrays.asList(col3));
            table.setSd(sd);
            db.createTable(table);
            return db.getTable(catName, dbName, tableName);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unable to drop and create table " + StatsUtils.getFullyQualifiedTableName((String)dbName, (String)tableName) + " because " + StringUtils.stringifyException((Throwable)exception)));
            throw exception;
        }
    }

    private void cleanUpTableQuietly(String catName, String dbName, String tableName) {
        try {
            db.dropTable(catName, dbName, tableName);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)exception)));
        }
    }

    private Set<CheckResult.PartitionResult> createPartsNotInMs(int numOfParts) {
        HashSet<CheckResult.PartitionResult> partsNotInMs = new HashSet<CheckResult.PartitionResult>();
        for (int i = 0; i < numOfParts; ++i) {
            CheckResult.PartitionResult result = new CheckResult.PartitionResult();
            result.setPartitionName("city=dummyCity_" + String.valueOf(i));
            result.setTableName("dummyTable");
            partsNotInMs.add(result);
        }
        return partsNotInMs;
    }

    @Test
    public void testNumberOfCreatePartitionCalls() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(10);
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        msck.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 5, 2, 0);
        ArgumentCaptor ifNotExistsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor needResultsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor argParts = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)2))).add_partitions((List)argParts.capture(), ((Boolean)ifNotExistsArg.capture()).booleanValue(), ((Boolean)needResultsArg.capture()).booleanValue());
        List apds = argParts.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)5L, (long)((List)apds.get(0)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)5L, (long)((List)apds.get(1)).size());
        Assert.assertTrue((boolean)((Boolean)ifNotExistsArg.getValue()));
        Assert.assertFalse((boolean)((Boolean)needResultsArg.getValue()));
    }

    @Test
    public void testUnevenNumberOfCreatePartitionCalls() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(9);
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        msck.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 5, 2, 0);
        ArgumentCaptor ifNotExistsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor needResultsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor argParts = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)2))).add_partitions((List)argParts.capture(), ((Boolean)ifNotExistsArg.capture()).booleanValue(), ((Boolean)needResultsArg.capture()).booleanValue());
        List apds = argParts.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)5L, (long)((List)apds.get(0)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)4L, (long)((List)apds.get(1)).size());
        Assert.assertTrue((boolean)((Boolean)ifNotExistsArg.getValue()));
        Assert.assertFalse((boolean)((Boolean)needResultsArg.getValue()));
    }

    @Test
    public void testEqualNumberOfPartitions() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(13);
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        msck.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 13, 2, 0);
        ArgumentCaptor ifNotExistsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor needResultsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor argParts = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)1))).add_partitions((List)argParts.capture(), ((Boolean)ifNotExistsArg.capture()).booleanValue(), ((Boolean)needResultsArg.capture()).booleanValue());
        Assert.assertEquals((String)"Unexpected number of batch size", (long)13L, (long)((List)argParts.getValue()).size());
        Assert.assertTrue((boolean)((Boolean)ifNotExistsArg.getValue()));
        Assert.assertFalse((boolean)((Boolean)needResultsArg.getValue()));
    }

    @Test
    public void testSmallNumberOfPartitions() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(10);
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        msck.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 20, 2, 0);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)1))).add_partitions((List)Mockito.anyObject(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        ArgumentCaptor ifNotExistsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor needResultsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor argParts = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)1))).add_partitions((List)argParts.capture(), ((Boolean)ifNotExistsArg.capture()).booleanValue(), ((Boolean)needResultsArg.capture()).booleanValue());
        Assert.assertEquals((String)"Unexpected number of batch size", (long)10L, (long)((List)argParts.getValue()).size());
        Assert.assertTrue((boolean)((Boolean)ifNotExistsArg.getValue()));
        Assert.assertFalse((boolean)((Boolean)needResultsArg.getValue()));
    }

    @Test
    public void testBatchingWhenException() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(23);
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        ((IMetaStoreClient)Mockito.doThrow(MetaException.class).doCallRealMethod().doCallRealMethod().when((Object)spyDb)).add_partitions((List)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        msck.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 30, 2, 0);
        ArgumentCaptor ifNotExistsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor needResultsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor argParts = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)3))).add_partitions((List)argParts.capture(), ((Boolean)ifNotExistsArg.capture()).booleanValue(), ((Boolean)needResultsArg.capture()).booleanValue());
        List apds = argParts.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)23L, (long)((List)apds.get(0)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)15L, (long)((List)apds.get(1)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)8L, (long)((List)apds.get(2)).size());
        Assert.assertTrue((boolean)((Boolean)ifNotExistsArg.getValue()));
        Assert.assertFalse((boolean)((Boolean)needResultsArg.getValue()));
    }

    @Test
    public void testRetriesExhaustedBatchSize() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(17);
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        ((IMetaStoreClient)Mockito.doThrow(MetaException.class).when((Object)spyDb)).add_partitions((List)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        Exception ex = null;
        try {
            msck.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 30, 2, 0);
        }
        catch (Exception retryEx) {
            ex = retryEx;
        }
        Assert.assertFalse((String)"Exception was expected but was not thrown", (ex == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected class of exception thrown", (boolean)(ex instanceof RetryUtilities.RetryException));
        ArgumentCaptor ifNotExistsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor needResultsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor argParts = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)5))).add_partitions((List)argParts.capture(), ((Boolean)ifNotExistsArg.capture()).booleanValue(), ((Boolean)needResultsArg.capture()).booleanValue());
        List apds = argParts.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)17L, (long)((List)apds.get(0)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)15L, (long)((List)apds.get(1)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)7L, (long)((List)apds.get(2)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)3L, (long)((List)apds.get(3)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)1L, (long)((List)apds.get(4)).size());
        Assert.assertTrue((boolean)((Boolean)ifNotExistsArg.getValue()));
        Assert.assertFalse((boolean)((Boolean)needResultsArg.getValue()));
    }

    @Test
    public void testMaxRetriesReached() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(17);
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        ((IMetaStoreClient)Mockito.doThrow(MetaException.class).when((Object)spyDb)).add_partitions((List)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        Exception ex = null;
        try {
            msck.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 30, 2, 2);
        }
        catch (Exception retryEx) {
            ex = retryEx;
        }
        Assert.assertFalse((String)"Exception was expected but was not thrown", (ex == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected class of exception thrown", (boolean)(ex instanceof RetryUtilities.RetryException));
        ArgumentCaptor ifNotExistsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor needResultsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor argParts = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)2))).add_partitions((List)argParts.capture(), ((Boolean)ifNotExistsArg.capture()).booleanValue(), ((Boolean)needResultsArg.capture()).booleanValue());
        List apds = argParts.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)17L, (long)((List)apds.get(0)).size());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)15L, (long)((List)apds.get(1)).size());
        Assert.assertTrue((boolean)((Boolean)ifNotExistsArg.getValue()));
        Assert.assertFalse((boolean)((Boolean)needResultsArg.getValue()));
    }

    @Test
    public void testOneMaxRetries() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(17);
        IMetaStoreClient spyDb = (IMetaStoreClient)Mockito.spy((Object)db);
        ((IMetaStoreClient)Mockito.doThrow(MetaException.class).when((Object)spyDb)).add_partitions((List)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        Exception ex = null;
        try {
            msck.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 30, 2, 1);
        }
        catch (Exception retryEx) {
            ex = retryEx;
        }
        Assert.assertFalse((String)"Exception was expected but was not thrown", (ex == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected class of exception thrown", (boolean)(ex instanceof RetryUtilities.RetryException));
        ArgumentCaptor ifNotExistsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor needResultsArg = ArgumentCaptor.forClass(Boolean.class);
        ArgumentCaptor argParts = ArgumentCaptor.forClass(List.class);
        ((IMetaStoreClient)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)1))).add_partitions((List)argParts.capture(), ((Boolean)ifNotExistsArg.capture()).booleanValue(), ((Boolean)needResultsArg.capture()).booleanValue());
        List apds = argParts.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)17L, (long)((List)apds.get(0)).size());
        Assert.assertTrue((boolean)((Boolean)ifNotExistsArg.getValue()));
        Assert.assertFalse((boolean)((Boolean)needResultsArg.getValue()));
    }
}

