/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.KeyWrapperFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestKeyWrapperFactory {
    private KeyWrapperFactory factory;

    @Before
    public void setup() throws Exception {
        SessionState ss = new SessionState(new HiveConf());
        SessionState.setCurrentSessionState((SessionState)ss);
        ArrayList<Text> col1 = new ArrayList<Text>();
        col1.add(new Text("0"));
        col1.add(new Text("1"));
        col1.add(new Text("2"));
        col1.add(new Text("3"));
        TypeInfo col1Type = TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo);
        ArrayList<Text> cola = new ArrayList<Text>();
        cola.add(new Text("a"));
        cola.add(new Text("b"));
        cola.add(new Text("c"));
        TypeInfo colaType = TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo);
        try {
            ArrayList<ArrayList<Text>> data = new ArrayList<ArrayList<Text>>();
            data.add(col1);
            data.add(cola);
            ArrayList<String> names = new ArrayList<String>();
            names.add("col1");
            names.add("cola");
            ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
            typeInfos.add(col1Type);
            typeInfos.add(colaType);
            TypeInfo dataType = TypeInfoFactory.getStructTypeInfo(names, typeInfos);
            InspectableObject r = new InspectableObject();
            ObjectInspector[] oi = new ObjectInspector[1];
            r.o = data;
            oi[0] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)dataType);
            try {
                ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(colaType, "cola", "", false);
                ExprNodeEvaluator eval = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc);
                ExprNodeEvaluator[] evals = new ExprNodeEvaluator[]{eval};
                ObjectInspector resultOI = eval.initialize(oi[0]);
                ObjectInspector[] resultOIs = new ObjectInspector[]{resultOI};
                this.factory = new KeyWrapperFactory(evals, oi, resultOIs);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testKeyWrapperEqualsCopy() throws Exception {
        KeyWrapper w1 = this.factory.getKeyWrapper();
        KeyWrapper w2 = w1.copyKey();
        Assert.assertTrue((boolean)w1.equals(w2));
    }

    @Test
    public void testDifferentWrapperTypesUnequal() {
        KeyWrapperFactory keyWrapperFactory = this.factory;
        keyWrapperFactory.getClass();
        KeyWrapperFactory.TextKeyWrapper w3 = new KeyWrapperFactory.TextKeyWrapper(keyWrapperFactory, false);
        KeyWrapperFactory keyWrapperFactory2 = this.factory;
        keyWrapperFactory2.getClass();
        KeyWrapperFactory.ListKeyWrapper w4 = new KeyWrapperFactory.ListKeyWrapper(keyWrapperFactory2, false);
        Assert.assertFalse((boolean)w3.equals((Object)w4));
        Assert.assertFalse((boolean)w4.equals((Object)w3));
    }

    @Test
    public void testUnsetHashCode() {
        KeyWrapper w1 = this.factory.getKeyWrapper();
        KeyWrapper w2 = w1.copyKey();
        w1.setHashKey();
        Assert.assertTrue((boolean)w1.equals(w2));
    }
}

