/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.CollectOperator;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.CollectDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestExplainTask {
    private static final String BACKUP_ID = "backup-id-mock";
    private static final String AST = "ast-mock";
    private PrintStream out;
    private ExplainTask uut;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Before
    public void setUp() {
        this.uut = new ExplainTask();
        this.uut.conf = (HiveConf)Mockito.mock(HiveConf.class);
        this.out = (PrintStream)Mockito.mock(PrintStream.class);
        QueryState qs = (QueryState)Mockito.mock(QueryState.class);
        HiveConf hiveConf = new HiveConf();
        Mockito.when((Object)qs.getConf()).thenReturn((Object)hiveConf);
        this.uut.queryState = qs;
    }

    @Test
    public void testExplainDoesSortTopLevelMapEntries() throws Exception {
        LinkedHashMap<String, String> explainMap1 = new LinkedHashMap<String, String>();
        explainMap1.put("/k1", "v");
        explainMap1.put("k3", "v");
        explainMap1.put("hdfs:///k2", "v");
        explainMap1.put("hdfs:///k1", "v");
        LinkedHashMap<String, String> explainMap2 = new LinkedHashMap<String, String>();
        explainMap2.put("hdfs:///k1", "v");
        explainMap2.put("hdfs:///k2", "v");
        explainMap2.put("/k1", "v");
        explainMap2.put("k3", "v");
        String result1 = this.explainToString(explainMap1);
        String result2 = this.explainToString(explainMap2);
        Assert.assertEquals((String)"both maps should be ordered, regardless of input order", (Object)result1, (Object)result2);
    }

    @Test
    public void testExplainDoesSortPathAsStrings() throws Exception {
        LinkedHashMap<String, String> explainMap1 = new LinkedHashMap<String, String>();
        explainMap1.put("/k1", "v");
        explainMap1.put("k3", "v");
        explainMap1.put("hdfs:/k2", "v");
        explainMap1.put("hdfs:/k1", "v");
        LinkedHashMap<Path, String> explainMap2 = new LinkedHashMap<Path, String>();
        explainMap2.put(new Path("hdfs:/k1"), "v");
        explainMap2.put(new Path("hdfs:/k2"), "v");
        explainMap2.put(new Path("/k1"), "v");
        explainMap2.put(new Path("k3"), "v");
        String result1 = this.explainToString(explainMap1);
        String result2 = this.explainToString(explainMap2);
        Assert.assertEquals((String)"both maps should be sorted the same way", (Object)result1, (Object)result2);
    }

    @Test
    public void testExplainDoesSortMapValues() throws Exception {
        LinkedHashMap<String, String> explainMap1Val = new LinkedHashMap<String, String>();
        explainMap1Val.put("a", "v");
        explainMap1Val.put("b", "v");
        LinkedHashMap<String, LinkedHashMap<String, String>> explainMap1 = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        explainMap1.put("k", explainMap1Val);
        LinkedHashMap<String, String> explainMap2Val = new LinkedHashMap<String, String>();
        explainMap2Val.put("b", "v");
        explainMap2Val.put("a", "v");
        LinkedHashMap<String, LinkedHashMap<String, String>> explainMap2 = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        explainMap2.put("k", explainMap2Val);
        String result1 = this.explainToString(explainMap1);
        String result2 = this.explainToString(explainMap2);
        Assert.assertEquals((String)"both maps should be sorted the same way", (Object)result1, (Object)result2);
    }

    private <K, V> String explainToString(Map<K, V> explainMap) throws Exception {
        ExplainWork work = new ExplainWork();
        ParseContext pCtx = new ParseContext();
        HashMap<String, DummyOperator> topOps = new HashMap<String, DummyOperator>();
        DummyOperator scanOp = new DummyOperator(new DummyExplainDesc<K, V>(explainMap));
        topOps.put("sample", scanOp);
        pCtx.setTopOps(topOps);
        work.setParseContext(pCtx);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        work.setConfig(new ExplainConfiguration());
        ExplainTask newExplainTask = new ExplainTask();
        newExplainTask.queryState = this.uut.queryState;
        newExplainTask.getJSONLogicalPlan(new PrintStream((OutputStream)baos), work);
        baos.close();
        return baos.toString();
    }

    @Test
    public void testGetJSONDependenciesJsonShhouldMatch() throws Exception {
        ExplainWork work = this.mockExplainWork();
        Mockito.when((Object)work.getDependency()).thenReturn((Object)true);
        HashSet<ReadEntity> inputs = new HashSet<ReadEntity>();
        Table table = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)table.getCompleteName()).thenReturn((Object)"table-name-mock");
        Mockito.when((Object)table.getTableType()).thenReturn((Object)TableType.EXTERNAL_TABLE);
        ReadEntity input1 = (ReadEntity)Mockito.mock(ReadEntity.class);
        Mockito.when((Object)input1.getType()).thenReturn((Object)Entity.Type.TABLE);
        Mockito.when((Object)input1.getTable()).thenReturn((Object)table);
        inputs.add(input1);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.getCompleteName()).thenReturn((Object)"partition-name-mock");
        ReadEntity input2 = (ReadEntity)Mockito.mock(ReadEntity.class);
        Mockito.when((Object)input2.getType()).thenReturn((Object)Entity.Type.PARTITION);
        Mockito.when((Object)input2.getPartition()).thenReturn((Object)partition);
        inputs.add(input2);
        Mockito.when((Object)work.getInputs()).thenReturn(inputs);
        JsonNode result = this.objectMapper.readTree(ExplainTask.getJSONDependencies((ExplainWork)work).toString());
        JsonNode expected = this.objectMapper.readTree("{\"input_partitions\":[{\"partitionName\":\"partition-name-mock\"}],\"input_tables\":[{\"tablename\":\"table-name-mock\",\"tabletype\":\"EXTERNAL_TABLE\"}]}");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testGetJSONPlan() throws Exception {
        Mockito.when((Object)this.uut.conf.getVar(HiveConf.ConfVars.HIVESTAGEIDREARRANGE)).thenReturn((Object)"EXECUTION");
        Task<ExplainTask> mockTask = this.mockTask();
        Mockito.when((Object)mockTask.getId()).thenReturn((Object)"mockTaskId");
        ExplainWork explainWorkMock = this.mockExplainWork();
        Mockito.when((Object)mockTask.getWork()).thenReturn((Object)explainWorkMock);
        List<Task> tasks = Arrays.asList(mockTask);
        JsonNode result = this.objectMapper.readTree(this.uut.getJSONPlan(null, tasks, null, true, false, false, "Plan Optimized by CBO", null, null).toString());
        JsonNode expected = this.objectMapper.readTree("{\"cboInfo\":\"Plan Optimized by CBO\", \"STAGE DEPENDENCIES\":{\"mockTaskId\":{\"ROOT STAGE\":\"TRUE\",\"BACKUP STAGE\":\"backup-id-mock\"}},\"STAGE PLANS\":{\"mockTaskId\":{}}}");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testOutputDependenciesJsonShouldMatch() throws Exception {
        Task<ExplainTask> task = this.mockTask();
        JsonNode result = this.objectMapper.readTree(this.uut.outputDependencies(task, this.out, null, true, true, 0).toString());
        JsonNode expected = this.objectMapper.readTree("{\"ROOT STAGE\":\"TRUE\",\"BACKUP STAGE\":\"backup-id-mock\",\"TASK TYPE\":\"EXPLAIN\"}");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testGetJSONLogicalPlanJsonShouldMatch() throws Exception {
        JsonNode result = this.objectMapper.readTree(this.uut.getJSONLogicalPlan(null, this.mockExplainWork()).toString());
        JsonNode expected = this.objectMapper.readTree("{}");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testOutputMapJsonShouldMatch() throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("key-1", "value-1");
        map.put("spark-work", new SparkWork("spark-work"));
        List emptList = Collections.emptyList();
        map.put("empty-list", emptList);
        ArrayList<Object> tezList1 = new ArrayList<Object>(Arrays.asList(this.mockTezWorkDependency()));
        map.put("tez-list-1", tezList1);
        ArrayList<Object> tezList2 = new ArrayList<Object>(Arrays.asList(this.mockTezWorkDependency(), this.mockTezWorkDependency()));
        map.put("tez-list-2", tezList2);
        ArrayList<Object> sparkList1 = new ArrayList<Object>(Arrays.asList(this.mockSparkWorkDependency()));
        map.put("spark-list-1", sparkList1);
        ArrayList<Object> sparkList2 = new ArrayList<Object>(Arrays.asList(this.mockSparkWorkDependency(), this.mockSparkWorkDependency()));
        map.put("spark-list-2", sparkList2);
        LinkedHashMap<String, Object> innerMap = new LinkedHashMap<String, Object>();
        innerMap.put("inner-key-1", "inner-value-1");
        innerMap.put("inner-key-2", tezList1);
        map.put("map-1", innerMap);
        JsonNode result = this.objectMapper.readTree(this.uut.outputMap(map, false, null, false, true, 0).toString());
        JsonNode expected = this.objectMapper.readTree("{\"key-1\":\"value-1\",\"tez-list-2\":[{\"parent\":\"name\"},{\"parent\":\"name\"}],\"tez-list-1\":{\"parent\":\"name\"},\"empty-list\":\"[]\",\"spark-list-2\":[{\"parent\":\"mock-name\"},{\"parent\":\"mock-name\"}],\"spark-list-1\":{\"parent\":\"mock-name\"}, \"map-1\":\"{inner-key-1=inner-value-1, inner-key-2=[mock-tez-dependency]}\",\"spark-work\":{\"Spark\":{\"DagName:\":\"spark-work:2\"}}}");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testOutputPlanJsonShouldMatch() throws Exception {
        SparkWork work = new SparkWork("spark-work");
        JsonNode result = this.objectMapper.readTree(this.uut.outputPlan((Object)work, null, false, true, 0, null).toString());
        JsonNode expected = this.objectMapper.readTree("{\"Spark\":{\"DagName:\":\"spark-work:1\"}}");
        Assert.assertEquals((Object)expected, (Object)result);
        CollectOperator parentCollectOperator1 = new CollectOperator();
        CollectOperator child1 = new CollectOperator();
        parentCollectOperator1.setChildOperators(new ArrayList<CollectOperator>(Arrays.asList(child1)));
        parentCollectOperator1.setConf((OperatorDesc)new CollectDesc());
        result = this.objectMapper.readTree(this.uut.outputPlan((Object)parentCollectOperator1, null, false, true, 0, null).toString());
        expected = this.objectMapper.readTree("{\"Collect\":{\"children\":{}}}");
        Assert.assertEquals((Object)expected, (Object)result);
        CollectOperator parentCollectOperator2 = new CollectOperator();
        CollectOperator child2 = new CollectOperator();
        parentCollectOperator2.setChildOperators(new ArrayList<CollectOperator>(Arrays.asList(child1, child2)));
        parentCollectOperator2.setConf((OperatorDesc)new CollectDesc());
        result = this.objectMapper.readTree(this.uut.outputPlan((Object)parentCollectOperator2, null, false, true, 0, null).toString());
        expected = this.objectMapper.readTree("{\"Collect\":{\"children\":[{},{}]}}");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testCollectAuthRelatedEntitiesJsonShouldMatch() throws Exception {
        QueryState qs = (QueryState)Mockito.mock(QueryState.class);
        Mockito.when((Object)qs.getHiveOperation()).thenReturn((Object)HiveOperation.EXPLAIN);
        this.uut.queryState = qs;
        SessionState.start((HiveConf)new HiveConf(ExplainTask.class));
        HiveAuthenticationProvider authenticationProviderMock = (HiveAuthenticationProvider)Mockito.mock(HiveAuthenticationProvider.class);
        Mockito.when((Object)authenticationProviderMock.getUserName()).thenReturn((Object)"test-user");
        SessionState.get().setAuthenticator(authenticationProviderMock);
        SessionState.get().setAuthorizer((HiveAuthorizationProvider)Mockito.mock(HiveAuthorizationProvider.class));
        ExplainWork work = this.mockExplainWork();
        JsonNode result = this.objectMapper.readTree(this.uut.collectAuthRelatedEntities(null, work).toString());
        JsonNode expected = this.objectMapper.readTree("{\"CURRENT_USER\":\"test-user\",\"OPERATION\":\"EXPLAIN\",\"INPUTS\":[],\"OUTPUTS\":[]}");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testOutputPlanVectorizationJsonShouldMatch() throws Exception {
        QueryState qs = (QueryState)Mockito.mock(QueryState.class);
        Mockito.when((Object)qs.getHiveOperation()).thenReturn((Object)HiveOperation.EXPLAIN);
        HiveConf hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        Mockito.when((Object)qs.getConf()).thenReturn((Object)hiveConf);
        this.uut.queryState = qs;
        JsonNode result = this.objectMapper.readTree(((JSONObject)this.uut.outputPlanVectorization(null, true).getRight()).toString());
        JsonNode expected = this.objectMapper.readTree("{\"enabled\":true,\"enabledConditionsMet\":[\"hive.vectorized.execution.enabled IS true\"]}");
        Assert.assertEquals((Object)expected, (Object)result);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        result = this.objectMapper.readTree(((JSONObject)this.uut.outputPlanVectorization(null, true).getRight()).toString());
        expected = this.objectMapper.readTree("{\"enabled\":false,\"enabledConditionsNotMet\":[\"hive.vectorized.execution.enabled IS false\"]}");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private TezWork.Dependency mockTezWorkDependency() {
        TezWork.Dependency dep = (TezWork.Dependency)Mockito.mock(TezWork.Dependency.class);
        Mockito.when((Object)dep.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dep.toString()).thenReturn((Object)"mock-tez-dependency");
        return dep;
    }

    private SparkWork.Dependency mockSparkWorkDependency() {
        SparkWork.Dependency dep = (SparkWork.Dependency)Mockito.mock(SparkWork.Dependency.class);
        Mockito.when((Object)dep.getName()).thenReturn((Object)"mock-name");
        Mockito.when((Object)dep.toString()).thenReturn((Object)"mock-spark-dependency");
        return dep;
    }

    private ExplainWork mockExplainWork() {
        ExplainWork explainWork = (ExplainWork)Mockito.mock(ExplainWork.class);
        Mockito.when((Object)explainWork.isFormatted()).thenReturn((Object)true);
        Mockito.when((Object)explainWork.getAnalyzer()).thenReturn(Mockito.mock(BaseSemanticAnalyzer.class));
        return explainWork;
    }

    private Task<ExplainTask> mockTask() {
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)task.getType()).thenReturn((Object)StageType.EXPLAIN);
        Mockito.when((Object)task.isRootTask()).thenReturn((Object)true);
        Task backupTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)backupTask.getId()).thenReturn((Object)BACKUP_ID);
        Mockito.when((Object)task.getBackupTask()).thenReturn((Object)backupTask);
        return task;
    }

    public static class DummyOperator
    extends TableScanOperator {
        private static final long serialVersionUID = 1L;

        public DummyOperator(TableScanDesc conf) {
            this.setConf((OperatorDesc)conf);
        }
    }

    public static class DummyExplainDesc<K, V>
    extends TableScanDesc {
        private static final long serialVersionUID = 1L;
        private Map<K, V> explainResult;

        public DummyExplainDesc(Map<K, V> explainResult) {
            this.explainResult = explainResult;
        }

        @Explain(displayName="test", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Map<K, V> explainMethod() {
            return this.explainResult;
        }
    }
}

