/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConcurrentDppInserts {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestConcurrentDppInserts.class.getName());
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();
    int N = 3;
    int M = 3;
    int K = 3;
    CyclicBarrier barrier = new CyclicBarrier(this.N);
    Semaphore finished = new Semaphore(0);
    LinkedList<Exception> exceptions = new LinkedList();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        IDriver driver = TestConcurrentDppInserts.createDriver(false);
        TestConcurrentDppInserts.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table tu(i int) partitioned by (k string, p string)"}) {
            driver.run(cmd);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestConcurrentDppInserts.createDriver(false);
        TestConcurrentDppInserts.dropTables(driver);
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"tu"}) {
            driver.run("drop table if exists " + t);
        }
    }

    @Test(timeout=600000L)
    public void testConcurrentCreationOfSamePartition() throws Exception {
        ArrayList<InserterThread> threads = new ArrayList<InserterThread>();
        for (int i = 0; i < this.N; ++i) {
            InserterThread e = new InserterThread();
            e.start();
            threads.add(e);
        }
        this.finished.acquire(this.N);
        IDriver driver = TestConcurrentDppInserts.createDriver(true);
        driver.run("select p,count(i) as c from tu group by p");
        ArrayList res = new ArrayList();
        Assertions.assertEquals((int)0, (int)this.exceptions.size(), (String)(" there were exceptions: " + this.getExceptionMessages()));
        driver.getResults(res);
        Assertions.assertEquals((int)(this.K * this.M), (int)res.size());
        for (String row : res) {
            String[] parts = row.split("\t");
            Assertions.assertEquals((Object)Integer.toString(this.N), (Object)parts[1], (String)row);
        }
    }

    private String getExceptionMessages() {
        StringBuilder sb = new StringBuilder();
        for (Exception exception : this.exceptions) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(exception.getClass().getName() + ":" + exception.getMessage());
        }
        return sb.toString();
    }

    private static IDriver createDriver(boolean custom) {
        HiveConf conf = new HiveConf(TestConcurrentDppInserts.env_setup.getTestCtx().hiveConf);
        if (custom) {
            conf.setVar(HiveConf.ConfVars.HIVE_LOCK_FILE_MOVE_MODE, "all");
            conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
            conf.setTimeVar(HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES, 100L, TimeUnit.MILLISECONDS);
        }
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }

    class InserterThread
    extends Thread {
        InserterThread() {
        }

        @Override
        public void run() {
            try {
                IDriver driver = TestConcurrentDppInserts.createDriver(true);
                for (int i = 0; i < TestConcurrentDppInserts.this.K; ++i) {
                    this.doTest(driver, i);
                }
            }
            catch (Throwable t) {
                System.out.println(t);
            }
            finally {
                TestConcurrentDppInserts.this.finished.release();
            }
        }

        private void doTest(IDriver driver, int pIdx) {
            try {
                TestConcurrentDppInserts.this.barrier.await(30L, TimeUnit.SECONDS);
                ArrayList<String> parts = new ArrayList<String>();
                for (int i = 0; i < TestConcurrentDppInserts.this.M; ++i) {
                    parts.add(String.format("select %d as i,%d as p", TestConcurrentDppInserts.this.M * pIdx + i, TestConcurrentDppInserts.this.M * pIdx + i));
                }
                driver.run("insert into tu partition(k=1,p) (" + Joiner.on((String)" union all ").join(parts) + ")");
            }
            catch (Exception e) {
                LOG.info("Exception in InserterThread:", (Throwable)e);
                TestConcurrentDppInserts.this.exceptions.add(e);
            }
        }
    }
}

