/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClientWithLocalCache;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTestUtilities;
import org.apache.hadoop.hive.ql.txn.compactor.Initiator;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TxnCommandsBaseForTests.class);
    static final int BUCKET_COUNT = 2;
    @Rule
    public TestName testName = new TestName();
    protected HiveConf hiveConf;
    protected Driver d;
    protected TxnStore txnHandler;

    public TxnStore getTxnStore() {
        return this.txnHandler;
    }

    @Before
    public void setUp() throws Exception {
        this.setUpInternal();
        if (this.hiveConf.getBoolVar(HiveConf.ConfVars.MSC_CACHE_ENABLED)) {
            HiveMetaStoreClientWithLocalCache.init((Configuration)this.hiveConf);
        }
    }

    void initHiveConf() {
        this.hiveConf = new HiveConf(this.getClass());
    }

    void setUpInternal() throws Exception {
        this.initHiveConf();
        Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
        this.hiveConf.set("mapred.local.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "local");
        this.hiveConf.set("mapred.system.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "system");
        this.hiveConf.set("mapreduce.jobtracker.staging.root.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "staging");
        this.hiveConf.set("mapred.temp.dir", workDir + File.separator + this.getClass().getSimpleName() + File.separator + "mapred" + File.separator + "temp");
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, this.getWarehouseDir());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEINPUTFORMAT, HiveInputFormat.class.getName());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK, true);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.MERGE_SPLIT_UPDATE, (boolean)true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVESTATSCOLAUTOGATHER, false);
        this.hiveConf.setBoolean("mapred.input.dir.recursive", true);
        TestTxnDbUtil.setConfValues((Configuration)this.hiveConf);
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        TestTxnDbUtil.prepDb((Configuration)this.hiveConf);
        File f = new File(this.getWarehouseDir());
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(this.getWarehouseDir()).mkdirs()) {
            throw new RuntimeException("Could not create " + this.getWarehouseDir());
        }
        SessionState ss = SessionState.start((HiveConf)this.hiveConf);
        ss.applyAuthorizationPolicy();
        this.d = new Driver(new QueryState.Builder().withHiveConf(this.hiveConf).nonIsolated().build());
        this.d.setMaxRows(10000);
        this.dropTables();
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBL) + "(a int, b int) clustered by (a) into " + 2 + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBLPART) + "(a int, b int) partitioned by (p string) clustered by (a) into " + 2 + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL) + "(a int, b int) clustered by (a) into " + 2 + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL2) + "(a int, b int) clustered by (a) into " + 2 + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create temporary  table " + (Object)((Object)Table.ACIDTBL2) + "(a int, b int, c int) clustered by (c) into " + 2 + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDNONBUCKET) + "(a int, b int) stored as orc TBLPROPERTIES ('transactional'='false')");
    }

    protected void dropTables() throws Exception {
        for (Table t : Table.values()) {
            this.runStatementOnDriver("drop table if exists " + (Object)((Object)t));
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.d != null) {
                this.dropTables();
                this.d.close();
                this.d.destroy();
                this.d = null;
            }
        }
        finally {
            TestTxnDbUtil.cleanDb((Configuration)this.hiveConf);
            FileUtils.deleteDirectory((File)new File(this.getTestDataDir()));
        }
    }

    protected String getWarehouseDir() {
        return this.getTestDataDir() + "/warehouse";
    }

    protected abstract String getTestDataDir();

    public static List<String> stringifyValues(int[][] rowsIn) {
        assert (rowsIn.length > 0);
        int[][] rows = (int[][])rowsIn.clone();
        Arrays.sort(rows, new RowComp());
        ArrayList<String> rs = new ArrayList<String>();
        for (int[] row : rows) {
            assert (row.length > 0);
            StringBuilder sb = new StringBuilder();
            for (int value : row) {
                sb.append(value).append("\t");
            }
            sb.setLength(sb.length() - 1);
            rs.add(sb.toString());
        }
        return rs;
    }

    protected String makeValuesClause(int[][] rows) {
        return TestTxnCommands2.makeValuesClause(rows);
    }

    public static void runWorker(HiveConf hiveConf) throws Exception {
        TxnCommandsBaseForTests.runCompactorThread(hiveConf, CompactorTestUtilities.CompactorThreadType.WORKER);
    }

    public static void runCleaner(HiveConf hiveConf) throws Exception {
        Thread.sleep(MetastoreConf.getTimeVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_OPENTXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
        TxnCommandsBaseForTests.runCompactorThread(hiveConf, CompactorTestUtilities.CompactorThreadType.CLEANER);
    }

    public static void runInitiator(HiveConf hiveConf) throws Exception {
        TxnCommandsBaseForTests.runCompactorThread(hiveConf, CompactorTestUtilities.CompactorThreadType.INITIATOR);
    }

    private static void runCompactorThread(HiveConf hiveConf, CompactorTestUtilities.CompactorThreadType type) throws Exception {
        Initiator t;
        AtomicBoolean stop = new AtomicBoolean(true);
        switch (type) {
            case INITIATOR: {
                t = new Initiator();
                break;
            }
            case WORKER: {
                t = new Worker();
                break;
            }
            case CLEANER: {
                t = new Cleaner();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
            }
        }
        t.setThreadId((int)t.getId());
        t.setConf((Configuration)hiveConf);
        t.init(stop);
        t.run();
    }

    protected List<String> runStatementOnDriver(String stmt) throws Exception {
        LOG.info("Running the query: " + stmt);
        try {
            this.d.run(stmt);
        }
        catch (CommandProcessorException e) {
            throw new RuntimeException(stmt + " failed: " + (Object)((Object)e));
        }
        ArrayList<String> rs = new ArrayList<String>();
        this.d.getResults(rs);
        return rs;
    }

    protected CommandProcessorException runStatementOnDriverNegative(String stmt) {
        try {
            this.d.run(stmt);
        }
        catch (CommandProcessorException e) {
            return e;
        }
        throw new RuntimeException("Didn't get expected failure!");
    }

    void assertVectorized(boolean vectorized, String query) throws Exception {
        List<String> rs = this.runStatementOnDriver("EXPLAIN VECTORIZATION DETAIL " + query);
        for (String line : rs) {
            if (line == null || !line.contains("Execution mode: vectorized")) continue;
            Assert.assertTrue((String)"Was vectorized when it wasn't expected", (boolean)vectorized);
            return;
        }
        Assert.assertTrue((String)"Din't find expected 'vectorized' in plan", (!vectorized ? 1 : 0) != 0);
    }

    void assertExpectedFileSet(Set<String> expectedFiles, String rootPath, String tableName) throws Exception {
        Pattern pattern = Pattern.compile("(.+)/(" + tableName + "/[delete_delta|delta|base].+)");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        HashSet<String> actualFiles = new HashSet<String>();
        RemoteIterator remoteIterator = fs.listFiles(new Path(rootPath), true);
        while (remoteIterator.hasNext()) {
            String p;
            Matcher matcher;
            LocatedFileStatus lfs = (LocatedFileStatus)remoteIterator.next();
            if (lfs.isDirectory() || !org.apache.hadoop.hive.common.FileUtils.HIDDEN_FILES_PATH_FILTER.accept(lfs.getPath()) || !(matcher = pattern.matcher(p = lfs.getPath().toString())).matches()) continue;
            actualFiles.add(matcher.group(2));
        }
        Assert.assertEquals((String)"Unexpected file list", expectedFiles, actualFiles);
    }

    void checkExpected(List<String> rs, String[][] expected, String msg, Logger LOG, boolean checkFileName) {
        LOG.warn(this.testName.getMethodName() + ": read data(" + msg + "): ");
        this.logResult(LOG, rs);
        Assert.assertEquals((String)(this.testName.getMethodName() + ": " + msg + "; " + rs), (long)expected.length, (long)rs.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)("Actual line (data) " + i + " data: " + rs.get(i) + "; expected " + expected[i][0]), (boolean)rs.get(i).startsWith(expected[i][0]));
            if (!checkFileName) continue;
            Assert.assertTrue((String)("Actual line(file) " + i + " file: " + rs.get(i)), (rs.get(i).endsWith(expected[i][1]) || rs.get(i).matches(expected[i][1]) ? 1 : 0) != 0);
        }
    }

    void logResult(Logger LOG, List<String> rs) {
        StringBuilder sb = new StringBuilder();
        for (String s : rs) {
            sb.append(s).append('\n');
        }
        LOG.info(sb.toString());
    }

    protected void checkResult(String[][] expectedResult, String query, boolean isVectorized, String msg, Logger LOG) throws Exception {
        List<String> rs = this.runStatementOnDriver(query);
        this.checkExpected(rs, expectedResult, msg + (isVectorized ? " vect" : ""), LOG, !isVectorized);
        this.assertVectorized(isVectorized, query);
    }

    void dropTable(String[] tabs) throws Exception {
        for (String tab : tabs) {
            this.d.run("drop table if exists " + tab);
        }
    }

    Driver swapDrivers(Driver otherDriver) {
        Driver tmp = this.d;
        this.d = otherDriver;
        return tmp;
    }

    static class RowComp
    implements Comparator<int[]> {
        RowComp() {
        }

        @Override
        public int compare(int[] row1, int[] row2) {
            assert (row1 != null && row2 != null && row1.length == row2.length);
            for (int i = 0; i < row1.length; ++i) {
                int comp = Integer.compare(row1[i], row2[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    public static enum Table {
        ACIDTBL("acidTbl"),
        ACIDTBLPART("acidTblPart"),
        ACIDTBL2("acidTbl2"),
        NONACIDORCTBL("nonAcidOrcTbl"),
        NONACIDORCTBL2("nonAcidOrcTbl2"),
        NONACIDNONBUCKET("nonAcidNonBucket");

        final String name;

        public String toString() {
            return this.name;
        }

        private Table(String name) {
            this.name = name;
        }
    }
}

