/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnExIm
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnExIm.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnExIm.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.hiveConf.set(MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID.getVarname(), "true");
    }

    @Test
    public void testExportDefaultDb() throws Exception {
        this.testExport(true);
    }

    @Test
    public void testExportCustomDb() throws Exception {
        this.testExport(false);
    }

    private void testExport(boolean useDefualtDb) throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        String tblName = useDefualtDb ? "T" : "foo.T";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("drop table if exists TImport ");
        if (!useDefualtDb) {
            this.runStatementOnDriver("create database foo");
        }
        this.runStatementOnDriver("create table " + tblName + " (a int, b int) stored as ORC");
        this.runStatementOnDriver("create table TImport (a int, b int) stored as ORC TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into " + tblName + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs = this.runStatementOnDriver("select * from " + tblName + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(rows1), rs);
        String exportStmt = "export table " + tblName + " to '" + this.getTestDataDir() + "/export'";
        rs = this.runStatementOnDriver("explain " + exportStmt);
        StringBuilder sb = new StringBuilder("*** " + exportStmt);
        for (String r : rs) {
            sb.append("\n").append(r);
        }
        LOG.error(sb.toString());
        this.runStatementOnDriver(exportStmt);
        this.runStatementOnDriver("import table TImport from '" + this.getTestDataDir() + "/export'");
        List<String> rs1 = this.runStatementOnDriver("select * from TImport order by a, b");
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(rows1), rs1);
    }

    @Test
    public void testExportMerge() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists TImport ");
        this.runStatementOnDriver("create table T (a int, b int) stored as ORC");
        this.runStatementOnDriver("create table TImport (a int, b int) stored as ORC TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into T(a,b) " + this.makeValuesClause(rows1));
        this.runStatementOnDriver("update T set b = 17 where a = 1");
        int[][] rows2 = new int[][]{{1, 17}, {3, 4}};
        List<String> rs = this.runStatementOnDriver("select * from T order by a,b");
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(rows2), rs);
        String exportStmt = "export table T to '" + this.getTestDataDir() + "/export'";
        rs = this.runStatementOnDriver("explain " + exportStmt);
        StringBuilder sb = new StringBuilder("*** " + exportStmt);
        for (String r : rs) {
            sb.append("\n").append(r);
        }
        LOG.error(sb.toString());
        this.runStatementOnDriver(exportStmt);
        this.runStatementOnDriver("import table TImport from '" + this.getTestDataDir() + "/export'");
        List<String> rs1 = this.runStatementOnDriver("select * from TImport order by a, b");
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(rows2), rs1);
    }

    @Test
    public void testExportPart() throws Exception {
        int[][] rows1 = new int[][]{{1, 2, 1}, {3, 4, 2}};
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists TImport ");
        this.runStatementOnDriver("create table TImport (a int, b int) partitioned by (p int) stored as ORC TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int) stored as ORC");
        this.runStatementOnDriver("insert into T partition(p)" + this.makeValuesClause(rows1));
        this.runStatementOnDriver("export table T partition(p=1) to '" + this.getTestDataDir() + "/export'");
        this.runStatementOnDriver("import table TImport from '" + this.getTestDataDir() + "/export'");
        List<String> rs1 = this.runStatementOnDriver("select * from TImport order by a, b");
        int[][] res = new int[][]{{1, 2, 1}};
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(res), rs1);
    }

    @Test
    public void testExportPartPartial() throws Exception {
        int[][] rows1 = new int[][]{{1, 2, 1, 1}, {3, 4, 2, 2}, {5, 6, 1, 2}, {7, 8, 2, 2}};
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists TImport ");
        this.runStatementOnDriver("create table TImport (a int, b int) partitioned by (p int, q int) stored as ORC TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int, q int) stored as ORC");
        this.runStatementOnDriver("insert into T partition(p,q)" + this.makeValuesClause(rows1));
        this.runStatementOnDriver("export table T partition(p=1) to '" + this.getTestDataDir() + "/export'");
        this.runStatementOnDriver("import table TImport from '" + this.getTestDataDir() + "/export'");
        List<String> rs1 = this.runStatementOnDriver("select * from TImport order by a, b");
        int[][] res = new int[][]{{1, 2, 1, 1}, {5, 6, 1, 2}};
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(res), rs1);
    }

    @Test
    public void testExportPartPartial2() throws Exception {
        int[][] rows1 = new int[][]{{1, 2, 1, 1}, {3, 4, 2, 2}, {5, 6, 1, 2}, {7, 8, 2, 2}};
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists TImport ");
        this.runStatementOnDriver("create table TImport (a int, b int) partitioned by (p int, q int) stored as ORC TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int, q int) stored as ORC");
        this.runStatementOnDriver("insert into T partition(p,q)" + this.makeValuesClause(rows1));
        this.runStatementOnDriver("export table T partition(q=2) to '" + this.getTestDataDir() + "/export'");
        this.runStatementOnDriver("import table TImport from '" + this.getTestDataDir() + "/export'");
        List<String> rs1 = this.runStatementOnDriver("select * from TImport order by a, b");
        int[][] res = new int[][]{{3, 4, 2, 2}, {5, 6, 1, 2}, {7, 8, 2, 2}};
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(res), rs1);
    }

    @Test
    public void testExportPartPartial3() throws Exception {
        int[][] rows1 = new int[][]{{1, 1, 1, 2}, {3, 2, 3, 8}, {5, 1, 2, 6}, {7, 2, 2, 8}};
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists TImport ");
        this.runStatementOnDriver("create table TImport (a int) partitioned by (p int, q int, r int) stored as ORC TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table T (a int) partitioned by (p int, q int, r int) stored as ORC");
        this.runStatementOnDriver("insert into T partition(p,q,r)" + this.makeValuesClause(rows1));
        this.runStatementOnDriver("export table T partition(p=2,r=8) to '" + this.getTestDataDir() + "/export'");
        this.runStatementOnDriver("import table TImport from '" + this.getTestDataDir() + "/export'");
        List<String> rs1 = this.runStatementOnDriver("select * from TImport order by a");
        int[][] res = new int[][]{{3, 2, 3, 8}, {7, 2, 2, 8}};
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(res), rs1);
    }

    @Test
    public void testExportBucketed() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {1, 3}, {2, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + this.makeValuesClause(rows1));
        this.runStatementOnDriver("export table " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "  to '" + this.getTestDataDir() + "/export'");
        this.runStatementOnDriver("drop table if exists TImport ");
        this.runStatementOnDriver("create table TImport (a int, b int) clustered by (a) into 2 buckets stored as ORC TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("import table TImport from '" + this.getTestDataDir() + "/export'");
        List<String> rs1 = this.runStatementOnDriver("select * from TImport order by a, b");
        Assert.assertEquals((String)"Content didn't match rs", TestTxnExIm.stringifyValues(rows1), rs1);
    }

    @Ignore
    @Test
    public void testCTLT() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("create table T like " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " TBLPROPERTIES ('transactional'='true')");
        List<String> rs = this.runStatementOnDriver("show create table T");
        StringBuilder sb = new StringBuilder("*show create table");
        for (String r : rs) {
            sb.append("\n").append(r);
        }
        LOG.error(sb.toString());
    }

    @Test
    public void testImport() throws Exception {
        this.testImport(false, true);
    }

    @Test
    public void testImportVectorized() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.testImport(true, true);
    }

    @Test
    public void testImportNoTarget() throws Exception {
        this.testImport(false, false);
    }

    private void testImport(boolean isVectorized, boolean existingTarget) throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        if (existingTarget) {
            this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        }
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("insert into Tstage values(1,2),(3,4),(5,6)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T from '" + this.getWarehouseDir() + "/1'");
        String testQuery = isVectorized ? "select ROW__ID, a, b from T order by ROW__ID" : "select ROW__ID, a, b, INPUT__FILE__NAME from T order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":2}\t5\t6", "t/delta_0000001_0000001_0000/000000_0"}};
        this.checkResult(expected, testQuery, isVectorized, "import existing table");
        this.runStatementOnDriver("update T set a = 0 where b = 6");
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "t/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", "t/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t0\t6", "t/delta_0000002_0000002_0000/bucket_00000_0"}};
        this.checkResult(expected2, testQuery, isVectorized, "update imported table");
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands2.runWorker(this.hiveConf);
        String[][] expected3 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", ".*t/delta_0000001_0000002_v000002[4-5]/bucket_00000"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t3\t4", ".*t/delta_0000001_0000002_v000002[4-5]/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t0\t6", ".*t/delta_0000001_0000002_v000002[4-5]/bucket_00000"}};
        this.checkResult(expected3, testQuery, isVectorized, "minor compact imported table");
    }

    @Test
    public void testImportPartitioned() throws Exception {
        boolean isVectorized = false;
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int) stored as orc");
        this.runStatementOnDriver("create table Tstage (a int, b int) partitioned by (p int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(1,2,10),(3,4,11),(5,6,12)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("insert into T values(0,0,10)");
        this.runStatementOnDriver("import table T PARTITION(p=11) from '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T PARTITION(p=12) from '" + this.getWarehouseDir() + "/1'");
        String testQuery = isVectorized ? "select ROW__ID, a, b from T order by ROW__ID" : "select ROW__ID, a, b, INPUT__FILE__NAME from T order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t0", "t/p=10/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t3\t4", "t/p=11/delta_0000002_0000002_0000/000000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t5\t6", "t/p=12/delta_0000003_0000003_0000/000000_0"}};
        this.checkResult(expected, testQuery, isVectorized, "import existing table");
    }

    @Test
    public void testImportPartitionedOrc() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table Tstage (a int, b int) partitioned by (p int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("insert into Tstage values(1,2,10),(3,4,11),(5,6,12)");
        int[][] rows = new int[][]{{3}};
        List<String> rsTstagePartitionsProperties = this.runStatementOnDriver("show partitions Tstage");
        for (String rsTstagePartition : rsTstagePartitionsProperties) {
            List<String> rsPartitionProperties = this.runStatementOnDriver("describe formatted Tstage partition(" + rsTstagePartition + ")");
            Assert.assertEquals((String)("COLUMN_STATS_ACCURATE of partition " + rsTstagePartition + " of Tstage table"), (Object)true, (Object)rsPartitionProperties.contains("\tCOLUMN_STATS_ACCURATE\t{\\\"BASIC_STATS\\\":\\\"true\\\"}"));
            Assert.assertEquals((String)(" of partition " + rsTstagePartition + " of Tstage table"), (Object)true, (Object)rsPartitionProperties.contains("\tnumRows             \t1                   "));
        }
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T from '" + this.getWarehouseDir() + "/1'");
        List<String> rsTProperties = this.runStatementOnDriver("show tblproperties T");
        Assert.assertEquals((String)"COLUMN_STATS_ACCURATE of T table", (Object)false, (Object)rsTProperties.contains("COLUMN_STATS_ACCURATE\t{\"BASIC_STATS\":\"true\"}"));
        Assert.assertEquals((String)"numRows of T table", (Object)false, (Object)rsTProperties.contains("numRows\t3"));
        List<String> rsTPartitionsProperties = this.runStatementOnDriver("show partitions T");
        for (String rsTPartition : rsTPartitionsProperties) {
            List<String> rsPartitionProperties = this.runStatementOnDriver("describe formatted T partition(" + rsTPartition + ")");
            Assert.assertEquals((String)("COLUMN_STATS_ACCURATE of partition " + rsTPartition + " of T table"), (Object)false, (Object)rsPartitionProperties.contains("\tCOLUMN_STATS_ACCURATE\t{\\\"BASIC_STATS\\\":\\\"true\\\"}"));
            Assert.assertEquals((String)(" of partition " + rsTPartition + " of T table"), (Object)false, (Object)rsPartitionProperties.contains("\tnumRows             \t1                   "));
        }
        List<String> rs = this.runStatementOnDriver("select count(*) from T");
        Assert.assertEquals((String)"Rowcount of imported table", TestTxnCommands2.stringifyValues(rows), rs);
    }

    @Test
    public void testImportPartitionedCreate() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table Tstage (a int, b int) partitioned by (p int) stored as orc");
        int[][] data = new int[][]{{1, 2, 10}, {3, 4, 11}, {5, 6, 12}};
        this.runStatementOnDriver("insert into Tstage" + TestTxnCommands2.makeValuesClause(data));
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T PARTITION(p=10) from '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T PARTITION(p=11) from '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T PARTITION(p=12) from '" + this.getWarehouseDir() + "/1'");
        List<String> rs = this.runStatementOnDriver("select a, b, p from T order by a,b,p");
        Assert.assertEquals((String)"reading imported data", TestTxnCommands2.stringifyValues(data), rs);
        rs = this.runStatementOnDriver("select INPUT__FILE__NAME from T order by INPUT__FILE__NAME");
        Assert.assertEquals((long)3L, (long)rs.size());
        Assert.assertTrue((boolean)rs.get(0).contains("t/p=10/delta_0000001_0000001_0000/00000"));
        Assert.assertTrue((boolean)rs.get(1).contains("t/p=11/delta_0000002_0000002_0000/00000"));
        Assert.assertTrue((boolean)rs.get(2).contains("t/p=12/delta_0000003_0000003_0000/00000"));
    }

    @Test
    public void testImportPartitionedCreate2() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table Tstage (a int, b int) partitioned by (p int) stored as orc");
        int[][] data = new int[][]{{1, 2, 10}, {3, 4, 11}, {5, 6, 12}};
        this.runStatementOnDriver("insert into Tstage" + TestTxnCommands2.makeValuesClause(data));
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T from '" + this.getWarehouseDir() + "/1'");
        List<String> rs = this.runStatementOnDriver("select a, b, p from T order by a,b,p");
        Assert.assertEquals((String)"reading imported data", TestTxnCommands2.stringifyValues(data), rs);
        rs = this.runStatementOnDriver("select INPUT__FILE__NAME from T order by INPUT__FILE__NAME");
        Assert.assertEquals((long)3L, (long)rs.size());
        Assert.assertTrue((boolean)rs.get(0).contains("t/p=10/delta_0000001_0000001_0000/00000"));
        Assert.assertTrue((boolean)rs.get(1).contains("t/p=11/delta_0000001_0000001_0000/00000"));
        Assert.assertTrue((boolean)rs.get(2).contains("t/p=12/delta_0000001_0000001_0000/00000"));
    }

    @Test
    public void testMM() throws Exception {
        this.testMM(true, true);
    }

    @Test
    public void testMMFlatSource() throws Exception {
        this.testMM(true, false);
    }

    @Test
    public void testMMCreate() throws Exception {
        this.testMM(false, true);
    }

    @Ignore(value="in this case no transactional tables are involved")
    @Test
    public void testMMCreateFlatSource() throws Exception {
        this.testMM(false, false);
    }

    private void testMM(boolean existingTable, boolean isSourceMM) throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CREATE_TABLES_AS_INSERT_ONLY, (boolean)true);
        this.hiveConf.setBoolean("mapred.input.dir.recursive", true);
        int[][] data = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        if (existingTable) {
            this.runStatementOnDriver("create table T (a int, b int)");
        }
        this.runStatementOnDriver("create table Tstage (a int, b int)" + (isSourceMM ? "" : " tblproperties('transactional'='false')"));
        this.runStatementOnDriver("insert into Tstage" + TestTxnCommands2.makeValuesClause(data));
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T from '" + this.getWarehouseDir() + "/1'");
        List<String> rs = this.runStatementOnDriver("select a, b from T order by a, b");
        Assert.assertEquals((String)"reading imported data", TestTxnCommands2.stringifyValues(data), rs);
        rs = this.runStatementOnDriver("select INPUT__FILE__NAME from T order by INPUT__FILE__NAME");
        Assert.assertEquals((long)3L, (long)rs.size());
        for (String s : rs) {
            Assert.assertTrue((String)s, (boolean)s.contains("/delta_0000001_0000001_0000/"));
            Assert.assertTrue((String)s, (boolean)s.endsWith("/000000_0"));
        }
    }

    private void checkResult(String[][] expectedResult, String query, boolean isVectorized, String msg) throws Exception {
        this.checkResult(expectedResult, query, isVectorized, msg, LOG);
    }

    @Ignore
    @Test
    public void testMMExportAborted() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CREATE_TABLES_AS_INSERT_ONLY, (boolean)true);
        this.hiveConf.setBoolean("mapred.input.dir.recursive", true);
        int[][] data = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        int[][] dataAbort = new int[][]{{10, 2}};
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int)");
        this.runStatementOnDriver("create table Tstage (a int, b int)");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, (boolean)true);
        this.runStatementOnDriver("insert into Tstage" + TestTxnCommands2.makeValuesClause(dataAbort));
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, (boolean)false);
        this.runStatementOnDriver("insert into Tstage" + TestTxnCommands2.makeValuesClause(data));
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T from '" + this.getWarehouseDir() + "/1'");
        List<String> rs = this.runStatementOnDriver("select a, b from T order by a, b");
        Assert.assertEquals((String)"reading imported data", TestTxnCommands2.stringifyValues(data), rs);
    }

    @Test
    public void testImportOrc() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("insert into Tstage values(1,2),(3,4),(5,6)");
        int[][] rows = new int[][]{{3}};
        List<String> rsTStageProperties = this.runStatementOnDriver("show tblproperties Tstage");
        Assert.assertEquals((String)"COLUMN_STATS_ACCURATE of Tstage table", (Object)true, (Object)rsTStageProperties.contains("COLUMN_STATS_ACCURATE\t{\"BASIC_STATS\":\"true\"}"));
        Assert.assertEquals((String)"numRows of Tstage table", (Object)true, (Object)rsTStageProperties.contains("numRows\t3"));
        Assert.assertEquals((String)"numFiles of Tstage table", (Object)true, (Object)rsTStageProperties.contains("numFiles\t1"));
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("import table T from '" + this.getWarehouseDir() + "/1'");
        List<String> rsTProperties = this.runStatementOnDriver("show tblproperties T");
        Assert.assertEquals((String)"COLUMN_STATS_ACCURATE of T table", (Object)false, (Object)rsTProperties.contains("COLUMN_STATS_ACCURATE\t{\"BASIC_STATS\":\"true\"}"));
        Assert.assertEquals((String)"numRows of T table", (Object)false, (Object)rsTProperties.contains("numRows\t3"));
        List<String> rs = this.runStatementOnDriver("select count(*) from T");
        Assert.assertEquals((String)"Rowcount of imported table", TestTxnCommands2.stringifyValues(rows), rs);
    }
}

