/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.TestDbTxnManager2;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnCommands3
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnCommands3.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands3.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Test
    public void testRenameTable() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK, false);
        this.runStatementOnDriver("drop database if exists mydb1 cascade");
        this.runStatementOnDriver("drop database if exists mydb2 cascade");
        this.runStatementOnDriver("create database mydb1");
        this.runStatementOnDriver("create database mydb2");
        this.runStatementOnDriver("create table mydb1.T(a int, b int) stored as orc");
        this.runStatementOnDriver("insert into mydb1.T values(1,2),(4,5)");
        this.runStatementOnDriver("update mydb1.T set b = 6 where b = 5");
        this.runStatementOnDriver("alter table mydb1.T compact 'minor'");
        this.runStatementOnDriver("alter table mydb1.T RENAME TO mydb1.S");
        String testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from mydb1.S";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "s/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t4\t6", "s/delta_0000002_0000002_0000/bucket_00000_0"}};
        this.checkResult(expected, testQuery, false, "check data", LOG);
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TABLE='t'"));
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE where CQ_TABLE='t'"));
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from WRITE_SET where WS_TABLE='t'"));
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID where T2W_TABLE='t'"));
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from NEXT_WRITE_ID where NWI_TABLE='t'"));
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TABLE='s'"));
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE where CQ_TABLE='s'"));
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from WRITE_SET where WS_TABLE='s'"));
        Assert.assertEquals((long)3L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID where T2W_TABLE='s'"));
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from NEXT_WRITE_ID where NWI_TABLE='s'"));
        this.runStatementOnDriver("alter table mydb1.S RENAME TO mydb2.bar");
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)2L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TABLE='bar'"));
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE where CQ_TABLE='bar'"));
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from WRITE_SET where WS_TABLE='bar'"));
        Assert.assertEquals((long)4L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID where T2W_TABLE='bar'"));
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from NEXT_WRITE_ID where NWI_TABLE='bar'"));
    }

    @Test
    public void testDeleteEventPruningOn() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)true);
        this.testDeleteEventPruning();
    }

    @Test
    public void testDeleteEventPruningOff() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.FILTER_DELETE_EVENTS, (boolean)false);
        this.testDeleteEventPruning();
    }

    private void testDeleteEventPruning() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)true);
        this.dropTable(new String[]{"T"});
        this.runStatementOnDriver("create transactional table T(a int, b int) stored as orc");
        this.runStatementOnDriver("insert into T values(1,2),(4,5)");
        this.runStatementOnDriver("insert into T values(4,6),(1,3)");
        this.runStatementOnDriver("delete from T where a = 1");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, a, b from T order by a, b");
        boolean isVectorized = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        String testQuery = isVectorized ? "select ROW__ID, a, b from T order by a, b" : "select ROW__ID, a, b, INPUT__FILE__NAME from T order by a, b";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t4\t5", "warehouse/t/delta_0000001_0000001_0000/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t4\t6", "warehouse/t/delta_0000002_0000002_0000/bucket_00000"}};
        this.checkResult(expected, testQuery, isVectorized, "after delete", LOG);
        this.runStatementOnDriver("alter table T compact 'MAJOR'");
        TestTxnCommands3.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t4\t5", "warehouse/t/base_0000001/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t4\t6", "warehouse/t/base_0000002/bucket_00000"}};
        this.checkResult(expected2, testQuery, isVectorized, "after compaction", LOG);
    }

    @Test
    public void testAcidMetaColumsDecode() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.hiveConf.set(MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID.getVarname(), "true");
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        int[][] data1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into T" + this.makeValuesClause(data1));
        int[][] data2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into T" + this.makeValuesClause(data2));
        int[][] dataAll = new int[][]{{1, 2}, {3, 4}, {5, 6}, {7, 8}};
        this.hiveConf.setBoolVar(HiveConf.ConfVars.OPTIMIZE_ACID_META_COLUMNS, true);
        List<String> rs = this.runStatementOnDriver("select a, b from T order by a, b");
        Assert.assertEquals(TestTxnCommands3.stringifyValues(dataAll), rs);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.OPTIMIZE_ACID_META_COLUMNS, false);
        rs = this.runStatementOnDriver("select a, b from T order by a, b");
        Assert.assertEquals(TestTxnCommands3.stringifyValues(dataAll), rs);
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.OPTIMIZE_ACID_META_COLUMNS, true);
        rs = this.runStatementOnDriver("select a, b from T order by a, b");
        Assert.assertEquals(TestTxnCommands3.stringifyValues(dataAll), rs);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.OPTIMIZE_ACID_META_COLUMNS, false);
        rs = this.runStatementOnDriver("select a, b from T order by a, b");
        Assert.assertEquals(TestTxnCommands3.stringifyValues(dataAll), rs);
    }

    @Test
    public void testSdpoBucketed() throws Exception {
        this.testSdpoBucketed(true, true, 1);
        this.testSdpoBucketed(true, false, 1);
        this.testSdpoBucketed(false, true, 1);
        this.testSdpoBucketed(false, false, 1);
        this.testSdpoBucketed(true, true, 2);
        this.testSdpoBucketed(true, false, 2);
        this.testSdpoBucketed(false, true, 2);
        this.testSdpoBucketed(false, false, 2);
    }

    private void testSdpoBucketed(boolean isVectorized, boolean isSdpo, int bucketing_version) throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, isVectorized);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEOPTSORTDYNAMICPARTITION, isSdpo);
        this.runStatementOnDriver("drop table if exists acid_uap");
        this.runStatementOnDriver("create transactional table acid_uap(a int, b varchar(128)) partitioned by (ds string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('bucketing_version'='" + bucketing_version + "')");
        this.runStatementOnDriver("insert into table acid_uap partition (ds='tomorrow') values (1, 'bah'),(2, 'yah')");
        this.runStatementOnDriver("insert into table acid_uap partition (ds='today') values (1, 'bah'),(2, 'yah')");
        this.runStatementOnDriver("select a,b, ds from acid_uap order by a,b, ds");
        String testQuery = isVectorized ? "select ROW__ID, a, b, ds from acid_uap order by ds, a, b" : "select ROW__ID, a, b, ds, INPUT__FILE__NAME from acid_uap order by ds, a, b";
        String[][] expected = new String[][]{{"{\"writeid\":2,\"bucketid\":536936448,\"rowid\":0}\t1\tbah\ttoday", "warehouse/acid_uap/ds=today/delta_0000002_0000002_0000/bucket_00001_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t2\tyah\ttoday", "warehouse/acid_uap/ds=today/delta_0000002_0000002_0000/bucket_00000_0"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t1\tbah\ttomorrow", "warehouse/acid_uap/ds=tomorrow/delta_0000001_0000001_0000/bucket_00001_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t2\tyah\ttomorrow", "warehouse/acid_uap/ds=tomorrow/delta_0000001_0000001_0000/bucket_00000_0"}};
        this.checkResult(expected, testQuery, isVectorized, "after insert", LOG);
        this.runStatementOnDriver("update acid_uap set b = 'fred'");
        String[][] expected2 = new String[][]{{"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t1\tfred\ttoday", "warehouse/acid_uap/ds=today/delta_0000003_0000003_0000/bucket_00001_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t2\tfred\ttoday", "warehouse/acid_uap/ds=today/delta_0000003_0000003_0000/bucket_00000_0"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t1\tfred\ttomorrow", "warehouse/acid_uap/ds=tomorrow/delta_0000003_0000003_0000/bucket_00001_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t2\tfred\ttomorrow", "warehouse/acid_uap/ds=tomorrow/delta_0000003_0000003_0000/bucket_00000_0"}};
        this.checkResult(expected2, testQuery, isVectorized, "after update", LOG);
    }

    @Test
    public void testCleaner2() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)true);
        this.dropTable(new String[]{"T"});
        this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        this.runStatementOnDriver("insert into T values(0,2)");
        this.runStatementOnDriver("insert into T values(1,4)");
        Driver driver2 = new Driver(new QueryState.Builder().withHiveConf(this.hiveConf).build());
        driver2.setMaxRows(10000);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.hiveConf);
        HiveTxnManager txnMgr1 = TestDbTxnManager2.swapTxnManager(txnMgr2);
        Driver driver1 = this.swapDrivers(driver2);
        this.runStatementOnDriver("start transaction");
        String testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from T";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t2", "t/delta_0000001_0000001_0000/bucket_00000_0"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t1\t4", "t/delta_0000002_0000002_0000/bucket_00000_0"}};
        this.checkResult(expected, testQuery, false, "check data", LOG);
        txnMgr2 = TestDbTxnManager2.swapTxnManager(txnMgr1);
        driver2 = this.swapDrivers(driver1);
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands2.runWorker(this.hiveConf);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Path warehousePath = new Path(this.getWarehouseDir());
        FileStatus[] actualList = fs.listStatus(new Path(warehousePath + "/t"), FileUtils.HIDDEN_FILES_PATH_FILTER);
        String[] expectedList = new String[]{"/t/delta_0000001_0000002_v0000018", "/t/delta_0000001_0000001_0000", "/t/delta_0000002_0000002_0000"};
        TestTxnCommands3.checkExpectedFiles(actualList, expectedList, warehousePath.toString());
        TestTxnCommands2.runCleaner(this.hiveConf);
        actualList = fs.listStatus(new Path(warehousePath + "/t"), FileUtils.HIDDEN_FILES_PATH_FILTER);
        TestTxnCommands3.checkExpectedFiles(actualList, expectedList, warehousePath.toString());
        txnMgr1 = TestDbTxnManager2.swapTxnManager(txnMgr2);
        driver1 = this.swapDrivers(driver2);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("insert into T values(2,5)");
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands3.runWorker(this.hiveConf);
        TestTxnCommands3.runCleaner(this.hiveConf);
        expectedList = new String[]{"/t/delta_0000001_0000003_v0000020"};
        actualList = fs.listStatus(new Path(warehousePath + "/t"), FileUtils.HIDDEN_FILES_PATH_FILTER);
        TestTxnCommands3.checkExpectedFiles(actualList, expectedList, warehousePath.toString());
    }

    private static void checkExpectedFiles(FileStatus[] actualList, String[] expectedList, String filePrefix) throws Exception {
        HashSet<String> expectedSet = new HashSet<String>();
        HashSet<String> unexpectedSet = new HashSet<String>();
        for (String string : expectedList) {
            expectedSet.add(string);
        }
        for (String string : actualList) {
            String endOfPath = string.getPath().toString().substring(string.getPath().toString().indexOf(filePrefix) + filePrefix.length());
            if (expectedSet.remove(endOfPath)) continue;
            unexpectedSet.add(endOfPath);
        }
        Assert.assertTrue((String)("not found set: " + expectedSet + " unexpected set: " + unexpectedSet), (expectedSet.isEmpty() && unexpectedSet.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testCompactionAbort() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)true);
        this.dropTable(new String[]{"T"});
        this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        this.runStatementOnDriver("insert into T values(0,2)");
        this.runStatementOnDriver("insert into T values(1,4)");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, (boolean)true);
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands3.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0th compaction state", (Object)"failed", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        GetOpenTxnsResponse openResp = txnHandler.getOpenTxns();
        Assert.assertEquals((String)openResp.toString(), (long)1L, (long)openResp.getOpen_txnsSize());
        Assert.assertTrue((String)openResp.toString(), (boolean)BitSet.valueOf(openResp.getAbortedBits()).get(0));
        TestTxnCommands3.runCleaner(this.hiveConf);
        Assert.assertTrue((String)openResp.toString(), (boolean)BitSet.valueOf(openResp.getAbortedBits()).get(0));
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_COMPONENTS"));
        int highestCompactWriteId = TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select CC_HIGHEST_WRITE_ID from COMPLETED_COMPACTIONS");
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from TXN_COMPONENTS where TC_WRITEID=" + highestCompactWriteId)));
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, (boolean)false);
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands3.runWorker(this.hiveConf);
        resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)2L, (long)resp.getCompactsSize());
        Assert.assertTrue((String)"Unexpected compaction state", ("failed".equalsIgnoreCase(((ShowCompactResponseElement)resp.getCompacts().get(0)).getState()) && "ready for cleaning".equalsIgnoreCase(((ShowCompactResponseElement)resp.getCompacts().get(1)).getState()) || "ready for cleaning".equalsIgnoreCase(((ShowCompactResponseElement)resp.getCompacts().get(0)).getState()) && "failed".equalsIgnoreCase(((ShowCompactResponseElement)resp.getCompacts().get(1)).getState()) ? 1 : 0) != 0);
        TestTxnCommands3.runCleaner(this.hiveConf);
    }

    @Test
    public void testNotEnoughToCompact() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + " compact 'MAJOR'");
        TestTxnCommands3.runWorker(this.hiveConf);
        this.assertTableIsEmpty("TXN_COMPONENTS");
        TestTxnCommands3.runCleaner(this.hiveConf);
        this.assertTableIsEmpty("TXN_COMPONENTS");
    }

    @Test
    public void testNotEnoughToCompactNeedsCleaning() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + " compact 'MAJOR'");
        TestTxnCommands3.runWorker(this.hiveConf);
        this.assertTableIsEmpty("TXN_COMPONENTS");
        TestTxnCommands3.runCleaner(this.hiveConf);
        this.assertTableIsEmpty("TXN_COMPONENTS");
    }

    private void assertTableIsEmpty(String table) throws Exception {
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select * from " + table)), (long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)("select count(*) from " + table)));
    }

    private void assertOneTxn() throws Exception {
        Assert.assertEquals((String)TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from TXNS"), (long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXNS"));
    }
}

