/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.AcidHouseKeeperService;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.lockmgr.TestDbTxnManager2;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTestUtilities;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnCommands
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnCommands.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Override
    void initHiveConf() {
        super.initHiveConf();
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
    }

    @Test
    public void testInsertOverwrite() throws Exception {
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL2));
        this.runStatementOnDriver("create table " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL2) + "3(a int, b int) clustered by (a) into " + 2 + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where b = 2");
        Assert.assertEquals((long)1L, (long)rs.size());
        Assert.assertEquals((Object)"1", (Object)rs.get(0));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, true);
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " values(3,2)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, false);
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " values(5,6)");
        rs = this.runStatementOnDriver("select a from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a");
        Assert.assertEquals((long)2L, (long)rs.size());
        Assert.assertEquals((Object)"1", (Object)rs.get(0));
        Assert.assertEquals((Object)"5", (Object)rs.get(1));
    }

    @Ignore(value="not needed but useful for testing")
    @Test
    public void testNonAcidInsert() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL));
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + "(a,b) values(2,3)");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL));
    }

    private void dumpBucketData(TxnCommandsBaseForTests.Table table, long writeId, int stmtId, int bucketNum) throws Exception {
    }

    private void dumpTableData(TxnCommandsBaseForTests.Table table, long writeId, int stmtId) throws Exception {
        for (int bucketNum = 0; bucketNum < 2; ++bucketNum) {
            this.dumpBucketData(table, writeId, stmtId, bucketNum);
        }
    }

    @Test
    public void testSimpleAcidInsert() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows2));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Data didn't match inside tx (rs0)", allData, rs0);
        this.runStatementOnDriver("COMMIT WORK");
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 0);
        this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        CommandProcessorException e = this.runStatementOnDriverNegative("COMMIT");
        Assert.assertEquals((String)("Error didn't match: " + (Object)((Object)e)), (long)ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN.getErrorCode(), (long)e.getErrorCode());
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Data didn't match inside tx (rs0)", allData, rs1);
    }

    @Test
    public void testMmExim() throws Exception {
        String tableName = "mm_table";
        String importName = tableName + "_import";
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int, b int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver(String.format("insert into %s (a,b) %s", tableName, this.makeValuesClause(rows1)));
        this.runStatementOnDriver(String.format("insert into %s (a,b) %s", tableName, this.makeValuesClause(rows1)));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        Table table = msClient.getTable("default", tableName);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Path exportPath = new Path(table.getSd().getLocation() + "_export");
        fs.delete(exportPath, true);
        this.runStatementOnDriver(String.format("export table %s to '%s'", tableName, exportPath));
        List<String> paths = this.listPathsRecursive(fs, exportPath);
        this.verifyMmExportPaths(paths, 2);
        this.runStatementOnDriver(String.format("import table %s from '%s'", importName, exportPath));
        Table imported = msClient.getTable("default", importName);
        Assert.assertEquals((String)imported.toString(), (Object)"insert_only", imported.getParameters().get("transactional_properties"));
        Path importPath = new Path(imported.getSd().getLocation());
        Object[] stat = fs.listStatus(importPath, AcidUtils.hiddenFileFilter);
        Assert.assertEquals((String)Arrays.toString(stat), (long)1L, (long)stat.length);
        this.assertIsDelta((FileStatus)stat[0]);
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows1));
        allData.sort(null);
        Collections.sort(allData);
        List<String> rs = this.runStatementOnDriver(String.format("select a,b from %s order by a,b", importName));
        Assert.assertEquals((String)("After import: " + rs), allData, rs);
        this.runStatementOnDriver("drop table if exists " + importName);
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver(String.format("insert overwrite table %s %s", tableName, this.makeValuesClause(rows2)));
        fs.delete(exportPath, true);
        this.runStatementOnDriver(String.format("export table %s to '%s'", tableName, exportPath));
        paths = this.listPathsRecursive(fs, exportPath);
        this.verifyMmExportPaths(paths, 1);
        this.runStatementOnDriver(String.format("create table %s (a int, b int) stored as orc TBLPROPERTIES ('transactional'='false')", importName));
        this.runStatementOnDriver(String.format("import table %s from '%s'", importName, exportPath));
        imported = msClient.getTable("default", importName);
        Assert.assertNull((String)imported.toString(), imported.getParameters().get("transactional"));
        Assert.assertNull((String)imported.toString(), imported.getParameters().get("transactional_properties"));
        importPath = new Path(imported.getSd().getLocation());
        stat = fs.listStatus(importPath, AcidUtils.hiddenFileFilter);
        allData = TestTxnCommands.stringifyValues(rows2);
        Collections.sort(allData);
        rs = this.runStatementOnDriver(String.format("select a,b from %s order by a,b", importName));
        Assert.assertEquals((String)("After import: " + rs), allData, rs);
        this.runStatementOnDriver("drop table if exists " + importName);
        this.runStatementOnDriver("drop table if exists " + tableName);
        msClient.close();
    }

    private static void syncThreadStart(CountDownLatch cdlIn, CountDownLatch cdlOut) {
        cdlIn.countDown();
        try {
            cdlOut.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testParallelInsertStats() throws Exception {
        boolean hasStats;
        int TASK_COUNT = 4;
        String tableName = "mm_table";
        IMetaStoreClient msClient = this.prepareParallelTest(tableName, 0);
        String[] queries = new String[4];
        for (int i = 0; i < queries.length; ++i) {
            queries[i] = String.format("insert into %s (a) values (" + i + ")", tableName);
        }
        this.runParallelQueries(queries);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats(msClient, tableName);
        boolean bl = hasStats = 0 != stats.size();
        if (hasStats) {
            this.verifyLongStats(4, 0, 3, stats);
        }
        this.runStatementOnDriver(String.format("insert into %s (a) values (4)", tableName));
        if (!hasStats) {
            stats = this.getTxnTableStats(msClient, tableName);
            Assert.assertEquals((long)0L, (long)stats.size());
        }
        this.runStatementOnDriver(String.format("analyze table %s compute statistics for columns", tableName));
        this.verifyLongStats(5, 0, 4, this.getTxnTableStats(msClient, tableName));
    }

    private void verifyLongStats(int dvCount, int min, int max, List<ColumnStatisticsObj> stats) {
        Assert.assertEquals((long)1L, (long)stats.size());
        LongColumnStatsData data = stats.get(0).getStatsData().getLongStats();
        Assert.assertEquals((long)min, (long)data.getLowValue());
        Assert.assertEquals((long)max, (long)data.getHighValue());
        Assert.assertEquals((long)dvCount, (long)data.getNumDVs());
    }

    private void runParallelQueries(String[] queries) throws InterruptedException, ExecutionException {
        int i;
        ExecutorService executor = Executors.newFixedThreadPool(queries.length);
        CountDownLatch cdlIn = new CountDownLatch(queries.length);
        CountDownLatch cdlOut = new CountDownLatch(1);
        Future[] tasks = new Future[queries.length];
        for (i = 0; i < tasks.length; ++i) {
            tasks[i] = executor.submit(new QueryRunnable(this.hiveConf, queries[i], cdlIn, cdlOut));
        }
        cdlIn.await();
        cdlOut.countDown();
        for (i = 0; i < tasks.length; ++i) {
            tasks[i].get();
        }
    }

    private IMetaStoreClient prepareParallelTest(String tableName, int val) throws Exception, MetaException, TException, NoSuchObjectException {
        this.hiveConf.setBoolean("hive.stats.autogather", true);
        this.hiveConf.setBoolean("hive.stats.column.autogather", true);
        Hive.closeCurrent();
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (" + val + ")", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (" + val + ")", tableName));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)1L, (long)stats.size());
        return msClient;
    }

    @Test
    public void testAddAndDropConstraintAdvancingWriteIds() throws Exception {
        String tableName = "constraints_table";
        this.hiveConf.setBoolean("hive.stats.autogather", true);
        this.hiveConf.setBoolean("hive.stats.column.autogather", true);
        Hive.closeCurrent();
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int, b string) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (0)", tableName));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        String validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds before add constraint::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:1:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s  ADD CONSTRAINT a_PK PRIMARY KEY (`a`) DISABLE NOVALIDATE", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds after add constraint primary key::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:2:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s CHANGE COLUMN b b STRING NOT NULL", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds after add constraint not null::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:3:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s ADD CONSTRAINT check1 CHECK (a <= 25)", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds after add constraint check::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:4:9223372036854775807::", (Object)validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s ADD CONSTRAINT unique1 UNIQUE (a, b) DISABLE", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        LOG.info("ValidWriteIds after add constraint unique::" + validWriteIds);
        Assert.assertEquals((Object)"default.constraints_table:5:9223372036854775807::", (Object)validWriteIds);
        LOG.info("ValidWriteIds before drop constraint::" + validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s  DROP CONSTRAINT a_PK", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.constraints_table:6:9223372036854775807::", (Object)validWriteIds);
        LOG.info("ValidWriteIds after drop constraint primary key::" + validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s  DROP CONSTRAINT check1", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.constraints_table:7:9223372036854775807::", (Object)validWriteIds);
        LOG.info("ValidWriteIds after drop constraint check::" + validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s  DROP CONSTRAINT unique1", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.constraints_table:8:9223372036854775807::", (Object)validWriteIds);
        LOG.info("ValidWriteIds after drop constraint unique::" + validWriteIds);
        this.runStatementOnDriver(String.format("alter table %s CHANGE COLUMN b b STRING", tableName));
        validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        Assert.assertEquals((Object)"default.constraints_table:9:9223372036854775807::", (Object)validWriteIds);
    }

    @Test
    public void testParallelInsertAnalyzeStats() throws Exception {
        boolean hasStats;
        String tableName = "mm_table";
        IMetaStoreClient msClient = this.prepareParallelTest(tableName, 0);
        String[] queries = new String[]{String.format("insert into %s (a) values (999)", tableName), String.format("analyze table %s compute statistics for columns", tableName)};
        this.runParallelQueries(queries);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats(msClient, tableName);
        boolean bl = hasStats = 0 != stats.size();
        if (hasStats) {
            this.verifyLongStats(2, 0, 999, stats);
        }
        this.runStatementOnDriver(String.format("insert into %s (a) values (1000)", tableName));
        if (!hasStats) {
            stats = this.getTxnTableStats(msClient, tableName);
            Assert.assertEquals((long)0L, (long)stats.size());
        }
        this.runStatementOnDriver(String.format("analyze table %s compute statistics for columns", tableName));
        this.verifyLongStats(3, 0, 1000, this.getTxnTableStats(msClient, tableName));
    }

    @Test
    public void testParallelTruncateAnalyzeStats() throws Exception {
        boolean hasStats;
        String tableName = "mm_table";
        IMetaStoreClient msClient = this.prepareParallelTest(tableName, 0);
        String[] queries = new String[]{String.format("truncate table %s", tableName), String.format("analyze table %s compute statistics for columns", tableName)};
        this.runParallelQueries(queries);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats(msClient, tableName);
        boolean bl = hasStats = 0 != stats.size();
        if (hasStats) {
            if (stats.get(0).getStatsData().getLongStats().getNumDVs() > 0L) {
                this.verifyLongStats(1, 0, 0, stats);
            } else {
                this.verifyLongStats(0, 0, 0, stats);
            }
        }
        this.runStatementOnDriver(String.format("analyze table %s compute statistics for columns", tableName));
        this.verifyLongStats(0, 0, 0, this.getTxnTableStats(msClient, tableName));
    }

    @Test
    public void testTxnStatsOnOff() throws Exception {
        String tableName = "mm_table";
        this.hiveConf.setBoolean("hive.stats.autogather", true);
        this.hiveConf.setBoolean("hive.stats.column.autogather", true);
        Hive.closeCurrent();
        this.runStatementOnDriver("drop table if exists " + tableName);
        this.runStatementOnDriver(String.format("create table %s (a int) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName));
        this.runStatementOnDriver(String.format("insert into %s (a) values (1)", tableName));
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        List<ColumnStatisticsObj> stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)1L, (long)stats.size());
        this.runStatementOnDriver(String.format("insert into %s (a) values (1)", tableName));
        stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)1L, (long)stats.size());
        msClient.close();
        this.hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED.getVarname(), false);
        msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)0L, (long)stats.size());
        msClient.close();
        this.hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED.getVarname(), true);
        msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)1L, (long)stats.size());
        msClient.close();
        this.hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED.getVarname(), false);
        Hive.closeCurrent();
        this.runStatementOnDriver(String.format("insert into %s (a) values (1)", tableName));
        this.hiveConf.setBoolean(MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED.getVarname(), true);
        msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        stats = this.getTxnTableStats((IMetaStoreClient)msClient, tableName);
        Assert.assertEquals((long)0L, (long)stats.size());
        msClient.close();
    }

    public List<ColumnStatisticsObj> getTxnTableStats(IMetaStoreClient msClient, String tableName) throws TException, NoSuchObjectException, MetaException {
        String validWriteIds = msClient.getValidWriteIds("default." + tableName).toString();
        List stats = msClient.getTableColumnStatistics("default", tableName, (List)Lists.newArrayList((Object[])new String[]{"a"}), "hive", validWriteIds);
        return stats;
    }

    private void assertIsDelta(FileStatus stat) {
        Assert.assertTrue((String)stat.toString(), (boolean)stat.getPath().getName().startsWith("delta_"));
    }

    private void verifyMmExportPaths(List<String> paths, int deltasOrBases) {
        Assert.assertEquals((String)paths.toString(), (long)(2 * deltasOrBases + 1), (long)paths.size());
        for (String path : paths) {
            Assert.assertFalse((String)path, (boolean)path.startsWith("delta_"));
            Assert.assertFalse((String)path, (boolean)path.startsWith("base_"));
        }
    }

    private List<String> listPathsRecursive(FileSystem fs, Path path) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        LinkedList<Path> queue = new LinkedList<Path>();
        queue.add(path);
        while (!queue.isEmpty()) {
            FileStatus[] stats;
            Path next = (Path)queue.pollFirst();
            for (FileStatus stat : stats = fs.listStatus(next, AcidUtils.hiddenFileFilter)) {
                Path child = stat.getPath();
                paths.add(child.toString());
                if (!stat.isDirectory()) continue;
                queue.add(child);
            }
        }
        return paths;
    }

    @Test
    public void testErrors() throws Exception {
        this.runStatementOnDriver("start transaction");
        CommandProcessorException e1 = this.runStatementOnDriverNegative("create table foo(x int, y int)");
        Assert.assertEquals((String)"Expected DDL to fail in an open txn", (long)ErrorMsg.OP_NOT_ALLOWED_IN_TXN.getErrorCode(), (long)e1.getErrorCode());
        CommandProcessorException e2 = this.runStatementOnDriverNegative("update " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " set a = 1 where b != 1");
        Assert.assertEquals((String)"Expected update of bucket column to fail", (Object)"FAILED: SemanticException [Error 10302]: Updating values of bucketing columns is not supported.  Column a.", (Object)e2.getMessage());
        Assert.assertEquals((String)"Expected update of bucket column to fail", (long)ErrorMsg.UPDATE_CANNOT_UPDATE_BUCKET_VALUE.getErrorCode(), (long)e2.getErrorCode());
        CommandProcessorException e3 = this.runStatementOnDriverNegative("commit");
        Assert.assertEquals((String)("Error didn't match: " + (Object)((Object)e3)), (long)ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN.getErrorCode(), (long)e3.getErrorCode());
        CommandProcessorException e4 = this.runStatementOnDriverNegative("rollback");
        Assert.assertEquals((String)("Error didn't match: " + (Object)((Object)e4)), (long)ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN.getErrorCode(), (long)e4.getErrorCode());
        this.runStatementOnDriver("start transaction");
        CommandProcessorException e5 = this.runStatementOnDriverNegative("start transaction");
        Assert.assertEquals((String)"Expected start transaction to fail", (long)ErrorMsg.OP_NOT_ALLOWED_IN_TXN.getErrorCode(), (long)e5.getErrorCode());
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        this.runStatementOnDriver("commit work");
        rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
    }

    @Test
    public void testReadMyOwnInsert() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        List<String> rs = this.runStatementOnDriver("select * from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL));
        Assert.assertEquals((String)("Expected empty " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL)), (long)0L, (long)rs.size());
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("START TRANSACTION");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        this.runStatementOnDriver("rollback work");
        Assert.assertEquals((String)"Can't see write after commit", (long)1L, (long)rs1.size());
    }

    @Test
    public void testImplicitRollback() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        CommandProcessorException e = this.runStatementOnDriverNegative("select * from no_such_table");
        Assert.assertEquals((String)"Txn didn't fail?", (Object)"FAILED: SemanticException [Error 10001]: Line 1:14 Table not found 'no_such_table'", (Object)e.getMessage());
        this.runStatementOnDriver("start transaction");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        this.runStatementOnDriver("commit");
        Assert.assertEquals((String)"Didn't rollback as expected", (long)0L, (long)rs1.size());
    }

    @Test
    public void testExplicitRollback() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) values(1,2)");
        this.runStatementOnDriver("ROLLBACK");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Rollback didn't rollback", (long)0L, (long)rs.size());
    }

    @Test
    public void testMultipleInserts() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows2));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match before commit rs", allData, rs);
        this.runStatementOnDriver("commit");
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 1);
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match after commit rs1", allData, rs1);
    }

    @Test
    public void testDeleteOfMultipleInserts() throws Exception {
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where b = 2");
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where b = 8");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        int[][] remain = new int[][]{{3, 4}, {5, 6}};
        Assert.assertEquals((String)"Content didn't match after delete ", TestTxnCommands.stringifyValues(remain), rs2);
    }

    @Test
    public void testDelete() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", TestTxnCommands.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where b = 4");
        int[][] updatedData2 = new int[][]{{1, 2}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", TestTxnCommands.stringifyValues(updatedData2), rs3);
        this.runStatementOnDriver("commit");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", TestTxnCommands.stringifyValues(updatedData2), rs4);
    }

    @Test
    public void testUpdateOfInserts() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", TestTxnCommands.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows2));
        Assert.assertEquals((String)"Content didn't match rs1", allData, rs1);
        this.runStatementOnDriver("update " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " set b = 1 where b != 1");
        int[][] updatedData = new int[][]{{1, 1}, {3, 1}, {5, 1}, {7, 1}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after update", TestTxnCommands.stringifyValues(updatedData), rs2);
        this.runStatementOnDriver("commit");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", TestTxnCommands.stringifyValues(updatedData), rs4);
    }

    @Test
    public void testUpdateDeleteOfInserts() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", TestTxnCommands.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        List<String> allData = TestTxnCommands.stringifyValues(rows1);
        allData.addAll(TestTxnCommands.stringifyValues(rows2));
        Assert.assertEquals((String)"Content didn't match rs1", allData, rs1);
        this.runStatementOnDriver("update " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " set b = 1 where b != 1");
        int[][] updatedData = new int[][]{{1, 1}, {3, 1}, {5, 1}, {7, 1}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after update", TestTxnCommands.stringifyValues(updatedData), rs2);
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where a = 7 and b = 1");
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 2);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 4);
        int[][] updatedData2 = new int[][]{{1, 1}, {3, 1}, {5, 1}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", TestTxnCommands.stringifyValues(updatedData2), rs3);
        this.runStatementOnDriver("commit");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", TestTxnCommands.stringifyValues(updatedData2), rs4);
    }

    @Test
    public void testMultipleDelete() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", TestTxnCommands.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where b = 8");
        int[][] updatedData2 = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", TestTxnCommands.stringifyValues(updatedData2), rs2);
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where b = 4");
        int[][] updatedData3 = new int[][]{{1, 2}, {5, 6}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete2", TestTxnCommands.stringifyValues(updatedData3), rs3);
        this.runStatementOnDriver("update " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " set b=3");
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 1L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 0);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 2);
        this.dumpTableData(TxnCommandsBaseForTests.Table.ACIDTBL, 2L, 4);
        List<String> rs5 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        int[][] updatedData4 = new int[][]{{1, 3}, {5, 3}};
        Assert.assertEquals((String)"Wrong data after delete", TestTxnCommands.stringifyValues(updatedData4), rs5);
        this.runStatementOnDriver("commit");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", TestTxnCommands.stringifyValues(updatedData4), rs4);
    }

    @Test
    public void testDeleteIn() throws Exception {
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where a IN (SELECT A.a from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "  A)");
        int[][] tableData = new int[][]{{1, 2}, {3, 2}, {5, 2}, {1, 3}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL2) + "(a,b,c) values(1,7,17),(3,7,17)");
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where a in(select a from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL2) + ")");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL2));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 7}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update failed", TestTxnCommands.stringifyValues(updatedData), rs);
    }

    @Test
    public void testTimeOutReaper() throws Exception {
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where a = 5");
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 2L, TimeUnit.MILLISECONDS);
        AcidHouseKeeperService houseKeeperService = new AcidHouseKeeperService();
        houseKeeperService.setConf((Configuration)this.hiveConf);
        houseKeeperService.run();
        CommandProcessorException e = this.runStatementOnDriverNegative("delete from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where a = 5");
        Assert.assertTrue((String)("Actual: " + e.getMessage()), (boolean)e.getMessage().contains("Transaction manager has aborted the transaction txnid:1"));
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 1L, TimeUnit.SECONDS);
        houseKeeperService.setConf((Configuration)this.hiveConf);
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("select count(*) from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " where a = 17");
        TestTxnCommands.pause(750);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        GetOpenTxnsInfoResponse txnsInfoResponse = txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)2L, (long)txnsInfoResponse.getOpen_txns().size());
        TxnInfo txnInfo = null;
        for (TxnInfo ti : txnsInfoResponse.getOpen_txns()) {
            if (ti.getState() != TxnState.OPEN) continue;
            txnInfo = ti;
            break;
        }
        Assert.assertNotNull(txnInfo);
        Assert.assertEquals((long)14L, (long)txnInfo.getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)txnInfo.getState());
        String s = TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select TXN_STARTED, TXN_LAST_HEARTBEAT from TXNS where TXN_ID = " + txnInfo.getId()), (boolean)false);
        String[] vals = s.split("\\s+");
        Assert.assertEquals((String)"Didn't get expected timestamps", (long)2L, (long)vals.length);
        long lastHeartbeat = Long.parseLong(vals[1]);
        Assert.assertNotEquals((String)"Didn't see heartbeat happen", (long)Long.parseLong(vals[0]), (long)lastHeartbeat);
        ShowLocksResponse slr = txnHandler.showLocks(new ShowLocksRequest());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", TxnCommandsBaseForTests.Table.ACIDTBL.name, null, slr.getLocks());
        TestTxnCommands.pause(750);
        houseKeeperService.run();
        TestTxnCommands.pause(750);
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)("Unexpected lock count: " + slr), (long)1L, (long)slr.getLocks().size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", TxnCommandsBaseForTests.Table.ACIDTBL.name, null, slr.getLocks());
        TestTxnCommands.pause(750);
        houseKeeperService.run();
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)("Unexpected lock count: " + slr), (long)1L, (long)slr.getLocks().size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", TxnCommandsBaseForTests.Table.ACIDTBL.name, null, slr.getLocks());
        s = TestTxnDbUtil.queryToString((Configuration)this.hiveConf, (String)("select TXN_STARTED, TXN_LAST_HEARTBEAT from TXNS where TXN_ID = " + txnInfo.getId()), (boolean)false);
        vals = s.split("\\s+");
        Assert.assertEquals((String)"Didn't get expected timestamps", (long)2L, (long)vals.length);
        Assert.assertTrue((String)("Heartbeat didn't progress: (old,new) (" + lastHeartbeat + "," + vals[1] + ")"), (lastHeartbeat < Long.parseLong(vals[1]) ? 1 : 0) != 0);
        this.runStatementOnDriver("rollback");
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)"Unexpected lock count", (long)0L, (long)slr.getLocks().size());
    }

    private static void pause(int timeMillis) {
        try {
            Thread.sleep(timeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void exchangePartition() throws Exception {
        this.runStatementOnDriver("create database ex1");
        this.runStatementOnDriver("create database ex2");
        this.runStatementOnDriver("CREATE TABLE ex1.exchange_part_test1 (f1 string) PARTITIONED BY (ds STRING)");
        this.runStatementOnDriver("CREATE TABLE ex2.exchange_part_test2 (f1 string) PARTITIONED BY (ds STRING)");
        this.runStatementOnDriver("ALTER TABLE ex2.exchange_part_test2 ADD PARTITION (ds='2013-04-05')");
        this.runStatementOnDriver("ALTER TABLE ex1.exchange_part_test1 EXCHANGE PARTITION (ds='2013-04-05') WITH TABLE ex2.exchange_part_test2");
    }

    @Test
    public void testMergeNegative() throws Exception {
        CommandProcessorException e = this.runStatementOnDriverNegative("MERGE INTO " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " target\nUSING " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " source ON target.a = source.a\nWHEN MATCHED THEN UPDATE set b = 1\nWHEN MATCHED THEN DELETE\nWHEN NOT MATCHED AND a < 1 THEN INSERT VALUES(1,2)");
        Assert.assertEquals((Object)ErrorMsg.MERGE_PREDIACTE_REQUIRED, (Object)((HiveException)e.getCause()).getCanonicalErrorMsg());
    }

    @Test
    public void testMergeNegative2() throws Exception {
        CommandProcessorException e = this.runStatementOnDriverNegative("MERGE INTO " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " target USING " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + "\n source ON target.pk = source.pk \nWHEN MATCHED THEN UPDATE set b = 1 \nWHEN MATCHED THEN UPDATE set b=a");
        Assert.assertEquals((Object)ErrorMsg.MERGE_TOO_MANY_UPDATE, (Object)((HiveException)e.getCause()).getCanonicalErrorMsg());
    }

    @Test
    public void testQuotedIdentifier() throws Exception {
        String target = "`aci/d_u/ami`";
        String src = "`src/name`";
        this.runStatementOnDriver("drop table if exists " + target);
        this.runStatementOnDriver("drop table if exists " + src);
        this.runStatementOnDriver("create table " + target + "(i int,`d?*de e` decimal(5,2),vc varchar(128)) clustered by (i) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + src + "(gh int, j decimal(5,2), k varchar(128))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah' \nwhen not matched then insert values(1,2.1,'baz')");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah',  `d?*de e` = current_timestamp()  \nwhen not matched then insert values(1,2.1, concat('baz', current_timestamp()))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah' \nwhen not matched then insert values(1,2.1,'a\\b')");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='\u2206\u220b'\nwhen not matched then insert values(`a/b`.gh,`a/b`.j,'c\\t')");
    }

    @Test
    public void testQuotedIdentifier2() throws Exception {
        String target = "`aci/d_u/ami`";
        String src = "`src/name`";
        this.runStatementOnDriver("drop table if exists " + target);
        this.runStatementOnDriver("drop table if exists " + src);
        this.runStatementOnDriver("create table " + target + "(i int,`d?*de e` decimal(5,2),vc varchar(128)) clustered by (i) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + src + "(`g/h` int, j decimal(5,2), k varchar(128))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=`g/h`\nwhen matched and `g/h` > 5 then delete \nwhen matched and `g/h` < 0 then update set vc='\u2206\u220b', `d?*de e` =  `d?*de e` * j + 1\nwhen not matched and `d?*de e` <> 0 then insert values(`a/b`.`g/h`,`a/b`.j,`a/b`.k)");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=`g/h`\nwhen matched and `g/h` > 5 then delete\n when matched and `g/h` < 0 then update set vc='\u2206\u220b'  , `d?*de e` =  `d?*de e` * j + 1  \n when not matched and `d?*de e` <> 0 then insert values(`a/b`.`g/h`,`a/b`.j,`a/b`.k)");
    }

    @Test
    public void testMergeType2SCD01() throws Exception {
        this.runStatementOnDriver("drop table if exists target");
        this.runStatementOnDriver("drop table if exists source");
        this.runStatementOnDriver("drop table if exists splitTable");
        this.runStatementOnDriver("create table splitTable(op int)");
        this.runStatementOnDriver("insert into splitTable values (0),(1)");
        this.runStatementOnDriver("create table source (key int, data int)");
        this.runStatementOnDriver("create table target (key int, data int, cur int) clustered by (key) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        int[][] targetVals = new int[][]{{1, 5, 1}, {2, 6, 1}, {1, 18, 0}};
        this.runStatementOnDriver("insert into target " + this.makeValuesClause(targetVals));
        int[][] sourceVals = new int[][]{{1, 7}, {3, 8}};
        this.runStatementOnDriver("insert into source " + this.makeValuesClause(sourceVals));
        String curMatch = "select s.*, case when t.cur is null then 0 else 1 end m from source s left outer join (select * from target where target.cur=1) t on s.key=t.key";
        String teeCurMatch = "select curMatch.*, case when splitTable.op is null or splitTable.op = 0 then 0 else 1 end `o/p\\n` from (" + curMatch + ") curMatch left outer join splitTable on curMatch.m=1";
        String stmt = "merge into target t using (" + teeCurMatch + ") s on t.key=s.key and t.cur=1 and s.`o/p\\n`=1 when matched then update set cur=0 when not matched then insert values(s.key,s.data,1)";
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STRICT_CHECKS_CARTESIAN, false);
        this.runStatementOnDriver(stmt);
        int[][] resultVals = new int[][]{{1, 5, 0}, {1, 7, 1}, {1, 18, 0}, {2, 6, 1}, {3, 8, 1}};
        List<String> r = this.runStatementOnDriver("select * from target order by key,data,cur");
        Assert.assertEquals(TestTxnCommands.stringifyValues(resultVals), r);
    }

    @Test
    public void testMergeType2SCD02() throws Exception {
        this.runStatementOnDriver("drop table if exists target");
        this.runStatementOnDriver("drop table if exists source");
        this.runStatementOnDriver("create table source (key int, data int)");
        this.runStatementOnDriver("create table target (key int, data int, cur int) clustered by (key) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        int[][] targetVals = new int[][]{{1, 5, 1}, {2, 6, 1}, {1, 18, 0}};
        this.runStatementOnDriver("insert into target " + this.makeValuesClause(targetVals));
        int[][] sourceVals = new int[][]{{1, 7}, {3, 8}};
        this.runStatementOnDriver("insert into source " + this.makeValuesClause(sourceVals));
        String baseSrc = "select source.*, 0 c from source union all select source.*, 1 c from source inner join target on source.key=target.key where target.cur=1";
        String stmt = "merge into target t using (" + baseSrc + ") s on t.key=s.key and t.cur=s.c and t.cur=1 when matched then update set cur=0 when not matched then insert values(s.key,s.data,1)";
        this.runStatementOnDriver(stmt);
        int[][] resultVals = new int[][]{{1, 5, 0}, {1, 7, 1}, {1, 18, 0}, {2, 6, 1}, {3, 8, 1}};
        List<String> r = this.runStatementOnDriver("select * from target order by key,data,cur");
        Assert.assertEquals(TestTxnCommands.stringifyValues(resultVals), r);
    }

    @Test
    public void testMergeOnTezEdges() throws Exception {
        String query = "merge into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " as t using " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED AND s.a > 8 THEN DELETE WHEN MATCHED THEN UPDATE SET b = 7 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "tez");
        hc.setBoolVar(HiveConf.ConfVars.HIVE_EXPLAIN_USER, false);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        List<String> explain = this.runStatementOnDriver("explain " + query);
        StringBuilder sb = new StringBuilder();
        for (String s : explain) {
            sb.append(s).append('\n');
        }
        LOG.info("Explain1: " + sb);
        for (int i = 0; i < explain.size(); ++i) {
            if (!explain.get(i).contains("Edges:")) continue;
            Assert.assertTrue((String)("At i+1=" + (i + 1) + explain.get(i + 1)), (boolean)explain.get(i + 1).contains("Reducer 2 <- Map 1 (SIMPLE_EDGE), Map 8 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 2) + explain.get(i + 2)), (boolean)explain.get(i + 2).contains("Reducer 3 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 3) + explain.get(i + 3)), (boolean)explain.get(i + 3).contains("Reducer 4 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 4) + explain.get(i + 4)), (boolean)explain.get(i + 4).contains("Reducer 5 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 5) + explain.get(i + 5)), (boolean)explain.get(i + 5).contains("Reducer 6 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 6) + explain.get(i + 6)), (boolean)explain.get(i + 6).contains("Reducer 7 <- Reducer 2 (SIMPLE_EDGE)"));
            break;
        }
    }

    @Test
    public void testMergeUpdateDelete() throws Exception {
        int[][] baseValsOdd = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " " + this.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        String query = "merge into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " as t using " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN MATCHED and t.a > 3 and t.a < 5 THEN DELETE WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 0}, {5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeUpdateDeleteNoCardCheck() throws Exception {
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK, false);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        int[][] baseValsOdd = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " " + this.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        String query = "merge into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " as t using " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN MATCHED and t.a > 3 and t.a < 5 THEN DELETE ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 0}, {5, 6}, {7, 8}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeDeleteUpdate() throws Exception {
        int[][] sourceVals = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " " + this.makeValuesClause(sourceVals));
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " " + this.makeValuesClause(targetVals));
        String query = "merge into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " as t using " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeCardinalityViolation() throws Exception {
        int[][] sourceVals = new int[][]{{2, 2}, {2, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " " + this.makeValuesClause(sourceVals));
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " " + this.makeValuesClause(targetVals));
        String query = "merge into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " as t using " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriverNegative(query);
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART) + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1'),(4,4,'p2')");
        query = "merge into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART) + " as t using " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b, 'p1') ";
        this.runStatementOnDriverNegative(query);
    }

    @Test
    public void testSetClauseFakeColumn() throws Exception {
        CommandProcessorException e1 = this.runStatementOnDriverNegative("MERGE INTO " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " target\nUSING " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + "\n source ON target.a = source.a\nWHEN MATCHED THEN UPDATE set t = 1");
        Assert.assertEquals((Object)ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, (Object)((HiveException)e1.getCause()).getCanonicalErrorMsg());
        CommandProcessorException e2 = this.runStatementOnDriverNegative("update " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " set t = 1");
        Assert.assertEquals((Object)ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, (Object)((HiveException)e2.getCause()).getCanonicalErrorMsg());
    }

    @Test
    public void testBadOnClause() throws Exception {
        CommandProcessorException e = this.runStatementOnDriverNegative("merge into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " trgt\nusing (select *\n       from " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " src) sub on sub.a = target.a\nwhen not matched then insert values (sub.a,sub.b)");
        Assert.assertTrue((String)("Error didn't match: " + (Object)((Object)e)), (boolean)e.getMessage().contains("No columns from target table 'trgt' found in ON clause '`sub`.`a` = `target`.`a`' of MERGE statement."));
    }

    @Test
    public void testCompactionBlocking() throws Exception {
        Timer cancelCompact = new Timer("CancelCompactionTimer", false);
        final Thread threadToInterrupt = Thread.currentThread();
        cancelCompact.schedule(new TimerTask(){

            @Override
            public void run() {
                threadToInterrupt.interrupt();
            }
        }, 5000L);
        long start = System.currentTimeMillis();
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + " compact 'major' AND WAIT");
        Assert.assertTrue((System.currentTimeMillis() > start + 2L ? 1 : 0) != 0);
    }

    @Test
    public void testMergeCase() throws Exception {
        this.runStatementOnDriver("create table merge_test (c1 integer, c2 integer, c3 integer) CLUSTERED BY (c1) into 2 buckets stored as orc tblproperties(\"transactional\"=\"true\")");
        this.runStatementOnDriver("create table if not exists e011_02 (c1 float, c2 double, c3 float)");
        this.runStatementOnDriver("merge into merge_test using e011_02 on (merge_test.c1 = e011_02.c1) when not matched then insert values (case when e011_02.c1 > 0 then e011_02.c1 + 1 else e011_02.c1 end, e011_02.c2 + e011_02.c3, coalesce(e011_02.c3, 1))");
    }

    @Test
    public void testNonAcidToAcidConversion01() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + "(a,b) values(0,12),(1,5)");
        this.runStatementOnDriver("alter table " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + "(a,b) values(1,17)");
        boolean isVectorized = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        String query = "select ROW__ID, a, b" + (isVectorized ? " from  " : ", INPUT__FILE__NAME from ") + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " order by ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":0}\t1\t2", "nonacidorctbl/000001_0"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":1}\t0\t12", "nonacidorctbl/000001_0_copy_1"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":2}\t1\t5", "nonacidorctbl/000001_0_copy_1"}, {"{\"writeid\":10000001,\"bucketid\":536936448,\"rowid\":0}\t1\t17", "nonacidorctbl/delta_10000001_10000001_0000/bucket_00001_0"}};
        this.checkResult(expected, query, isVectorized, "before compact", LOG);
        Assert.assertEquals((long)0x20000000L, (long)BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)this.hiveConf).bucket(0)));
        Assert.assertEquals((long)0x20010000L, (long)BucketCodec.V1.encode(new AcidOutputFormat.Options((Configuration)this.hiveConf).bucket(1)));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " compact 'major'");
        TestTxnCommands.runWorker(this.hiveConf);
        query = "select ROW__ID, a, b" + (isVectorized ? "" : ", INPUT__FILE__NAME") + " from " + (Object)((Object)TxnCommandsBaseForTests.Table.NONACIDORCTBL) + " order by ROW__ID";
        String[][] expected2 = new String[][]{{"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":0}\t1\t2", "nonacidorctbl/base_10000001_v0000019/bucket_00001"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":1}\t0\t12", "nonacidorctbl/base_10000001_v0000019/bucket_00001"}, {"{\"writeid\":0,\"bucketid\":536936448,\"rowid\":2}\t1\t5", "nonacidorctbl/base_10000001_v0000019/bucket_00001"}, {"{\"writeid\":10000001,\"bucketid\":536936448,\"rowid\":0}\t1\t17", "nonacidorctbl/base_10000001_v0000019/bucket_00001"}};
        this.checkResult(expected2, query, isVectorized, "after major compact", LOG);
    }

    @Test
    public void testMoreBucketsThanReducers() throws Exception {
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setIntVar(HiveConf.ConfVars.MAXREDUCERS, 1);
        hc.setIntVar(HiveConf.ConfVars.HADOOPNUMREDUCERS, 1);
        hc.setBoolVar(HiveConf.ConfVars.HIVE_EXPLAIN_USER, false);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " values(1,1)");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " values(0,0),(3,3)");
        this.runStatementOnDriver("update " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " set b = -1");
        List<String> r = this.runStatementOnDriver("select * from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " order by a, b");
        int[][] expected = new int[][]{{0, -1}, {1, -1}, {3, -1}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(expected), r);
    }

    @Ignore(value="Moved to Tez")
    @Test
    public void testMoreBucketsThanReducers2() throws Exception {
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setIntVar(HiveConf.ConfVars.MAXREDUCERS, 2);
        hc.setIntVar(HiveConf.ConfVars.HADOOPNUMREDUCERS, 2);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        this.runStatementOnDriver("create table fourbuckets (a int, b int) clustered by (a) into 4 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into fourbuckets values(0,1),(1,1)");
        this.runStatementOnDriver("insert into fourbuckets values(2,2),(3,2)");
        this.runStatementOnDriver("insert into fourbuckets values(0,3),(1,3)");
        this.runStatementOnDriver("insert into fourbuckets values(2,4),(3,4)");
        this.runStatementOnDriver("update fourbuckets set b = -1");
        List<String> r = this.runStatementOnDriver("select * from fourbuckets order by a, b");
        int[][] expected = new int[][]{{0, -1}, {0, -1}, {1, -1}, {1, -1}, {2, -1}, {2, -1}, {3, -1}, {3, -1}};
        Assert.assertEquals(TestTxnCommands.stringifyValues(expected), r);
    }

    @Test
    public void testVersioningVersionFileEnabled() throws Exception {
        this.acidVersionTest(true);
    }

    @Test
    public void testVersioningVersionFileDisabled() throws Exception {
        this.acidVersionTest(false);
    }

    private void acidVersionTest(boolean enableVersionFile) throws Exception {
        boolean originalEnableVersionFile = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE, enableVersionFile);
        this.hiveConf.set(MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID.getVarname(), "true");
        Hive.closeCurrent();
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("create table T (a int, b int) stored as orc");
        int[][] data = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into T" + this.makeValuesClause(data));
        this.runStatementOnDriver("update T set a=3 where b=2");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        RemoteIterator files = fs.listFiles(new Path(this.getWarehouseDir(), "t"), true);
        CompactorTestUtilities.checkAcidVersion((RemoteIterator<LocatedFileStatus>)files, fs, enableVersionFile, new String[]{"delta_", "delete_delta_"});
        this.runStatementOnDriver("alter table T compact 'minor'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getType().equals((Object)CompactionType.MINOR));
        files = fs.listFiles(new Path(this.getWarehouseDir(), "t"), true);
        CompactorTestUtilities.checkAcidVersion((RemoteIterator<LocatedFileStatus>)files, fs, enableVersionFile, new String[]{"delta_", "delete_delta_"});
        this.runStatementOnDriver("insert into T" + this.makeValuesClause(data));
        this.runStatementOnDriver("alter table T compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        txnHandler = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)2L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 1 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(1)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(1)).getHadoopJobId().startsWith("job_local"));
        files = fs.listFiles(new Path(this.getWarehouseDir(), "t"), true);
        CompactorTestUtilities.checkAcidVersion((RemoteIterator<LocatedFileStatus>)files, fs, enableVersionFile, new String[]{"delta_", "delete_delta_", "base_"});
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE, originalEnableVersionFile);
    }

    @Test
    public void testTruncateWithBase() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL) + " values(1,2),(3,4)");
        this.runStatementOnDriver("truncate table " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL));
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBL.toString().toLowerCase()), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000002", (Object)name);
        List<String> r = this.runStatementOnDriver("select * from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBL));
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testTruncateWithBaseAllPartition() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART) + " partition(p='a') values(1,2),(3,4)");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART) + " partition(p='b') values(1,2),(3,4)");
        this.runStatementOnDriver("truncate table " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART));
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=a"), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        List<String> r = this.runStatementOnDriver("select * from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART));
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testTruncateWithBaseOnePartition() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART) + " partition(p='a') values(1,2),(3,4)");
        this.runStatementOnDriver("insert into " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART) + " partition(p='b') values(5,5),(4,4)");
        this.runStatementOnDriver("truncate table " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART) + " partition(p='b')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        Object[] stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=b"), AcidUtils.baseFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 base and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        String name = stat[0].getPath().getName();
        Assert.assertEquals((Object)"base_0000003", (Object)name);
        stat = fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=a"), AcidUtils.deltaFileFilter);
        if (1 != stat.length) {
            Assert.fail((String)("Expecting 1 delta and found " + stat.length + " files " + Arrays.toString(stat)));
        }
        List<String> r = this.runStatementOnDriver("select * from " + (Object)((Object)TxnCommandsBaseForTests.Table.ACIDTBLPART));
        Assert.assertEquals((long)2L, (long)r.size());
    }

    private static final class QueryRunnable
    implements Runnable {
        private final CountDownLatch cdlIn;
        private final CountDownLatch cdlOut;
        private final String query;
        private final HiveConf hiveConf;

        QueryRunnable(HiveConf hiveConf, String query, CountDownLatch cdlIn, CountDownLatch cdlOut) {
            this.query = query;
            this.cdlIn = cdlIn;
            this.cdlOut = cdlOut;
            this.hiveConf = new HiveConf(hiveConf);
        }

        @Override
        public void run() {
            SessionState ss = SessionState.start((HiveConf)this.hiveConf);
            try {
                ss.applyAuthorizationPolicy();
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
            QueryState qs = new QueryState.Builder().withHiveConf(this.hiveConf).nonIsolated().build();
            try (Driver d = new Driver(qs);){
                LOG.info("Ready to run the query: " + this.query);
                TestTxnCommands.syncThreadStart(this.cdlIn, this.cdlOut);
                try {
                    try {
                        d.run(this.query);
                    }
                    catch (CommandProcessorException e) {
                        throw new RuntimeException(this.query + " failed: " + (Object)((Object)e));
                    }
                    d.getResults(new ArrayList());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

