/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCompactionTxnHandler {
    private HiveConf conf = new HiveConf();
    private TxnStore txnHandler;

    public TestCompactionTxnHandler() throws Exception {
        TestTxnDbUtil.setConfValues((Configuration)this.conf);
        TestTxnDbUtil.prepDb((Configuration)this.conf);
        this.conf.setIntVar(HiveConf.ConfVars.METASTORE_DIRECT_SQL_MAX_QUERY_LENGTH, 1);
        this.conf.setIntVar(HiveConf.ConfVars.METASTORE_DIRECT_SQL_MAX_ELEMENTS_IN_CLAUSE, 10);
        this.tearDown();
    }

    @Test
    public void testFindNextToCompact() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        long now = System.currentTimeMillis();
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((String)"foo", (String)ci.dbname);
        Assert.assertEquals((String)"bar", (String)ci.tableName);
        Assert.assertEquals((String)"ds=today", (String)ci.partName);
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)ci.type);
        Assert.assertNull((Object)ci.runAs);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        ci.runAs = "bob";
        this.txnHandler.updateCompactorState(ci, this.openTxn());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        Assert.assertEquals((String)"foo", (String)c.getDbname());
        Assert.assertEquals((String)"bar", (String)c.getTablename());
        Assert.assertEquals((String)"ds=today", (String)c.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
        Assert.assertEquals((String)"working", (String)c.getState());
        Assert.assertTrue((c.getStart() - 5000L < now && c.getStart() + 5000L > now ? 1 : 0) != 0);
        Assert.assertEquals((String)"fred", (String)c.getWorkerid());
        Assert.assertEquals((String)"bob", (String)c.getRunAs());
    }

    @Test
    public void testFindNextToCompact2() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=yesterday");
        this.txnHandler.compact(rqst);
        long now = System.currentTimeMillis();
        boolean expectToday = false;
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((String)"foo", (String)ci.dbname);
        Assert.assertEquals((String)"bar", (String)ci.tableName);
        if ("ds=today".equals(ci.partName)) {
            expectToday = false;
        } else if ("ds=yesterday".equals(ci.partName)) {
            expectToday = true;
        } else {
            Assert.fail((String)("partition name should have been today or yesterday but was " + ci.partName));
        }
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)ci.type);
        ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((String)"foo", (String)ci.dbname);
        Assert.assertEquals((String)"bar", (String)ci.tableName);
        if (expectToday) {
            Assert.assertEquals((String)"ds=today", (String)ci.partName);
        } else {
            Assert.assertEquals((String)"ds=yesterday", (String)ci.partName);
        }
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)ci.type);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)2, (int)compacts.size());
        for (ShowCompactResponseElement e : compacts) {
            Assert.assertEquals((String)"working", (String)e.getState());
            Assert.assertTrue((e.getStart() - 5000L < now && e.getStart() + 5000L > now ? 1 : 0) != 0);
            Assert.assertEquals((String)"fred", (String)e.getWorkerid());
        }
    }

    @Test
    public void testFindNextToCompactNothingToCompact() throws Exception {
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
    }

    @Test
    public void testMarkCompacted() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        this.txnHandler.markCompacted(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        Assert.assertEquals((String)"foo", (String)c.getDbname());
        Assert.assertEquals((String)"bar", (String)c.getTablename());
        Assert.assertEquals((String)"ds=today", (String)c.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
        Assert.assertEquals((String)"ready for cleaning", (String)c.getState());
        Assert.assertNull((Object)c.getWorkerid());
    }

    @Test
    public void testFindNextToClean() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        this.txnHandler.markCompacted(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        List toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((int)1, (int)toClean.size());
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)1, (int)compacts.size());
        ShowCompactResponseElement c = (ShowCompactResponseElement)compacts.get(0);
        Assert.assertEquals((String)"foo", (String)c.getDbname());
        Assert.assertEquals((String)"bar", (String)c.getTablename());
        Assert.assertEquals((String)"ds=today", (String)c.getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
        Assert.assertEquals((String)"ready for cleaning", (String)c.getState());
        Assert.assertNull((Object)c.getWorkerid());
    }

    @Test
    public void testMarkCleaned() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        this.txnHandler.markCompacted(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        List toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((int)1, (int)toClean.size());
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        this.txnHandler.markCleaned(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((int)1, (int)rsp.getCompactsSize());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
    }

    @Test
    public void testShowCompactions() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        showCompactResponse.getCompacts().forEach(e -> {
            Assert.assertEquals((String)"foo", (String)e.getDbname());
            Assert.assertEquals((String)"bar", (String)e.getTablename());
            Assert.assertEquals((String)"ds=today", (String)e.getPartitionname());
            Assert.assertEquals((String)"initiated", (String)e.getState());
            Assert.assertEquals((Object)CompactionType.MINOR, (Object)e.getType());
            Assert.assertEquals((long)1L, (long)e.getId());
        });
    }

    @Test
    public void testMarkFailed() throws Exception {
        int i;
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        String workerId = "fred";
        String status = "failed";
        String errorMessage = "Dummy error";
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        ci.errorMessage = "Dummy error";
        this.txnHandler.markFailed(ci);
        Assert.assertNull((Object)this.txnHandler.findNextToCompact("fred"));
        boolean failedCheck = this.txnHandler.checkFailedCompactions(ci);
        Assert.assertFalse((boolean)failedCheck);
        try {
            this.txnHandler.markFailed(ci);
            Assert.fail((String)"The first call to markFailed() must have failed as this call did not throw the expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No record with CQ_ID="));
        }
        Assert.assertFalse((boolean)this.txnHandler.checkFailedCompactions(ci));
        for (i = 1; i < MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD); ++i) {
            this.addFailedCompaction("foo", "bar", CompactionType.MINOR, "ds=today", "Dummy error");
        }
        Assert.assertTrue((boolean)this.txnHandler.checkFailedCompactions(ci));
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_RETRY_TIME, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)this.txnHandler.checkFailedCompactions(ci));
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_RETRY_TIME, (long)7L, (TimeUnit)TimeUnit.DAYS);
        this.checkShowCompaction("foo", "bar", "ds=today", "failed", "Dummy error");
        for (i = 0; i < 300; ++i) {
            this.addFailedCompaction("foo", "bar", CompactionType.MINOR, "ds=today", "Dummy error");
        }
        this.checkShowCompaction("foo", "bar", "ds=today", "failed", "Dummy error");
        this.txnHandler.purgeCompactionHistory();
    }

    private void checkShowCompaction(String dbName, String tableName, String partition, String status, String errorMessage) throws MetaException {
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        showCompactResponse.getCompacts().forEach(e -> {
            Assert.assertEquals((String)dbName, (String)e.getDbname());
            Assert.assertEquals((String)tableName, (String)e.getTablename());
            Assert.assertEquals((String)partition, (String)e.getPartitionname());
            Assert.assertEquals((String)status, (String)e.getState());
            Assert.assertEquals((String)errorMessage, (String)e.getErrorMessage());
        });
    }

    private void addFailedCompaction(String dbName, String tableName, CompactionType type, String partitionName, String errorMessage) throws MetaException {
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, type);
        rqst.setPartitionname(partitionName);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        ci.errorMessage = errorMessage;
        this.txnHandler.markFailed(ci);
    }

    @Test
    public void testRevokeFromLocalWorkers() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        rqst = new CompactionRequest("foo", "baz", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        rqst = new CompactionRequest("foo", "bazzoo", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact("fred-193892"));
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact("bob-193892"));
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact("fred-193893"));
        this.txnHandler.revokeFromLocalWorkers("fred");
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)3, (int)compacts.size());
        boolean sawWorkingBob = false;
        int initiatedCount = 0;
        for (ShowCompactResponseElement c : compacts) {
            if (c.getState().equals("working")) {
                Assert.assertEquals((String)"bob-193892", (String)c.getWorkerid());
                sawWorkingBob = true;
                continue;
            }
            if (c.getState().equals("initiated")) {
                ++initiatedCount;
                continue;
            }
            Assert.fail((String)"Unexpected state");
        }
        Assert.assertTrue((boolean)sawWorkingBob);
        Assert.assertEquals((int)2, (int)initiatedCount);
    }

    @Test
    public void testRevokeTimedOutWorkers() throws Exception {
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        rqst = new CompactionRequest("foo", "baz", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact("fred-193892"));
        Thread.sleep(200L);
        Assert.assertNotNull((Object)this.txnHandler.findNextToCompact("fred-193892"));
        this.txnHandler.revokeTimedoutWorkers(100L);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((int)2, (int)compacts.size());
        boolean sawWorking = false;
        boolean sawInitiated = false;
        for (ShowCompactResponseElement c : compacts) {
            if (c.getState().equals("working")) {
                sawWorking = true;
                continue;
            }
            if (c.getState().equals("initiated")) {
                sawInitiated = true;
                continue;
            }
            Assert.fail((String)"Unexpected state");
        }
        Assert.assertTrue((boolean)sawWorking);
        Assert.assertTrue((boolean)sawInitiated);
    }

    @Test
    public void testFindPotentialCompactions() throws Exception {
        CompactionInfo ci2;
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("yourtable");
        comp.setPartitionname("mypartition=myvalue");
        comp.setOperationType(DataOperationType.UPDATE);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        Assert.assertEquals((int)0, (int)this.txnHandler.numLocksInLockTable());
        Set potentials = this.txnHandler.findPotentialCompactions(100, -1L);
        Assert.assertEquals((int)2, (int)potentials.size());
        boolean sawMyTable = false;
        boolean sawYourTable = false;
        for (CompactionInfo ci2 : potentials) {
            sawMyTable |= ci2.dbname.equals("mydb") && ci2.tableName.equals("mytable") && ci2.partName == null;
            sawYourTable |= ci2.dbname.equals("mydb") && ci2.tableName.equals("yourtable") && ci2.partName.equals("mypartition=myvalue");
        }
        Assert.assertTrue((boolean)sawMyTable);
        Assert.assertTrue((boolean)sawYourTable);
        potentials = this.txnHandler.findPotentialCompactions(100, -1L, 1L);
        Assert.assertEquals((int)2, (int)potentials.size());
        TimeUnit.SECONDS.sleep(2L);
        potentials = this.txnHandler.findPotentialCompactions(100, -1L, 1L);
        Assert.assertEquals((int)0, (int)potentials.size());
        CompactionRequest rqst = new CompactionRequest("mydb", "mytable", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        ci2 = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markFailed(ci2);
        potentials = this.txnHandler.findPotentialCompactions(100, -1L, 1L);
        Assert.assertEquals((int)1, (int)potentials.size());
    }

    @Test
    public void testMarkCleanedCleansTxnsAndTxnComponents() throws Exception {
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("mytable");
        comp.setOperationType(DataOperationType.INSERT);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        txnid = this.openTxn();
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("yourtable");
        comp.setOperationType(DataOperationType.DELETE);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        txnid = this.openTxn();
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("foo");
        comp.setPartitionname("bar=compact");
        comp.setOperationType(DataOperationType.UPDATE);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.DB, "mydb");
        comp.setTablename("foo");
        comp.setPartitionname("baz=compact");
        comp.setOperationType(DataOperationType.UPDATE);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        Assert.assertTrue((res.getState() == LockState.ACQUIRED ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        CompactionInfo ci = new CompactionInfo();
        CompactionRequest rqst = new CompactionRequest("mydb", "mytable", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        this.txnHandler.markCompacted(ci);
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        List toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((int)1, (int)toClean.size());
        this.txnHandler.markCleaned(ci);
        GetOpenTxnsResponse txnList = this.txnHandler.getOpenTxns();
        Assert.assertEquals((int)3, (int)txnList.getOpen_txnsSize());
        txnid = this.openTxn();
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
        txnList = this.txnHandler.getOpenTxns();
        Assert.assertEquals((int)3, (int)txnList.getOpen_txnsSize());
        rqst = new CompactionRequest("mydb", "foo", CompactionType.MAJOR);
        rqst.setPartitionname("bar");
        this.txnHandler.compact(rqst);
        Assert.assertEquals((int)0, (int)this.txnHandler.findReadyToClean(0L, 0L).size());
        ci = this.txnHandler.findNextToCompact("fred");
        Assert.assertNotNull((Object)ci);
        this.txnHandler.markCompacted(ci);
        toClean = this.txnHandler.findReadyToClean(0L, 0L);
        Assert.assertEquals((int)1, (int)toClean.size());
        this.txnHandler.markCleaned(ci);
        this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost"));
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis());
        this.txnHandler.setOpenTxnTimeOutMillis(1L);
        this.txnHandler.cleanEmptyAbortedAndCommittedTxns();
        txnList = this.txnHandler.getOpenTxns();
        Assert.assertEquals((int)3, (int)txnList.getOpen_txnsSize());
        this.txnHandler.setOpenTxnTimeOutMillis(1000L);
    }

    @Test
    public void addDynamicPartitions() throws Exception {
        String dbName = "default";
        String tableName = "adp_table";
        OpenTxnsResponse openTxns = this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost"));
        long txnId = (Long)openTxns.getTxn_ids().get(0);
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest(dbName, tableName);
        rqst.setTxnIds(openTxns.getTxn_ids());
        AllocateTableWriteIdsResponse writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        long writeId = ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId();
        Assert.assertEquals((long)txnId, (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        Assert.assertEquals((long)1L, (long)writeId);
        LockComponent lc = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, dbName);
        lc.setIsDynamicPartitionWrite(true);
        lc.setTablename(tableName);
        DataOperationType dop = DataOperationType.UPDATE;
        lc.setOperationType(dop);
        LockRequest lr = new LockRequest(Arrays.asList(lc), "me", "localhost");
        lr.setTxnid(txnId);
        LockResponse lock = this.txnHandler.lock(lr);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)lock.getState());
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, writeId, dbName, tableName, Arrays.asList("ds=yesterday", "ds=today"));
        adp.setOperationType(dop);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        Set potentials = this.txnHandler.findPotentialCompactions(1000, -1L);
        Assert.assertEquals((int)2, (int)potentials.size());
        TreeSet sorted = new TreeSet(potentials);
        int i = 0;
        block4: for (CompactionInfo ci : sorted) {
            Assert.assertEquals((String)dbName, (String)ci.dbname);
            Assert.assertEquals((String)tableName, (String)ci.tableName);
            switch (i++) {
                case 0: {
                    Assert.assertEquals((String)"ds=today", (String)ci.partName);
                    continue block4;
                }
                case 1: {
                    Assert.assertEquals((String)"ds=yesterday", (String)ci.partName);
                    continue block4;
                }
            }
            throw new RuntimeException("What?");
        }
    }

    @Test
    public void testEnqueueTimeEvenAfterFailed() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        long before = System.currentTimeMillis();
        this.txnHandler.compact(rqst);
        long after = System.currentTimeMillis();
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        ShowCompactResponseElement element = (ShowCompactResponseElement)showCompactResponse.getCompacts().get(0);
        Assert.assertTrue((boolean)element.isSetEnqueueTime());
        long enqueueTime = element.getEnqueueTime();
        Assert.assertTrue((enqueueTime <= after ? 1 : 0) != 0);
        Assert.assertTrue((enqueueTime >= before ? 1 : 0) != 0);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markFailed(ci);
        this.checkEnqueueTime(enqueueTime);
    }

    @Test
    public void testEnqueueTimeThroughLifeCycle() throws Exception {
        String dbName = "foo";
        String tableName = "bar";
        String partitionName = "ds=today";
        CompactionRequest rqst = new CompactionRequest("foo", "bar", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        long before = System.currentTimeMillis();
        this.txnHandler.compact(rqst);
        long after = System.currentTimeMillis();
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        ShowCompactResponseElement element = (ShowCompactResponseElement)showCompactResponse.getCompacts().get(0);
        Assert.assertTrue((boolean)element.isSetEnqueueTime());
        long enqueueTime = element.getEnqueueTime();
        Assert.assertTrue((enqueueTime <= after ? 1 : 0) != 0);
        Assert.assertTrue((enqueueTime >= before ? 1 : 0) != 0);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        ci.runAs = "bob";
        this.txnHandler.updateCompactorState(ci, this.openTxn());
        this.checkEnqueueTime(enqueueTime);
        this.txnHandler.markCompacted(ci);
        this.checkEnqueueTime(enqueueTime);
        this.txnHandler.markCleaned(ci);
        this.checkEnqueueTime(enqueueTime);
    }

    private void checkEnqueueTime(long enqueueTime) throws MetaException {
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        ShowCompactResponseElement element = (ShowCompactResponseElement)showCompactResponse.getCompacts().get(0);
        Assert.assertTrue((boolean)element.isSetEnqueueTime());
        Assert.assertEquals((long)enqueueTime, (long)element.getEnqueueTime());
    }

    @Before
    public void setUp() throws Exception {
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TestTxnDbUtil.cleanDb((Configuration)this.conf);
    }

    private long openTxn() throws MetaException {
        List txns = this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost")).getTxn_ids();
        return (Long)txns.get(0);
    }
}

