/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMetastoreExpr {
    protected static HiveMetaStoreClient client;

    @After
    public void tearDown() throws Exception {
        try {
            client.close();
        }
        catch (Throwable e) {
            System.err.println("Unable to close metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw new Exception(e);
        }
    }

    @Before
    public void setUp() throws Exception {
        try {
            client = new HiveMetaStoreClient((Configuration)new HiveConf(this.getClass()));
        }
        catch (Throwable e) {
            System.err.println("Unable to open the metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw new Exception(e);
        }
    }

    private static void silentDropDatabase(String dbName) throws TException {
        try {
            for (String tableName : client.getTables(dbName, "*")) {
                client.dropTable(dbName, tableName);
            }
            client.dropDatabase(dbName);
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (InvalidOperationException invalidOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testPartitionExpr() throws Exception {
        String dbName = "filterdb";
        String tblName = "filtertbl";
        TestMetastoreExpr.silentDropDatabase(dbName);
        Database db = new Database();
        db.setName(dbName);
        client.createDatabase(db);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>(2);
        cols.add(new FieldSchema("c1", "string", ""));
        cols.add(new FieldSchema("c2", "int", ""));
        ArrayList partCols = Lists.newArrayList((Object[])new FieldSchema[]{new FieldSchema("p1", "string", ""), new FieldSchema("p2", "int", "")});
        Table tbl = new Table();
        tbl.setDbName(dbName);
        tbl.setTableName(tblName);
        this.addSd(cols, tbl);
        tbl.setPartitionKeys((List)partCols);
        client.createTable(tbl);
        tbl = client.getTable(dbName, tblName);
        this.addPartition(client, tbl, Lists.newArrayList((Object[])new String[]{"p11", "32"}), "part1");
        this.addPartition(client, tbl, Lists.newArrayList((Object[])new String[]{"p12", "32"}), "part2");
        this.addPartition(client, tbl, Lists.newArrayList((Object[])new String[]{"p13", "31"}), "part3");
        this.addPartition(client, tbl, Lists.newArrayList((Object[])new String[]{"p14", "-33"}), "part4");
        ExprBuilder e = new ExprBuilder(tblName);
        this.checkExpr(3, dbName, tblName, e.val(0).intCol("p2").pred(">", 2).build(), tbl);
        this.checkExpr(3, dbName, tblName, e.intCol("p2").val(0).pred("<", 2).build(), tbl);
        this.checkExpr(1, dbName, tblName, e.intCol("p2").val(0).pred(">", 2).build(), tbl);
        this.checkExpr(2, dbName, tblName, e.val(31).intCol("p2").pred("<=", 2).build(), tbl);
        this.checkExpr(3, dbName, tblName, e.val("p11").strCol("p1").pred(">", 2).build(), tbl);
        this.checkExpr(1, dbName, tblName, e.val("p11").strCol("p1").pred(">", 2).intCol("p2").val(31).pred("<", 2).pred("and", 2).build(), tbl);
        this.checkExpr(3, dbName, tblName, e.val(32).val(31).intCol("p2").val(false).pred("between", 4).build(), tbl);
        this.addPartition(client, tbl, Lists.newArrayList((Object[])new String[]{"__HIVE_DEFAULT_PARTITION__", "36"}), "part5");
        this.addPartition(client, tbl, Lists.newArrayList((Object[])new String[]{"p16", "__HIVE_DEFAULT_PARTITION__"}), "part6");
        this.checkExpr(5, dbName, tblName, e.val("p").strCol("p1").fn("instr", (TypeInfo)TypeInfoFactory.intTypeInfo, 2).val(0).pred("<=", 2).build(), tbl);
        this.checkExpr(1, dbName, tblName, e.intCol("p2").pred("isnull", 1).build(), tbl);
        this.checkExpr(1, dbName, tblName, e.val("__HIVE_DEFAULT_PARTITION__").intCol("p2").pred("=", 2).build(), tbl);
        this.checkExpr(5, dbName, tblName, e.intCol("p1").pred("isnotnull", 1).build(), tbl);
        this.checkExpr(5, dbName, tblName, e.val("__HIVE_DEFAULT_PARTITION__").strCol("p1").pred("!=", 2).build(), tbl);
        try {
            client.listPartitionsByExpr(dbName, tblName, new byte[]{102, 111, 111}, null, (short)-1, new ArrayList());
            Assert.fail((String)"Should have thrown IncompatibleMetastoreException");
        }
        catch (IMetaStoreClient.IncompatibleMetastoreException incompatibleMetastoreException) {
            // empty catch block
        }
        try {
            this.checkExpr(-1, dbName, tblName, e.val(31).intCol("p3").pred(">", 2).build(), tbl);
            Assert.fail((String)"Should have thrown");
        }
        catch (IMetaStoreClient.IncompatibleMetastoreException ignore) {
            Assert.fail((String)"Should not have thrown IncompatibleMetastoreException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkExpr(int numParts, String dbName, String tblName, ExprNodeGenericFuncDesc expr, Table t) throws Exception {
        ArrayList parts = new ArrayList();
        client.listPartitionsByExpr(dbName, tblName, SerializationUtilities.serializeExpressionToKryo((ExprNodeGenericFuncDesc)expr), null, (short)-1, parts);
        Assert.assertEquals((String)("Partition check failed: " + expr.getExprString()), (long)numParts, (long)parts.size());
        PartitionsByExprRequest req = new PartitionsByExprRequest(dbName, tblName, ByteBuffer.wrap(SerializationUtilities.serializeExpressionToKryo((ExprNodeGenericFuncDesc)expr)));
        req.setMaxParts((short)-1);
        req.setId(t.getId());
        ArrayList partSpec = new ArrayList();
        client.listPartitionsSpecByExpr(req, partSpec);
        int partSpecSize = 0;
        if (!partSpec.isEmpty()) {
            partSpecSize = ((PartitionSpec)partSpec.iterator().next()).getSharedSDPartitionSpec().getPartitionsSize();
        }
        Assert.assertEquals((String)("Partition Spec check failed: " + expr.getExprString()), (long)numParts, (long)partSpecSize);
    }

    private void addSd(ArrayList<FieldSchema> cols, Table tbl) {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setCols(cols);
        sd.setCompressed(false);
        sd.setNumBuckets(1);
        sd.setParameters(new HashMap());
        sd.setBucketCols(new ArrayList());
        sd.setSerdeInfo(new SerDeInfo());
        sd.getSerdeInfo().setName(tbl.getTableName());
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().getParameters().put("serialization.format", "1");
        sd.setSortCols(new ArrayList());
        sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
        sd.setInputFormat(HiveInputFormat.class.getName());
        sd.setOutputFormat(HiveOutputFormat.class.getName());
        tbl.setSd(sd);
    }

    private void addPartition(HiveMetaStoreClient client, Table table, List<String> vals, String location) throws TException {
        Partition part = new Partition();
        part.setDbName(table.getDbName());
        part.setTableName(table.getTableName());
        part.setValues(vals);
        part.setParameters(new HashMap());
        part.setSd(table.getSd().deepCopy());
        part.getSd().setSerdeInfo(table.getSd().getSerdeInfo());
        part.getSd().setLocation(table.getSd().getLocation() + location);
        client.add_partition(part);
    }

    public static class ExprBuilder {
        private final String tblName;
        private final Stack<ExprNodeDesc> stack = new Stack();

        public ExprBuilder(String tblName) {
            this.tblName = tblName;
        }

        public ExprNodeGenericFuncDesc build() throws Exception {
            if (this.stack.size() != 1) {
                throw new Exception("Bad test: " + this.stack.size());
            }
            return (ExprNodeGenericFuncDesc)this.stack.pop();
        }

        public ExprBuilder pred(String name, int args) throws Exception {
            return this.fn(name, (TypeInfo)TypeInfoFactory.booleanTypeInfo, args);
        }

        private ExprBuilder fn(String name, TypeInfo ti, int args) throws Exception {
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            for (int i = 0; i < args; ++i) {
                children.add(this.stack.pop());
            }
            this.stack.push((ExprNodeDesc)new ExprNodeGenericFuncDesc(ti, FunctionRegistry.getFunctionInfo((String)name).getGenericUDF(), children));
            return this;
        }

        public ExprBuilder strCol(String col) {
            return this.colInternal((TypeInfo)TypeInfoFactory.stringTypeInfo, col, true);
        }

        public ExprBuilder intCol(String col) {
            return this.colInternal((TypeInfo)TypeInfoFactory.intTypeInfo, col, true);
        }

        private ExprBuilder colInternal(TypeInfo ti, String col, boolean part) {
            this.stack.push((ExprNodeDesc)new ExprNodeColumnDesc(ti, col, this.tblName, part));
            return this;
        }

        public ExprBuilder val(String val) {
            return this.valInternal((TypeInfo)TypeInfoFactory.stringTypeInfo, val);
        }

        public ExprBuilder val(int val) {
            return this.valInternal((TypeInfo)TypeInfoFactory.intTypeInfo, val);
        }

        public ExprBuilder val(boolean val) {
            return this.valInternal((TypeInfo)TypeInfoFactory.booleanTypeInfo, val);
        }

        private ExprBuilder valInternal(TypeInfo ti, Object val) {
            this.stack.push((ExprNodeDesc)new ExprNodeConstantDesc(ti, val));
            return this;
        }
    }
}

