/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUpper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

@Description(name="upper,ucase", value="_FUNC_(str) - Returns str with all characters changed to uppercase", extended="Example:\n  > SELECT _FUNC_('Facebook') FROM src LIMIT 1;\n  'FACEBOOK'")
@VectorizedExpressions(value={StringUpper.class})
public class GenericUDFUpper
extends GenericUDF {
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.StringConverter stringConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory returnType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
    private transient GenericUDFUtils.StringHelper returnHelper;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("UPPER requires 1 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("UPPER only takes primitive types, got " + arguments[0].getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        this.stringConverter = new PrimitiveObjectInspectorConverter.StringConverter(this.argumentOI);
        PrimitiveObjectInspector.PrimitiveCategory inputType = this.argumentOI.getPrimitiveCategory();
        WritableStringObjectInspector outputOI = null;
        switch (inputType) {
            case CHAR: {
                this.returnType = inputType;
                CharTypeInfo typeInfo = TypeInfoFactory.getCharTypeInfo((int)GenericUDFUtils.StringHelper.getFixedStringSizeForType(this.argumentOI));
                outputOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo);
                break;
            }
            case VARCHAR: {
                this.returnType = inputType;
                VarcharTypeInfo typeInfo = TypeInfoFactory.getVarcharTypeInfo((int)GenericUDFUtils.StringHelper.getFixedStringSizeForType(this.argumentOI));
                outputOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo);
                break;
            }
            default: {
                this.returnType = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            }
        }
        this.returnHelper = new GenericUDFUtils.StringHelper(this.returnType);
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String val = null;
        if (arguments[0] != null) {
            val = (String)this.stringConverter.convert(arguments[0].get());
        }
        if (val == null) {
            return null;
        }
        val = val.toUpperCase();
        return this.returnHelper.setReturnValue(val);
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("upper", children);
    }
}

