/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@Description(name="tumbling_window", value="_FUNC_(timestamp, interval, origin) - returns the timestamp truncated to the  beginning of tumbling window time interval starting from origin timestamp,  by default origin is unix epoch 0", extended="param has to be a timestamp value, Example:\n  > SELECT _FUNC_(timestamp, interval) FROM src ;\n  > SELECT _FUNC_(timestamp, interval, origin_timestamp);\n")
public class GenericUDFTumbledWindow
extends GenericUDF {
    private PrimitiveObjectInspector intervalOI;
    private PrimitiveObjectInspector timestampOI;
    private PrimitiveObjectInspector originTsOI = null;
    private final transient TimestampWritableV2 timestampResult = new TimestampWritableV2();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 3);
        this.timestampOI = (PrimitiveObjectInspector)arguments[0];
        this.intervalOI = (PrimitiveObjectInspector)arguments[1];
        if (arguments.length == 3) {
            this.originTsOI = (PrimitiveObjectInspector)arguments[2];
            if (!PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.originTsOI.getPrimitiveCategory()).equals((Object)PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP)) {
                throw new UDFArgumentException("Third arg has to be timestamp got " + this.originTsOI.getTypeInfo().toString());
            }
        }
        if (!PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.timestampOI.getPrimitiveCategory()).equals((Object)PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP)) {
            throw new UDFArgumentException("First arg has to be timestamp got " + this.timestampOI.getTypeInfo().toString());
        }
        if (!this.intervalOI.getPrimitiveCategory().equals((Object)PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME)) {
            throw new UDFArgumentException("Second arg has to be interval got " + this.intervalOI.getTypeInfo().toString());
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.timestampTypeInfo);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0] == null) {
            return null;
        }
        Timestamp ts = PrimitiveObjectInspectorUtils.getTimestamp((Object)arguments[0].get(), (PrimitiveObjectInspector)this.timestampOI);
        HiveIntervalDayTime idt = PrimitiveObjectInspectorUtils.getHiveIntervalDayTime((Object)arguments[1].get(), (PrimitiveObjectInspector)this.intervalOI);
        Timestamp origin = this.originTsOI == null ? Timestamp.ofEpochMilli((long)0L) : PrimitiveObjectInspectorUtils.getTimestamp((Object)arguments[2].get(), (PrimitiveObjectInspector)this.originTsOI);
        this.timestampResult.set(Timestamp.ofEpochMilli((long)this.truncate(ts, idt, origin)));
        return this.timestampResult;
    }

    private long truncate(Timestamp ts, HiveIntervalDayTime idt, Timestamp origin) {
        long intervalDurationMs = idt.getTotalSeconds() * 1000L + (long)idt.getNanos() / 1000L;
        long offset = ts.toEpochMilli() % intervalDurationMs - origin.toEpochMilli() % intervalDurationMs;
        if (offset < 0L) {
            offset += intervalDurationMs;
        }
        return ts.toEpochMilli() - offset;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "tumbling_window";
    }
}

