/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncDateFromDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncDateFromString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncDateFromTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncDecimalNoScale;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncFloat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncFloatNoScale;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateParser;

@Description(name="trunc", value="_FUNC_(date, fmt) / _FUNC_(N,D) - Returns If input is date returns date with the time portion of the day truncated to the unit specified by the format model fmt. If you omit fmt, then date is truncated to the nearest day. It currently only supports 'MONTH'/'MON'/'MM', 'QUARTER'/'Q' and 'YEAR'/'YYYY'/'YY' as format.If input is a number group returns N truncated to D decimal places. If D is omitted, then N is truncated to 0 places.D can be negative to truncate (make zero) D digits left of the decimal point.", extended="date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. The time part of date is ignored.\nExample:\n  > SELECT _FUNC_('2009-02-12', 'MM');\nOK\n '2009-02-01'\n > SELECT _FUNC_('2017-03-15', 'Q');\nOK\n '2017-01-01'\n > SELECT _FUNC_('2015-10-27', 'YEAR');\nOK\n '2015-01-01' > SELECT _FUNC_(1234567891.1234567891,4);\nOK\n 1234567891.1234\n > SELECT _FUNC_(1234567891.1234567891,-4);\nOK\n 1234560000 > SELECT _FUNC_(1234567891.1234567891,0);\nOK\n 1234567891\n > SELECT _FUNC_(1234567891.1234567891);\nOK\n 1234567891")
@VectorizedExpressions(value={TruncDateFromTimestamp.class, TruncDateFromString.class, TruncDateFromDate.class, TruncFloat.class, TruncFloatNoScale.class, TruncDecimal.class, TruncDecimalNoScale.class})
public class GenericUDFTrunc
extends GenericUDF {
    private transient PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private transient ObjectInspectorConverters.Converter textConverter1;
    private transient ObjectInspectorConverters.Converter textConverter2;
    private transient ObjectInspectorConverters.Converter dateWritableConverter;
    private transient ObjectInspectorConverters.Converter byteConverter;
    private transient ObjectInspectorConverters.Converter shortConverter;
    private transient ObjectInspectorConverters.Converter intConverter;
    private transient ObjectInspectorConverters.Converter longConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private final Date date = new Date();
    private final Text output = new Text();
    private transient String fmtInput;
    private transient PrimitiveObjectInspector inputOI;
    private transient PrimitiveObjectInspector inputScaleOI;
    private int scale = 0;
    private boolean inputSacleConst;
    private boolean dateTypeArg;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length == 2) {
            this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
            this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
            if ((PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.inputType1) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP || PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.inputType1) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) && PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.inputType2) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
                this.dateTypeArg = true;
                return this.initializeDate(arguments);
            }
            if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.inputType1) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP && PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.inputType2) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP) {
                this.dateTypeArg = false;
                return this.initializeNumber(arguments);
            }
            throw new UDFArgumentException("Got wrong argument types : first argument type : " + arguments[0].getTypeName() + ", second argument type : " + arguments[1].getTypeName());
        }
        if (arguments.length == 1) {
            this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
            if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.inputType1) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP) {
                this.dateTypeArg = false;
                return this.initializeNumber(arguments);
            }
            throw new UDFArgumentException("Only primitive type arguments are accepted, when arguments length is one, got " + arguments[0].getTypeName());
        }
        throw new UDFArgumentException("TRUNC requires one or two argument, got " + arguments.length);
    }

    private ObjectInspector initializeNumber(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1 || arguments.length > 2) {
            throw new UDFArgumentLengthException("TRUNC requires one or two argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "TRUNC input only takes primitive types, got " + arguments[0].getTypeName());
        }
        this.inputOI = (PrimitiveObjectInspector)arguments[0];
        if (arguments.length == 2) {
            if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentTypeException(1, "TRUNC second argument only takes primitive types, got " + arguments[1].getTypeName());
            }
            this.inputScaleOI = (PrimitiveObjectInspector)arguments[1];
            this.inputSacleConst = arguments[1] instanceof ConstantObjectInspector;
            if (this.inputSacleConst) {
                try {
                    Object obj = ((ConstantObjectInspector)arguments[1]).getWritableConstantValue();
                    this.fmtInput = obj != null ? obj.toString() : null;
                    this.scale = Integer.parseInt(this.fmtInput);
                }
                catch (Exception e) {
                    throw new UDFArgumentException("TRUNC input only takes integer values, got " + this.fmtInput);
                }
            } else {
                switch (this.inputScaleOI.getPrimitiveCategory()) {
                    case BYTE: {
                        this.byteConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.writableByteObjectInspector);
                        break;
                    }
                    case SHORT: {
                        this.shortConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.writableShortObjectInspector);
                        break;
                    }
                    case INT: {
                        this.intConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                        break;
                    }
                    case LONG: {
                        this.longConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                        break;
                    }
                    default: {
                        throw new UDFArgumentTypeException(1, this.getFuncName().toUpperCase() + " second argument only takes integer values");
                    }
                }
            }
        }
        this.inputType1 = this.inputOI.getPrimitiveCategory();
        AbstractPrimitiveWritableObjectInspector outputOI = null;
        switch (this.inputType1) {
            case DECIMAL: {
                outputOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)this.inputType1);
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case VOID: 
            case FLOAT: 
            case DOUBLE: {
                outputOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)this.inputType1);
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only numeric or string group data types are allowed for TRUNC function. Got " + this.inputType1.name());
            }
        }
        return outputOI;
    }

    private ObjectInspector initializeDate(ObjectInspector[] arguments) throws UDFArgumentLengthException, UDFArgumentTypeException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("trunc() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[0].getTypeName() + " is passed. as first arguments");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + arguments[1].getTypeName() + " is passed. as second arguments");
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        switch (this.inputType1) {
            case VOID: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                this.inputType1 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.textConverter1 = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[0], (SettableTimestampObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                this.dateWritableConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "TRUNC() only takes STRING/TIMESTAMP/DATEWRITABLE types as first argument, got " + this.inputType1);
            }
        }
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.inputType2) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.inputType2) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP) {
            throw new UDFArgumentTypeException(1, "trunc() only takes STRING/CHAR/VARCHAR types as second argument, got " + this.inputType2);
        }
        this.inputType2 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
        if (arguments[1] instanceof ConstantObjectInspector) {
            Object obj = ((ConstantObjectInspector)arguments[1]).getWritableConstantValue();
            this.fmtInput = obj != null ? obj.toString() : null;
        } else {
            this.textConverter2 = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.dateTypeArg) {
            return this.evaluateDate(arguments);
        }
        return this.evaluateNumber(arguments);
    }

    private Object evaluateDate(GenericUDF.DeferredObject[] arguments) throws UDFArgumentLengthException, HiveException, UDFArgumentTypeException, UDFArgumentException {
        Date d;
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("trunc() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        if (this.textConverter2 != null) {
            this.fmtInput = this.textConverter2.convert(arguments[1].get()).toString();
        }
        switch (this.inputType1) {
            case STRING: {
                String dateString = this.textConverter1.convert(arguments[0].get()).toString();
                d = DateParser.parseDate((String)dateString);
                if (d != null) break;
                return null;
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampWritableV2)this.timestampConverter.convert(arguments[0].get())).getTimestamp();
                d = Date.ofEpochMilli((long)ts.toEpochMilli());
                break;
            }
            case DATE: {
                DateWritableV2 dw = (DateWritableV2)this.dateWritableConverter.convert(arguments[0].get());
                d = dw.get();
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "TRUNC() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + this.inputType1);
            }
        }
        if (this.evalDate(d) == null) {
            return null;
        }
        this.output.set(this.date.toString());
        return this.output;
    }

    private Object evaluateNumber(GenericUDF.DeferredObject[] arguments) throws HiveException, UDFArgumentTypeException {
        if (arguments[0] == null) {
            return null;
        }
        Object input = arguments[0].get();
        if (input == null) {
            return null;
        }
        if (arguments.length == 2 && arguments[1] != null && arguments[1].get() != null && !this.inputSacleConst) {
            Object scaleObj = null;
            switch (this.inputScaleOI.getPrimitiveCategory()) {
                case BYTE: {
                    scaleObj = this.byteConverter.convert(arguments[1].get());
                    this.scale = ((ByteWritable)scaleObj).get();
                    break;
                }
                case SHORT: {
                    scaleObj = this.shortConverter.convert(arguments[1].get());
                    this.scale = ((ShortWritable)scaleObj).get();
                    break;
                }
                case INT: {
                    scaleObj = this.intConverter.convert(arguments[1].get());
                    this.scale = ((IntWritable)scaleObj).get();
                    break;
                }
                case LONG: {
                    scaleObj = this.longConverter.convert(arguments[1].get());
                    long l = ((LongWritable)scaleObj).get();
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw new UDFArgumentException(this.getFuncName().toUpperCase() + " scale argument out of allowed range");
                    }
                    this.scale = (int)l;
                }
            }
        }
        switch (this.inputType1) {
            case VOID: {
                return null;
            }
            case DECIMAL: {
                HiveDecimalWritable decimalWritable = (HiveDecimalWritable)this.inputOI.getPrimitiveWritableObject(input);
                HiveDecimal dec = this.trunc(decimalWritable.getHiveDecimal(), this.scale);
                if (dec == null) {
                    return null;
                }
                return new HiveDecimalWritable(dec);
            }
            case BYTE: {
                ByteWritable byteWritable = (ByteWritable)this.inputOI.getPrimitiveWritableObject(input);
                if (this.scale >= 0) {
                    return byteWritable;
                }
                return new ByteWritable((byte)this.trunc(byteWritable.get(), this.scale));
            }
            case SHORT: {
                ShortWritable shortWritable = (ShortWritable)this.inputOI.getPrimitiveWritableObject(input);
                if (this.scale >= 0) {
                    return shortWritable;
                }
                return new ShortWritable((short)this.trunc(shortWritable.get(), this.scale));
            }
            case INT: {
                IntWritable intWritable = (IntWritable)this.inputOI.getPrimitiveWritableObject(input);
                if (this.scale >= 0) {
                    return intWritable;
                }
                return new IntWritable((int)this.trunc(intWritable.get(), this.scale));
            }
            case LONG: {
                LongWritable longWritable = (LongWritable)this.inputOI.getPrimitiveWritableObject(input);
                if (this.scale >= 0) {
                    return longWritable;
                }
                return new LongWritable(this.trunc(longWritable.get(), this.scale));
            }
            case FLOAT: {
                float f = ((FloatWritable)this.inputOI.getPrimitiveWritableObject(input)).get();
                return new FloatWritable((float)this.trunc(f, this.scale));
            }
            case DOUBLE: {
                return this.trunc((DoubleWritable)this.inputOI.getPrimitiveWritableObject(input), this.scale);
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string group data types are allowed for TRUNC function. Got " + this.inputType1.name());
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("trunc", children);
    }

    private Date evalDate(Date d) throws UDFArgumentException {
        this.date.setTimeInDays(d.toEpochDay());
        if ("MONTH".equals(this.fmtInput) || "MON".equals(this.fmtInput) || "MM".equals(this.fmtInput)) {
            this.date.setDayOfMonth(1);
            return this.date;
        }
        if ("QUARTER".equals(this.fmtInput) || "Q".equals(this.fmtInput)) {
            int month = this.date.getMonth() - 1;
            int quarter = month / 3;
            int monthToSet = quarter * 3 + 1;
            this.date.setMonth(monthToSet);
            this.date.setDayOfMonth(1);
            return this.date;
        }
        if ("YEAR".equals(this.fmtInput) || "YYYY".equals(this.fmtInput) || "YY".equals(this.fmtInput)) {
            this.date.setMonth(1);
            this.date.setDayOfMonth(1);
            return this.date;
        }
        return null;
    }

    protected HiveDecimal trunc(HiveDecimal input, int scale) {
        BigDecimal bigDecimal = this.trunc(input.bigDecimalValue(), scale);
        return HiveDecimal.create((BigDecimal)bigDecimal);
    }

    protected long trunc(long input, int scale) {
        return this.trunc(BigDecimal.valueOf(input), scale).longValue();
    }

    protected double trunc(double input, int scale) {
        return this.trunc(BigDecimal.valueOf(input), scale).doubleValue();
    }

    protected DoubleWritable trunc(DoubleWritable input, int scale) {
        BigDecimal bigDecimal = new BigDecimal(input.get());
        BigDecimal trunc = this.trunc(bigDecimal, scale);
        DoubleWritable doubleWritable = new DoubleWritable(trunc.doubleValue());
        return doubleWritable;
    }

    protected BigDecimal trunc(BigDecimal input, int scale) {
        BigDecimal output = new BigDecimal(0);
        BigDecimal pow = BigDecimal.valueOf(Math.pow(10.0, Math.abs(scale)));
        if (scale >= 0) {
            pow = BigDecimal.valueOf(Math.pow(10.0, scale));
            if (scale != 0) {
                long longValue = input.multiply(pow).longValue();
                output = BigDecimal.valueOf(longValue).divide(pow);
            } else {
                output = BigDecimal.valueOf(input.longValue());
            }
        } else {
            long longValue2 = input.divide(pow).longValue();
            output = BigDecimal.valueOf(longValue2).multiply(pow);
        }
        return output;
    }
}

